# Effect of aggregation probability on the convergence rate



from algorithms import *

plot_only = True

linestyles = ['-', '-.', '--', ':', '-.', '-', '-', '-.', '--', ':', '-.', '-']
markers = ['o', '*', 'd', 'v', 'P', '1', 'p', 'X']
colors = ['tab:blue', 'tab:brown', 'tab:green', 'tab:red', 'tab:purple', 'tab:gray',
          'tab:olive', 'tab:cyan']

mu = 1e-4
experiment = "VR_import"


datasets = ["a1a", "duke", "phishing", "madelon", "mushrooms", "a8a", "gisette_scale"]

T_dict = {"a1a": 321, "mushrooms": 677,  "phishing": 1005, "duke": 11, "madelon": 500, "gisette_scale": 60, "a8a": 2837}



# characterization of the problem
for dataset in datasets:
    print("#############################")
    print(dataset)
    print("#############################")

    T = T_dict[dataset]


    A, b = get_data(dataset)
    A = A
    b = b

    n, d = A.shape

    A = normalize_data(A)
    A, b = rearrange_data(A, "random", b)

    blocks = create_blocks(n, T)
    print(n * d/len(blocks))
    K = int(5000)
    skip_it = int(K / 500)

    v = (1 + 1e-6)*np.ones(n)
    m = int(n/T)
    x0 = np.zeros(d)
    f, g = make_fg_logreg(A, b, mu)



    def total_loss(x): return objective(f, x, n)


    if m*T != n:
        continue

    if not plot_only:
        Lmat = np.dot(A.T, A)/n/4 + mu*np.eye(d)
        L = eigh(Lmat, eigvals = (d-1,d-1))[0][0]

        xstar = find_xstar(g, mu, L, d, n, K, pre_text='', loss=total_loss)

        Fstar = total_loss(xstar)

    Flist = []
    Xlist = []

    labels = ["importance+", "uniform+", "uniform"]

    it = create_it(T=K, skip_it=skip_it, tau = 1)


    vr = 1

    settings = [(False, True), (False, False), (True, False)]

    if not plot_only:
        for tau in [1]:
            for sett in settings:
                simple_spars, imp = sett
                #probs, alpha, _ , _ = get_alpha_probs(A, blocks, mu, imp, tau, simple_spars)
                print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
                print("simple_spars: {}, importance: {}".format(simple_spars,imp))
                print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
                F, x = dist_GD(total_loss, g, blocks, A, mu, vr,  imp, K, skip_it, tau, simple_spars, x0=None, pre_text='')
                Flist.append((F - Fstar)/(F[0]-Fstar))
                Xlist.append(x)



         # save F
        for backup in [True, False]:
            filename = createfilename(experiment, dataset, T,  mu, backup)
            pickle_out = open(filename, "wb")
            pickle.dump((Flist, Xlist), pickle_out)
            pickle_out.close()


    # load F
    (Flist, Xlist) = load_pickle(experiment, dataset, T, mu)


    it_list = [it for i in Flist]

    # plot
    alphas = None#
    visualize(Flist, it_list, "sparsif_", dataset, labels, linestyles=linestyles, markers=markers,
              colors=colors, alphas=alphas, muT=mu/T, ppe=n/T)



