# Ensemble and Mixture-of-Experts DeepONets For Operator Learning

The supplemental material contains the the code for running our experiments (in a reproducible way).

## Requirements

For running the code, the following Python libraries are required:

1. numpy
2. matplotlib
3. json
4. scipy
5. torch
6. jax
7. haiku

We provide a [``requirements.txt``](requirements.txt) file that can be used to install the libraries with pip:

```bash
>> pip install -r requirements.txt
```

## Dataset
Please refer to the paper for the datasets used.

## DeepONet code
We provide the Python code for the four problems (Darcy flow, lid-driven cavity flow, 2D reaction-diffusion, and 3D reaction-diffusion with variable coefficient diffusion) in this paper in the [``src/``](code/src/) folder. The code files are

1. [``darcy_flow_deeponet.py``](code/src/darcy_flow_deeponet.py)
2. [``cavity_flow_deeponet.py``](code/src/cavity_flow_deeponet.py)
3. [``diffrec_deeponet.py``](code/src/diffrec_deeponet.py)
4. [``diffrec_3d_deeponet.py``](code/src/diffrec_3d_deeponet.py)

These files run the vanilla, POD, modified-POD, and ensemble DeepONets, and also contain plotting code. All the DeepONet models are defined in the [``jax_networks.py``](code/jax_networks.py) file. The [``utils.py``](code/utils.py) file contains helper functions for forming the POD basis and implements the Partition-of-Unity (PoU) method. The [``train_utils.py``](code/train_utils.py) file contains a generic Jax training function for DeepONets.

**Hyperparameters**: One can change the learning rate, activation function, and other DeepONet hyperparameters within the code files. The code also automatically saves the results in a descriptive folder name for each problem separately.
