
# My Paper Title

This repository is the official implementation of [Query-Aware Graph Attention for Precise Subgraph Retrieval in Knowledge-Augmented Reasoning].

## Retrieve
### Requirements
docker command:
docker run \
-it \
--name=retrieve \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--security-opt seccomp=unconfined \
--cap-add=SYS_PTRACE \
--ipc=host \
--network host \
--shm-size=16G \
--group-add 39 \
-v /opt/hyhal:/opt/hyhal \
-v /usr/local/hyhal:/usr/local/hyhal \
-v /QSRAG/retrieve:/QSRAG/retrieve \
image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10

To install requirements:

```setup
cd retrieve
pip install -r requirements.txt
```
### Pre_emb

Embedding pre-computation:
dataset: webqsp, cwq
```bash
python data_process/preemb.py -d dataset
```

### Train
```bash
nohup python train.py -d dataset >xxx.log 2>&1 &
```
The training results and logs are saved in a folder like cwq_May25-10:08:34:828_pid594

### Inference

```bash
python inference.py -p P
```
P is the path to the saved model checkpoint.

## Reason
### Requirements
docker command:
docker run \
-it \
--name=retrieve \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--security-opt seccomp=unconfined \
--cap-add=SYS_PTRACE \
--ipc=host \
--network host \
--shm-size=16G \
--group-add 39 \
-v /opt/hyhal:/opt/hyhal \
-v /usr/local/hyhal:/usr/local/hyhal \
-v /QSRAG/reason:/QSRAG/reason \
image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.7.2-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250327

To install requirements:

```setup
cd reason
pip install -r requirements.txt
```
### reason
- `llama` saved our local large model.
- `retrieveresult` stores the retrieval results.
- `outputs` stores the reasoning results.
```bash
python data_utils/runllama4.py
```

### compute
```bash
python data_utils/acompute.py
```

## Results

Our model achieves the following performance on :

**Table: Retrieval evaluation results on WebQSP and CWQ datasets. Best results are in bold.**

|                      | WebQSP Triplet Recall | WebQSP Answer Recall | CWQ Triplet Recall | CWQ Answer Recall |
|----------------------|-----------------------|-----------------------|--------------------|-------------------|
| SR+NSM w/ E2E        | 0.487                 | 0.707                 | --                 | --                |
| Retrieve-Rewrite-Answer | 0.058              | 0.740                 | --                 | --                |
| RoG                  | 0.713                 | 0.807                 | 0.623              | 0.841             |
| G-Retriever          | 0.294                 | 0.545                 | 0.183              | 0.375             |
| GNN-RAG              | 0.522                 | 0.818                 | 0.500              | 0.841             |
| SubgraphRAG          | 0.883                 | **0.944**             | 0.811              | 0.914             |
| **QSRAG**            | **0.905**             | 0.942                 | **0.903**          | **0.955**         |


**Table: KGQA results on WebQSP and CWQ. Best results are in bold and underlined. By default, our reasoners use the top 100 retrieved triples. Results with 50 and 200 triples (indicated in parentheses) are also shown.**

| Model                                | WebQSP Micro-F1 | WebQSP Macro-F1 | WebQSP Hit | WebQSP Hit@1 | CWQ Micro-F1 | CWQ Macro-F1 | CWQ Hit | CWQ Hit@1 |
|--------------------------------------|------------------|------------------|-------------|----------------|----------------|----------------|---------|-------------|
| SR+NSM w/ E2E                        | --               | 64.10            | --          | --             | --             | 46.30          | --      | --          |
| ToG                                 | --               | --               | 82.60       | --             | --             | --             | **67.60** | --        |
| Retrieve-Rewrite-Answer             | --               | --               | 79.36       | --             | --             | --             | --      | --          |
| G-Retriever                         | --               | 53.41            | 73.46       | --             | --             | --             | --      | --          |
| RoG                                 | 52.60            | 70.45            | 85.38       | 79.36          | 46.12          | 54.44          | 60.97   | 56.10       |
| GNN-RAG                             | 10.89            | 71.28            | 85.69       | 80.59          | 28.80          | **59.43**      | 66.81   | **61.74**   |
| SubgraphRAG + Llama (200)           | 42.46            | 66.98            | 83.22       | 77.36          | 39.04          | 41.97          | 54.38   | 48.23       |
| SubgraphRAG + GPT-4o-mini (200)     | 49.78            | 69.76            | 85.54       | 78.89          | 44.82          | 43.00          | 53.33   | 48.12       |
| QSRAG + Llama (50)                  | 47.99            | 69.46            | 83.85       | 79.42          | 46.17          | 45.78          | 56.13   | 51.09       |
| QSRAG + Llama                       | 48.62            | 70.61            | 85.63       | 80.59          | 43.33          | 45.70          | 56.95   | 51.66       |
| QSRAG + Llama (200)                 | 49.03            | 70.13            | 85.55       | 79.54          | 40.82          | 44.55          | 57.18   | 51.03       |
| QSRAG + GPT-4o-mini (50)            | 51.57            | 69.10            | 81.20       | 75.55          | 49.80          | 44.16          | 51.15   | 46.90       |
| QSRAG + GPT-4o-mini                 | 55.25            | 70.70            | 83.34       | 76.93          | __**50.29**__  | 45.31          | 53.02   | 48.51       |
| QSRAG + GPT-4o-mini (200)           | __**55.50**__    | __**71.82**__    | 84.77       | 78.13          | 49.77          | 45.44          | 54.04   | 48.97       |
| QSRAG + GLM-4-Air (50)              | 47.47            | 68.69            | 87.44       | 79.06          | 39.74          | __46.32__      | 63.43   | 52.96       |
| QSRAG + GLM-4-Air                   | 46.38            | 68.25            | 88.85       | 80.59          | 33.06          | 44.16          | 63.15   | 52.54       |
| QSRAG + GLM-4-Air (200)             | 45.85            | 68.43            | __**90.88**__ | __**81.50**__ | 29.39          | 44.28          | __65.56__ | __53.46__ |


## Contributing

We welcome contributions to this project! By contributing, you agree that your contributions will be licensed under the [Creative Commons Attribution 4.0 International (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/) license.
If you'd like to contribute, please fork the repository and submit a pull request. For major changes, please open an issue first to discuss what you would like to change.
All contributions should be properly documented and include clear descriptions of the proposed updates or additions.


## Acknowledgements
Thanks to the [SubgraphRAG](https://github.com/Graph-COM/SubgraphRAG) contributors for their valuable work and open source contributions.
