icl_sys_prompt = (
    "You are a reasoning assistant. Based on the given knowledge graph triplets, your task is to answer the question.\n"
    "You must use only the entities found in the triplets that are **meaningful names** (e.g., 'Aviva Stadium', not 'm.0wz2kl3').\n"
    "Each answer must be a full entity name as it appears in the triplets.\n"
    "Return each answer in a new line, prefixed with 'ans:'.\n"
    "If the answer is not present or is an internal ID (like 'm.0xxx'), respond with 'ans: not available'."
)

icl_user_prompt = """Input Triplets:
(Lou Seal,sports.mascot.team,San Francisco Giants)
(San Francisco Giants,sports.sports_team.championships,2012 World Series)
(San Francisco Giants,sports.sports_championship_event.champion,2014 World Series)
(San Francisco Giants,time.participant.event,2014 Major League Baseball season)
(San Francisco Giants,time.participant.event,2010 World Series)
(San Francisco Giants,time.participant.event,2010 Major League Baseball season)
(San Francisco Giants,sports.sports_team.championships,2014 World Series)
(San Francisco Giants,sports.sports_team.team_mascot,Crazy Crab)
(San Francisco Giants,sports.sports_team.championships,2010 World Series)
(San Francisco Giants,sports.professional_sports_team.owner_s,Bill Neukom)
(San Francisco Giants,time.participant.event,2012 World Series)
(San Francisco,sports.sports_team_location.teams,San Francisco Giants)
(San Francisco Giants,sports.sports_team.arena_stadium,AT&T Park)
(AT&T Park,location.location.events,2012 World Series)
(m.011zsc4_,organization.leadership.organization,San Francisco Giants)
(San Francisco Giants,sports.sports_team.previously_known_as,New York Giants)
(AT&T Park,location.location.events,2010 World Series)
(Crazy Crab,sports.mascot.team,San Francisco Giants)
(New York Giants,baseball.baseball_team.league,National League)
(San Francisco Giants,sports.sports_team.colors,Black)
(San Francisco Giants,sports.sports_team.previously_known_as,New York Gothams)
(m.0k079qm,base.schemastaging.team_training_ground_relationship.team,San Francisco Giants)
(m.0k079ry,base.schemastaging.team_training_ground_relationship.team,San Francisco Giants)
(2010 World Series,time.event.locations,AT&T Park)
(San Francisco Giants,time.participant.event,2012 Major League Baseball season)
(San Francisco Giants,baseball.baseball_team.league,National League)
(m.0crtd80,sports.sports_league_participation.league,National League West)
(San Francisco Giants,sports.sports_team.location,San Francisco)
(San Francisco Giants,sports.sports_team.sport,Baseball)
(m.05n6dtn,baseball.baseball_team_stats.team,San Francisco Giants)


Question:
What year did the team with mascot named Lou Seal win the World Series?"""

icl_ass_prompt = """To find the year the team with mascot named Lou Seal won the World Series, we need to find the team with mascot named Lou Seal and then find the year they won the World Series.

From the triplets, we can see that Lou Seal is the mascot of the San Francisco Giants.

Now, we need to find the year the San Francisco Giants won the World Series.

From the triplets, we can see that San Francisco Giants won the 2010 World Series and 2012 World Series and 2014 World Series.

So, the team with mascot named Lou Seal (San Francisco Giants) won the World Series in 2010, 2012, and 2014.

Therefore, the formatted answers are:

ans: 2014 World Series (2014 World Series)
ans: 2012 World Series (2012 World Series)
ans: 2010 World Series (2010 World Series)"""

last_prompt = (
    "Please provide your answer in the same format as the example. The answer should be a meaningful entity or information, "
    "not a random string like 'm02h98gq' or 'm.0xxx'.Please list all reasonable answers from the above triplets. If the answer is not present in the triplets, respond with 'ans: not available'."
)



icl_sys_prompt_score = (
    "You are a reasoning assistant. Based on the given knowledge graph triple and its confidence, your task is to answer the question.\n"
    "You must use only the entities found in the triplets that are **meaningful names** (e.g., 'Aviva Stadium', not 'm.0wz2kl3').\n"
    "Each answer must be a full entity name as it appears in the triplets.\n"
    "Return each answer in a new line, prefixed with 'ans:'.\n"
    "If the answer is not present or is an internal ID (like 'm.0xxx'), respond with 'ans: not available'."
)

icl_user_prompt_score = """Input Triplets:
(Lou Seal,sports.mascot.team,San Francisco Giants)[Confidence: 0.9999743700027466]
(San Francisco Giants,sports.sports_team.team_mascot,Lou Seal)[Confidence: 0.9999568462371826]
(2014 World Series,sports.sports_championship_event.champion,San Francisco Giants)[Confidence: 0.8941453695297241]
(2012 World Series,sports.sports_championship_event.champion,San Francisco Giants)[Confidence: 0.8416239619255066]
(2010 World Series,sports.sports_championship_event.champion,San Francisco Giants)[Confidence: 0.8150305151939392]
(San Francisco Giants,sports.sports_team.championships,2014 World Series)[Confidence: 0.7321670055389404]
(San Francisco Giants,sports.sports_team.championships,2012 World Series)[Confidence: 0.6976805329322815]
(San Francisco Giants,sports.sports_team.championships,2010 World Series)[Confidence: 0.6664191484451294]
(San Francisco Giants,time.participant.event,2012 World Series)[Confidence: 0.07613193988800049]
(San Francisco Giants,time.participant.event,2010 World Series)[Confidence: 0.07032240927219391]
(Crazy Crab,sports.mascot.team,San Francisco Giants)[Confidence: 0.06551104038953781]
(San Francisco Giants,time.participant.event,2012 Major League Baseball season)[Confidence: 0.05442618206143379]
(San Francisco Giants,sports.sports_team.team_mascot,Crazy Crab)[Confidence: 0.03922161087393761]
(San Francisco Giants,time.participant.event,2014 Major League Baseball season)[Confidence: 0.03325091302394867]
(San Francisco Giants,time.participant.event,2010 Major League Baseball season)[Confidence: 0.028896385803818703]
(Bill Neukom,sports.sports_team_owner.teams_owned,San Francisco Giants)[Confidence: 0.000997280585579574]
(2012 World Series,time.event.participant,San Francisco Giants)[Confidence: 0.0008764338563196361]
(2010 World Series,time.event.participant,San Francisco Giants)[Confidence: 0.0005736841121688485]
(San Francisco Giants,baseball.baseball_team.current_manager,Bruce Bochy)[Confidence: 0.0002885302237700671]
(San Francisco Giants,sports.sports_team.previously_known_as,New York Gothams)[Confidence: 0.0002580081345513463]
(2012 Major League Baseball season,time.event.participant,San Francisco Giants)[Confidence: 0.0002402325189905241]
(San Francisco Giants,sports.professional_sports_team.owner_s,Bill Neukom)[Confidence: 0.0002128211926901713]
(New York Gothams,sports.defunct_sports_team.later_known_as,San Francisco Giants)[Confidence: 0.00016655285435263067]
(San Francisco Giants,base.rivalries.rival.rivals,Dodgers–Giants rivalry)[Confidence: 0.00012789081665687263]
(Bruce Bochy,baseball.baseball_manager.current_team_managed,San Francisco Giants)[Confidence: 0.00010816461144713685]
(2010 Major League Baseball season,time.event.participant,San Francisco Giants)[Confidence: 9.182350913761184e-05]
(San Francisco Giants,sports.sports_team.previously_known_as,New York Giants)[Confidence: 7.569997251266614e-05]
(New York Giants,sports.defunct_sports_team.later_known_as,San Francisco Giants)[Confidence: 7.506387919420376e-05]
(San Francisco Giants,sports.sports_team.location,San Francisco)[Confidence: 6.395062519004568e-05]
(San Francisco Giants,sports.sports_team.arena_stadium,AT&T Park)[Confidence: 5.913597851758823e-05]
(2014 Major League Baseball season,time.event.participant,San Francisco Giants)[Confidence: 5.756726750405505e-05]
(San Francisco,sports.sports_team_location.teams,San Francisco Giants)[Confidence: 4.663351137423888e-05]
(2010 Major League Baseball season,sports.sports_league_season.championship,2010 World Series)[Confidence: 4.4011550926370546e-05]
(AT&T Park,sports.sports_facility.teams,San Francisco Giants)[Confidence: 3.0568244255846366e-05]
(Dodgers–Giants rivalry,base.rivalries.rivalry.rival,San Francisco Giants)[Confidence: 1.6189556845347397e-05]
(2012 Major League Baseball season,sports.sports_league_season.championship,2012 World Series)[Confidence: 1.5469984646188095e-05]

Question:
What year did the team with mascot named Lou Seal win the World Series?"""


icl_sys_prompt_path_score = (
    "You are an inference assistant. Based on the inference path formed by the given knowledge graph triples and their confidence, your task is to answer questions.\n"
    "You must use only the entities found in the triplets that are **meaningful names** (e.g., 'Aviva Stadium', not 'm.0wz2kl3').\n"
    "Each answer must be a full entity name as it appears in the triplets.\n"
    "Return each answer in a new line, prefixed with 'ans:'.\n"
    "If the answer is not present or is an internal ID (like 'm.0xxx'), respond with 'ans: not available'."
)
last_prompt_path_score = (
    "Please return each answer in a new line, prefixed with 'ans:'. The answer should be a meaningful entity or information, "
    "not a random string like 'm02h98gq' or 'm.0xxx'.Please list all reasonable answers from the above triplets. If the answer is not present in the triplets, respond with 'ans: not available'."
)
icl_user_prompt_path_score = (
    """Input Paths:
Path 1 (Confidence: 0.95):
(Lou Seal, sports.mascot.team, San Francisco Giants)
(San Francisco Giants, sports.sports_team.championships, 2014 World Series)

Path 2 (Confidence: 0.92):
(Lou Seal, sports.mascot.team, San Francisco Giants)
(San Francisco Giants, sports.sports_team.championships, 2012 World Series)

Path 3 (Confidence: 0.90):
(Lou Seal, sports.mascot.team, San Francisco Giants)
(San Francisco Giants, sports.sports_team.championships, 2010 World Series)

Path 4 (Confidence: 0.40):
(Lou Seal, sports.mascot.team, San Francisco Giants)
(San Francisco Giants, sports.sports_team.arena_stadium, AT&T Park)

Path 5 (Confidence: 0.20):
(Lou Seal, sports.mascot.team, San Francisco Giants)
(San Francisco Giants, sports.sports_team.location, San Francisco)


Question: What year did the team with mascot named Lou Seal win the World Series?"""
)

icl_ass_path_prompt = (
    """To answer the question "What year did the team with mascot named Lou Seal win the World Series?", we examine the provided inference paths and their confidence scores.

Based on the paths, we can infer the following relevant information:
- Paths 1, 2, and 3 use the relationship (Lou Seal, sports.mascot.team, San Francisco Giants) to identify that Lou Seal is the mascot for the San Francisco Giants.
- Paths 1, 2, and 3 then connect the San Francisco Giants to their World Series championships: 2014 World Series, 2012 World Series, and 2010 World Series, respectively.

Paths 4 and 5 provide information about the San Francisco Giants (stadium, location, other events, another mascot) but do not answer the specific question about World Series wins.

Based on the relevant inference paths (Paths 1, 2, and 3), the team with mascot Lou Seal (the San Francisco Giants) won the World Series in 2014, 2012, and 2010.

Therefore, the formatted answers are:

ans: 2014 World Series (2014 World Series)
ans: 2012 World Series (2012 World Series)
ans: 2010 World Series (2010 World Series)"""
)
