# from transformers import pipeline
from utils.save_json import save_json
from utils.load_json import load_json
import os
import random

if __name__ == "__main__":
    cnt = 0

    for foldername, subfolders, filenames in os.walk('datas/task_datas'):
        for filename in filenames:
            if filename.endswith('.json'):
                
                datas = load_json(os.path.join(foldername, filename))

                ## Split the stances by new lines
                for data in datas:
                    for stance in data['stances']:
                        if isinstance(stance['stance'], str):
                            stance['stance'] = stance['stance'].split('\n\n') if len(stance['stance'].split('\n\n')) > 1 else stance['stance'].split('\n')

                ## Filter out the stances that do not start with the party name
                for data in datas:
                    for stance in data['stances']:
                        for stn in stance['stance']:
                            if not stn.startswith(stance['party_name']) and not stn.startswith(' ' + stance['party_name']):
                                cnt += 1
                        stance['stance'] = [stn for stn in stance['stance'] if stn.startswith((stance['party_name'], ' ' + stance['party_name']))]
                        
                save_json(datas, os.path.join(foldername, filename))
    
    print(cnt)