"""Automatically generated by binding_generator.py.

MuJoCo header version: 200
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import collections
import ctypes
# pylint: disable=undefined-variable
# pylint: disable=wildcard-import
from dm_control.mujoco.wrapper import util
from dm_control.mujoco.wrapper.mjbindings.types import *
import numpy as np
# pylint: disable=line-too-long
# pylint: disable=invalid-name
# common_typos_disable

mjlib = util.get_mjlib()

# ------------------------ctypes function declarations-------------------------

mjlib.mj_activate.__doc__ = """
Activate license, call mju_error on failure. Return 1 if ok, 0 if failure.

Args:
  filename: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_activate.argtypes = [
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_activate.restype = ctypes.c_int

mjlib.mj_deactivate.__doc__ = """
Deactivate license, free memory.
"""
mjlib.mj_deactivate.argtypes = None
mjlib.mj_deactivate.restype = None

mjlib.mj_certQuestion.__doc__ = """
Server side: generate certificate question.

Args:
  question: util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_certQuestion.argtypes = [
    util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_certQuestion.restype = None

mjlib.mj_certAnswer.__doc__ = """
Client side: generate certificate answer given question.

Args:
  question: util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')) <const>
  answer: util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_certAnswer.argtypes = [
    util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_certAnswer.restype = None

mjlib.mj_certCheck.__doc__ = """
Server side: check certificate question-answer pair; return 1 if match, 0 if
mismatch.

Args:
  question: util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')) <const>
  answer: util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_certCheck.argtypes = [
    util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(16,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_certCheck.restype = ctypes.c_int

mjlib.mj_defaultVFS.__doc__ = """
Initialize VFS to empty (no deallocation).

Args:
  vfs: ctypes.POINTER(MJVFS)
"""
mjlib.mj_defaultVFS.argtypes = [
    ctypes.POINTER(MJVFS),
]
mjlib.mj_defaultVFS.restype = None

mjlib.mj_addFileVFS.__doc__ = """
Add file to VFS, return 0: success, 1: full, 2: repeated name, -1: not found on
disk.

Args:
  vfs: ctypes.POINTER(MJVFS)
  directory: ctypes.POINTER(ctypes.c_char) <const>
  filename: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_addFileVFS.argtypes = [
    ctypes.POINTER(MJVFS),
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_addFileVFS.restype = ctypes.c_int

mjlib.mj_makeEmptyFileVFS.__doc__ = """
Make empty file in VFS, return 0: success, 1: full, 2: repeated name.

Args:
  vfs: ctypes.POINTER(MJVFS)
  filename: ctypes.POINTER(ctypes.c_char) <const>
  filesize: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mj_makeEmptyFileVFS.argtypes = [
    ctypes.POINTER(MJVFS),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mj_makeEmptyFileVFS.restype = ctypes.c_int

mjlib.mj_findFileVFS.__doc__ = """
Return file index in VFS, or -1 if not found in VFS.

Args:
  vfs: ctypes.POINTER(MJVFS) <const>
  filename: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_findFileVFS.argtypes = [
    ctypes.POINTER(MJVFS),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_findFileVFS.restype = ctypes.c_int

mjlib.mj_deleteFileVFS.__doc__ = """
Delete file from VFS, return 0: success, -1: not found in VFS.

Args:
  vfs: ctypes.POINTER(MJVFS)
  filename: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_deleteFileVFS.argtypes = [
    ctypes.POINTER(MJVFS),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_deleteFileVFS.restype = ctypes.c_int

mjlib.mj_deleteVFS.__doc__ = """
Delete all files from VFS.

Args:
  vfs: ctypes.POINTER(MJVFS)
"""
mjlib.mj_deleteVFS.argtypes = [
    ctypes.POINTER(MJVFS),
]
mjlib.mj_deleteVFS.restype = None

mjlib.mj_loadXML.__doc__ = """
Parse XML file in MJCF or URDF format, compile it, return low-level model. If
vfs is not NULL, look up files in vfs before reading from disk. If error is not
NULL, it must have size error_sz.

Args:
  filename: ctypes.POINTER(ctypes.c_char) <const>
  vfs: ctypes.POINTER(MJVFS) <const>
  error: ctypes.POINTER(ctypes.c_char)
  error_sz: ctypes.c_int

Returns:
  ctypes.POINTER(MJMODEL)
"""
mjlib.mj_loadXML.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(MJVFS),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mj_loadXML.restype = ctypes.POINTER(MJMODEL)

mjlib.mj_saveLastXML.__doc__ = """
Update XML data structures with info from low-level model, save as MJCF. If
error is not NULL, it must have size error_sz.

Args:
  filename: ctypes.POINTER(ctypes.c_char) <const>
  m: ctypes.POINTER(MJMODEL) <const>
  error: ctypes.POINTER(ctypes.c_char)
  error_sz: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mj_saveLastXML.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mj_saveLastXML.restype = ctypes.c_int

mjlib.mj_freeLastXML.__doc__ = """
Free last XML model if loaded. Called internally at each load.
"""
mjlib.mj_freeLastXML.argtypes = None
mjlib.mj_freeLastXML.restype = None

mjlib.mj_printSchema.__doc__ = """
Print internal XML schema as plain text or HTML, with style-padding or &nbsp;.

Args:
  filename: ctypes.POINTER(ctypes.c_char) <const>
  buffer_: ctypes.POINTER(ctypes.c_char)
  buffer_sz: ctypes.c_int
  flg_html: ctypes.c_int
  flg_pad: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mj_printSchema.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mj_printSchema.restype = ctypes.c_int

mjlib.mj_step.__doc__ = """
Advance simulation, use control callback to obtain external force and control.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_step.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_step.restype = None

mjlib.mj_step1.__doc__ = """
Advance simulation in two steps: before external force and control is set by
user.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_step1.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_step1.restype = None

mjlib.mj_step2.__doc__ = """
Advance simulation in two steps: after external force and control is set by
user.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_step2.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_step2.restype = None

mjlib.mj_forward.__doc__ = """
Forward dynamics: same as mj_step but do not integrate in time.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_forward.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_forward.restype = None

mjlib.mj_inverse.__doc__ = """
Inverse dynamics: qacc must be set before calling.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_inverse.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_inverse.restype = None

mjlib.mj_forwardSkip.__doc__ = """
Forward dynamics with skip; skipstage is mjtStage.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  skipstage: ctypes.c_int
  skipsensor: ctypes.c_int
"""
mjlib.mj_forwardSkip.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mj_forwardSkip.restype = None

mjlib.mj_inverseSkip.__doc__ = """
Inverse dynamics with skip; skipstage is mjtStage.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  skipstage: ctypes.c_int
  skipsensor: ctypes.c_int
"""
mjlib.mj_inverseSkip.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mj_inverseSkip.restype = None

mjlib.mj_defaultLROpt.__doc__ = """
Set default options for length range computation.

Args:
  opt: ctypes.POINTER(MJLROPT)
"""
mjlib.mj_defaultLROpt.argtypes = [
    ctypes.POINTER(MJLROPT),
]
mjlib.mj_defaultLROpt.restype = None

mjlib.mj_defaultSolRefImp.__doc__ = """
Set solver parameters to default values.

Args:
  solref: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  solimp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_defaultSolRefImp.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_defaultSolRefImp.restype = None

mjlib.mj_defaultOption.__doc__ = """
Set physics options to default values.

Args:
  opt: ctypes.POINTER(MJOPTION)
"""
mjlib.mj_defaultOption.argtypes = [
    ctypes.POINTER(MJOPTION),
]
mjlib.mj_defaultOption.restype = None

mjlib.mj_defaultVisual.__doc__ = """
Set visual options to default values.

Args:
  vis: ctypes.POINTER(MJVISUAL)
"""
mjlib.mj_defaultVisual.argtypes = [
    ctypes.POINTER(MJVISUAL),
]
mjlib.mj_defaultVisual.restype = None

mjlib.mj_copyModel.__doc__ = """
Copy mjModel, allocate new if dest is NULL.

Args:
  dest: ctypes.POINTER(MJMODEL)
  src: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.POINTER(MJMODEL)
"""
mjlib.mj_copyModel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_copyModel.restype = ctypes.POINTER(MJMODEL)

mjlib.mj_saveModel.__doc__ = """
Save model to binary MJB file or memory buffer; buffer has precedence when
given.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  filename: ctypes.POINTER(ctypes.c_char) <const>
  buffer_: ctypes.c_void_p
  buffer_sz: ctypes.c_int
"""
mjlib.mj_saveModel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_void_p,
    ctypes.c_int,
]
mjlib.mj_saveModel.restype = None

mjlib.mj_loadModel.__doc__ = """
Load model from binary MJB file. If vfs is not NULL, look up file in vfs before
reading from disk.

Args:
  filename: ctypes.POINTER(ctypes.c_char) <const>
  vfs: ctypes.POINTER(MJVFS) <const>

Returns:
  ctypes.POINTER(MJMODEL)
"""
mjlib.mj_loadModel.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(MJVFS),
]
mjlib.mj_loadModel.restype = ctypes.POINTER(MJMODEL)

mjlib.mj_deleteModel.__doc__ = """
Free memory allocation in model.

Args:
  m: ctypes.POINTER(MJMODEL)
"""
mjlib.mj_deleteModel.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_deleteModel.restype = None

mjlib.mj_sizeModel.__doc__ = """
Return size of buffer needed to hold model.

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_sizeModel.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_sizeModel.restype = ctypes.c_int

mjlib.mj_makeData.__doc__ = """
Allocate mjData correponding to given model.

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.POINTER(MJDATA)
"""
mjlib.mj_makeData.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_makeData.restype = ctypes.POINTER(MJDATA)

mjlib.mj_copyData.__doc__ = """
Copy mjData.

Args:
  dest: ctypes.POINTER(MJDATA)
  m: ctypes.POINTER(MJMODEL) <const>
  src: ctypes.POINTER(MJDATA) <const>

Returns:
  ctypes.POINTER(MJDATA)
"""
mjlib.mj_copyData.argtypes = [
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_copyData.restype = ctypes.POINTER(MJDATA)

mjlib.mj_resetData.__doc__ = """
Reset data to defaults.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_resetData.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_resetData.restype = None

mjlib.mj_resetDataDebug.__doc__ = """
Reset data to defaults, fill everything else with debug_value.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  debug_value: ctypes.c_ubyte
"""
mjlib.mj_resetDataDebug.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_ubyte,
]
mjlib.mj_resetDataDebug.restype = None

mjlib.mj_resetDataKeyframe.__doc__ = """
Reset data, set fields from specified keyframe.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  key: ctypes.c_int
"""
mjlib.mj_resetDataKeyframe.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
]
mjlib.mj_resetDataKeyframe.restype = None

mjlib.mj_stackAlloc.__doc__ = """
Allocate array of specified size on mjData stack. Call mju_error on stack
overflow.

Args:
  d: ctypes.POINTER(MJDATA)
  size: ctypes.c_int

Returns:
  util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_stackAlloc.argtypes = [
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
]
mjlib.mj_stackAlloc.restype = util.ndptr(dtype=np.float64, flags=('C', 'W'))

mjlib.mj_deleteData.__doc__ = """
Free memory allocation in mjData.

Args:
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_deleteData.argtypes = [
    ctypes.POINTER(MJDATA),
]
mjlib.mj_deleteData.restype = None

mjlib.mj_resetCallbacks.__doc__ = """
Reset all callbacks to NULL pointers (NULL is the default).
"""
mjlib.mj_resetCallbacks.argtypes = None
mjlib.mj_resetCallbacks.restype = None

mjlib.mj_setConst.__doc__ = """
Set constant fields of mjModel, corresponding to qpos0 configuration.

Args:
  m: ctypes.POINTER(MJMODEL)
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_setConst.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_setConst.restype = None

mjlib.mj_setLengthRange.__doc__ = """
Set actuator_lengthrange for specified actuator; return 1 if ok, 0 if error.

Args:
  m: ctypes.POINTER(MJMODEL)
  d: ctypes.POINTER(MJDATA)
  index: ctypes.c_int
  opt: ctypes.POINTER(MJLROPT) <const>
  error: ctypes.POINTER(ctypes.c_char)
  error_sz: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mj_setLengthRange.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.POINTER(MJLROPT),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mj_setLengthRange.restype = ctypes.c_int

mjlib.mj_printModel.__doc__ = """
Print model to text file.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  filename: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mj_printModel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_printModel.restype = None

mjlib.mj_printData.__doc__ = """
Print data to text file.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  filename: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mj_printData.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_printData.restype = None

mjlib.mju_printMat.__doc__ = """
Print matrix to screen.

Args:
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  nc: ctypes.c_int
"""
mjlib.mju_printMat.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_printMat.restype = None

mjlib.mju_printMatSparse.__doc__ = """
Print sparse matrix to screen.

Args:
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  rownnz: util.ndptr(dtype=np.intc, flags=('C', 'W')) <const>
  rowadr: util.ndptr(dtype=np.intc, flags=('C', 'W')) <const>
  colind: util.ndptr(dtype=np.intc, flags=('C', 'W')) <const>
"""
mjlib.mju_printMatSparse.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
]
mjlib.mju_printMatSparse.restype = None

mjlib.mj_fwdPosition.__doc__ = """
Run position-dependent computations.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_fwdPosition.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_fwdPosition.restype = None

mjlib.mj_fwdVelocity.__doc__ = """
Run velocity-dependent computations.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_fwdVelocity.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_fwdVelocity.restype = None

mjlib.mj_fwdActuation.__doc__ = """
Compute actuator force qfrc_actuation.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_fwdActuation.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_fwdActuation.restype = None

mjlib.mj_fwdAcceleration.__doc__ = """
Add up all non-constraint forces, compute qacc_unc.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_fwdAcceleration.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_fwdAcceleration.restype = None

mjlib.mj_fwdConstraint.__doc__ = """
Run selected constraint solver.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_fwdConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_fwdConstraint.restype = None

mjlib.mj_Euler.__doc__ = """
Euler integrator, semi-implicit in velocity.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_Euler.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_Euler.restype = None

mjlib.mj_RungeKutta.__doc__ = """
Runge-Kutta explicit order-N integrator.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  N: ctypes.c_int
"""
mjlib.mj_RungeKutta.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
]
mjlib.mj_RungeKutta.restype = None

mjlib.mj_invPosition.__doc__ = """
Run position-dependent computations in inverse dynamics.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_invPosition.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_invPosition.restype = None

mjlib.mj_invVelocity.__doc__ = """
Run velocity-dependent computations in inverse dynamics.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_invVelocity.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_invVelocity.restype = None

mjlib.mj_invConstraint.__doc__ = """
Apply the analytical formula for inverse constraint dynamics.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_invConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_invConstraint.restype = None

mjlib.mj_compareFwdInv.__doc__ = """
Compare forward and inverse dynamics, save results in fwdinv.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_compareFwdInv.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_compareFwdInv.restype = None

mjlib.mj_sensorPos.__doc__ = """
Evaluate position-dependent sensors.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_sensorPos.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_sensorPos.restype = None

mjlib.mj_sensorVel.__doc__ = """
Evaluate velocity-dependent sensors.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_sensorVel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_sensorVel.restype = None

mjlib.mj_sensorAcc.__doc__ = """
Evaluate acceleration and force-dependent sensors.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_sensorAcc.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_sensorAcc.restype = None

mjlib.mj_energyPos.__doc__ = """
Evaluate position-dependent energy (potential).

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_energyPos.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_energyPos.restype = None

mjlib.mj_energyVel.__doc__ = """
Evaluate velocity-dependent energy (kinetic).

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_energyVel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_energyVel.restype = None

mjlib.mj_checkPos.__doc__ = """
Check qpos, reset if any element is too big or nan.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_checkPos.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_checkPos.restype = None

mjlib.mj_checkVel.__doc__ = """
Check qvel, reset if any element is too big or nan.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_checkVel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_checkVel.restype = None

mjlib.mj_checkAcc.__doc__ = """
Check qacc, reset if any element is too big or nan.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_checkAcc.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_checkAcc.restype = None

mjlib.mj_kinematics.__doc__ = """
Run forward kinematics.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_kinematics.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_kinematics.restype = None

mjlib.mj_comPos.__doc__ = """
Map inertias and motion dofs to global frame centered at CoM.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_comPos.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_comPos.restype = None

mjlib.mj_camlight.__doc__ = """
Compute camera and light positions and orientations.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_camlight.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_camlight.restype = None

mjlib.mj_tendon.__doc__ = """
Compute tendon lengths, velocities and moment arms.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_tendon.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_tendon.restype = None

mjlib.mj_transmission.__doc__ = """
Compute actuator transmission lengths and moments.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_transmission.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_transmission.restype = None

mjlib.mj_crb.__doc__ = """
Run composite rigid body inertia algorithm (CRB).

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_crb.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_crb.restype = None

mjlib.mj_factorM.__doc__ = """
Compute sparse L'*D*L factorizaton of inertia matrix.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_factorM.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_factorM.restype = None

mjlib.mj_solveM.__doc__ = """
Solve linear system M * x = y using factorization: x = inv(L'*D*L)*y.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  x: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  y: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mj_solveM.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_solveM.restype = None

mjlib.mj_solveM2.__doc__ = """
Half of linear solve: x = sqrt(inv(D))*inv(L')*y.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  x: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  y: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mj_solveM2.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_solveM2.restype = None

mjlib.mj_comVel.__doc__ = """
Compute cvel, cdof_dot.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_comVel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_comVel.restype = None

mjlib.mj_passive.__doc__ = """
Compute qfrc_passive from spring-dampers, viscosity and density.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_passive.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_passive.restype = None

mjlib.mj_subtreeVel.__doc__ = """
subtree linear velocity and angular momentum.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_subtreeVel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_subtreeVel.restype = None

mjlib.mj_rne.__doc__ = """
RNE: compute M(qpos)*qacc + C(qpos,qvel); flg_acc=0 removes inertial term.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  flg_acc: ctypes.c_int
  result: util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_rne.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_rne.restype = None

mjlib.mj_rnePostConstraint.__doc__ = """
RNE with complete data: compute cacc, cfrc_ext, cfrc_int.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_rnePostConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_rnePostConstraint.restype = None

mjlib.mj_collision.__doc__ = """
Run collision detection.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_collision.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_collision.restype = None

mjlib.mj_makeConstraint.__doc__ = """
Construct constraints.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_makeConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_makeConstraint.restype = None

mjlib.mj_projectConstraint.__doc__ = """
Compute inverse constaint inertia efc_AR.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_projectConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_projectConstraint.restype = None

mjlib.mj_referenceConstraint.__doc__ = """
Compute efc_vel, efc_aref.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
"""
mjlib.mj_referenceConstraint.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
]
mjlib.mj_referenceConstraint.restype = None

mjlib.mj_constraintUpdate.__doc__ = """
Compute efc_state, efc_force, qfrc_constraint, and (optionally) cone Hessians.
If cost is not NULL, set *cost = s(jar) where jar = Jac*qacc-aref.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  jar: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  cost: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  flg_coneHessian: ctypes.c_int
"""
mjlib.mj_constraintUpdate.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_constraintUpdate.restype = None

mjlib.mj_addContact.__doc__ = """
Add contact to d->contact list; return 0 if success; 1 if buffer full.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  con: ctypes.POINTER(MJCONTACT) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_addContact.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJCONTACT),
]
mjlib.mj_addContact.restype = ctypes.c_int

mjlib.mj_isPyramidal.__doc__ = """
Determine type of friction cone.

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_isPyramidal.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_isPyramidal.restype = ctypes.c_int

mjlib.mj_isSparse.__doc__ = """
Determine type of constraint Jacobian.

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_isSparse.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_isSparse.restype = ctypes.c_int

mjlib.mj_isDual.__doc__ = """
Determine type of solver (PGS is dual, CG and Newton are primal).

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_isDual.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_isDual.restype = ctypes.c_int

mjlib.mj_mulJacVec.__doc__ = """
Multiply dense or sparse constraint Jacobian by vector.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_mulJacVec.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_mulJacVec.restype = None

mjlib.mj_mulJacTVec.__doc__ = """
Multiply dense or sparse constraint Jacobian transpose by vector.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_mulJacTVec.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_mulJacTVec.restype = None

mjlib.mj_jac.__doc__ = """
Compute 3/6-by-nv end-effector Jacobian of global point attached to given body.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  jacp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacr: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  point: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  body: ctypes.c_int
"""
mjlib.mj_jac.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jac.restype = None

mjlib.mj_jacBody.__doc__ = """
Compute body frame end-effector Jacobian.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  jacp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacr: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  body: ctypes.c_int
"""
mjlib.mj_jacBody.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jacBody.restype = None

mjlib.mj_jacBodyCom.__doc__ = """
Compute body center-of-mass end-effector Jacobian.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  jacp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacr: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  body: ctypes.c_int
"""
mjlib.mj_jacBodyCom.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jacBodyCom.restype = None

mjlib.mj_jacGeom.__doc__ = """
Compute geom end-effector Jacobian.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  jacp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacr: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  geom: ctypes.c_int
"""
mjlib.mj_jacGeom.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jacGeom.restype = None

mjlib.mj_jacSite.__doc__ = """
Compute site end-effector Jacobian.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  jacp: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacr: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  site: ctypes.c_int
"""
mjlib.mj_jacSite.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jacSite.restype = None

mjlib.mj_jacPointAxis.__doc__ = """
Compute translation end-effector Jacobian of point, and rotation Jacobian of
axis.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  jacPoint: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  jacAxis: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  point: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  axis: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  body: ctypes.c_int
"""
mjlib.mj_jacPointAxis.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_jacPointAxis.restype = None

mjlib.mj_name2id.__doc__ = """
Get id of object with specified name, return -1 if not found; type is mjtObj.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  type_: ctypes.c_int
  name: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mj_name2id.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.c_int,
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mj_name2id.restype = ctypes.c_int

mjlib.mj_id2name.__doc__ = """
Get name of object with specified id, return 0 if invalid type or id; type is
mjtObj.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  type_: ctypes.c_int
  id_: ctypes.c_int

Returns:
  ctypes.POINTER(ctypes.c_char)
"""
mjlib.mj_id2name.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mj_id2name.restype = ctypes.POINTER(ctypes.c_char)

mjlib.mj_fullM.__doc__ = """
Convert sparse inertia matrix M into full (i.e. dense) matrix.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  dst: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  M: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_fullM.argtypes = [
    ctypes.POINTER(MJMODEL),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_fullM.restype = None

mjlib.mj_mulM.__doc__ = """
Multiply vector by inertia matrix.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_mulM.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_mulM.restype = None

mjlib.mj_mulM2.__doc__ = """
Multiply vector by (inertia matrix)^(1/2).

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_mulM2.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_mulM2.restype = None

mjlib.mj_addM.__doc__ = """
Add inertia matrix to destination matrix. Destination can be sparse
uncompressed, or dense when all int* are NULL.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  dst: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  rownnz: util.ndptr(dtype=np.intc, flags=('C', 'W'))
  rowadr: util.ndptr(dtype=np.intc, flags=('C', 'W'))
  colind: util.ndptr(dtype=np.intc, flags=('C', 'W'))
"""
mjlib.mj_addM.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
]
mjlib.mj_addM.restype = None

mjlib.mj_applyFT.__doc__ = """
Apply cartesian force and torque (outside xfrc_applied mechanism).

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  force: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  torque: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  point: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  body: ctypes.c_int
  qfrc_target: util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_applyFT.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_applyFT.restype = None

mjlib.mj_objectVelocity.__doc__ = """
Compute object 6D velocity in object-centered frame, world/local orientation.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  objtype: ctypes.c_int
  objid: ctypes.c_int
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  flg_local: ctypes.c_int
"""
mjlib.mj_objectVelocity.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_objectVelocity.restype = None

mjlib.mj_objectAcceleration.__doc__ = """
Compute object 6D acceleration in object-centered frame, world/local
orientation.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  objtype: ctypes.c_int
  objid: ctypes.c_int
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  flg_local: ctypes.c_int
"""
mjlib.mj_objectAcceleration.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mj_objectAcceleration.restype = None

mjlib.mj_contactForce.__doc__ = """
Extract 6D force:torque for one contact, in contact frame.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  id_: ctypes.c_int
  result: util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_contactForce.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_contactForce.restype = None

mjlib.mj_differentiatePos.__doc__ = """
Compute velocity by finite-differencing two positions.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  qvel: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  dt: ctypes.c_double
  qpos1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  qpos2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mj_differentiatePos.argtypes = [
    ctypes.POINTER(MJMODEL),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_differentiatePos.restype = None

mjlib.mj_integratePos.__doc__ = """
Integrate position with given velocity.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  qpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  qvel: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  dt: ctypes.c_double
"""
mjlib.mj_integratePos.argtypes = [
    ctypes.POINTER(MJMODEL),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mj_integratePos.restype = None

mjlib.mj_normalizeQuat.__doc__ = """
Normalize all quaterions in qpos-type vector.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  qpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mj_normalizeQuat.argtypes = [
    ctypes.POINTER(MJMODEL),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_normalizeQuat.restype = None

mjlib.mj_local2Global.__doc__ = """
Map from body local to global Cartesian coordinates.

Args:
  d: ctypes.POINTER(MJDATA)
  xpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  xmat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  pos: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  quat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  body: ctypes.c_int
  sameframe: ctypes.c_ubyte
"""
mjlib.mj_local2Global.argtypes = [
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_ubyte,
]
mjlib.mj_local2Global.restype = None

mjlib.mj_getTotalmass.__doc__ = """
Sum all body masses.

Args:
  m: ctypes.POINTER(MJMODEL) <const>

Returns:
  ctypes.c_double
"""
mjlib.mj_getTotalmass.argtypes = [
    ctypes.POINTER(MJMODEL),
]
mjlib.mj_getTotalmass.restype = ctypes.c_double

mjlib.mj_setTotalmass.__doc__ = """
Scale body masses and inertias to achieve specified total mass.

Args:
  m: ctypes.POINTER(MJMODEL)
  newmass: ctypes.c_double
"""
mjlib.mj_setTotalmass.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.c_double,
]
mjlib.mj_setTotalmass.restype = None

mjlib.mj_version.__doc__ = """
Return version number: 1.0.2 is encoded as 102.

Returns:
  ctypes.c_int
"""
mjlib.mj_version.argtypes = None
mjlib.mj_version.restype = ctypes.c_int

mjlib.mj_ray.__doc__ = """
Intersect ray (pnt+x*vec, x>=0) with visible geoms, except geoms in bodyexclude.
Return geomid and distance (x) to nearest surface, or -1 if no intersection.
geomgroup, flg_static are as in mjvOption; geomgroup==NULL skips group
exclusion.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  pnt: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  geomgroup: util.ndptr(dtype=np.ubyte, flags=('C', 'W')) <const>
  flg_static: ctypes.c_ubyte
  bodyexclude: ctypes.c_int
  geomid: util.ndptr(dtype=np.intc, flags=('C', 'W'))

Returns:
  ctypes.c_double
"""
mjlib.mj_ray.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.ubyte, flags=('C', 'W')),
    ctypes.c_ubyte,
    ctypes.c_int,
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
]
mjlib.mj_ray.restype = ctypes.c_double

mjlib.mj_rayHfield.__doc__ = """
Interect ray with hfield, return nearest distance or -1 if no intersection.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  geomid: ctypes.c_int
  pnt: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mj_rayHfield.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_rayHfield.restype = ctypes.c_double

mjlib.mj_rayMesh.__doc__ = """
Interect ray with mesh, return nearest distance or -1 if no intersection.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  geomid: ctypes.c_int
  pnt: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mj_rayMesh.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mj_rayMesh.restype = ctypes.c_double

mjlib.mju_rayGeom.__doc__ = """
Interect ray with pure geom, return nearest distance or -1 if no intersection.

Args:
  pos: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  size: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  pnt: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  geomtype: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_rayGeom.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_rayGeom.restype = ctypes.c_double

mjlib.mju_raySkin.__doc__ = """
Interect ray with skin, return nearest vertex id.

Args:
  nface: ctypes.c_int
  nvert: ctypes.c_int
  face: util.ndptr(dtype=np.intc, flags=('C', 'W')) <const>
  vert: util.ndptr(dtype=np.float32, flags=('C', 'W')) <const>
  pnt: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vertid: util.ndptr(dtype=np.intc, flags=('C', 'W'))

Returns:
  ctypes.c_double
"""
mjlib.mju_raySkin.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
]
mjlib.mju_raySkin.restype = ctypes.c_double

mjlib.mjv_defaultCamera.__doc__ = """
Set default camera.

Args:
  cam: ctypes.POINTER(MJVCAMERA)
"""
mjlib.mjv_defaultCamera.argtypes = [
    ctypes.POINTER(MJVCAMERA),
]
mjlib.mjv_defaultCamera.restype = None

mjlib.mjv_defaultPerturb.__doc__ = """
Set default perturbation.

Args:
  pert: ctypes.POINTER(MJVPERTURB)
"""
mjlib.mjv_defaultPerturb.argtypes = [
    ctypes.POINTER(MJVPERTURB),
]
mjlib.mjv_defaultPerturb.restype = None

mjlib.mjv_room2model.__doc__ = """
Transform pose from room to model space.

Args:
  modelpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  modelquat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  roompos: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  roomquat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scn: ctypes.POINTER(MJVSCENE) <const>
"""
mjlib.mjv_room2model.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_room2model.restype = None

mjlib.mjv_model2room.__doc__ = """
Transform pose from model to room space.

Args:
  roompos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  roomquat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  modelpos: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  modelquat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scn: ctypes.POINTER(MJVSCENE) <const>
"""
mjlib.mjv_model2room.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_model2room.restype = None

mjlib.mjv_cameraInModel.__doc__ = """
Get camera info in model space; average left and right OpenGL cameras.

Args:
  headpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  forward: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  up: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  scn: ctypes.POINTER(MJVSCENE) <const>
"""
mjlib.mjv_cameraInModel.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_cameraInModel.restype = None

mjlib.mjv_cameraInRoom.__doc__ = """
Get camera info in room space; average left and right OpenGL cameras.

Args:
  headpos: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  forward: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  up: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  scn: ctypes.POINTER(MJVSCENE) <const>
"""
mjlib.mjv_cameraInRoom.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_cameraInRoom.restype = None

mjlib.mjv_frustumHeight.__doc__ = """
Get frustum height at unit distance from camera; average left and right OpenGL
cameras.

Args:
  scn: ctypes.POINTER(MJVSCENE) <const>

Returns:
  ctypes.c_double
"""
mjlib.mjv_frustumHeight.argtypes = [
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_frustumHeight.restype = ctypes.c_double

mjlib.mjv_alignToCamera.__doc__ = """
Rotate 3D vec in horizontal plane by angle between (0,1) and
(forward_x,forward_y).

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  forward: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mjv_alignToCamera.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mjv_alignToCamera.restype = None

mjlib.mjv_moveCamera.__doc__ = """
Move camera with mouse; action is mjtMouse.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  action: ctypes.c_int
  reldx: ctypes.c_double
  reldy: ctypes.c_double
  scn: ctypes.POINTER(MJVSCENE) <const>
  cam: ctypes.POINTER(MJVCAMERA)
"""
mjlib.mjv_moveCamera.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.c_int,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.POINTER(MJVSCENE),
    ctypes.POINTER(MJVCAMERA),
]
mjlib.mjv_moveCamera.restype = None

mjlib.mjv_movePerturb.__doc__ = """
Move perturb object with mouse; action is mjtMouse.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  action: ctypes.c_int
  reldx: ctypes.c_double
  reldy: ctypes.c_double
  scn: ctypes.POINTER(MJVSCENE) <const>
  pert: ctypes.POINTER(MJVPERTURB)
"""
mjlib.mjv_movePerturb.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.POINTER(MJVSCENE),
    ctypes.POINTER(MJVPERTURB),
]
mjlib.mjv_movePerturb.restype = None

mjlib.mjv_moveModel.__doc__ = """
Move model with mouse; action is mjtMouse.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  action: ctypes.c_int
  reldx: ctypes.c_double
  reldy: ctypes.c_double
  roomup: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_moveModel.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.c_int,
    ctypes.c_double,
    ctypes.c_double,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_moveModel.restype = None

mjlib.mjv_initPerturb.__doc__ = """
Copy perturb pos,quat from selected body; set scale for perturbation.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  scn: ctypes.POINTER(MJVSCENE) <const>
  pert: ctypes.POINTER(MJVPERTURB)
"""
mjlib.mjv_initPerturb.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVSCENE),
    ctypes.POINTER(MJVPERTURB),
]
mjlib.mjv_initPerturb.restype = None

mjlib.mjv_applyPerturbPose.__doc__ = """
Set perturb pos,quat in d->mocap when selected body is mocap, and in d->qpos
otherwise. Write d->qpos only if flg_paused and subtree root for selected body
has free joint.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  pert: ctypes.POINTER(MJVPERTURB) <const>
  flg_paused: ctypes.c_int
"""
mjlib.mjv_applyPerturbPose.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVPERTURB),
    ctypes.c_int,
]
mjlib.mjv_applyPerturbPose.restype = None

mjlib.mjv_applyPerturbForce.__doc__ = """
Set perturb force,torque in d->xfrc_applied, if selected body is dynamic.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  pert: ctypes.POINTER(MJVPERTURB) <const>
"""
mjlib.mjv_applyPerturbForce.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVPERTURB),
]
mjlib.mjv_applyPerturbForce.restype = None

mjlib.mjv_averageCamera.__doc__ = """
Return the average of two OpenGL cameras.

Args:
  cam1: ctypes.POINTER(MJVGLCAMERA) <const>
  cam2: ctypes.POINTER(MJVGLCAMERA) <const>

Returns:
  MJVGLCAMERA
"""
mjlib.mjv_averageCamera.argtypes = [
    ctypes.POINTER(MJVGLCAMERA),
    ctypes.POINTER(MJVGLCAMERA),
]
mjlib.mjv_averageCamera.restype = MJVGLCAMERA

mjlib.mjv_select.__doc__ = """
Select geom or skin with mouse, return bodyid; -1: none selected.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA) <const>
  vopt: ctypes.POINTER(MJVOPTION) <const>
  aspectratio: ctypes.c_double
  relx: ctypes.c_double
  rely: ctypes.c_double
  scn: ctypes.POINTER(MJVSCENE) <const>
  selpnt: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  geomid: util.ndptr(dtype=np.intc, flags=('C', 'W'))
  skinid: util.ndptr(dtype=np.intc, flags=('C', 'W'))

Returns:
  ctypes.c_int
"""
mjlib.mjv_select.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVOPTION),
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.POINTER(MJVSCENE),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
    util.ndptr(dtype=np.intc, flags=('C', 'W')),
]
mjlib.mjv_select.restype = ctypes.c_int

mjlib.mjv_defaultOption.__doc__ = """
Set default visualization options.

Args:
  opt: ctypes.POINTER(MJVOPTION)
"""
mjlib.mjv_defaultOption.argtypes = [
    ctypes.POINTER(MJVOPTION),
]
mjlib.mjv_defaultOption.restype = None

mjlib.mjv_defaultFigure.__doc__ = """
Set default figure.

Args:
  fig: ctypes.POINTER(MJVFIGURE)
"""
mjlib.mjv_defaultFigure.argtypes = [
    ctypes.POINTER(MJVFIGURE),
]
mjlib.mjv_defaultFigure.restype = None

mjlib.mjv_initGeom.__doc__ = """
Initialize given geom fields when not NULL, set the rest to their default
values.

Args:
  geom: ctypes.POINTER(MJVGEOM)
  type_: ctypes.c_int
  size: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  pos: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  rgba: util.ndptr(dtype=np.float32, flags=('C', 'W')) <const>
"""
mjlib.mjv_initGeom.argtypes = [
    ctypes.POINTER(MJVGEOM),
    ctypes.c_int,
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
]
mjlib.mjv_initGeom.restype = None

mjlib.mjv_makeConnector.__doc__ = """
Set (type, size, pos, mat) for connector-type geom between given points. Assume
that mjv_initGeom was already called to set all other properties.

Args:
  geom: ctypes.POINTER(MJVGEOM)
  type_: ctypes.c_int
  width: ctypes.c_double
  a0: ctypes.c_double
  a1: ctypes.c_double
  a2: ctypes.c_double
  b0: ctypes.c_double
  b1: ctypes.c_double
  b2: ctypes.c_double
"""
mjlib.mjv_makeConnector.argtypes = [
    ctypes.POINTER(MJVGEOM),
    ctypes.c_int,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
]
mjlib.mjv_makeConnector.restype = None

mjlib.mjv_defaultScene.__doc__ = """
Set default abstract scene.

Args:
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_defaultScene.argtypes = [
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_defaultScene.restype = None

mjlib.mjv_makeScene.__doc__ = """
Allocate resources in abstract scene.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  scn: ctypes.POINTER(MJVSCENE)
  maxgeom: ctypes.c_int
"""
mjlib.mjv_makeScene.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJVSCENE),
    ctypes.c_int,
]
mjlib.mjv_makeScene.restype = None

mjlib.mjv_freeScene.__doc__ = """
Free abstract scene.

Args:
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_freeScene.argtypes = [
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_freeScene.restype = None

mjlib.mjv_updateScene.__doc__ = """
Update entire scene given model state.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  opt: ctypes.POINTER(MJVOPTION) <const>
  pert: ctypes.POINTER(MJVPERTURB) <const>
  cam: ctypes.POINTER(MJVCAMERA)
  catmask: ctypes.c_int
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_updateScene.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVOPTION),
    ctypes.POINTER(MJVPERTURB),
    ctypes.POINTER(MJVCAMERA),
    ctypes.c_int,
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_updateScene.restype = None

mjlib.mjv_addGeoms.__doc__ = """
Add geoms from selected categories.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  opt: ctypes.POINTER(MJVOPTION) <const>
  pert: ctypes.POINTER(MJVPERTURB) <const>
  catmask: ctypes.c_int
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_addGeoms.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVOPTION),
    ctypes.POINTER(MJVPERTURB),
    ctypes.c_int,
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_addGeoms.restype = None

mjlib.mjv_makeLights.__doc__ = """
Make list of lights.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_makeLights.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_makeLights.restype = None

mjlib.mjv_updateCamera.__doc__ = """
Update camera.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  cam: ctypes.POINTER(MJVCAMERA)
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_updateCamera.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVCAMERA),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_updateCamera.restype = None

mjlib.mjv_updateSkin.__doc__ = """
Update skins.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  d: ctypes.POINTER(MJDATA)
  scn: ctypes.POINTER(MJVSCENE)
"""
mjlib.mjv_updateSkin.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJDATA),
    ctypes.POINTER(MJVSCENE),
]
mjlib.mjv_updateSkin.restype = None

mjlib.mjr_defaultContext.__doc__ = """
Set default mjrContext.

Args:
  con: ctypes.POINTER(MJRCONTEXT)
"""
mjlib.mjr_defaultContext.argtypes = [
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_defaultContext.restype = None

mjlib.mjr_makeContext.__doc__ = """
Allocate resources in custom OpenGL context; fontscale is mjtFontScale.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  con: ctypes.POINTER(MJRCONTEXT)
  fontscale: ctypes.c_int
"""
mjlib.mjr_makeContext.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJRCONTEXT),
    ctypes.c_int,
]
mjlib.mjr_makeContext.restype = None

mjlib.mjr_changeFont.__doc__ = """
Change font of existing context.

Args:
  fontscale: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT)
"""
mjlib.mjr_changeFont.argtypes = [
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_changeFont.restype = None

mjlib.mjr_addAux.__doc__ = """
Add Aux buffer with given index to context; free previous Aux buffer.

Args:
  index: ctypes.c_int
  width: ctypes.c_int
  height: ctypes.c_int
  samples: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT)
"""
mjlib.mjr_addAux.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_addAux.restype = None

mjlib.mjr_freeContext.__doc__ = """
Free resources in custom OpenGL context, set to default.

Args:
  con: ctypes.POINTER(MJRCONTEXT)
"""
mjlib.mjr_freeContext.argtypes = [
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_freeContext.restype = None

mjlib.mjr_uploadTexture.__doc__ = """
Upload texture to GPU, overwriting previous upload if any.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
  texid: ctypes.c_int
"""
mjlib.mjr_uploadTexture.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJRCONTEXT),
    ctypes.c_int,
]
mjlib.mjr_uploadTexture.restype = None

mjlib.mjr_uploadMesh.__doc__ = """
Upload mesh to GPU, overwriting previous upload if any.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
  meshid: ctypes.c_int
"""
mjlib.mjr_uploadMesh.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJRCONTEXT),
    ctypes.c_int,
]
mjlib.mjr_uploadMesh.restype = None

mjlib.mjr_uploadHField.__doc__ = """
Upload height field to GPU, overwriting previous upload if any.

Args:
  m: ctypes.POINTER(MJMODEL) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
  hfieldid: ctypes.c_int
"""
mjlib.mjr_uploadHField.argtypes = [
    ctypes.POINTER(MJMODEL),
    ctypes.POINTER(MJRCONTEXT),
    ctypes.c_int,
]
mjlib.mjr_uploadHField.restype = None

mjlib.mjr_restoreBuffer.__doc__ = """
Make con->currentBuffer current again.

Args:
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_restoreBuffer.argtypes = [
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_restoreBuffer.restype = None

mjlib.mjr_setBuffer.__doc__ = """
Set OpenGL framebuffer for rendering: mjFB_WINDOW or mjFB_OFFSCREEN. If only one
buffer is available, set that buffer and ignore framebuffer argument.

Args:
  framebuffer: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT)
"""
mjlib.mjr_setBuffer.argtypes = [
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_setBuffer.restype = None

mjlib.mjr_readPixels.__doc__ = """
Read pixels from current OpenGL framebuffer to client buffer. Viewport is in
OpenGL framebuffer; client buffer starts at (0,0).

Args:
  rgb: util.ndptr(dtype=np.ubyte, flags=('C', 'W'))
  depth: util.ndptr(dtype=np.float32, flags=('C', 'W'))
  viewport: MJRRECT
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_readPixels.argtypes = [
    util.ndptr(dtype=np.ubyte, flags=('C', 'W')),
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
    MJRRECT,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_readPixels.restype = None

mjlib.mjr_drawPixels.__doc__ = """
Draw pixels from client buffer to current OpenGL framebuffer. Viewport is in
OpenGL framebuffer; client buffer starts at (0,0).

Args:
  rgb: util.ndptr(dtype=np.ubyte, flags=('C', 'W')) <const>
  depth: util.ndptr(dtype=np.float32, flags=('C', 'W')) <const>
  viewport: MJRRECT
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_drawPixels.argtypes = [
    util.ndptr(dtype=np.ubyte, flags=('C', 'W')),
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
    MJRRECT,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_drawPixels.restype = None

mjlib.mjr_blitBuffer.__doc__ = """
Blit from src viewpoint in current framebuffer to dst viewport in other
framebuffer. If src, dst have different size and flg_depth==0, color is
interpolated with GL_LINEAR.

Args:
  src: MJRRECT
  dst: MJRRECT
  flg_color: ctypes.c_int
  flg_depth: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_blitBuffer.argtypes = [
    MJRRECT,
    MJRRECT,
    ctypes.c_int,
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_blitBuffer.restype = None

mjlib.mjr_setAux.__doc__ = """
Set Aux buffer for custom OpenGL rendering (call restoreBuffer when done).

Args:
  index: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_setAux.argtypes = [
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_setAux.restype = None

mjlib.mjr_blitAux.__doc__ = """
Blit from Aux buffer to con->currentBuffer.

Args:
  index: ctypes.c_int
  src: MJRRECT
  left: ctypes.c_int
  bottom: ctypes.c_int
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_blitAux.argtypes = [
    ctypes.c_int,
    MJRRECT,
    ctypes.c_int,
    ctypes.c_int,
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_blitAux.restype = None

mjlib.mjr_text.__doc__ = """
Draw text at (x,y) in relative coordinates; font is mjtFont.

Args:
  font: ctypes.c_int
  txt: ctypes.POINTER(ctypes.c_char) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
  x: ctypes.c_float
  y: ctypes.c_float
  r: ctypes.c_float
  g: ctypes.c_float
  b: ctypes.c_float
"""
mjlib.mjr_text.argtypes = [
    ctypes.c_int,
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(MJRCONTEXT),
    ctypes.c_float,
    ctypes.c_float,
    ctypes.c_float,
    ctypes.c_float,
    ctypes.c_float,
]
mjlib.mjr_text.restype = None

mjlib.mjr_overlay.__doc__ = """
Draw text overlay; font is mjtFont; gridpos is mjtGridPos.

Args:
  font: ctypes.c_int
  gridpos: ctypes.c_int
  viewport: MJRRECT
  overlay: ctypes.POINTER(ctypes.c_char) <const>
  overlay2: ctypes.POINTER(ctypes.c_char) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_overlay.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
    MJRRECT,
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_overlay.restype = None

mjlib.mjr_maxViewport.__doc__ = """
Get maximum viewport for active buffer.

Args:
  con: ctypes.POINTER(MJRCONTEXT) <const>

Returns:
  MJRRECT
"""
mjlib.mjr_maxViewport.argtypes = [
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_maxViewport.restype = MJRRECT

mjlib.mjr_rectangle.__doc__ = """
Draw rectangle.

Args:
  viewport: MJRRECT
  r: ctypes.c_float
  g: ctypes.c_float
  b: ctypes.c_float
  a: ctypes.c_float
"""
mjlib.mjr_rectangle.argtypes = [
    MJRRECT,
    ctypes.c_float,
    ctypes.c_float,
    ctypes.c_float,
    ctypes.c_float,
]
mjlib.mjr_rectangle.restype = None

mjlib.mjr_figure.__doc__ = """
Draw 2D figure.

Args:
  viewport: MJRRECT
  fig: ctypes.POINTER(MJVFIGURE)
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_figure.argtypes = [
    MJRRECT,
    ctypes.POINTER(MJVFIGURE),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_figure.restype = None

mjlib.mjr_render.__doc__ = """
Render 3D scene.

Args:
  viewport: MJRRECT
  scn: ctypes.POINTER(MJVSCENE)
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjr_render.argtypes = [
    MJRRECT,
    ctypes.POINTER(MJVSCENE),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjr_render.restype = None

mjlib.mjr_finish.__doc__ = """
Call glFinish.
"""
mjlib.mjr_finish.argtypes = None
mjlib.mjr_finish.restype = None

mjlib.mjr_getError.__doc__ = """
Call glGetError and return result.

Returns:
  ctypes.c_int
"""
mjlib.mjr_getError.argtypes = None
mjlib.mjr_getError.restype = ctypes.c_int

mjlib.mjr_findRect.__doc__ = """
Find first rectangle containing mouse, -1: not found.

Args:
  x: ctypes.c_int
  y: ctypes.c_int
  nrect: ctypes.c_int
  rect: ctypes.POINTER(MJRRECT) <const>

Returns:
  ctypes.c_int
"""
mjlib.mjr_findRect.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
    ctypes.POINTER(MJRRECT),
]
mjlib.mjr_findRect.restype = ctypes.c_int

mjlib.mjui_themeSpacing.__doc__ = """
Get builtin UI theme spacing (ind: 0-1).

Args:
  ind: ctypes.c_int

Returns:
  MJUITHEMESPACING
"""
mjlib.mjui_themeSpacing.argtypes = [
    ctypes.c_int,
]
mjlib.mjui_themeSpacing.restype = MJUITHEMESPACING

mjlib.mjui_themeColor.__doc__ = """
Get builtin UI theme color (ind: 0-3).

Args:
  ind: ctypes.c_int

Returns:
  MJUITHEMECOLOR
"""
mjlib.mjui_themeColor.argtypes = [
    ctypes.c_int,
]
mjlib.mjui_themeColor.restype = MJUITHEMECOLOR

mjlib.mjui_add.__doc__ = """
Add definitions to UI.

Args:
  ui: ctypes.POINTER(MJUI)
  def_: ctypes.POINTER(MJUIDEF) <const>
"""
mjlib.mjui_add.argtypes = [
    ctypes.POINTER(MJUI),
    ctypes.POINTER(MJUIDEF),
]
mjlib.mjui_add.restype = None

mjlib.mjui_resize.__doc__ = """
Compute UI sizes.

Args:
  ui: ctypes.POINTER(MJUI)
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjui_resize.argtypes = [
    ctypes.POINTER(MJUI),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjui_resize.restype = None

mjlib.mjui_update.__doc__ = """
Update specific section/item; -1: update all.

Args:
  section: ctypes.c_int
  item: ctypes.c_int
  ui: ctypes.POINTER(MJUI) <const>
  state: ctypes.POINTER(MJUISTATE) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjui_update.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
    ctypes.POINTER(MJUI),
    ctypes.POINTER(MJUISTATE),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjui_update.restype = None

mjlib.mjui_event.__doc__ = """
Handle UI event, return pointer to changed item, NULL if no change.

Args:
  ui: ctypes.POINTER(MJUI)
  state: ctypes.POINTER(MJUISTATE)
  con: ctypes.POINTER(MJRCONTEXT) <const>

Returns:
  ctypes.POINTER(MJUIITEM)
"""
mjlib.mjui_event.argtypes = [
    ctypes.POINTER(MJUI),
    ctypes.POINTER(MJUISTATE),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjui_event.restype = ctypes.POINTER(MJUIITEM)

mjlib.mjui_render.__doc__ = """
Copy UI image to current buffer.

Args:
  ui: ctypes.POINTER(MJUI)
  state: ctypes.POINTER(MJUISTATE) <const>
  con: ctypes.POINTER(MJRCONTEXT) <const>
"""
mjlib.mjui_render.argtypes = [
    ctypes.POINTER(MJUI),
    ctypes.POINTER(MJUISTATE),
    ctypes.POINTER(MJRCONTEXT),
]
mjlib.mjui_render.restype = None

mjlib.mju_error.__doc__ = """
Main error function; does not return to caller.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mju_error.argtypes = [
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_error.restype = None

mjlib.mju_error_i.__doc__ = """
Error function with int argument; msg is a printf format string.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
  i: ctypes.c_int
"""
mjlib.mju_error_i.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mju_error_i.restype = None

mjlib.mju_error_s.__doc__ = """
Error function with string argument.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
  text: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mju_error_s.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_error_s.restype = None

mjlib.mju_warning.__doc__ = """
Main warning function; returns to caller.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mju_warning.argtypes = [
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_warning.restype = None

mjlib.mju_warning_i.__doc__ = """
Warning function with int argument.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
  i: ctypes.c_int
"""
mjlib.mju_warning_i.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mju_warning_i.restype = None

mjlib.mju_warning_s.__doc__ = """
Warning function with string argument.

Args:
  msg: ctypes.POINTER(ctypes.c_char) <const>
  text: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mju_warning_s.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_warning_s.restype = None

mjlib.mju_clearHandlers.__doc__ = """
Clear user error and memory handlers.
"""
mjlib.mju_clearHandlers.argtypes = None
mjlib.mju_clearHandlers.restype = None

mjlib.mju_malloc.__doc__ = """
Allocate memory; byte-align on 8; pad size to multiple of 8.

Args:
  size: ctypes.c_size_t

Returns:
  ctypes.c_void_p
"""
mjlib.mju_malloc.argtypes = [
    ctypes.c_size_t,
]
mjlib.mju_malloc.restype = ctypes.c_void_p

mjlib.mju_free.__doc__ = """
Free memory, using free() by default.

Args:
  ptr: ctypes.c_void_p
"""
mjlib.mju_free.argtypes = [
    ctypes.c_void_p,
]
mjlib.mju_free.restype = None

mjlib.mj_warning.__doc__ = """
High-level warning function: count warnings in mjData, print only the first.

Args:
  d: ctypes.POINTER(MJDATA)
  warning: ctypes.c_int
  info: ctypes.c_int
"""
mjlib.mj_warning.argtypes = [
    ctypes.POINTER(MJDATA),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mj_warning.restype = None

mjlib.mju_writeLog.__doc__ = """
Write [datetime, type: message] to MUJOCO_LOG.TXT.

Args:
  type_: ctypes.POINTER(ctypes.c_char) <const>
  msg: ctypes.POINTER(ctypes.c_char) <const>
"""
mjlib.mju_writeLog.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_writeLog.restype = None

mjlib.mju_zero3.__doc__ = """
Set res = 0.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mju_zero3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_zero3.restype = None

mjlib.mju_copy3.__doc__ = """
Set res = vec.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  data: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_copy3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_copy3.restype = None

mjlib.mju_scl3.__doc__ = """
Set res = vec*scl.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
"""
mjlib.mju_scl3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_scl3.restype = None

mjlib.mju_add3.__doc__ = """
Set res = vec1 + vec2.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_add3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_add3.restype = None

mjlib.mju_sub3.__doc__ = """
Set res = vec1 - vec2.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_sub3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_sub3.restype = None

mjlib.mju_addTo3.__doc__ = """
Set res = res + vec.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_addTo3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_addTo3.restype = None

mjlib.mju_subFrom3.__doc__ = """
Set res = res - vec.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_subFrom3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_subFrom3.restype = None

mjlib.mju_addToScl3.__doc__ = """
Set res = res + vec*scl.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
"""
mjlib.mju_addToScl3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_addToScl3.restype = None

mjlib.mju_addScl3.__doc__ = """
Set res = vec1 + vec2*scl.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
"""
mjlib.mju_addScl3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_addScl3.restype = None

mjlib.mju_normalize3.__doc__ = """
Normalize vector, return length before normalization.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))

Returns:
  ctypes.c_double
"""
mjlib.mju_normalize3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_normalize3.restype = ctypes.c_double

mjlib.mju_norm3.__doc__ = """
Return vector length (without normalizing the vector).

Args:
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_norm3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_norm3.restype = ctypes.c_double

mjlib.mju_dot3.__doc__ = """
Return dot-product of vec1 and vec2.

Args:
  vec1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_dot3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_dot3.restype = ctypes.c_double

mjlib.mju_dist3.__doc__ = """
Return Cartesian distance between 3D vectors pos1 and pos2.

Args:
  pos1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  pos2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_dist3.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_dist3.restype = ctypes.c_double

mjlib.mju_rotVecMat.__doc__ = """
Multiply vector by 3D rotation matrix: res = mat * vec.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  mat: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_rotVecMat.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_rotVecMat.restype = None

mjlib.mju_rotVecMatT.__doc__ = """
Multiply vector by transposed 3D rotation matrix: res = mat' * vec.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  mat: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_rotVecMatT.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_rotVecMatT.restype = None

mjlib.mju_cross.__doc__ = """
Compute cross-product: res = cross(a, b).

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  a: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  b: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_cross.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_cross.restype = None

mjlib.mju_zero4.__doc__ = """
Set res = 0.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mju_zero4.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_zero4.restype = None

mjlib.mju_unit4.__doc__ = """
Set res = (1,0,0,0).

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
"""
mjlib.mju_unit4.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_unit4.restype = None

mjlib.mju_copy4.__doc__ = """
Set res = vec.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  data: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_copy4.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_copy4.restype = None

mjlib.mju_normalize4.__doc__ = """
Normalize vector, return length before normalization.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))

Returns:
  ctypes.c_double
"""
mjlib.mju_normalize4.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_normalize4.restype = ctypes.c_double

mjlib.mju_zero.__doc__ = """
Set res = 0.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int
"""
mjlib.mju_zero.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_zero.restype = None

mjlib.mju_copy.__doc__ = """
Set res = vec.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  data: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_copy.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_copy.restype = None

mjlib.mju_sum.__doc__ = """
Return sum(vec).

Args:
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_sum.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_sum.restype = ctypes.c_double

mjlib.mju_L1.__doc__ = """
Return L1 norm: sum(abs(vec)).

Args:
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_L1.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_L1.restype = ctypes.c_double

mjlib.mju_scl.__doc__ = """
Set res = vec*scl.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
  n: ctypes.c_int
"""
mjlib.mju_scl.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    ctypes.c_int,
]
mjlib.mju_scl.restype = None

mjlib.mju_add.__doc__ = """
Set res = vec1 + vec2.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_add.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_add.restype = None

mjlib.mju_sub.__doc__ = """
Set res = vec1 - vec2.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_sub.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_sub.restype = None

mjlib.mju_addTo.__doc__ = """
Set res = res + vec.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_addTo.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_addTo.restype = None

mjlib.mju_subFrom.__doc__ = """
Set res = res - vec.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_subFrom.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_subFrom.restype = None

mjlib.mju_addToScl.__doc__ = """
Set res = res + vec*scl.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
  n: ctypes.c_int
"""
mjlib.mju_addToScl.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    ctypes.c_int,
]
mjlib.mju_addToScl.restype = None

mjlib.mju_addScl.__doc__ = """
Set res = vec1 + vec2*scl.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  scl: ctypes.c_double
  n: ctypes.c_int
"""
mjlib.mju_addScl.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    ctypes.c_int,
]
mjlib.mju_addScl.restype = None

mjlib.mju_normalize.__doc__ = """
Normalize vector, return length before normalization.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_normalize.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_normalize.restype = ctypes.c_double

mjlib.mju_norm.__doc__ = """
Return vector length (without normalizing vector).

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_norm.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_norm.restype = ctypes.c_double

mjlib.mju_dot.__doc__ = """
Return dot-product of vec1 and vec2.

Args:
  vec1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_dot.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_dot.restype = ctypes.c_double

mjlib.mju_mulMatVec.__doc__ = """
Multiply matrix and vector: res = mat * vec.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  nc: ctypes.c_int
"""
mjlib.mju_mulMatVec.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_mulMatVec.restype = None

mjlib.mju_mulMatTVec.__doc__ = """
Multiply transposed matrix and vector: res = mat' * vec.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  nc: ctypes.c_int
"""
mjlib.mju_mulMatTVec.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_mulMatTVec.restype = None

mjlib.mju_transpose.__doc__ = """
Transpose matrix: res = mat'.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  nc: ctypes.c_int
"""
mjlib.mju_transpose.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_transpose.restype = None

mjlib.mju_mulMatMat.__doc__ = """
Multiply matrices: res = mat1 * mat2.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mat2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  r1: ctypes.c_int
  c1: ctypes.c_int
  c2: ctypes.c_int
"""
mjlib.mju_mulMatMat.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_mulMatMat.restype = None

mjlib.mju_mulMatMatT.__doc__ = """
Multiply matrices, second argument transposed: res = mat1 * mat2'.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mat2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  r1: ctypes.c_int
  c1: ctypes.c_int
  r2: ctypes.c_int
"""
mjlib.mju_mulMatMatT.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_mulMatMatT.restype = None

mjlib.mju_mulMatTMat.__doc__ = """
Multiply matrices, first argument transposed: res = mat1' * mat2.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat1: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mat2: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  r1: ctypes.c_int
  c1: ctypes.c_int
  c2: ctypes.c_int
"""
mjlib.mju_mulMatTMat.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_mulMatTMat.restype = None

mjlib.mju_sqrMatTD.__doc__ = """
Set res = mat' * diag * mat if diag is not NULL, and res = mat' * mat otherwise.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  diag: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  nr: ctypes.c_int
  nc: ctypes.c_int
"""
mjlib.mju_sqrMatTD.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_sqrMatTD.restype = None

mjlib.mju_transformSpatial.__doc__ = """
Coordinate transform of 6D motion or force vector in rotation:translation
format. rotnew2old is 3-by-3, NULL means no rotation; flg_force specifies force
or motion type.

Args:
  res: util.ndptr(shape=(6,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(6,), dtype=np.float64, flags=('C', 'W')) <const>
  flg_force: ctypes.c_int
  newpos: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  oldpos: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  rotnew2old: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_transformSpatial.argtypes = [
    util.ndptr(shape=(6,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(6,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_transformSpatial.restype = None

mjlib.mju_rotVecQuat.__doc__ = """
Rotate vector by quaternion.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_rotVecQuat.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_rotVecQuat.restype = None

mjlib.mju_negQuat.__doc__ = """
Conjugate quaternion, corresponding to opposite rotation.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_negQuat.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_negQuat.restype = None

mjlib.mju_mulQuat.__doc__ = """
Muiltiply quaternions.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  quat1: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  quat2: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_mulQuat.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_mulQuat.restype = None

mjlib.mju_mulQuatAxis.__doc__ = """
Muiltiply quaternion and axis.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  axis: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_mulQuatAxis.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_mulQuatAxis.restype = None

mjlib.mju_axisAngle2Quat.__doc__ = """
Convert axisAngle to quaternion.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  axis: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  angle: ctypes.c_double
"""
mjlib.mju_axisAngle2Quat.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_axisAngle2Quat.restype = None

mjlib.mju_quat2Vel.__doc__ = """
Convert quaternion (corresponding to orientation difference) to 3D velocity.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  dt: ctypes.c_double
"""
mjlib.mju_quat2Vel.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_quat2Vel.restype = None

mjlib.mju_subQuat.__doc__ = """
Subtract quaternions, express as 3D velocity: qb*quat(res) = qa.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  qa: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  qb: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_subQuat.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_subQuat.restype = None

mjlib.mju_quat2Mat.__doc__ = """
Convert quaternion to 3D rotation matrix.

Args:
  res: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_quat2Mat.argtypes = [
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_quat2Mat.restype = None

mjlib.mju_mat2Quat.__doc__ = """
Convert 3D rotation matrix to quaterion.

Args:
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_mat2Quat.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_mat2Quat.restype = None

mjlib.mju_derivQuat.__doc__ = """
Compute time-derivative of quaternion, given 3D rotational velocity.

Args:
  res: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  vel: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_derivQuat.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_derivQuat.restype = None

mjlib.mju_quatIntegrate.__doc__ = """
Integrate quaterion given 3D angular velocity.

Args:
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  vel: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  scale: ctypes.c_double
"""
mjlib.mju_quatIntegrate.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
]
mjlib.mju_quatIntegrate.restype = None

mjlib.mju_quatZ2Vec.__doc__ = """
Construct quaternion performing rotation from z-axis to given vector.

Args:
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_quatZ2Vec.argtypes = [
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_quatZ2Vec.restype = None

mjlib.mju_mulPose.__doc__ = """
Multiply two poses.

Args:
  posres: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  quatres: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  pos1: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  quat1: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  pos2: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  quat2: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_mulPose.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_mulPose.restype = None

mjlib.mju_negPose.__doc__ = """
Conjugate pose, corresponding to the opposite spatial transformation.

Args:
  posres: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  quatres: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W'))
  pos: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_negPose.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_negPose.restype = None

mjlib.mju_trnVecPose.__doc__ = """
Transform vector by pose.

Args:
  res: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W'))
  pos: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
  quat: util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')) <const>
"""
mjlib.mju_trnVecPose.argtypes = [
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(4,), dtype=np.float64, flags=('C', 'W')),
    util.ndptr(shape=(3,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_trnVecPose.restype = None

mjlib.mju_cholFactor.__doc__ = """
Cholesky decomposition: mat = L*L'; return rank.

Args:
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int
  mindiag: ctypes.c_double

Returns:
  ctypes.c_int
"""
mjlib.mju_cholFactor.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_double,
]
mjlib.mju_cholFactor.restype = ctypes.c_int

mjlib.mju_cholSolve.__doc__ = """
Solve mat * res = vec, where mat is Cholesky-factorized.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_cholSolve.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_cholSolve.restype = None

mjlib.mju_cholUpdate.__doc__ = """
Cholesky rank-one update: L*L' +/- x*x'; return rank.

Args:
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  x: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int
  flg_plus: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mju_cholUpdate.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_cholUpdate.restype = ctypes.c_int

mjlib.mju_eig3.__doc__ = """
Eigenvalue decomposition of symmetric 3x3 matrix.

Args:
  eigval: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  eigvec: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  quat: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  mat: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_int
"""
mjlib.mju_eig3.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_eig3.restype = ctypes.c_int

mjlib.mju_muscleGain.__doc__ = """
Muscle active force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax,
fvmax).

Args:
  len_: ctypes.c_double
  vel: ctypes.c_double
  lengthrange: util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')) <const>
  acc0: ctypes.c_double
  prm: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_muscleGain.argtypes = [
    ctypes.c_double,
    ctypes.c_double,
    util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_muscleGain.restype = ctypes.c_double

mjlib.mju_muscleBias.__doc__ = """
Muscle passive force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax,
fvmax).

Args:
  len_: ctypes.c_double
  lengthrange: util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')) <const>
  acc0: ctypes.c_double
  prm: util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_muscleBias.argtypes = [
    ctypes.c_double,
    util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')),
    ctypes.c_double,
    util.ndptr(shape=(9,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_muscleBias.restype = ctypes.c_double

mjlib.mju_muscleDynamics.__doc__ = """
Muscle activation dynamics, prm = (tau_act, tau_deact).

Args:
  ctrl: ctypes.c_double
  act: ctypes.c_double
  prm: util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')) <const>

Returns:
  ctypes.c_double
"""
mjlib.mju_muscleDynamics.argtypes = [
    ctypes.c_double,
    ctypes.c_double,
    util.ndptr(shape=(2,), dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_muscleDynamics.restype = ctypes.c_double

mjlib.mju_encodePyramid.__doc__ = """
Convert contact force to pyramid representation.

Args:
  pyramid: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  force: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mu: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  dim: ctypes.c_int
"""
mjlib.mju_encodePyramid.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_encodePyramid.restype = None

mjlib.mju_decodePyramid.__doc__ = """
Convert pyramid representation to contact force.

Args:
  force: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  pyramid: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  mu: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  dim: ctypes.c_int
"""
mjlib.mju_decodePyramid.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_decodePyramid.restype = None

mjlib.mju_springDamper.__doc__ = """
Integrate spring-damper analytically, return pos(dt).

Args:
  pos0: ctypes.c_double
  vel0: ctypes.c_double
  Kp: ctypes.c_double
  Kv: ctypes.c_double
  dt: ctypes.c_double

Returns:
  ctypes.c_double
"""
mjlib.mju_springDamper.argtypes = [
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
]
mjlib.mju_springDamper.restype = ctypes.c_double

mjlib.mju_min.__doc__ = """
Return min(a,b) with single evaluation of a and b.

Args:
  a: ctypes.c_double
  b: ctypes.c_double

Returns:
  ctypes.c_double
"""
mjlib.mju_min.argtypes = [
    ctypes.c_double,
    ctypes.c_double,
]
mjlib.mju_min.restype = ctypes.c_double

mjlib.mju_max.__doc__ = """
Return max(a,b) with single evaluation of a and b.

Args:
  a: ctypes.c_double
  b: ctypes.c_double

Returns:
  ctypes.c_double
"""
mjlib.mju_max.argtypes = [
    ctypes.c_double,
    ctypes.c_double,
]
mjlib.mju_max.restype = ctypes.c_double

mjlib.mju_sign.__doc__ = """
Return sign of x: +1, -1 or 0.

Args:
  x: ctypes.c_double

Returns:
  ctypes.c_double
"""
mjlib.mju_sign.argtypes = [
    ctypes.c_double,
]
mjlib.mju_sign.restype = ctypes.c_double

mjlib.mju_round.__doc__ = """
Round x to nearest integer.

Args:
  x: ctypes.c_double

Returns:
  ctypes.c_int
"""
mjlib.mju_round.argtypes = [
    ctypes.c_double,
]
mjlib.mju_round.restype = ctypes.c_int

mjlib.mju_type2Str.__doc__ = """
Convert type id (mjtObj) to type name.

Args:
  type_: ctypes.c_int

Returns:
  ctypes.POINTER(ctypes.c_char)
"""
mjlib.mju_type2Str.argtypes = [
    ctypes.c_int,
]
mjlib.mju_type2Str.restype = ctypes.POINTER(ctypes.c_char)

mjlib.mju_str2Type.__doc__ = """
Convert type name to type id (mjtObj).

Args:
  str_: ctypes.POINTER(ctypes.c_char) <const>

Returns:
  ctypes.c_int
"""
mjlib.mju_str2Type.argtypes = [
    ctypes.POINTER(ctypes.c_char),
]
mjlib.mju_str2Type.restype = ctypes.c_int

mjlib.mju_warningText.__doc__ = """
Construct a warning message given the warning type and info.

Args:
  warning: ctypes.c_int
  info: ctypes.c_int

Returns:
  ctypes.POINTER(ctypes.c_char)
"""
mjlib.mju_warningText.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_warningText.restype = ctypes.POINTER(ctypes.c_char)

mjlib.mju_isBad.__doc__ = """
Return 1 if nan or abs(x)>mjMAXVAL, 0 otherwise. Used by check functions.

Args:
  x: ctypes.c_double

Returns:
  ctypes.c_int
"""
mjlib.mju_isBad.argtypes = [
    ctypes.c_double,
]
mjlib.mju_isBad.restype = ctypes.c_int

mjlib.mju_isZero.__doc__ = """
Return 1 if all elements are 0.

Args:
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int

Returns:
  ctypes.c_int
"""
mjlib.mju_isZero.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_isZero.restype = ctypes.c_int

mjlib.mju_standardNormal.__doc__ = """
Standard normal random number generator (optional second number).

Args:
  num2: util.ndptr(dtype=np.float64, flags=('C', 'W'))

Returns:
  ctypes.c_double
"""
mjlib.mju_standardNormal.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
]
mjlib.mju_standardNormal.restype = ctypes.c_double

mjlib.mju_f2n.__doc__ = """
Convert from float to mjtNum.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float32, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_f2n.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_f2n.restype = None

mjlib.mju_n2f.__doc__ = """
Convert from mjtNum to float.

Args:
  res: util.ndptr(dtype=np.float32, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_n2f.argtypes = [
    util.ndptr(dtype=np.float32, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_n2f.restype = None

mjlib.mju_d2n.__doc__ = """
Convert from double to mjtNum.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_d2n.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_d2n.restype = None

mjlib.mju_n2d.__doc__ = """
Convert from mjtNum to double.

Args:
  res: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  vec: util.ndptr(dtype=np.float64, flags=('C', 'W')) <const>
  n: ctypes.c_int
"""
mjlib.mju_n2d.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_n2d.restype = None

mjlib.mju_insertionSort.__doc__ = """
Insertion sort, resulting list is in increasing order.

Args:
  list_: util.ndptr(dtype=np.float64, flags=('C', 'W'))
  n: ctypes.c_int
"""
mjlib.mju_insertionSort.argtypes = [
    util.ndptr(dtype=np.float64, flags=('C', 'W')),
    ctypes.c_int,
]
mjlib.mju_insertionSort.restype = None

mjlib.mju_Halton.__doc__ = """
Generate Halton sequence.

Args:
  index: ctypes.c_int
  base: ctypes.c_int

Returns:
  ctypes.c_double
"""
mjlib.mju_Halton.argtypes = [
    ctypes.c_int,
    ctypes.c_int,
]
mjlib.mju_Halton.restype = ctypes.c_double

mjlib.mju_strncpy.__doc__ = """
Call strncpy, then set dst[n-1] = 0.

Args:
  dst: ctypes.POINTER(ctypes.c_char)
  src: ctypes.POINTER(ctypes.c_char) <const>
  n: ctypes.c_int

Returns:
  ctypes.POINTER(ctypes.c_char)
"""
mjlib.mju_strncpy.argtypes = [
    ctypes.POINTER(ctypes.c_char),
    ctypes.POINTER(ctypes.c_char),
    ctypes.c_int,
]
mjlib.mju_strncpy.restype = ctypes.POINTER(ctypes.c_char)

# --------------------------------String arrays--------------------------------

mjDISABLESTRING = (ctypes.c_char_p * 12).in_dll(mjlib, 'mjDISABLESTRING')
mjENABLESTRING = (ctypes.c_char_p * 4).in_dll(mjlib, 'mjENABLESTRING')
mjTIMERSTRING = (ctypes.c_char_p * 13).in_dll(mjlib, 'mjTIMERSTRING')
mjLABELSTRING = (ctypes.c_char_p * 14).in_dll(mjlib, 'mjLABELSTRING')
mjFRAMESTRING = (ctypes.c_char_p * 7).in_dll(mjlib, 'mjFRAMESTRING')
mjVISSTRING = ((ctypes.c_char_p * 3) * 22).in_dll(mjlib, 'mjVISSTRING')
mjRNDSTRING = ((ctypes.c_char_p * 3) * 9).in_dll(mjlib, 'mjRNDSTRING')

# -------------------------Callback function pointers--------------------------

class _Callbacks(object):

  __slots__ = [
      '_mjcb_passive',
      '_mjcb_control',
      '_mjcb_contactfilter',
      '_mjcb_sensor',
      '_mjcb_time',
      '_mjcb_act_dyn',
      '_mjcb_act_gain',
      '_mjcb_act_bias'
  ]

  def __init__(self):
    self._mjcb_passive = ctypes.c_void_p.in_dll(mjlib, 'mjcb_passive')
    self._mjcb_control = ctypes.c_void_p.in_dll(mjlib, 'mjcb_control')
    self._mjcb_contactfilter = ctypes.c_void_p.in_dll(mjlib, 'mjcb_contactfilter')
    self._mjcb_sensor = ctypes.c_void_p.in_dll(mjlib, 'mjcb_sensor')
    self._mjcb_time = ctypes.c_void_p.in_dll(mjlib, 'mjcb_time')
    self._mjcb_act_dyn = ctypes.c_void_p.in_dll(mjlib, 'mjcb_act_dyn')
    self._mjcb_act_gain = ctypes.c_void_p.in_dll(mjlib, 'mjcb_act_gain')
    self._mjcb_act_bias = ctypes.c_void_p.in_dll(mjlib, 'mjcb_act_bias')

  @property
  def mjcb_passive(self):
    if self._mjcb_passive.value:
      return mjfGeneric(self._mjcb_passive.value)
    else:
      return None

  @mjcb_passive.setter
  def mjcb_passive(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfGeneric)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_passive._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_passive.value = new_func_ptr.value

  @property
  def mjcb_control(self):
    if self._mjcb_control.value:
      return mjfGeneric(self._mjcb_control.value)
    else:
      return None

  @mjcb_control.setter
  def mjcb_control(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfGeneric)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_control._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_control.value = new_func_ptr.value

  @property
  def mjcb_contactfilter(self):
    if self._mjcb_contactfilter.value:
      return mjfGeneric(self._mjcb_contactfilter.value)
    else:
      return None

  @mjcb_contactfilter.setter
  def mjcb_contactfilter(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfGeneric)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_contactfilter._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_contactfilter.value = new_func_ptr.value

  @property
  def mjcb_sensor(self):
    if self._mjcb_sensor.value:
      return mjfSensor(self._mjcb_sensor.value)
    else:
      return None

  @mjcb_sensor.setter
  def mjcb_sensor(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfSensor)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_sensor._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_sensor.value = new_func_ptr.value

  @property
  def mjcb_time(self):
    if self._mjcb_time.value:
      return mjfTime(self._mjcb_time.value)
    else:
      return None

  @mjcb_time.setter
  def mjcb_time(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfTime)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_time._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_time.value = new_func_ptr.value

  @property
  def mjcb_act_dyn(self):
    if self._mjcb_act_dyn.value:
      return mjfAct(self._mjcb_act_dyn.value)
    else:
      return None

  @mjcb_act_dyn.setter
  def mjcb_act_dyn(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfAct)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_act_dyn._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_act_dyn.value = new_func_ptr.value

  @property
  def mjcb_act_gain(self):
    if self._mjcb_act_gain.value:
      return mjfAct(self._mjcb_act_gain.value)
    else:
      return None

  @mjcb_act_gain.setter
  def mjcb_act_gain(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfAct)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_act_gain._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_act_gain.value = new_func_ptr.value

  @property
  def mjcb_act_bias(self):
    if self._mjcb_act_bias.value:
      return mjfAct(self._mjcb_act_bias.value)
    else:
      return None

  @mjcb_act_bias.setter
  def mjcb_act_bias(self, value):
    new_func_ptr, wrapped_pyfunc = util.cast_func_to_c_void_p(
        value, mjfAct)
    # Prevents wrapped_pyfunc from being inadvertently garbage collected.
    self._mjcb_act_bias._wrapped_pyfunc = wrapped_pyfunc
    self._mjcb_act_bias.value = new_func_ptr.value


callbacks = _Callbacks()  # pylint: disable=invalid-name
del _Callbacks

# ----------------------------End of generated code----------------------------
