"""Automatically generated by binding_generator.py.

MuJoCo header version: 200
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import ctypes

# ------------ctypes struct, union, and function type declarations-------------


class MJLROPT(ctypes.Structure):
  """options for mj_setLengthRange()."""
  _fields_ = [
      ('mode', ctypes.c_int),
      ('useexisting', ctypes.c_int),
      ('uselimit', ctypes.c_int),
      ('accel', ctypes.c_double),
      ('maxforce', ctypes.c_double),
      ('timeconst', ctypes.c_double),
      ('timestep', ctypes.c_double),
      ('inttotal', ctypes.c_double),
      ('inteval', ctypes.c_double),
      ('tolrange', ctypes.c_double),
  ]


class MJVFS(ctypes.Structure):
  """virtual file system for loading from memory."""
  _fields_ = [
      ('nfile', ctypes.c_int),
      ('filename', ctypes.c_char * 200 * 100),
      ('filesize', ctypes.c_int * (200)),
      ('filedata', ctypes.c_void_p * 200),
  ]


class MJOPTION(ctypes.Structure):
  """physics options."""
  _fields_ = [
      ('timestep', ctypes.c_double),
      ('apirate', ctypes.c_double),
      ('impratio', ctypes.c_double),
      ('tolerance', ctypes.c_double),
      ('noslip_tolerance', ctypes.c_double),
      ('mpr_tolerance', ctypes.c_double),
      ('gravity', ctypes.c_double * (3)),
      ('wind', ctypes.c_double * (3)),
      ('magnetic', ctypes.c_double * (3)),
      ('density', ctypes.c_double),
      ('viscosity', ctypes.c_double),
      ('o_margin', ctypes.c_double),
      ('o_solref', ctypes.c_double * (2)),
      ('o_solimp', ctypes.c_double * (5)),
      ('integrator', ctypes.c_int),
      ('collision', ctypes.c_int),
      ('cone', ctypes.c_int),
      ('jacobian', ctypes.c_int),
      ('solver', ctypes.c_int),
      ('iterations', ctypes.c_int),
      ('noslip_iterations', ctypes.c_int),
      ('mpr_iterations', ctypes.c_int),
      ('disableflags', ctypes.c_int),
      ('enableflags', ctypes.c_int),
  ]


class GLOBAL(ctypes.Structure):
  """global parameters."""
  _fields_ = [
      ('fovy', ctypes.c_float),
      ('ipd', ctypes.c_float),
      ('linewidth', ctypes.c_float),
      ('glow', ctypes.c_float),
      ('offwidth', ctypes.c_int),
      ('offheight', ctypes.c_int),
  ]


class QUALITY(ctypes.Structure):
  """rendering quality."""
  _fields_ = [
      ('shadowsize', ctypes.c_int),
      ('offsamples', ctypes.c_int),
      ('numslices', ctypes.c_int),
      ('numstacks', ctypes.c_int),
      ('numquads', ctypes.c_int),
  ]


class HEADLIGHT(ctypes.Structure):
  """head light."""
  _fields_ = [
      ('ambient', ctypes.c_float * (3)),
      ('diffuse', ctypes.c_float * (3)),
      ('specular', ctypes.c_float * (3)),
      ('active', ctypes.c_int),
  ]


class MAP(ctypes.Structure):
  """mapping."""
  _fields_ = [
      ('stiffness', ctypes.c_float),
      ('stiffnessrot', ctypes.c_float),
      ('force', ctypes.c_float),
      ('torque', ctypes.c_float),
      ('alpha', ctypes.c_float),
      ('fogstart', ctypes.c_float),
      ('fogend', ctypes.c_float),
      ('znear', ctypes.c_float),
      ('zfar', ctypes.c_float),
      ('haze', ctypes.c_float),
      ('shadowclip', ctypes.c_float),
      ('shadowscale', ctypes.c_float),
      ('actuatortendon', ctypes.c_float),
  ]


class SCALE(ctypes.Structure):
  """scale of decor elements relative to mean body size."""
  _fields_ = [
      ('forcewidth', ctypes.c_float),
      ('contactwidth', ctypes.c_float),
      ('contactheight', ctypes.c_float),
      ('connect', ctypes.c_float),
      ('com', ctypes.c_float),
      ('camera', ctypes.c_float),
      ('light', ctypes.c_float),
      ('selectpoint', ctypes.c_float),
      ('jointlength', ctypes.c_float),
      ('jointwidth', ctypes.c_float),
      ('actuatorlength', ctypes.c_float),
      ('actuatorwidth', ctypes.c_float),
      ('framelength', ctypes.c_float),
      ('framewidth', ctypes.c_float),
      ('constraint', ctypes.c_float),
      ('slidercrank', ctypes.c_float),
  ]


class RGBA(ctypes.Structure):
  """color of decor elements."""
  _fields_ = [
      ('fog', ctypes.c_float * (4)),
      ('haze', ctypes.c_float * (4)),
      ('force', ctypes.c_float * (4)),
      ('inertia', ctypes.c_float * (4)),
      ('joint', ctypes.c_float * (4)),
      ('actuator', ctypes.c_float * (4)),
      ('actuatornegative', ctypes.c_float * (4)),
      ('actuatorpositive', ctypes.c_float * (4)),
      ('com', ctypes.c_float * (4)),
      ('camera', ctypes.c_float * (4)),
      ('light', ctypes.c_float * (4)),
      ('selectpoint', ctypes.c_float * (4)),
      ('connect', ctypes.c_float * (4)),
      ('contactpoint', ctypes.c_float * (4)),
      ('contactforce', ctypes.c_float * (4)),
      ('contactfriction', ctypes.c_float * (4)),
      ('contacttorque', ctypes.c_float * (4)),
      ('contactgap', ctypes.c_float * (4)),
      ('rangefinder', ctypes.c_float * (4)),
      ('constraint', ctypes.c_float * (4)),
      ('slidercrank', ctypes.c_float * (4)),
      ('crankbroken', ctypes.c_float * (4)),
  ]


class MJVISUAL(ctypes.Structure):
  """visualization options."""
  _fields_ = [
      ('global_', GLOBAL),
      ('quality', QUALITY),
      ('headlight', HEADLIGHT),
      ('map_', MAP),
      ('scale', SCALE),
      ('rgba', RGBA),
  ]


class MJSTATISTIC(ctypes.Structure):
  """model statistics (in qpos0)."""
  _fields_ = [
      ('meaninertia', ctypes.c_double),
      ('meanmass', ctypes.c_double),
      ('meansize', ctypes.c_double),
      ('extent', ctypes.c_double),
      ('center', ctypes.c_double * (3)),
  ]


class MJMODEL(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('nq', ctypes.c_int),
      ('nv', ctypes.c_int),
      ('nu', ctypes.c_int),
      ('na', ctypes.c_int),
      ('nbody', ctypes.c_int),
      ('njnt', ctypes.c_int),
      ('ngeom', ctypes.c_int),
      ('nsite', ctypes.c_int),
      ('ncam', ctypes.c_int),
      ('nlight', ctypes.c_int),
      ('nmesh', ctypes.c_int),
      ('nmeshvert', ctypes.c_int),
      ('nmeshtexvert', ctypes.c_int),
      ('nmeshface', ctypes.c_int),
      ('nmeshgraph', ctypes.c_int),
      ('nskin', ctypes.c_int),
      ('nskinvert', ctypes.c_int),
      ('nskintexvert', ctypes.c_int),
      ('nskinface', ctypes.c_int),
      ('nskinbone', ctypes.c_int),
      ('nskinbonevert', ctypes.c_int),
      ('nhfield', ctypes.c_int),
      ('nhfielddata', ctypes.c_int),
      ('ntex', ctypes.c_int),
      ('ntexdata', ctypes.c_int),
      ('nmat', ctypes.c_int),
      ('npair', ctypes.c_int),
      ('nexclude', ctypes.c_int),
      ('neq', ctypes.c_int),
      ('ntendon', ctypes.c_int),
      ('nwrap', ctypes.c_int),
      ('nsensor', ctypes.c_int),
      ('nnumeric', ctypes.c_int),
      ('nnumericdata', ctypes.c_int),
      ('ntext', ctypes.c_int),
      ('ntextdata', ctypes.c_int),
      ('ntuple', ctypes.c_int),
      ('ntupledata', ctypes.c_int),
      ('nkey', ctypes.c_int),
      ('nuser_body', ctypes.c_int),
      ('nuser_jnt', ctypes.c_int),
      ('nuser_geom', ctypes.c_int),
      ('nuser_site', ctypes.c_int),
      ('nuser_cam', ctypes.c_int),
      ('nuser_tendon', ctypes.c_int),
      ('nuser_actuator', ctypes.c_int),
      ('nuser_sensor', ctypes.c_int),
      ('nnames', ctypes.c_int),
      ('nM', ctypes.c_int),
      ('nemax', ctypes.c_int),
      ('njmax', ctypes.c_int),
      ('nconmax', ctypes.c_int),
      ('nstack', ctypes.c_int),
      ('nuserdata', ctypes.c_int),
      ('nmocap', ctypes.c_int),
      ('nsensordata', ctypes.c_int),
      ('nbuffer', ctypes.c_int),
      ('opt', MJOPTION),
      ('vis', MJVISUAL),
      ('stat', MJSTATISTIC),
      ('buffer_', ctypes.c_void_p),
      ('qpos0', ctypes.POINTER(ctypes.c_double)),
      ('qpos_spring', ctypes.POINTER(ctypes.c_double)),
      ('body_parentid', ctypes.POINTER(ctypes.c_int)),
      ('body_rootid', ctypes.POINTER(ctypes.c_int)),
      ('body_weldid', ctypes.POINTER(ctypes.c_int)),
      ('body_mocapid', ctypes.POINTER(ctypes.c_int)),
      ('body_jntnum', ctypes.POINTER(ctypes.c_int)),
      ('body_jntadr', ctypes.POINTER(ctypes.c_int)),
      ('body_dofnum', ctypes.POINTER(ctypes.c_int)),
      ('body_dofadr', ctypes.POINTER(ctypes.c_int)),
      ('body_geomnum', ctypes.POINTER(ctypes.c_int)),
      ('body_geomadr', ctypes.POINTER(ctypes.c_int)),
      ('body_simple', ctypes.POINTER(ctypes.c_ubyte)),
      ('body_sameframe', ctypes.POINTER(ctypes.c_ubyte)),
      ('body_pos', ctypes.POINTER(ctypes.c_double)),
      ('body_quat', ctypes.POINTER(ctypes.c_double)),
      ('body_ipos', ctypes.POINTER(ctypes.c_double)),
      ('body_iquat', ctypes.POINTER(ctypes.c_double)),
      ('body_mass', ctypes.POINTER(ctypes.c_double)),
      ('body_subtreemass', ctypes.POINTER(ctypes.c_double)),
      ('body_inertia', ctypes.POINTER(ctypes.c_double)),
      ('body_invweight0', ctypes.POINTER(ctypes.c_double)),
      ('body_user', ctypes.POINTER(ctypes.c_double)),
      ('jnt_type', ctypes.POINTER(ctypes.c_int)),
      ('jnt_qposadr', ctypes.POINTER(ctypes.c_int)),
      ('jnt_dofadr', ctypes.POINTER(ctypes.c_int)),
      ('jnt_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('jnt_group', ctypes.POINTER(ctypes.c_int)),
      ('jnt_limited', ctypes.POINTER(ctypes.c_ubyte)),
      ('jnt_solref', ctypes.POINTER(ctypes.c_double)),
      ('jnt_solimp', ctypes.POINTER(ctypes.c_double)),
      ('jnt_pos', ctypes.POINTER(ctypes.c_double)),
      ('jnt_axis', ctypes.POINTER(ctypes.c_double)),
      ('jnt_stiffness', ctypes.POINTER(ctypes.c_double)),
      ('jnt_range', ctypes.POINTER(ctypes.c_double)),
      ('jnt_margin', ctypes.POINTER(ctypes.c_double)),
      ('jnt_user', ctypes.POINTER(ctypes.c_double)),
      ('dof_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('dof_jntid', ctypes.POINTER(ctypes.c_int)),
      ('dof_parentid', ctypes.POINTER(ctypes.c_int)),
      ('dof_Madr', ctypes.POINTER(ctypes.c_int)),
      ('dof_simplenum', ctypes.POINTER(ctypes.c_int)),
      ('dof_solref', ctypes.POINTER(ctypes.c_double)),
      ('dof_solimp', ctypes.POINTER(ctypes.c_double)),
      ('dof_frictionloss', ctypes.POINTER(ctypes.c_double)),
      ('dof_armature', ctypes.POINTER(ctypes.c_double)),
      ('dof_damping', ctypes.POINTER(ctypes.c_double)),
      ('dof_invweight0', ctypes.POINTER(ctypes.c_double)),
      ('dof_M0', ctypes.POINTER(ctypes.c_double)),
      ('geom_type', ctypes.POINTER(ctypes.c_int)),
      ('geom_contype', ctypes.POINTER(ctypes.c_int)),
      ('geom_conaffinity', ctypes.POINTER(ctypes.c_int)),
      ('geom_condim', ctypes.POINTER(ctypes.c_int)),
      ('geom_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('geom_dataid', ctypes.POINTER(ctypes.c_int)),
      ('geom_matid', ctypes.POINTER(ctypes.c_int)),
      ('geom_group', ctypes.POINTER(ctypes.c_int)),
      ('geom_priority', ctypes.POINTER(ctypes.c_int)),
      ('geom_sameframe', ctypes.POINTER(ctypes.c_ubyte)),
      ('geom_solmix', ctypes.POINTER(ctypes.c_double)),
      ('geom_solref', ctypes.POINTER(ctypes.c_double)),
      ('geom_solimp', ctypes.POINTER(ctypes.c_double)),
      ('geom_size', ctypes.POINTER(ctypes.c_double)),
      ('geom_rbound', ctypes.POINTER(ctypes.c_double)),
      ('geom_pos', ctypes.POINTER(ctypes.c_double)),
      ('geom_quat', ctypes.POINTER(ctypes.c_double)),
      ('geom_friction', ctypes.POINTER(ctypes.c_double)),
      ('geom_margin', ctypes.POINTER(ctypes.c_double)),
      ('geom_gap', ctypes.POINTER(ctypes.c_double)),
      ('geom_user', ctypes.POINTER(ctypes.c_double)),
      ('geom_rgba', ctypes.POINTER(ctypes.c_float)),
      ('site_type', ctypes.POINTER(ctypes.c_int)),
      ('site_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('site_matid', ctypes.POINTER(ctypes.c_int)),
      ('site_group', ctypes.POINTER(ctypes.c_int)),
      ('site_sameframe', ctypes.POINTER(ctypes.c_ubyte)),
      ('site_size', ctypes.POINTER(ctypes.c_double)),
      ('site_pos', ctypes.POINTER(ctypes.c_double)),
      ('site_quat', ctypes.POINTER(ctypes.c_double)),
      ('site_user', ctypes.POINTER(ctypes.c_double)),
      ('site_rgba', ctypes.POINTER(ctypes.c_float)),
      ('cam_mode', ctypes.POINTER(ctypes.c_int)),
      ('cam_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('cam_targetbodyid', ctypes.POINTER(ctypes.c_int)),
      ('cam_pos', ctypes.POINTER(ctypes.c_double)),
      ('cam_quat', ctypes.POINTER(ctypes.c_double)),
      ('cam_poscom0', ctypes.POINTER(ctypes.c_double)),
      ('cam_pos0', ctypes.POINTER(ctypes.c_double)),
      ('cam_mat0', ctypes.POINTER(ctypes.c_double)),
      ('cam_fovy', ctypes.POINTER(ctypes.c_double)),
      ('cam_ipd', ctypes.POINTER(ctypes.c_double)),
      ('cam_user', ctypes.POINTER(ctypes.c_double)),
      ('light_mode', ctypes.POINTER(ctypes.c_int)),
      ('light_bodyid', ctypes.POINTER(ctypes.c_int)),
      ('light_targetbodyid', ctypes.POINTER(ctypes.c_int)),
      ('light_directional', ctypes.POINTER(ctypes.c_ubyte)),
      ('light_castshadow', ctypes.POINTER(ctypes.c_ubyte)),
      ('light_active', ctypes.POINTER(ctypes.c_ubyte)),
      ('light_pos', ctypes.POINTER(ctypes.c_double)),
      ('light_dir', ctypes.POINTER(ctypes.c_double)),
      ('light_poscom0', ctypes.POINTER(ctypes.c_double)),
      ('light_pos0', ctypes.POINTER(ctypes.c_double)),
      ('light_dir0', ctypes.POINTER(ctypes.c_double)),
      ('light_attenuation', ctypes.POINTER(ctypes.c_float)),
      ('light_cutoff', ctypes.POINTER(ctypes.c_float)),
      ('light_exponent', ctypes.POINTER(ctypes.c_float)),
      ('light_ambient', ctypes.POINTER(ctypes.c_float)),
      ('light_diffuse', ctypes.POINTER(ctypes.c_float)),
      ('light_specular', ctypes.POINTER(ctypes.c_float)),
      ('mesh_vertadr', ctypes.POINTER(ctypes.c_int)),
      ('mesh_vertnum', ctypes.POINTER(ctypes.c_int)),
      ('mesh_texcoordadr', ctypes.POINTER(ctypes.c_int)),
      ('mesh_faceadr', ctypes.POINTER(ctypes.c_int)),
      ('mesh_facenum', ctypes.POINTER(ctypes.c_int)),
      ('mesh_graphadr', ctypes.POINTER(ctypes.c_int)),
      ('mesh_vert', ctypes.POINTER(ctypes.c_float)),
      ('mesh_normal', ctypes.POINTER(ctypes.c_float)),
      ('mesh_texcoord', ctypes.POINTER(ctypes.c_float)),
      ('mesh_face', ctypes.POINTER(ctypes.c_int)),
      ('mesh_graph', ctypes.POINTER(ctypes.c_int)),
      ('skin_matid', ctypes.POINTER(ctypes.c_int)),
      ('skin_rgba', ctypes.POINTER(ctypes.c_float)),
      ('skin_inflate', ctypes.POINTER(ctypes.c_float)),
      ('skin_vertadr', ctypes.POINTER(ctypes.c_int)),
      ('skin_vertnum', ctypes.POINTER(ctypes.c_int)),
      ('skin_texcoordadr', ctypes.POINTER(ctypes.c_int)),
      ('skin_faceadr', ctypes.POINTER(ctypes.c_int)),
      ('skin_facenum', ctypes.POINTER(ctypes.c_int)),
      ('skin_boneadr', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonenum', ctypes.POINTER(ctypes.c_int)),
      ('skin_vert', ctypes.POINTER(ctypes.c_float)),
      ('skin_texcoord', ctypes.POINTER(ctypes.c_float)),
      ('skin_face', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonevertadr', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonevertnum', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonebindpos', ctypes.POINTER(ctypes.c_float)),
      ('skin_bonebindquat', ctypes.POINTER(ctypes.c_float)),
      ('skin_bonebodyid', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonevertid', ctypes.POINTER(ctypes.c_int)),
      ('skin_bonevertweight', ctypes.POINTER(ctypes.c_float)),
      ('hfield_size', ctypes.POINTER(ctypes.c_double)),
      ('hfield_nrow', ctypes.POINTER(ctypes.c_int)),
      ('hfield_ncol', ctypes.POINTER(ctypes.c_int)),
      ('hfield_adr', ctypes.POINTER(ctypes.c_int)),
      ('hfield_data', ctypes.POINTER(ctypes.c_float)),
      ('tex_type', ctypes.POINTER(ctypes.c_int)),
      ('tex_height', ctypes.POINTER(ctypes.c_int)),
      ('tex_width', ctypes.POINTER(ctypes.c_int)),
      ('tex_adr', ctypes.POINTER(ctypes.c_int)),
      ('tex_rgb', ctypes.POINTER(ctypes.c_ubyte)),
      ('mat_texid', ctypes.POINTER(ctypes.c_int)),
      ('mat_texuniform', ctypes.POINTER(ctypes.c_ubyte)),
      ('mat_texrepeat', ctypes.POINTER(ctypes.c_float)),
      ('mat_emission', ctypes.POINTER(ctypes.c_float)),
      ('mat_specular', ctypes.POINTER(ctypes.c_float)),
      ('mat_shininess', ctypes.POINTER(ctypes.c_float)),
      ('mat_reflectance', ctypes.POINTER(ctypes.c_float)),
      ('mat_rgba', ctypes.POINTER(ctypes.c_float)),
      ('pair_dim', ctypes.POINTER(ctypes.c_int)),
      ('pair_geom1', ctypes.POINTER(ctypes.c_int)),
      ('pair_geom2', ctypes.POINTER(ctypes.c_int)),
      ('pair_signature', ctypes.POINTER(ctypes.c_int)),
      ('pair_solref', ctypes.POINTER(ctypes.c_double)),
      ('pair_solimp', ctypes.POINTER(ctypes.c_double)),
      ('pair_margin', ctypes.POINTER(ctypes.c_double)),
      ('pair_gap', ctypes.POINTER(ctypes.c_double)),
      ('pair_friction', ctypes.POINTER(ctypes.c_double)),
      ('exclude_signature', ctypes.POINTER(ctypes.c_int)),
      ('eq_type', ctypes.POINTER(ctypes.c_int)),
      ('eq_obj1id', ctypes.POINTER(ctypes.c_int)),
      ('eq_obj2id', ctypes.POINTER(ctypes.c_int)),
      ('eq_active', ctypes.POINTER(ctypes.c_ubyte)),
      ('eq_solref', ctypes.POINTER(ctypes.c_double)),
      ('eq_solimp', ctypes.POINTER(ctypes.c_double)),
      ('eq_data', ctypes.POINTER(ctypes.c_double)),
      ('tendon_adr', ctypes.POINTER(ctypes.c_int)),
      ('tendon_num', ctypes.POINTER(ctypes.c_int)),
      ('tendon_matid', ctypes.POINTER(ctypes.c_int)),
      ('tendon_group', ctypes.POINTER(ctypes.c_int)),
      ('tendon_limited', ctypes.POINTER(ctypes.c_ubyte)),
      ('tendon_width', ctypes.POINTER(ctypes.c_double)),
      ('tendon_solref_lim', ctypes.POINTER(ctypes.c_double)),
      ('tendon_solimp_lim', ctypes.POINTER(ctypes.c_double)),
      ('tendon_solref_fri', ctypes.POINTER(ctypes.c_double)),
      ('tendon_solimp_fri', ctypes.POINTER(ctypes.c_double)),
      ('tendon_range', ctypes.POINTER(ctypes.c_double)),
      ('tendon_margin', ctypes.POINTER(ctypes.c_double)),
      ('tendon_stiffness', ctypes.POINTER(ctypes.c_double)),
      ('tendon_damping', ctypes.POINTER(ctypes.c_double)),
      ('tendon_frictionloss', ctypes.POINTER(ctypes.c_double)),
      ('tendon_lengthspring', ctypes.POINTER(ctypes.c_double)),
      ('tendon_length0', ctypes.POINTER(ctypes.c_double)),
      ('tendon_invweight0', ctypes.POINTER(ctypes.c_double)),
      ('tendon_user', ctypes.POINTER(ctypes.c_double)),
      ('tendon_rgba', ctypes.POINTER(ctypes.c_float)),
      ('wrap_type', ctypes.POINTER(ctypes.c_int)),
      ('wrap_objid', ctypes.POINTER(ctypes.c_int)),
      ('wrap_prm', ctypes.POINTER(ctypes.c_double)),
      ('actuator_trntype', ctypes.POINTER(ctypes.c_int)),
      ('actuator_dyntype', ctypes.POINTER(ctypes.c_int)),
      ('actuator_gaintype', ctypes.POINTER(ctypes.c_int)),
      ('actuator_biastype', ctypes.POINTER(ctypes.c_int)),
      ('actuator_trnid', ctypes.POINTER(ctypes.c_int)),
      ('actuator_group', ctypes.POINTER(ctypes.c_int)),
      ('actuator_ctrllimited', ctypes.POINTER(ctypes.c_ubyte)),
      ('actuator_forcelimited', ctypes.POINTER(ctypes.c_ubyte)),
      ('actuator_dynprm', ctypes.POINTER(ctypes.c_double)),
      ('actuator_gainprm', ctypes.POINTER(ctypes.c_double)),
      ('actuator_biasprm', ctypes.POINTER(ctypes.c_double)),
      ('actuator_ctrlrange', ctypes.POINTER(ctypes.c_double)),
      ('actuator_forcerange', ctypes.POINTER(ctypes.c_double)),
      ('actuator_gear', ctypes.POINTER(ctypes.c_double)),
      ('actuator_cranklength', ctypes.POINTER(ctypes.c_double)),
      ('actuator_acc0', ctypes.POINTER(ctypes.c_double)),
      ('actuator_length0', ctypes.POINTER(ctypes.c_double)),
      ('actuator_lengthrange', ctypes.POINTER(ctypes.c_double)),
      ('actuator_user', ctypes.POINTER(ctypes.c_double)),
      ('sensor_type', ctypes.POINTER(ctypes.c_int)),
      ('sensor_datatype', ctypes.POINTER(ctypes.c_int)),
      ('sensor_needstage', ctypes.POINTER(ctypes.c_int)),
      ('sensor_objtype', ctypes.POINTER(ctypes.c_int)),
      ('sensor_objid', ctypes.POINTER(ctypes.c_int)),
      ('sensor_dim', ctypes.POINTER(ctypes.c_int)),
      ('sensor_adr', ctypes.POINTER(ctypes.c_int)),
      ('sensor_cutoff', ctypes.POINTER(ctypes.c_double)),
      ('sensor_noise', ctypes.POINTER(ctypes.c_double)),
      ('sensor_user', ctypes.POINTER(ctypes.c_double)),
      ('numeric_adr', ctypes.POINTER(ctypes.c_int)),
      ('numeric_size', ctypes.POINTER(ctypes.c_int)),
      ('numeric_data', ctypes.POINTER(ctypes.c_double)),
      ('text_adr', ctypes.POINTER(ctypes.c_int)),
      ('text_size', ctypes.POINTER(ctypes.c_int)),
      ('text_data', ctypes.POINTER(ctypes.c_char)),
      ('tuple_adr', ctypes.POINTER(ctypes.c_int)),
      ('tuple_size', ctypes.POINTER(ctypes.c_int)),
      ('tuple_objtype', ctypes.POINTER(ctypes.c_int)),
      ('tuple_objid', ctypes.POINTER(ctypes.c_int)),
      ('tuple_objprm', ctypes.POINTER(ctypes.c_double)),
      ('key_time', ctypes.POINTER(ctypes.c_double)),
      ('key_qpos', ctypes.POINTER(ctypes.c_double)),
      ('key_qvel', ctypes.POINTER(ctypes.c_double)),
      ('key_act', ctypes.POINTER(ctypes.c_double)),
      ('name_bodyadr', ctypes.POINTER(ctypes.c_int)),
      ('name_jntadr', ctypes.POINTER(ctypes.c_int)),
      ('name_geomadr', ctypes.POINTER(ctypes.c_int)),
      ('name_siteadr', ctypes.POINTER(ctypes.c_int)),
      ('name_camadr', ctypes.POINTER(ctypes.c_int)),
      ('name_lightadr', ctypes.POINTER(ctypes.c_int)),
      ('name_meshadr', ctypes.POINTER(ctypes.c_int)),
      ('name_skinadr', ctypes.POINTER(ctypes.c_int)),
      ('name_hfieldadr', ctypes.POINTER(ctypes.c_int)),
      ('name_texadr', ctypes.POINTER(ctypes.c_int)),
      ('name_matadr', ctypes.POINTER(ctypes.c_int)),
      ('name_pairadr', ctypes.POINTER(ctypes.c_int)),
      ('name_excludeadr', ctypes.POINTER(ctypes.c_int)),
      ('name_eqadr', ctypes.POINTER(ctypes.c_int)),
      ('name_tendonadr', ctypes.POINTER(ctypes.c_int)),
      ('name_actuatoradr', ctypes.POINTER(ctypes.c_int)),
      ('name_sensoradr', ctypes.POINTER(ctypes.c_int)),
      ('name_numericadr', ctypes.POINTER(ctypes.c_int)),
      ('name_textadr', ctypes.POINTER(ctypes.c_int)),
      ('name_tupleadr', ctypes.POINTER(ctypes.c_int)),
      ('name_keyadr', ctypes.POINTER(ctypes.c_int)),
      ('names', ctypes.POINTER(ctypes.c_char)),
  ]


class MJCONTACT(ctypes.Structure):
  """result of collision detection functions."""
  _fields_ = [
      ('dist', ctypes.c_double),
      ('pos', ctypes.c_double * (3)),
      ('frame', ctypes.c_double * (9)),
      ('includemargin', ctypes.c_double),
      ('friction', ctypes.c_double * (5)),
      ('solref', ctypes.c_double * (2)),
      ('solimp', ctypes.c_double * (5)),
      ('mu', ctypes.c_double),
      ('H', ctypes.c_double * (36)),
      ('dim', ctypes.c_int),
      ('geom1', ctypes.c_int),
      ('geom2', ctypes.c_int),
      ('exclude', ctypes.c_int),
      ('efc_address', ctypes.c_int),
  ]


class MJWARNINGSTAT(ctypes.Structure):
  """warning statistics."""
  _fields_ = [
      ('lastinfo', ctypes.c_int),
      ('number', ctypes.c_int),
  ]


class MJTIMERSTAT(ctypes.Structure):
  """timer statistics."""
  _fields_ = [
      ('duration', ctypes.c_double),
      ('number', ctypes.c_int),
  ]


class MJSOLVERSTAT(ctypes.Structure):
  """per-iteration solver statistics."""
  _fields_ = [
      ('improvement', ctypes.c_double),
      ('gradient', ctypes.c_double),
      ('lineslope', ctypes.c_double),
      ('nactive', ctypes.c_int),
      ('nchange', ctypes.c_int),
      ('neval', ctypes.c_int),
      ('nupdate', ctypes.c_int),
  ]


class MJDATA(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('nstack', ctypes.c_int),
      ('nbuffer', ctypes.c_int),
      ('pstack', ctypes.c_int),
      ('maxuse_stack', ctypes.c_int),
      ('maxuse_con', ctypes.c_int),
      ('maxuse_efc', ctypes.c_int),
      ('warning', MJWARNINGSTAT * (8)),
      ('timer', MJTIMERSTAT * (13)),
      ('solver', MJSOLVERSTAT * (1000)),
      ('solver_iter', ctypes.c_int),
      ('solver_nnz', ctypes.c_int),
      ('solver_fwdinv', ctypes.c_double * (2)),
      ('ne', ctypes.c_int),
      ('nf', ctypes.c_int),
      ('nefc', ctypes.c_int),
      ('ncon', ctypes.c_int),
      ('time', ctypes.c_double),
      ('energy', ctypes.c_double * (2)),
      ('buffer_', ctypes.c_void_p),
      ('stack', ctypes.POINTER(ctypes.c_double)),
      ('qpos', ctypes.POINTER(ctypes.c_double)),
      ('qvel', ctypes.POINTER(ctypes.c_double)),
      ('act', ctypes.POINTER(ctypes.c_double)),
      ('qacc_warmstart', ctypes.POINTER(ctypes.c_double)),
      ('ctrl', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_applied', ctypes.POINTER(ctypes.c_double)),
      ('xfrc_applied', ctypes.POINTER(ctypes.c_double)),
      ('qacc', ctypes.POINTER(ctypes.c_double)),
      ('act_dot', ctypes.POINTER(ctypes.c_double)),
      ('mocap_pos', ctypes.POINTER(ctypes.c_double)),
      ('mocap_quat', ctypes.POINTER(ctypes.c_double)),
      ('userdata', ctypes.POINTER(ctypes.c_double)),
      ('sensordata', ctypes.POINTER(ctypes.c_double)),
      ('xpos', ctypes.POINTER(ctypes.c_double)),
      ('xquat', ctypes.POINTER(ctypes.c_double)),
      ('xmat', ctypes.POINTER(ctypes.c_double)),
      ('xipos', ctypes.POINTER(ctypes.c_double)),
      ('ximat', ctypes.POINTER(ctypes.c_double)),
      ('xanchor', ctypes.POINTER(ctypes.c_double)),
      ('xaxis', ctypes.POINTER(ctypes.c_double)),
      ('geom_xpos', ctypes.POINTER(ctypes.c_double)),
      ('geom_xmat', ctypes.POINTER(ctypes.c_double)),
      ('site_xpos', ctypes.POINTER(ctypes.c_double)),
      ('site_xmat', ctypes.POINTER(ctypes.c_double)),
      ('cam_xpos', ctypes.POINTER(ctypes.c_double)),
      ('cam_xmat', ctypes.POINTER(ctypes.c_double)),
      ('light_xpos', ctypes.POINTER(ctypes.c_double)),
      ('light_xdir', ctypes.POINTER(ctypes.c_double)),
      ('subtree_com', ctypes.POINTER(ctypes.c_double)),
      ('cdof', ctypes.POINTER(ctypes.c_double)),
      ('cinert', ctypes.POINTER(ctypes.c_double)),
      ('ten_wrapadr', ctypes.POINTER(ctypes.c_int)),
      ('ten_wrapnum', ctypes.POINTER(ctypes.c_int)),
      ('ten_J_rownnz', ctypes.POINTER(ctypes.c_int)),
      ('ten_J_rowadr', ctypes.POINTER(ctypes.c_int)),
      ('ten_J_colind', ctypes.POINTER(ctypes.c_int)),
      ('ten_length', ctypes.POINTER(ctypes.c_double)),
      ('ten_J', ctypes.POINTER(ctypes.c_double)),
      ('wrap_obj', ctypes.POINTER(ctypes.c_int)),
      ('wrap_xpos', ctypes.POINTER(ctypes.c_double)),
      ('actuator_length', ctypes.POINTER(ctypes.c_double)),
      ('actuator_moment', ctypes.POINTER(ctypes.c_double)),
      ('crb', ctypes.POINTER(ctypes.c_double)),
      ('qM', ctypes.POINTER(ctypes.c_double)),
      ('qLD', ctypes.POINTER(ctypes.c_double)),
      ('qLDiagInv', ctypes.POINTER(ctypes.c_double)),
      ('qLDiagSqrtInv', ctypes.POINTER(ctypes.c_double)),
      ('contact', ctypes.POINTER(MJCONTACT)),
      ('efc_type', ctypes.POINTER(ctypes.c_int)),
      ('efc_id', ctypes.POINTER(ctypes.c_int)),
      ('efc_J_rownnz', ctypes.POINTER(ctypes.c_int)),
      ('efc_J_rowadr', ctypes.POINTER(ctypes.c_int)),
      ('efc_J_rowsuper', ctypes.POINTER(ctypes.c_int)),
      ('efc_J_colind', ctypes.POINTER(ctypes.c_int)),
      ('efc_JT_rownnz', ctypes.POINTER(ctypes.c_int)),
      ('efc_JT_rowadr', ctypes.POINTER(ctypes.c_int)),
      ('efc_JT_rowsuper', ctypes.POINTER(ctypes.c_int)),
      ('efc_JT_colind', ctypes.POINTER(ctypes.c_int)),
      ('efc_J', ctypes.POINTER(ctypes.c_double)),
      ('efc_JT', ctypes.POINTER(ctypes.c_double)),
      ('efc_pos', ctypes.POINTER(ctypes.c_double)),
      ('efc_margin', ctypes.POINTER(ctypes.c_double)),
      ('efc_frictionloss', ctypes.POINTER(ctypes.c_double)),
      ('efc_diagApprox', ctypes.POINTER(ctypes.c_double)),
      ('efc_KBIP', ctypes.POINTER(ctypes.c_double)),
      ('efc_D', ctypes.POINTER(ctypes.c_double)),
      ('efc_R', ctypes.POINTER(ctypes.c_double)),
      ('efc_AR_rownnz', ctypes.POINTER(ctypes.c_int)),
      ('efc_AR_rowadr', ctypes.POINTER(ctypes.c_int)),
      ('efc_AR_colind', ctypes.POINTER(ctypes.c_int)),
      ('efc_AR', ctypes.POINTER(ctypes.c_double)),
      ('ten_velocity', ctypes.POINTER(ctypes.c_double)),
      ('actuator_velocity', ctypes.POINTER(ctypes.c_double)),
      ('cvel', ctypes.POINTER(ctypes.c_double)),
      ('cdof_dot', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_bias', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_passive', ctypes.POINTER(ctypes.c_double)),
      ('efc_vel', ctypes.POINTER(ctypes.c_double)),
      ('efc_aref', ctypes.POINTER(ctypes.c_double)),
      ('subtree_linvel', ctypes.POINTER(ctypes.c_double)),
      ('subtree_angmom', ctypes.POINTER(ctypes.c_double)),
      ('actuator_force', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_actuator', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_unc', ctypes.POINTER(ctypes.c_double)),
      ('qacc_unc', ctypes.POINTER(ctypes.c_double)),
      ('efc_b', ctypes.POINTER(ctypes.c_double)),
      ('efc_force', ctypes.POINTER(ctypes.c_double)),
      ('efc_state', ctypes.POINTER(ctypes.c_int)),
      ('qfrc_constraint', ctypes.POINTER(ctypes.c_double)),
      ('qfrc_inverse', ctypes.POINTER(ctypes.c_double)),
      ('cacc', ctypes.POINTER(ctypes.c_double)),
      ('cfrc_int', ctypes.POINTER(ctypes.c_double)),
      ('cfrc_ext', ctypes.POINTER(ctypes.c_double)),
  ]

mjfGeneric = ctypes.CFUNCTYPE(None, ctypes.POINTER(MJMODEL), ctypes.POINTER(MJDATA))
mjfConFilt = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.POINTER(MJMODEL), ctypes.POINTER(MJDATA), ctypes.c_int, ctypes.c_int)
mjfSensor = ctypes.CFUNCTYPE(None, ctypes.POINTER(MJMODEL), ctypes.POINTER(MJDATA), ctypes.c_int)
mjfTime = ctypes.CFUNCTYPE(ctypes.c_double)
mjfAct = ctypes.CFUNCTYPE(ctypes.c_double, ctypes.POINTER(MJMODEL), ctypes.POINTER(MJDATA), ctypes.c_int)
mjfCollision = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.POINTER(MJMODEL), ctypes.POINTER(MJDATA), ctypes.POINTER(MJCONTACT), ctypes.c_int, ctypes.c_int, ctypes.c_double)

class MJRRECT(ctypes.Structure):
  """OpenGL rectangle."""
  _fields_ = [
      ('left', ctypes.c_int),
      ('bottom', ctypes.c_int),
      ('width', ctypes.c_int),
      ('height', ctypes.c_int),
  ]


class MJRCONTEXT(ctypes.Structure):
  """custom OpenGL context."""
  _fields_ = [
      ('lineWidth', ctypes.c_float),
      ('shadowClip', ctypes.c_float),
      ('shadowScale', ctypes.c_float),
      ('fogStart', ctypes.c_float),
      ('fogEnd', ctypes.c_float),
      ('fogRGBA', ctypes.c_float * (4)),
      ('shadowSize', ctypes.c_int),
      ('offWidth', ctypes.c_int),
      ('offHeight', ctypes.c_int),
      ('offSamples', ctypes.c_int),
      ('fontScale', ctypes.c_int),
      ('auxWidth', ctypes.c_int * (10)),
      ('auxHeight', ctypes.c_int * (10)),
      ('auxSamples', ctypes.c_int * (10)),
      ('offFBO', ctypes.c_uint),
      ('offFBO_r', ctypes.c_uint),
      ('offColor', ctypes.c_uint),
      ('offColor_r', ctypes.c_uint),
      ('offDepthStencil', ctypes.c_uint),
      ('offDepthStencil_r', ctypes.c_uint),
      ('shadowFBO', ctypes.c_uint),
      ('shadowTex', ctypes.c_uint),
      ('auxFBO', ctypes.c_uint * (10)),
      ('auxFBO_r', ctypes.c_uint * (10)),
      ('auxColor', ctypes.c_uint * (10)),
      ('auxColor_r', ctypes.c_uint * (10)),
      ('ntexture', ctypes.c_int),
      ('textureType', ctypes.c_int * (100)),
      ('texture', ctypes.c_uint * (100)),
      ('basePlane', ctypes.c_uint),
      ('baseMesh', ctypes.c_uint),
      ('baseHField', ctypes.c_uint),
      ('baseBuiltin', ctypes.c_uint),
      ('baseFontNormal', ctypes.c_uint),
      ('baseFontShadow', ctypes.c_uint),
      ('baseFontBig', ctypes.c_uint),
      ('rangePlane', ctypes.c_int),
      ('rangeMesh', ctypes.c_int),
      ('rangeHField', ctypes.c_int),
      ('rangeBuiltin', ctypes.c_int),
      ('rangeFont', ctypes.c_int),
      ('nskin', ctypes.c_int),
      ('skinvertVBO', ctypes.POINTER(ctypes.c_uint)),
      ('skinnormalVBO', ctypes.POINTER(ctypes.c_uint)),
      ('skintexcoordVBO', ctypes.POINTER(ctypes.c_uint)),
      ('skinfaceVBO', ctypes.POINTER(ctypes.c_uint)),
      ('charWidth', ctypes.c_int * (127)),
      ('charWidthBig', ctypes.c_int * (127)),
      ('charHeight', ctypes.c_int),
      ('charHeightBig', ctypes.c_int),
      ('glewInitialized', ctypes.c_int),
      ('windowAvailable', ctypes.c_int),
      ('windowSamples', ctypes.c_int),
      ('windowStereo', ctypes.c_int),
      ('windowDoublebuffer', ctypes.c_int),
      ('currentBuffer', ctypes.c_int),
  ]

mjfItemEnable = ctypes.CFUNCTYPE(ctypes.c_int, ctypes.c_int, ctypes.c_void_p)

class MJUISTATE(ctypes.Structure):
  """mouse and keyboard state."""
  _fields_ = [
      ('nrect', ctypes.c_int),
      ('rect', MJRRECT * (15)),
      ('userdata', ctypes.c_void_p),
      ('type_', ctypes.c_int),
      ('left', ctypes.c_int),
      ('right', ctypes.c_int),
      ('middle', ctypes.c_int),
      ('doubleclick', ctypes.c_int),
      ('button', ctypes.c_int),
      ('buttontime', ctypes.c_double),
      ('x', ctypes.c_double),
      ('y', ctypes.c_double),
      ('dx', ctypes.c_double),
      ('dy', ctypes.c_double),
      ('sx', ctypes.c_double),
      ('sy', ctypes.c_double),
      ('control', ctypes.c_int),
      ('shift', ctypes.c_int),
      ('alt', ctypes.c_int),
      ('key', ctypes.c_int),
      ('keytime', ctypes.c_double),
      ('mouserect', ctypes.c_int),
      ('dragrect', ctypes.c_int),
      ('dragbutton', ctypes.c_int),
  ]


class MJUITHEMESPACING(ctypes.Structure):
  """UI visualization theme spacing."""
  _fields_ = [
      ('total', ctypes.c_int),
      ('scroll', ctypes.c_int),
      ('label', ctypes.c_int),
      ('section', ctypes.c_int),
      ('itemside', ctypes.c_int),
      ('itemmid', ctypes.c_int),
      ('itemver', ctypes.c_int),
      ('texthor', ctypes.c_int),
      ('textver', ctypes.c_int),
      ('linescroll', ctypes.c_int),
      ('samples', ctypes.c_int),
  ]


class MJUITHEMECOLOR(ctypes.Structure):
  """UI visualization theme color."""
  _fields_ = [
      ('master', ctypes.c_float * (3)),
      ('thumb', ctypes.c_float * (3)),
      ('secttitle', ctypes.c_float * (3)),
      ('sectfont', ctypes.c_float * (3)),
      ('sectsymbol', ctypes.c_float * (3)),
      ('sectpane', ctypes.c_float * (3)),
      ('shortcut', ctypes.c_float * (3)),
      ('fontactive', ctypes.c_float * (3)),
      ('fontinactive', ctypes.c_float * (3)),
      ('decorinactive', ctypes.c_float * (3)),
      ('decorinactive2', ctypes.c_float * (3)),
      ('button', ctypes.c_float * (3)),
      ('check', ctypes.c_float * (3)),
      ('radio', ctypes.c_float * (3)),
      ('select', ctypes.c_float * (3)),
      ('select2', ctypes.c_float * (3)),
      ('slider', ctypes.c_float * (3)),
      ('slider2', ctypes.c_float * (3)),
      ('edit', ctypes.c_float * (3)),
      ('edit2', ctypes.c_float * (3)),
      ('cursor', ctypes.c_float * (3)),
  ]


class SINGLE(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('modifier', ctypes.c_int),
      ('shortcut', ctypes.c_int),
  ]


class MULTI(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('nelem', ctypes.c_int),
      ('name', ctypes.c_char * 20 * 40),
  ]


class SLIDER(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('range_', ctypes.c_double * (2)),
      ('divisions', ctypes.c_double),
  ]


class EDIT(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('nelem', ctypes.c_int),
      ('range_', ctypes.c_double * (5 * 2)),
  ]


class MJUIITEM_ANON_UNION(ctypes.Union):
  """<no header comment found>."""
  _fields_ = [
      ('single', SINGLE),
      ('multi', MULTI),
      ('slider', SLIDER),
      ('edit', EDIT),
  ]


class MJUIITEM(ctypes.Structure):
  """UI item."""
  _anonymous_ = [
      'mjuiItem_anon_union',
  ]
  _fields_ = [
      ('type_', ctypes.c_int),
      ('name', ctypes.c_char * 40),
      ('state', ctypes.c_int),
      ('pdata', ctypes.c_void_p),
      ('sectionid', ctypes.c_int),
      ('itemid', ctypes.c_int),
      ('mjuiItem_anon_union', MJUIITEM_ANON_UNION),
      ('rect', MJRRECT),
  ]


class MJUISECTION(ctypes.Structure):
  """UI section."""
  _fields_ = [
      ('name', ctypes.c_char * 40),
      ('state', ctypes.c_int),
      ('modifier', ctypes.c_int),
      ('shortcut', ctypes.c_int),
      ('nitem', ctypes.c_int),
      ('item', MJUIITEM * (80)),
      ('rtitle', MJRRECT),
      ('rcontent', MJRRECT),
  ]


class MJUI(ctypes.Structure):
  """entire UI."""
  _fields_ = [
      ('spacing', MJUITHEMESPACING),
      ('color', MJUITHEMECOLOR),
      ('predicate', mjfItemEnable),
      ('userdata', ctypes.c_void_p),
      ('rectid', ctypes.c_int),
      ('auxid', ctypes.c_int),
      ('radiocol', ctypes.c_int),
      ('width', ctypes.c_int),
      ('height', ctypes.c_int),
      ('maxheight', ctypes.c_int),
      ('scroll', ctypes.c_int),
      ('mousesect', ctypes.c_int),
      ('mouseitem', ctypes.c_int),
      ('mousehelp', ctypes.c_int),
      ('editsect', ctypes.c_int),
      ('edititem', ctypes.c_int),
      ('editcursor', ctypes.c_int),
      ('editscroll', ctypes.c_int),
      ('edittext', ctypes.c_char * 500),
      ('editchanged', ctypes.POINTER(MJUIITEM)),
      ('nsect', ctypes.c_int),
      ('sect', MJUISECTION * (10)),
  ]


class MJUIDEF(ctypes.Structure):
  """<no header comment found>."""
  _fields_ = [
      ('type_', ctypes.c_int),
      ('name', ctypes.c_char * 40),
      ('state', ctypes.c_int),
      ('pdata', ctypes.c_void_p),
      ('other', ctypes.c_char * 500),
  ]


class MJVPERTURB(ctypes.Structure):
  """object selection and perturbation."""
  _fields_ = [
      ('select', ctypes.c_int),
      ('skinselect', ctypes.c_int),
      ('active', ctypes.c_int),
      ('refpos', ctypes.c_double * (3)),
      ('refquat', ctypes.c_double * (4)),
      ('localpos', ctypes.c_double * (3)),
      ('scale', ctypes.c_double),
  ]


class MJVCAMERA(ctypes.Structure):
  """abstract camera."""
  _fields_ = [
      ('type_', ctypes.c_int),
      ('fixedcamid', ctypes.c_int),
      ('trackbodyid', ctypes.c_int),
      ('lookat', ctypes.c_double * (3)),
      ('distance', ctypes.c_double),
      ('azimuth', ctypes.c_double),
      ('elevation', ctypes.c_double),
  ]


class MJVGLCAMERA(ctypes.Structure):
  """OpenGL camera."""
  _fields_ = [
      ('pos', ctypes.c_float * (3)),
      ('forward', ctypes.c_float * (3)),
      ('up', ctypes.c_float * (3)),
      ('frustum_center', ctypes.c_float),
      ('frustum_bottom', ctypes.c_float),
      ('frustum_top', ctypes.c_float),
      ('frustum_near', ctypes.c_float),
      ('frustum_far', ctypes.c_float),
  ]


class MJVGEOM(ctypes.Structure):
  """abstract geom."""
  _fields_ = [
      ('type_', ctypes.c_int),
      ('dataid', ctypes.c_int),
      ('objtype', ctypes.c_int),
      ('objid', ctypes.c_int),
      ('category', ctypes.c_int),
      ('texid', ctypes.c_int),
      ('texuniform', ctypes.c_int),
      ('texcoord', ctypes.c_int),
      ('segid', ctypes.c_int),
      ('texrepeat', ctypes.c_float * (2)),
      ('size', ctypes.c_float * (3)),
      ('pos', ctypes.c_float * (3)),
      ('mat', ctypes.c_float * (9)),
      ('rgba', ctypes.c_float * (4)),
      ('emission', ctypes.c_float),
      ('specular', ctypes.c_float),
      ('shininess', ctypes.c_float),
      ('reflectance', ctypes.c_float),
      ('label', ctypes.c_char * 100),
      ('camdist', ctypes.c_float),
      ('modelrbound', ctypes.c_float),
      ('transparent', ctypes.c_ubyte),
  ]


class MJVLIGHT(ctypes.Structure):
  """OpenGL light."""
  _fields_ = [
      ('pos', ctypes.c_float * (3)),
      ('dir_', ctypes.c_float * (3)),
      ('attenuation', ctypes.c_float * (3)),
      ('cutoff', ctypes.c_float),
      ('exponent', ctypes.c_float),
      ('ambient', ctypes.c_float * (3)),
      ('diffuse', ctypes.c_float * (3)),
      ('specular', ctypes.c_float * (3)),
      ('headlight', ctypes.c_ubyte),
      ('directional', ctypes.c_ubyte),
      ('castshadow', ctypes.c_ubyte),
  ]


class MJVOPTION(ctypes.Structure):
  """abstract visualization options."""
  _fields_ = [
      ('label', ctypes.c_int),
      ('frame', ctypes.c_int),
      ('geomgroup', ctypes.c_ubyte * (6)),
      ('sitegroup', ctypes.c_ubyte * (6)),
      ('jointgroup', ctypes.c_ubyte * (6)),
      ('tendongroup', ctypes.c_ubyte * (6)),
      ('actuatorgroup', ctypes.c_ubyte * (6)),
      ('flags', ctypes.c_ubyte * (22)),
  ]


class MJVSCENE(ctypes.Structure):
  """abstract scene passed to OpenGL renderer."""
  _fields_ = [
      ('maxgeom', ctypes.c_int),
      ('ngeom', ctypes.c_int),
      ('geoms', ctypes.POINTER(MJVGEOM)),
      ('geomorder', ctypes.POINTER(ctypes.c_int)),
      ('nskin', ctypes.c_int),
      ('skinfacenum', ctypes.POINTER(ctypes.c_int)),
      ('skinvertadr', ctypes.POINTER(ctypes.c_int)),
      ('skinvertnum', ctypes.POINTER(ctypes.c_int)),
      ('skinvert', ctypes.POINTER(ctypes.c_float)),
      ('skinnormal', ctypes.POINTER(ctypes.c_float)),
      ('nlight', ctypes.c_int),
      ('lights', MJVLIGHT * (8)),
      ('camera', MJVGLCAMERA * (2)),
      ('enabletransform', ctypes.c_ubyte),
      ('translate', ctypes.c_float * (3)),
      ('rotate', ctypes.c_float * (4)),
      ('scale', ctypes.c_float),
      ('stereo', ctypes.c_int),
      ('flags', ctypes.c_ubyte * (9)),
  ]


class MJVFIGURE(ctypes.Structure):
  """abstract 2D figure passed to OpenGL renderer."""
  _fields_ = [
      ('flg_legend', ctypes.c_int),
      ('flg_ticklabel', ctypes.c_int * (2)),
      ('flg_extend', ctypes.c_int),
      ('flg_barplot', ctypes.c_int),
      ('flg_selection', ctypes.c_int),
      ('flg_symmetric', ctypes.c_int),
      ('legendoff', ctypes.c_int),
      ('gridsize', ctypes.c_int * (2)),
      ('selection', ctypes.c_int),
      ('highlight', ctypes.c_int * (2)),
      ('gridrgb', ctypes.c_float * (3)),
      ('gridwidth', ctypes.c_float),
      ('figurergba', ctypes.c_float * (4)),
      ('panergba', ctypes.c_float * (4)),
      ('legendrgba', ctypes.c_float * (4)),
      ('textrgb', ctypes.c_float * (3)),
      ('range_', ctypes.c_float * (2 * 2)),
      ('xlabel', ctypes.c_char * 100),
      ('title', ctypes.c_char * 100),
      ('xformat', ctypes.c_char * 20),
      ('yformat', ctypes.c_char * 20),
      ('minwidth', ctypes.c_char * 20),
      ('linepnt', ctypes.c_int * (100)),
      ('linergb', ctypes.c_float * (100 * 3)),
      ('linewidth', ctypes.c_float * (100)),
      ('linedata', ctypes.c_float * (100 * 2000)),
      ('linename', ctypes.c_char * 100 * 100),
      ('xaxispixel', ctypes.c_int * (2)),
      ('yaxispixel', ctypes.c_int * (2)),
      ('xaxisdata', ctypes.c_float * (2)),
      ('yaxisdata', ctypes.c_float * (2)),
  ]

# ----------------------------End of generated code----------------------------
