# Knowledge Distillation Based on Transformed Teacher Matching

This repo is for reproducing the CIFAR-100 experimental results in our paper Knowledge Distillation Based on Transformed Teacher Matching.

## Installation

The repo is tested with Python 3.8, PyTorch 2.0.1, and CUDA 11.7.

## Running

1. Fetch the pretrained teacher models by:
    ```
    sh scripts/fetch_pretrained_teachers.sh
    ```
   which will download and save the models to `save/models`
   
2. An example of running Transformed Teacher Matching (TTM) is given by:
    ```
    python3 train_student.py --path_t ./save/models/vgg13_vanilla/ckpt_epoch_240.pth \
                             --model_s vgg8 \
                             --distill ttm --ttm_l 0.1 \
                             -r 1 -b 45 -a 0 \
                             --trial 1
    ```
    where the flags are explained as:
    - `--path_t`: specify the path of the teacher model
    - `--model_s`: specify the student model, see 'models/\_\_init\_\_.py' to check the available model types.
    - `--distill`: specify the distillation method
    - `--ttm_l`: the exponent of power transform (denoted as $\gamma$ in our paper)
    - `-r`: the weight of the cross-entropy loss between logit and ground truth, default: `1`
    - `-b`: the weight of a distillation loss, default: `None`
    - `-a`: the weight of an additional distillation loss, default: `None`
    - `--trial`: specify the experimental id to differentiate between multiple runs.
    
3. Combining a distillation objective with another distillation objective is done by setting `--add` as the desired additional distillation loss (default: `'kd'`), and `-a` as a non-zero value, which results in the following example (combining CRD with WTTM)
    ```
    python3 train_student.py --path_t ./save/models/vgg13_vanilla/ckpt_epoch_240.pth \
                             --model_s vgg8 \
                             --distill crd \
                             --add wttm --ttm_l 0.2 \
                             -b 0.8 -a 4 \
                             --trial 1
    ```

4. The resulting log file of an experiment recording test accuracy after each training epoch is saved in `save`.

Note: the default setting is for a single-GPU training. If you would like to play this repo with multiple GPUs, you might need to tune the learning rate, which empirically needs to be scaled up linearly with the batch size, see [this paper](https://arxiv.org/abs/1706.02677)
