# MEET: Parameter-Efficient Tuning Helps Language Model Alignment

## Method
Aligning large language models (LLMs) with human preferences is essential for safe and useful LLMs. Previous works mainly adopt reinforcement learning and direct preference optimization with human feedback for alignment. Nevertheless, they can only align models with one preference at the training time (e.g., they cannot learn to generate concise responses when the preference data prefers detailed responses). Prior works incorporate controllable generations for alignment to make language models learn multiple preferences and provide outputs with different preferences during inference if asked. Controllable generations use different control tokens for different preferences during training and inference, making LLMs behave differently when required. However, current controllable generation methods use several special tokens or hand-crafted prompts as control tokens, which is sub-optimal for language models. We argue that LLMs can learn control tokens themselves and have a better quality of controllable generations. To this end, we first use parameter-efficient tuning (e.g., prompting tuning and low-rank adaptation) to train control tokens and then train models for controllable generations, similar to prior works. Our approach, alignMEnt with parameter-Efficient #Tuning (MEET), improves the controllable generation quality consistently by an apparent margin on two well-recognized datasets.




## Requirements
Make sure you have Python>=3.8 installed on your machine.
pip install torch==1.8.2+cu111 torchtext==0.9.2 -f https://download.pytorch.org/whl/lts/1.8/torch_lts.html




## Quick Start
For a quick start, you can directly run MEET

# MEET (Prompt Tuning)
```shell
bash ./shell/summary_MEET_prompt_tuning.sh
```
```shell
bash ./shell/rlhf_MEET_prompt_tuning.sh
```
# MEET (LoRA)
```shell
bash ./shell/summary_MEET_lora.sh
```
```shell
bash ./shell/rlhf_MEET_lora.sh
```
