#!/bin/bash

torchrun --nproc_per_node=4 --master_port=41022 --master_addr=localhost torchrun_main.py \
    --model_config configs/llama_1b.json \
    --optimizer adam \
    --lr 0.0006 \
    --batch_size 64 \
    --total_batch_size 512 \
    --num_training_steps 100000 \
    --warmup_steps 10000 \
    --weight_decay 0.00001 \
    --use_modulewise_wd \
    --alpha_positively_with_WD \
    --unbalancedWD_every 500 \
    --esd_metric_for_tb alpha \
    --assign_func tb_linear_map\
    --wd_min_ratio 0.66666 \
    --wd_max_ratio 3 \
    --dtype bfloat16 \
    --eval_every 1000 \
    --wandb_name slurm-ours-1b-alpha-lr0.0006-WD0.00001 \
    --target_eval_tokens 10_000_000 \
    --save_every 10000