#!/bin/bash

torchrun --nproc_per_node=4 --master_port=40001 --master_addr=localhost torchrun_main.py \
    --model_config configs/llama_1b.json \
    --optimizer adam \
    --lr 0.0006 \
    --batch_size 64 \
    --total_batch_size 512 \
    --num_training_steps 100000 \
    --warmup_steps 10000 \
    --weight_decay 0.00001 \
    --dtype bfloat16 \
    --eval_every 1000 \
    --wandb_name slurm-adam-1b-lr0.0006-WD0.00001 \
    --target_eval_tokens 10_000_000 \
    --save_every 10000