from .agents import Car, Pedestrian, RectangleBuilding
from .entities import Entity
from typing import Union
import pdb

class World:
    def __init__(self, dt: float, width: float, height: float, ppm: float = 8):
        self.dynamic_agents = []
        self.static_agents = []
        self.t = 0 # simulation time
        self.dt = dt # simulation time step
        # pdb.set_trace()
        try:
            from .visualizer import Visualizer
            self.visualizer = Visualizer(width, height, ppm=ppm)
            self.headless = False
        except:
            self.headless = True
        
    def add(self, entity: Entity):
        if entity.movable:
            self.dynamic_agents.append(entity)
        else:
            self.static_agents.append(entity)
        
    def tick(self):
        for agent in self.dynamic_agents:
            agent.tick(self.dt)
        self.t += self.dt
    
    def render(self):
        try:
            self.visualizer.create_canvas(bg_color = 'gray')
            self.visualizer.update_agents(self.agents)
        except:
            pass
    
    def remove_agents(self):
        try:
            self.visualizer.remove_agents(self.agents)
        except:
            pass

        
    @property
    def agents(self):
        return self.static_agents + self.dynamic_agents
        
    def collision_exists(self, agent = None):
        if agent is None:
            for i in range(len(self.dynamic_agents)):
                for j in range(i+1, len(self.dynamic_agents)):
                    if self.dynamic_agents[i].collidable and self.dynamic_agents[j].collidable:
                        if self.dynamic_agents[i].collidesWith(self.dynamic_agents[j]):
                            return True
                for j in range(len(self.static_agents)):
                    if self.dynamic_agents[i].collidable and self.static_agents[j].collidable:
                        if self.dynamic_agents[i].collidesWith(self.static_agents[j]):
                            return True
            return False
            
        if not agent.collidable: return False
        
        for i in range(len(self.agents)):
            if self.agents[i] is not agent and self.agents[i].collidable and agent.collidesWith(self.agents[i]):
                return True
        return False
    
    def close(self):
        self.reset()
        self.static_agents = []
        if not self.headless and self.visualizer.window_created:
            self.visualizer.close()
        
    def reset(self):
        self.dynamic_agents = []
        self.t = 0