# TiLoIL

## Installation

This codebase was developed and tested for Python 3.8. Required packages can be found in requirements.txt.

We recommend setting up a virtual environment as follows:

    python3 -m virtualenv --python=3.8 TiLoIL
    source TiLoIL/bin/activate
    pip install -r requirements.txt

Optionally, pyygraphviz can also be installed for visualization.

    sudo apt-get install graphviz graphviz-dev

Finally, we rely on [Rabinizer4](https://www7.in.tum.de/~kretinsk/rabinizer4.zip) for LDBA synthesis. The path to the unzipped folder needs to be set as an environment variable

    export RABINIZER_PATH=/path/to/rabinizer

Note: the codebase also relies on a version of [safety-gym](https://github.com/openai/safety-gym) with updated dependencies, which is provided as a submodule.

## Execution

We provide configuration files for reproducing all experimental runs in the main paper:

    python drs_ltl_continuous.py --config configs/fetch_align.json
    python drs_ltl_tabular.py --config configs/q_cir_3.json

And the log will be found under the results folder. 