"""ICLR modular pipeline package.

Subpackages:
- utils: shared helpers (I/O, dates, logging, text)
- data: dataset fetching, filtering, enrichment (comments/news), analysis, reformatting
- inference: model loading and generation helpers, various inference modes
- evaluation: parsing and metrics utilities
- cli: thin command-line wrappers invoking library functions

All file paths and secrets must be provided via function arguments, a config object,
or environment variables. No hardcoded absolute paths or API keys.
"""

__all__ = [
    "utils",
    "data",
    "inference",
    "evaluation",
]
