from __future__ import annotations

import argparse

from ..evaluation import (
    process_logits,
    process_logits_firstonly,
    process_verbalized,
)


def main() -> None:
    p = argparse.ArgumentParser(description="ICLR evaluation CLI")
    sub = p.add_subparsers(dest="cmd", required=True)

    sp = sub.add_parser("logits", help="Evaluate multi-sample logits outputs")
    sp.add_argument("pattern", help="Glob pattern for JSONL files (e.g., cached_*_samples_10.jsonl)")

    sp = sub.add_parser("logits-first", help="Evaluate first-sample-only using token probs tail confidence")
    sp.add_argument("pattern", help="Glob pattern for JSONL files")

    sp = sub.add_parser("verbalized", help="Evaluate verbalized outputs JSONL (confidence/trend)")
    sp.add_argument("pattern", help="Glob pattern for JSONL files")

    args = p.parse_args()

    if args.cmd == "logits":
        process_logits(args.pattern)
        return

    if args.cmd == "logits-first":
        process_logits_firstonly(args.pattern, verbose=True)
        return

    if args.cmd == "verbalized":
        process_verbalized(args.pattern)
        return


if __name__ == "__main__":
    main()
