from setuptools import setup
import os
import torch
import glob
from torch.utils.cpp_extension import BuildExtension, CUDAExtension

include_dirs = os.path.dirname(os.path.abspath(__file__))
source_file = glob.glob(os.path.join('./', 'cuda_extension', '*.cpp'))
source_file += glob.glob(os.path.join('./', 'cuda_extension', '*.cu'))

if torch.cuda.is_available():
    setup(
        name='r2d2lib',
        ext_modules=[
            CUDAExtension('r2d2lib',
                            sources=source_file,
                            include_dirs=[include_dirs],
                            extra_compile_args={'nvcc': ['-extended-lambda'],}
                            )
        ],
        cmdclass={'build_ext': BuildExtension})