# PiBO

PiBO contains the two frameworks used for experiments - Spearmint and SMAC. Each of them come with a yml. file (mint.yml, smac.yml) containing all the requirements for running. Spearmint is written in python2, but its benchmarks are in python3. Thus, it is required to have a base pip environment with torch, pybnn and torchvision installed, and have the default python point to python3. However, the conda environment provided by the .yml file should be active when running the experiments. To start, simply run (in Spearmint):


bash start_one.sh p{beta} {prior_quality} {prior_number} {function}

So, if one wanted to run the FC-Net benchmark for a strong prior and a beta of 10 (for the 0:th sampled prior), one would enter

bash start_one.sh p10 strong 0 fcnet

For our BOWS implementation, one substitutes "p10" for "warping". This must always be run from the root of each approach's repo.


For SMAC, the arguments are slightly more complicated, as there are more options.

bash start_one.sh {{model}_{beta}_{acq.function}} {prior_quality} {initialization} {prior_number} {function}


So, if one wanted to run the FC-Net benchmark for a strong prior and a beta of 10 (for the 0:th sampled prior), EI acquisition function and GP surrogate, one would enter


bash start_one.sh gp_10_EI strong prior 0 fcnet

If one instead wanted to run UCB with a beta of 2, one would enter gp_2_UCB. For a random forest surrogate, enter rf_10_LogEI__10__, as it defaults to log transforming the black-box function. The last 10 is a hyperparameter of the adaptive binning, signifying the number of bins we start out with (10*beta).


All arguments, in short:

beta: float
prior_quality: [strong, weak, wrong, noprior]
prior_number: integer 0-19
function: [branin, svm, fcnet, xgboost]
initialization: [prior, sobol]


We provide the original licenses of Spearmint and SMAC as part of their respective repositories, as well as in this folder.
