# Advancing Fine-Grained Classification by Structure and Subject Preserving Augmentation

![Teaser Image](images/teaser.png)


## Setup

### Datasets

#### Available Datasets
- **Aircraft, Cars, and DTD**: These datasets can be downloaded via torchvision.
- **CUB**: Download from [Caltech-UCSD Birds-200-2011](https://www.vision.caltech.edu/datasets/cub_200_2011/).
- **CompCars**: Download from [CompCars dataset page](https://mmlab.ie.cuhk.edu.hk/datasets/comp_cars/).

#### Dataset Splits
If the original dataset does not include a validation set, splits are provided in the directory: `fgvc/datasets_files` and are loaded automatically.

#### Configuration
After downloading a dataset, specify the path in the corresponding `.py` file located in `fgvc/datasets`, and update the respective class in `all_utils/dataset_utils.py` to reflect the new path.


### Create env
```
conda env create -f environment.yml
```
you might want to re-install pytorch from https://pytorch.org/get-started/locally/ if you have problems


### Install local package
```
pip install -e .
```

## Running

### Prompts Construction
To create the prompts using GPT-4, follow the instructions in the paper.  
We provide our generated prompts i prompts_engineering/gpt_prompts.  

### Generation + Filtering
The generation code is located at: `run_aug/run_aug.py`.  
To use SaSPA, choose a dataset and ensure that `var BASE_MODEL = "blip_diffusion"` and `CONTROLNET = "canny"`.  
The code will automatically generate a JSON file with the filtered augmentations.  

### Training
Once you have the JSON file, copy it to `trainings_scripts/consecutive_runs_aug.sh`, under the variable `aug_json`.   
Make sure the correct dataset is specified in the `dataset` variable. The appropriate arguments for training, such as augmentation ratio and traditional augmentation, are automatically chosen in the script based on the dataset name.

That's it!
You should see your training start at `logs/dataset_name`.  
