
param_set_pretrain = {
    "hp": {
        "fea_len": 128,  # 64,
        "num_heads": 4,
        "num_encoders": 6,
        "num_decoder": 1,
        "attention_dropout": 0.0,
        "dropout": 0.0
    },
    "training_options": {
        "lr": 1e-5,
        "wd": 0,
        "lr_milestones": [200, 300],
        "epochs": 400,
        "batch_size": 256,
        "val_ratio": 0.1,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}


param_set0 = {
    "hp": {
        "fea_len": 256,
        "num_heads": 4,
        "num_encoders": 4,
        "num_decoder": 1,
        "attention_dropout": 0.0,
        "dropout": 0.1
    },
    "training_options": {
        "lr": 0.0001,
        "wd": 3e-5,
        "lr_milestones": [150, 200],
        "epochs": 250,
        "batch_size": 128,
        "val_ratio": 0.1,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}


param_set1 = {
    "hp": {
        "fea_len": 64,
        "num_heads": 4,
        "num_encoders": 4,
        "num_decoder": 1,
        "attention_dropout": 0.0,
        "dropout": 0.1
    },
    "training_options": {
        "lr": 0.0001,
        "wd": 1e-5,
        "lr_milestones": [75, 150],
        "epochs": 200,
        "batch_size": 32,
        "val_ratio": 0.1,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}


param_set3 = {
    "hp": {
        "fea_len": 64,
        "num_heads": 8,
        "num_encoders": 8,
        "num_decoder": 1,
        "attention_dropout": 0.05,
        "dropout": 0.0
    },
    "training_options": {
        "lr": 0.0001,
        "wd": 0,
        "lr_milestones": [75, 150, 200],
        "epochs": 250,
        "batch_size": 256,
        "val_ratio": 0.01,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}


param_set4 = {
    "hp": {
        "fea_len": 256,
        "num_heads": 2,
        "num_encoders": 8,
        "num_decoder": 1,
        "attention_dropout": 0.0,
        "dropout": 0.0
    },
    "training_options": {
        "lr": 0.0001,
        "wd": 0,
        "lr_milestones": [75, 150, 200],
        "epochs": 250,
        "batch_size": 256,
        "val_ratio": 0.01,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}

param_set5 = {
    "hp": {
        "fea_len": 64,
        "num_heads": 4,
        "num_encoders": 4,
        "num_decoder": 1,
        "attention_dropout": 0.0,
        "dropout": 0.1
    },
    "training_options": {
        "lr": 0.0001,
        "wd": 3e-5,
        "lr_milestones": [75, 150],
        "epochs": 200,
        "batch_size": 32,
        "val_ratio": 0.05,
        "cuda": True
    },
    "data_options": {
        "k": 15,
        "tol": 1e-4
    }
}


p = {
    # "pretrain": param_set_pretrain,
    "matbench_phonons": param_set0,
    "matbench_dielectric": param_set1,
    "matbench_log_gvrh": param_set0,
    "matbench_log_kvrh": param_set0,
    "matbench_mp_gap": param_set3,
    "matbench_mp_e_form": param_set4,
    "matbench_jdft2d": param_set5
}
