import random

def generate_results_file():
    # Read words from words.txt
    with open('dictionary.txt', 'r') as f:
        words = [word.strip() for word in f.readlines()]

    # Generate 10 random key-value pairs
    pairs = [(random.choice(words), random.choice(words)) for _ in range(10)]

    # Generate 1000 random words for the bottom section
    bottom_words = [random.choice(words) for _ in range(1000)]

    # Select a random key-value pair for the question
    question_pair = random.choice(pairs)

    # Write to results.txt
    with open('words.txt', 'w') as f:
        f.write("Key-value pairs are comma separated tuples of the form (key,value).\n")
        f.write("Key-value pairs start in the next line:\n")
        for pair in pairs:
            f.write(f"({pair[0]},{pair[1]})\n")
        f.write("Key-value pairs end here, please ignore everything below except the last\n")
        f.write("line of this file.\n")
        f.write(' '.join(bottom_words) + '\n')
        f.write(f"What is the value for key '{question_pair[0]}'?\n")

if __name__ == "__main__":
    generate_results_file()