import argparse


def caesar_cipher(text, shift):
    result = ""
    for char in text:
        if char.isalpha():
            ascii_offset = 65 if char.isupper() else 97
            shifted_char = chr((ord(char) - ascii_offset + shift) % 26 + ascii_offset)
            result += shifted_char
        else:
            result += char
    return result


parser = argparse.ArgumentParser(description="Apply Caesar cipher")
parser.add_argument("letter", help="Letter from the previous script")
args = parser.parse_args()

message = "Vaqo eo pda gejc kb pda ckzo"
encrypted = caesar_cipher(message, ord(args.letter) - 65)
print(f"The decrypted message is: {encrypted}")
print("Use the alphabetical index (A=1, B=2, etc.) of the first letter of the decrypted message in the next script.")
