import argparse


def prime_factors(n):
    # raise ValueError if n is not a positive integer or larger than 1,000,000
    if not isinstance(n, int) or n <= 0 or n > 1_000_000:
        raise ValueError("Input must be a positive integer less than or equal to 1,000,000")

    factors = []
    d = 2
    while n > 1:
        while n % d == 0:
            factors.append(d)
            n //= d
        d += 1
        if d * d > n:
            if n > 1:
                factors.append(n)
            break
    return factors


parser = argparse.ArgumentParser(description="Find prime factors")
parser.add_argument("count", type=int, help="Count of 'I's from the previous script")
args = parser.parse_args()

factors = prime_factors(args.count)
print(f"The prime factors of {args.count} are: {factors}")
print("Use the largest prime factor in the next script.")
