import argparse

def rot13(message):
    result = ""
    for char in message:
        if char.isalpha():
            ascii_offset = 65 if char.isupper() else 97
            rotated_char = chr((ord(char) - ascii_offset + 13) % 26 + ascii_offset)
            result += rotated_char
        else:
            result += char
    return result

parser = argparse.ArgumentParser(description="Apply ROT13 encoding")
parser.add_argument("dot_count", type=int, help="Count of dots from the previous script")
args = parser.parse_args()

original = "PRIMESRCOOL"[:args.dot_count]
encoded = rot13(original)
print(f"The ROT13 encoding of the first {args.dot_count} letters of 'PRIMESRCOOL' is: {encoded}")
print("Take the last letter of this encoded string and use it in the next script.")