import argparse

def decrypt(ciphertext, key):
    return ''.join(chr((ord(char) - 65 - key) % 26 + 65) if char.isalpha() else char for char in ciphertext)

parser = argparse.ArgumentParser(description="Decrypt final message")
parser.add_argument("key", type=int, help="Number from the bottom of the ASCII tree")
args = parser.parse_args()

encrypted_message = "LZW XAFSD EWKKSYW AK: QGMJWLZWTWKL"
decrypted_message = decrypt(encrypted_message, args.key % 26)

print("Congratulations! Here's the final decrypted message:")
print(decrypted_message)