import argparse

morse_code_dict = {
    'A':'.-', 'B':'-...', 'C':'-.-.', 'D':'-..', 'E':'.', 'F':'..-.',
    'G':'--.', 'H':'....', 'I':'..', 'J':'.---', 'K':'-.-', 'L':'.-..',
    'M':'--', 'N':'-.', 'O':'---', 'P':'.--.', 'Q':'--.-', 'R':'.-.',
    'S':'...', 'T':'-', 'U':'..-', 'V':'...-', 'W':'.--', 'X':'-..-',
    'Y':'-.--', 'Z':'--..', '0':'-----', '1':'.----', '2':'..---',
    '3':'...--', '4':'....-', '5':'.....', '6':'-....', '7':'--...',
    '8':'---..', '9':'----.'
}

parser = argparse.ArgumentParser(description="Convert to Morse code")
parser.add_argument("count", type=int, help="Count of '1's from the previous script")
args = parser.parse_args()

message = "PUZZLEHUNT"[:args.count]
morse_message = ' '.join(morse_code_dict[char] for char in message)
print(f"The Morse code for the first {args.count} letters of 'PUZZLEHUNT' is: {morse_message}")
print("Count the number of dots (.) in this Morse code and use it in the next script.")