import sys


def insertion_sort(arr):
    for i in range(1, len(arr)):
        key = arr[i]
        j = i - 1

        # Move elements of arr[0..i-1], that are greater than key,
        # to one position ahead of their current position
        while j >= 0 and key < arr[j]:
            arr[j + 1] = arr[j]
            j -= 1

        arr[j] = key
    return arr


if __name__ == '__main__':
    if len(sys.argv) != 2:
        print("Usage: python sort.py <comma-separated list of numbers>")
        sys.exit(1)

    arr = list(map(int, sys.argv[1].split(',')))
    sorted_arr = insertion_sort(arr)
    print(", ".join(map(str, sorted_arr)))
