# AdapterAlignment

This repository implements **Adapter Alignment (AAMax)** for efficient multi-subject fMRI-to-image reconstruction.  
It builds upon the pipelines from [MindEye1](https://github.com/MedARC-AI/fMRI-reconstruction-NSD) and [MindEye2](https://github.com/MedARC-AI/MindEyeV2), with modifications for subject-specific adapter alignment and greedy image selection. 

To run the notebooks here, you will have to follow the instructions from MindEy1's repository to set up versatile diffusion in `data/vd` and the instructions from MindEye2 to set up Stable Diffusion XL, bigCLIP and download their unCLIP checkpoints.

---

## Setup

1. Clone this repository and install dependencies from MindEye1/MindEye2.  
   We recommend using Python ≥ 3.9 and a recent PyTorch build with CUDA.  
   ```bash
   git clone https://github.com/yourname/AdapterAlignment.git
   cd AdapterAlignment
   pip install -r requirements.txt


# MindEye Project Setup and Execution Guide

## Data Preparation

### Download and Preprocessing
1. Download and preprocess the Natural Scenes Dataset (NSD) betas and images
2. Use preprocessing scripts from MindEye2 or your own pipeline

### Required File Formats
- **Betas**: Shape `(10000, 3, num_voxels)`
- **Images**: Shape `(73000, H, W, 3)` - all NSD images in a single NumPy array

### Subject-Specific Setup
- Create subject-specific betas and image_ids
- Place each subject's data in corresponding folders: `data/new_dl/subjXX/`
- Include the provided `image_ids.npy` and `voxel_ids.npy` files in each subject folder

---

## MindEye1 (Versatile Diffusion) Pipeline

1. Train Reference Model - Train_MindEye1_Clean.ipynb
2. Fine-tune New Subjects - Train_MindEye1_FineTune_Clean.ipynb
3. Generate Reconstructions - Reconstruction_MindEye1_Clean.ipynb
4. Evaluate Results - MindEye1_ReconstructionMetrics.ipynb

## MindEye2 (unCLIP + SDXL) Pipeline

1. Train Reference Model - Run Train_MindEye2_Clean.ipynb to train a subject reference model.
2. Fine-tune New Subjects - Run Train_MindEye2_FineTune_Clean.ipynb to fine-tune with baseline or AAMax.
3. Reconstructions
    - First run unCLIP_Reconstruction_Clean.ipynb for intermediate unCLIP outputs.
    - Then run SDXL_Reconstruction_Clean.ipynb for final reconstruction
4. Metrics - Evaluate using MindEye2_ReconstructionMetrics.ipynb.

## Image Selection (Greedy Algorithm)

- Use ImageSelection.ipynb to run the greedy selection algorithm and obtain common image IDs.
- For random selection, simply take the first k images from each split.

## Notes:

- Pixel-level metrics in the results are reported for completeness but are not directly optimized during training.
- The repository provides global indices for NSD images and betas. Ensure your preprocessed files align with these indices.
- Adapter Alignment can be applied with different architectures; the codebase supports both MindEye1 and MindEye2 pipelines.