# Unleashing the Power of PAC-Bayes Training for Unbounded Loss
## Environment:
* PyTorch 
* PyG (PyTorch Geometric) 
* transformers

We also provide the environment we used in experiments, using the following command to install
```
conda env create -f environment.yml
```
## baselines:
1. CNN baseline examples (label smoothing=0.1 is added to all CNNs)
* CIFAR10: ResNet18 + SGD (lr=0.1, momentum=0.6) + weight decay (1e-2) + batch size (128)
	```
	python ./example/train_CNN.py --optimizer SGD --model resnet18 --seed 42 --dataset cifar10 --batch_size 128 -lr 1e-1 -beta 0.6 --weight_decay 1e-2
	```
* CIFAR10: ResNet18 + Adam (lr 5e-3) + weight decay (1e-3) + noise injection/pertubed gradient descent (1e-2) + batchsize 2048
	```
	python ./example/train_CNN.py --optimizer Adam --model resnet18 --seed 42 --dataset cifar10 --batch_size 2048 -lr 5e-3 -beta 0 --weight_decay 1e-3 --noise_level 1e-2
	```
2. GNN baseline examples
* CORAML: GCN + AdamW (lr=0.1) + noise injection/perturbed gradient descent (1e-2) + dropout (0.5) 
	```
	python ./example/train_GNN.py --dataset cora_ml --model gcn -lr 1e-1 -nl 1e-2 --dropout 0.5
	```
* CORAML including validation nodes for training: GCN + AdamW (lr=0.1) + noise injection/perturbed gradient descent (1e-2) + dropout (0.5) 
	```
	python ./example/train_GNN.py --dataset cora_ml --model gcn -lr 1e-1 -nl 1e-2 --dropout 0.5 --train_rest
	```
3. Finetune the last layer of the pretrained BERT on SST
	```
	cd transformer
	python transformer_autotuning.py  --num_labels 2 --task_name SST --train_data ./data/SST/train.set.txt  --test_data ./data/SST/test.set.txt --lr 0.01 --batch_size 100 --train_size 100 --max_epoch 260 --method baseline
	```
## Our PAC-Bayes training
1. CNN examples (label smoothing=0.1 is added to all CNNs)
* PAC-Bayes training with a scalar prior
	```
	python ./example/train_auto_scalar.py --model resnet18
	```
* PAC-Bayes training with a layer-wise prior
	```
	python ./example/train_auto_layer.py --model resnet18
	```
2. GNN example
* PAC-Bayes training with a scalar prior for gcn
	```
	python ./example/train_auto_GNN.py --model gcn
	```
3. Transfer learning example
* PAC-Bayes training with a scalar prior for finetuning the last layer of the pretrained BERT
	```
	cd transformer
	python ./transformer_autotuning.py  --num_labels 2 --task_name SST --train_data ./data/SST/train.set.txt  --test_data ./data/SST/test.set.txt --lr 0.01 --batch_size 100 --train_size 100 --shift 200 --max_epoch 260 --refine_gamma 1
	```
