import argparse

def add_shared_args():
    parser = argparse.ArgumentParser(description='Parameter Processing')
    
    # basic
    parser.add_argument('--dataset', type=str, default='CIFAR10', help='dataset')
    parser.add_argument('--ipc', type=int, default=1, help='image(s) per class')
    parser.add_argument('--data_path', type=str, default='data', help='dataset path')
    parser.add_argument('--save_path', type=str, default='result', help='path to save results')
    parser.add_argument('--res', type=int, default=128, choices=[128, 256, 512], help='resolution')
    parser.add_argument('--init', type = str, choices = ['noise', 'real'], default = 'real', help = 'noise/real: initialize synthetic images from random noise or randomly sampled real images.')
    parser.add_argument('--log_it', type=int, default=10, help='how often to print logs')
    parser.add_argument('--save_image_it', type=int, help='= eval_it if not specified')

    # train
    parser.add_argument('--Iteration', type=int, default=1000, help='training iterations')
    parser.add_argument('--batch_real', type=int, default=64, help='batch size for real data')
    parser.add_argument('--lr_net', type=float, default=0.01, help='learning rate for updating network parameters')
    parser.add_argument('--lr_latent_base', type=float, default=0.01, help='base learning rate for updating latents, real lr_latent = latent_per_class * lr_latent_base')
    parser.add_argument('--mom_latent', type=float, default=0.5, help='momentum for updating synthetic latents')
    parser.add_argument('--mom_net', type=float, default=0.9, help='momentum for updating networks')
    parser.add_argument('--weight_decay', type=float, default=0.0005, help='weight decay for updating networks')

    # eval
    parser.add_argument('--batch_train', type=int, default=64, help='batch size for training networks')
    parser.add_argument('--batch_test', type=int, default=64, help='batch size for training networks')
    parser.add_argument('--eval_mode', type=str, default='M', help='eval_mode')  # S: the same to training model, M: multi architectures
    parser.add_argument('--num_eval', type=int, default=5, help='the number of evaluating randomly initialized models')
    parser.add_argument('--eval_it', type=int, default=100, help='how often to evaluate')
    parser.add_argument('--epoch_eval_train', type=int, default=1000, help='epochs to train a model with synthetic data')

    # aug
    parser.add_argument('--dsa', type=str, default='False', choices=['True', 'False'], help='whether to use differentiable Siamese augmentation.')
    parser.add_argument('--dsa_eval', type=str, default='True', choices=['True', 'False'], help='whether to use differentiable Siamese augmentation during evaluation.')
    parser.add_argument('--dsa_strategy', type=str, default='color_crop_flip_scale_rotate', help='differentiable Siamese augmentation strategy')
    parser.add_argument('--cutmix_p', type = float, default = 0.5, help = 'prob of using cutmix')
    parser.add_argument('--cutmix_beta', type = float, default = 1.0)

    # net
    parser.add_argument('--model', type=str, default='ConvNet', help='model')
    parser.add_argument('--train_width', type=int, default=128)
    parser.add_argument('--train_depth', type=int, default=5)
    parser.add_argument('--test_width', type=int, default=128)
    parser.add_argument('--test_depth', type=int, default=5)    # high-res maybe 5? GLaD default: 5

    # latent
    parser.add_argument('--lpc', type=int, default=None, help='latent(s) per class, by default computed from ipc and f')
    parser.add_argument("--ae_config", type=str, default="configs/autoencoder/train_autoencoder_dc.yaml", help="path to config which constructs model")
    parser.add_argument("--ae_ckpt", type=str, default="diffusion_models/sd-v1-4-autoencoder.ckpt", help="path to checkpoint of SD model")
    parser.add_argument("--C", type=int, default=4, help="latent channels")
    parser.add_argument("--f", type=int, default=8, choices = [8, 4, 2], help="downsampling factor")
    parser.add_argument("--ldc_mode", type = str, choices = ['same_ipc', 'same_param', 'same_storage'], default = 'same_ipc')

    # misc
    parser.add_argument('--comment', type = str, default = None)
    parser.add_argument('--torch_num_threads', type = int, default = 4) # to avoid CPU being overwhelmed
    return parser
