try:
    from math import inf
except ImportError:
    inf = float('Inf')

dist = {'ABC': (
'mielke', (2.13957439294237, 9.694054209976372, -0.2151666855790424, 24.66682096996722), 0.0, 367.1090937108722,
17.7798048228741, 8.023897099664797), 'ABCGG': (
'mielke', (2.690736875067711, 9.87194119442827, -0.10331423330418296, 18.892561638665345), 0.0, 260.5790507996169,
14.504679564786528, 5.608781486812306), 'nAcid': (
'wald', (-0.016759884329029997, 0.05574973066513966), 0.0, 21.0, 0.10405826991265525, 0.41988536481984173), 'nBase': (
'gilbrat', (-0.013550099308985382, 0.03735609543576404), 0.0, 23.0, 0.32036558541108756, 0.7290123223823954),
        'SpAbs_A': ('mielke', (2.0380344987046852, 9.308127783649844, -0.1948803907027331, 41.40599760690083), 0.0,
                    602.3555754429683, 29.259635325448194, 13.126937157677594), 'SpMax_A': (
    'johnsonsu', (0.030962052633405637, 1.2598528486006886, 2.439403340266052, 0.1245667935348392), 0.0,
    4.354332988399193, 2.434963765596621, 0.14014939835874798), 'SpDiam_A': (
    'johnsonsu', (0.3655483764032613, 1.281623847628468, 4.866336080584178, 0.22844449196432176), 0.0,
    7.226988669831329, 4.780095227617037, 0.25277948755047375), 'SpAD_A': (
    'mielke', (2.0339247389574027, 9.770463297371247, -0.18784023988379028, 41.47160153968562), 0.0, 602.3555754429683,
    29.259635325448194, 13.126937157677592), 'SpMAD_A': (
    'johnsonsu', (1.0050329310170254, 1.623400379315782, 1.3211758021859787, 0.0602455845380722), 0.0,
    1.5545788037739317, 1.272462819905342, 0.05590463000647472), 'LogEE_A': (
    'johnsonsu', (1.286160105749599, 1.2723831263006664, 4.442509190458479, 0.30580779450982604), 0.6931471805599453,
    7.070774826717258, 3.9620949128304868, 0.46956018903937785), 'VE1_A': (
    'genlogistic', (0.4242655248817724, 4.32261224308534, 0.2519336813516051), 1.0, 11.6463345865172,
    3.8669385766211835, 0.6876444747524828), 'VE2_A': (
    'norminvgauss', (1.886414103911565, 1.6283256867645601, 0.1306965632355086, 0.03690920908243024),
    0.011525503965453585, 1.0, 0.19437004520626433, 0.06598968661773466), 'VE3_A': (
    'johnsonsu', (1.1086027444550544, 1.1139391209882894, 2.6541546204794413, 0.3549957976036826), -2.3025850929940455,
    5.777467702160251, 2.057737570322348, 0.6657708305368333), 'VR1_A': (
    'genhalflogistic', (0.00017450257068584552, -0.3098797010059524, 120333.23759781432), 0.0, 3.599270953424594e+21,
    4863147782583644.0, 4.177111222423459e+18), 'VR2_A': (
    'genhalflogistic', (0.002251682823772607, -131179.47034231533, 202667.85519726248), 0.0, 3.5286970131613667e+19,
    47577830189148.87, 4.09519898405023e+16), 'VR3_A': (
    'foldcauchy', (5.2418661237442565, 1.386294359768932, 0.952830650666908), -1.2628643221541276, 51.957405985181126,
    6.072225904665912, 1.8037240775745451), 'nAromAtom': (
    'burr12', (0.4034922089166935, 0.9589198874117781, -2.2975634900946253e-27, 4.426904950416692), 0.0, 176.0,
    10.473882181958858, 6.835091465961268), 'nAromBond': (
    'frechet_r', (0.2530559354764481, -1.8734023528313275e-28, 3.0822084455815757), 0.0, 184.0, 10.735000241789294,
    7.08967231269102), 'nAtom': (
    'mielke', (2.165343008205428, 7.329277529019914, 1.9325278697061212, 53.502327735912004), 1.0, 940.0,
    41.66372598607555, 19.288744893468884), 'nHeavyAtom': (
    'burr', (9.368813837244522, 0.22806228704182424, -0.1349715344721453, 31.947568117675267), 1.0, 492.0,
    23.018790295492657, 10.292491151457297), 'nSpiro': (
    'exponweib', (1.0921393975745954, 0.7654079413758943, -1.3377549780282024e-30, 0.008240286955079171), 0.0, 5.0,
    0.032266454414876446, 0.18604567819579892), 'nBridgehead': (
    'wald', (-0.017460939276550805, 0.057889890365103516), 0.0, 32.0, 0.11442384225405128, 0.6073770007058182),
        'nHetero': (
        'dweibull', (1.209709973087401, 6.388779806433782, 2.6016860358507454), 0.0, 246.0, 6.261061860156914,
        3.4805542339867244), 'nH': (
    'pearson3', (0.9070609778901844, 18.683036660336082, 8.803922586205204), 0.0, 448.0, 18.64507161537466,
    9.76262759755328), 'nB': (
    'genhalflogistic', (8.873815706833515e-08, -3.853449274453186e-05, 0.0013431052173330025), 0.0, 4.0,
    0.0006181964087101652, 0.02783254462141895), 'nC': (
    'burr', (8.51348490201238, 0.2342839011067014, -0.14202170910873557, 23.53646106089552), 0.0, 305.0,
    16.757592510543972, 7.658039790549587), 'nN': (
    'gennorm', (0.10897032264856085, 1.9998135583401075, 5.08723171961507e-10), 0.0, 88.0, 2.5760009096505296,
    1.8790712738229132), 'nO': (
    'dgamma', (1.787690944317748, 2.546666434070654, 0.8413734394245261), 0.0, 122.0, 2.826532519352946,
    2.185658926711321), 'nS': (
    'halfgennorm', (0.36830583262048633, -1.0545984040425644e-24, 0.0035687879326442903), 0.0, 21.0, 0.420637565691537,
    0.6583513301760163), 'nP': (
    'halflogistic', (-8.636042925686507e-10, 0.005900339435839345), 0.0, 19.0, 0.007730722531756083,
    0.11042224289269664),
        'nF': ('wald', (-0.03656130181100978, 0.12229895811989612), 0.0, 36.0, 0.20560977299252806, 0.7350000601982511),
        'nCl': ('pareto', (6.230583522173028, -0.146626922117644, 0.14662692211064926), 0.0, 12.0, 0.1711881264466515,
                0.4802244282116924), 'nBr': (
    'wald', (-0.006649251754648659, 0.022037018562352042), 0.0, 10.0, 0.043001899026177286, 0.22386003709849175),
        'nI': ('halflogistic', (-1.0752466571190056e-08, 0.0035002428617900926), 0.0, 6.0, 0.0032360556193792157,
               0.07043606034370284), 'nX': (
    'gilbrat', (-0.03448856920660349, 0.09724841394474455), 0.0, 36.0, 0.42303585408473604, 0.9004250522330343),
        'ATS0dv': (
        'burr', (7.989152187938657, 0.2378374481546196, -1.615224062572633, 468.9530117203084), 0.0, 8061.308641975309,
        326.6387124019021, 159.2007101093589), 'ATS1dv': (
    'mielke', (1.8629333667088717, 8.210398842348065, -1.4844996283779621, 442.7478591280886), 0.0, 6287.666666666666,
    306.6130599418629, 146.55732939260827), 'ATS2dv': (
    'norm', (439.59826588399085, 228.3295355735694), 0.0, 11109.77777777778, 440.4735591490632, 231.54535720668537),
        'ATS3dv': (
        'vonmises_line', (30.55238047378733, 421.00786210162437, 1368.4116981194766), 0.0, 10642.111111111111,
        425.88831374501933, 256.8572577177339), 'ATS4dv': (
    'mielke', (0.9291670269108149, 6.355245169180859, -6.523489022095105e-10, 730.8075974659885), 0.0, 11505.0,
    397.74251954788537, 283.00875652599547), 'ATS5dv': (
    'nakagami', (0.3140895991918179, -2.687573365786455e-24, 488.85285186411636), 0.0, 14703.333333333332,
    367.7678662558587, 304.04414120492856), 'ATS6dv': ('gausshyper', (
    0.41226064840904186, 2.1837642876109866, 1.534995199482342, 1.6633533322559337, -2.1487340487017994e-28,
    5861.217396759204), 0.0, 13808.666666666668, 329.02763350362653, 295.3890596975588), 'ATS7dv': (
    'nakagami', (0.164798180053448, -3.994591494030621e-26, 350.3309959272742), -2.3333333333333335, 14580.666666666668,
    289.09964009109916, 288.03572776364115), 'ATS8dv': (
    'nakagami', (0.3035237490401468, -1.5528348377330374e-25, 368.9893496606944), 0.0, 20297.777777777777,
    247.04509298508123, 283.816836475553), 'ATS0d': (
    'mielke', (2.176176791070229, 8.602448253014561, -0.6409634999874456, 189.98906926875645), 0.0, 2825.0,
    137.96351464916373, 62.59730169187055), 'ATS1d': (
    'logistic', (171.7777035469939, 41.323897584055786), 0.0, 3585.0, 173.04642354426508, 79.82110693769148), 'ATS2d': (
    'mielke', (2.031364913449216, 6.784574627121759, 0.3034710030289401, 368.45321407498614), 0.0, 5689.0,
    270.462254077417, 133.72703189057145), 'ATS3d': (
    'vonmises_line', (10.580941352924953, 290.44757144912205, 495.1693957998907), 0.0, 6674.0, 295.566660001124,
    167.69163162679993), 'ATS4d': (
    'logistic', (271.93248781245404, 93.89326751563587), 0.0, 7293.0, 282.4338288053387, 185.12915080857871), 'ATS5d': (
    'foldnorm', (0.1381174951831275, -1.4204383094659748e-11, 323.6794399546111), 0.0, 7935.0, 258.2229035888066,
    194.5622131901996), 'ATS6d': (
    'nakagami', (0.28983342421602754, -8.253572012661012e-27, 362.563415754659), 0.0, 8854.0, 238.17149395722814,
    201.94056944047884), 'ATS7d': (
    'nakagami', (0.36182661582271125, -7.240419315674425e-26, 273.5805684621782), 0.0, 9662.0, 216.30404938252244,
    203.45287044228002), 'ATS8d': (
    'nakagami', (0.17830229873857917, -1.637163298447776e-26, 248.17568416203028), 0.0, 10308.0, 191.7453841116988,
    199.55147206113222), 'ATS0s': (
    'burr', (5.303767692103436, 0.37285808438054996, -0.7292893710384002, 272.42420544744346), 2.1007944691358027,
    6943.106538637402, 206.73065931779044, 120.68973599606618), 'ATS1s': (
    'mielke', (2.286300090397926, 8.503878403958655, -0.626974002496419, 184.4772297427582), 1.0503972345679014,
    3319.064814814815, 136.39217929654768, 62.130303726216255), 'ATS2s': (
    'mielke', (2.008351235274839, 6.377077729227417, -1.11363334476002, 334.05596287439346), 0.0, 6102.271604938271,
    247.16096422666394, 130.62738448689473), 'ATS3s': (
    'burr', (6.278383123016065, 0.318819881139804, -1.2971906683558185, 400.11773438901724), 0.0, 8679.793209876543,
    296.2489154116328, 163.9934769460791), 'ATS4s': (
    'vonmises_line', (21.599648983575264, 323.3212738015825, 860.3682802945611), 0.0, 10257.469135802468,
    328.6482042261055, 208.04546189069615), 'ATS5s': (
    'logistic', (297.6818577730546, 113.68890176324766), 0.0, 14285.704732510287, 316.05637989848947,
    244.01577759747218), 'ATS6s': (
    'chi', (0.7980389148760523, -6.307042203674726e-27, 420.7273146880576), 0.0, 13431.870370370369, 285.9829548469338,
    245.26113497701255), 'ATS7s': (
    'nakagami', (0.251259300535407, -3.8517119351819728e-25, 483.2744343184571), 0.0, 14382.046296296297,
    262.23893830896907, 253.26795658288967), 'ATS8s': (
    'nakagami', (0.2553826970932047, -5.8862260690598e-25, 278.7650867161076), 0.0, 17900.654320987655,
    235.61866730371645, 268.5229645188285), 'ATS0Z': (
    'foldcauchy', (2.9390323912167773, 177.99999999807454, 334.3850088924778), 9.0, 31114.0, 1171.9823833628054,
    635.4482036182104), 'ATS1Z': (
    'burr', (8.553463560115002, 0.2377805605016406, -10.505530795345843, 1673.8869831847562), 0.0, 32071.0,
    1186.6768963142163, 552.2901389837602), 'ATS2Z': (
    'genlogistic', (0.8714178086699798, 1805.2263714438309, 410.9161064368087), 0.0, 46524.0, 1729.218156676848,
    836.0252013964284), 'ATS3Z': (
    'gennorm', (1.232899414918045, 1895.4105306262422, 951.8733130120688), 0.0, 50355.0, 1880.895352287,
    1021.4472411879289), 'ATS4Z': (
    'dweibull', (1.086539779356407, 1838.6601680694735, 856.3473865088786), 0.0, 57743.0, 1802.722297808605,
    1145.0762274425142), 'ATS5Z': (
    'mielke', (0.921863134421897, 7.372149091498296, -0.007100103477076458, 2701.252477372424), 0.0, 67124.0,
    1659.2998239512553, 1217.377511854521), 'ATS6Z': (
    'chi', (0.7912092665472339, -5.160755225816949e-26, 2251.858407050331), 0.0, 75724.0, 1523.1496871769336,
    1249.2293274083106), 'ATS7Z': (
    'nakagami', (0.22470364810657129, -6.4120403055397725e-27, 2000.5546709189725), 0.0, 78699.0, 1375.3496782895434,
    1257.7094088907595), 'ATS8Z': (
    'chi', (0.6182113608699612, -6.562735685719046e-25, 2254.0145101106136), 0.0, 87322.0, 1211.7438248975009,
    1249.487764177859), 'ATS0m': (
    'dgamma', (1.0656337463252834, 4630.044337277648, 1729.2734619371145), 48.1636, 126769.904003, 4752.315594874443,
    2902.588800256648), 'ATS1m': (
    'gennorm', (1.2974699249592319, 4600.183578367001, 2066.40742503631), 0.0, 126196.672527246, 4541.188870433377,
    2139.8478726234803), 'ATS2m': (
    't', (8.45347735623335, 6715.015589487024, 2732.712330946839), 0.0, 178391.121621516, 6512.584022780209,
    3196.1163201775894), 'ATS3m': (
    'gennorm', (1.3050636545450711, 6961.331731971098, 3764.0885647852933), 0.0, 188580.62108524598, 6892.375981265033,
    3823.9990218468656), 'ATS4m': (
    'gennorm', (1.1968605152490839, 6522.422880626001, 3793.7510196538988), 0.0, 214392.44854039198, 6498.448137172971,
    4271.60279205585), 'ATS5m': (
    'vonmises_line', (17.66879018261271, 5985.570133256491, 17223.010410633127), 0.0, 252481.54008831596,
    5972.799859909593, 4474.137493743307), 'ATS6m': (
    'nakagami', (0.30383908397255716, -1.357047906408976e-24, 6863.434501000664), 0.0, 286091.3917047576,
    5473.728422799412, 4544.616176571289), 'ATS7m': (
    'chi', (0.6945799068194479, -1.7528656303660138e-24, 9119.691578724953), 0.0, 298479.81338773, 4917.301347456811,
    4543.762120906964), 'ATS8m': (
    'chi', (0.6182113621154646, -2.5445145332781596e-23, 8054.60785470699), 0.0, 330981.12548278196, 4309.609388604709,
    4503.882994981019), 'ATS0v': (
    'johnsonsu', (0.2698507382175711, 1.718416197797825, 10422.992762382688, 5714.058192528462), 208.12775011307815,
    217881.40796866143, 9340.617189236347, 4159.903709549975), 'ATS1v': (
    'gennorm', (1.3731777281094506, 11748.65005634382, 5356.353044568321), 0.0, 235663.75900259713, 11646.368244650206,
    5255.696181223913), 'ATS2v': (
    'gennorm', (1.3660798586038072, 17075.571910692153, 8147.426085425332), 0.0, 337609.47801694483, 16803.880118446526,
    8012.159594240208), 'ATS3v': (
    'dweibull', (1.1281321900659507, 18844.135927731295, 7640.744952067742), 0.0, 405090.17676910496,
    18598.518765434528, 10014.516644165324), 'ATS4v': (
    'dweibull', (1.1139287895188685, 17986.127644205342, 8273.624267537647), 0.0, 449922.5459221606, 17772.44168134484,
    11121.880545563325), 'ATS5v': (
    'logistic', (16169.087461698724, 6151.450572298471), 0.0, 498062.91781298106, 16457.560464931936,
    11938.039427497806), 'ATS6v': (
    'nakagami', (0.29325903954652827, -3.3003014968324083e-24, 19773.3818610527), 0.0, 556486.4860059246,
    15278.348998493486, 12538.060214186784), 'ATS7v': (
    'nakagami', (0.2260779649957705, -2.9888798717321296e-25, 20608.538196480375), 0.0, 618719.1163712076,
    13970.368027796987, 12762.81369626028), 'ATS8v': (
    'nakagami', (0.24526897913821494, -6.1532716547235935e-24, 16481.529826089616), 0.0, 661852.0346187897,
    12448.8971629765, 12596.914231123865), 'ATS0se': (
    'mielke', (2.397446424966571, 7.669096504796787, -3.8958226516694587, 431.07894758859584), 0.198025,
    7511.197485999998, 325.20322161960223, 149.55221483554453), 'ATS1se': (
    'mielke', (2.362357065331082, 7.416601153120313, -2.424515174762746, 447.0400138377479), 0.0, 7579.690552000002,
    340.2008726443561, 156.23403244911927), 'ATS2se': (
    'burr', (6.845370312482589, 0.3240281109936195, -0.33481855888073186, 776.1639369273393), 0.0, 13159.707116000001,
    587.3534232831732, 285.5232576461694), 'ATS3se': (
    'maxwell', (-90.62797698332568, 527.1561950350947), 0.0, 19367.559492, 744.1872861631033, 406.14824776543713),
        'ATS4se': ('logistic', (769.323410085309, 243.80187215125991), 0.0, 22023.285703999998, 798.212064923645,
                   492.15614264646825), 'ATS5se': (
    'logistic', (723.6271321926363, 262.47493501138524), 0.0, 23537.245167999998, 751.6797541726812, 532.5737345044763),
        'ATS6se': (
        'chi', (0.9108819141054683, -5.5474226908275e-28, 962.372422651862), 0.0, 26281.894385999993, 693.250459750757,
        567.3385913840997), 'ATS7se': (
    'chi', (0.6098796400868001, -1.1381842298997206e-26, 1146.7834815382162), 0.0, 29923.72476399999, 644.2421017680632,
    598.1190554674666), 'ATS8se': (
    'nakagami', (0.2684117360878201, -3.280541448947205e-27, 721.8885927788056), 0.0, 32671.512569999995,
    586.8182036118546, 606.9529646339354), 'ATS0pe': (
    'burr', (8.010353107306141, 0.2975086795336835, -2.860571583961246, 353.69974586409137), 0.6723999999999999,
    6117.6535, 264.6862462183304, 121.36126147336294), 'ATS1pe': (
    'dweibull', (1.1226639547698767, 284.8033578258087, 96.12137238377832), 0.0, 6340.370500000001, 284.7521727418395,
    130.57542939132344), 'ATS2pe': (
    'burr', (6.826759829301443, 0.33092421534188304, -3.996779783847146, 639.9357434544665), 0.0, 10835.8242,
    484.18367224048365, 234.79543961231974), 'ATS3pe': (
    'maxwell', (-94.36799590443127, 446.41183631291256), 0.0, 15723.0865, 606.1771118959648, 329.67085888474077),
        'ATS4pe': (
        'logistic', (619.807728236328, 194.60010572305293), 0.0, 17837.1291, 644.7874994556446, 397.11168598179427),
        'ATS5pe': (
        'logistic', (573.1588308915482, 206.63690556027152), 0.0, 19211.7722, 605.9154517457929, 430.3993614569669),
        'ATS6pe': (
        'nakagami', (0.40420140882709626, -5.798467049006497e-27, 738.3017783524449), 0.0, 21389.966099999998,
        558.6128062936119, 458.1307831891324), 'ATS7pe': (
    'skewnorm', (48061568.85623046, -8.779105232093883e-05, 725.1705497999731), 0.0, 24225.1796, 518.1955183353045,
    481.58183040214595), 'ATS8pe': (
    'nakagami', (0.27236002210976973, -5.0961568259718494e-24, 718.3085368708606), 0.0, 26432.1207, 470.88475989269733,
    487.83716771182134), 'ATS0are': (
    'mielke', (2.3180950184998927, 8.182244023351586, -0.8416641160716828, 348.25025439907125), 0.8281000000000001,
    6101.8536, 261.600477960949, 120.30951936967463), 'ATS1are': (
    'vonmises_line', (15.45499390406782, 276.57187745403905, 448.54737005368133), 0.0, 6230.125000000001,
    278.24830574630005, 127.73074510537477), 'ATS2are': (
    'burr', (7.065820210024455, 0.3154962736290945, -2.063441164115537, 630.6742900391663), 0.0, 10688.3283,
    476.037379961992, 231.23495680597085), 'ATS3are': (
    'logistic', (584.9206895756274, 161.3932666822925), 0.0, 15617.374399999997, 596.9832285916502, 325.30800181347865),
        'ATS4are': ('logistic', (611.9863041103995, 196.63898748741263), 0.0, 17728.771999999997, 636.7949582247312,
                    392.6763993288925), 'ATS5are': (
    'gamma', (70.81612692789355, -2477.7752021901197, 43.28166000854094), 0.0, 19111.054599999996, 598.8899585530536,
    425.88735220658407), 'ATS6are': (
    'nakagami', (0.3795124837966761, -8.13549875449516e-25, 782.3879455187239), 0.0, 21252.8497, 551.6961873076885,
    453.196496744923), 'ATS7are': (
    'chi', (0.6293511560572571, -1.871780290678532e-26, 907.5243987730478), 0.0, 24049.3644, 511.7724144880216,
    476.58762166617504), 'ATS8are': (
    'chi', (0.6981424242054542, -2.2080548948096727e-27, 820.6923024081993), 0.0, 26259.543999999994, 465.0659171402208,
    483.06083453273635), 'ATS0p': (
    'mielke', (2.154735293577474, 8.114252810696605, -0.5330152598757248, 89.77303218731461), 0.754861904849,
    12391.295823978944, 67.12179166789238, 59.0940340477086), 'ATS1p': (
    'burr', (8.393844543670046, 0.25250491525624286, -0.03382781790164925, 110.4229042125059), 0.0, 1604.6452335119993,
    80.54088394753, 36.66825653363277), 'ATS2p': (
    'gennorm', (1.3573197790475504, 119.71723953342553, 57.37805500469015), 0.0, 2399.985969503954, 119.05030544667908,
    57.202248936785644), 'ATS3p': (
    'logistic', (133.99231181431352, 38.22387715684497), 0.0, 2922.516695805976, 135.86679062610938, 73.15283725202589),
        'ATS4p': ('vonmises_line', (17.65468417068539, 130.69100373217435, 317.30558959204427), 0.0, 3219.257145267287,
                  131.87146311612116, 81.49611478805265), 'ATS5p': (
    'vonmises_line', (12.729604965321332, 120.14245037443331, 283.9827536977639), 0.0, 3505.869782777395,
    122.29350876811735, 87.3000887873994), 'ATS6p': (
    'chi', (0.7494719233972195, -2.3247038653777303e-30, 186.26988428264121), 0.0, 3950.6508150276677,
    114.14078667165775, 92.44478433741362), 'ATS7p': (
    'chi', (0.8830453140214959, -1.800988751103988e-26, 147.18311754681008), 0.0, 4430.078503671377, 104.98170321509299,
    94.70885327543624), 'ATS8p': (
    'chi', (0.5413409984228921, -3.443803803086479e-27, 146.10712812070562), 0.0, 4786.978715528916, 94.29727072800638,
    94.08384186268442), 'ATS0i': (
    'burr', (7.159614113695866, 0.3298688897081619, -14.702008581367636, 8802.472597790376), 18.84135788396689,
    157839.21770722186, 6784.830674935497, 3169.2711380134383), 'ATS1i': (
    'logistic', (6312.1641352489205, 1501.8659637365708), 0.0, 145608.35709398857, 6381.355956296661,
    2960.5461777436567), 'ATS2i': (
    'maxwell', (-678.4290440602635, 7834.226831800167), 0.0, 264168.0844719297, 11619.253067778529, 5741.78185176186),
        'ATS3i': (
        'ncx2', (108.26761756655247, 8.97960433343568, -39104.85296417297, 465.49847450969855), 0.0, 403330.2591120484,
        15127.244043017192, 8413.197216079889), 'ATS4i': (
    'gamma', (17.403527733523234, -19624.40776837395, 2080.7809210454243), 0.0, 459481.0120823679, 16601.49143007681,
    10335.937519661047), 'ATS5i': (
    'rayleigh', (-2142.6190292564834, 14520.005816531831), 0.0, 480009.0224630408, 15724.50768130554,
    11151.057453510422), 'ATS6i': (
    'foldnorm', (0.034104821672984904, -0.17653875043084014, 19259.335268406852), 0.0, 539924.2621938376,
    14503.652223499304, 11923.885027452634), 'ATS7i': (
    'nakagami', (0.281562165658461, -1.8991613872201947e-23, 19868.47140806826), 0.0, 618472.6232443578,
    13531.506546941888, 12643.06630365178), 'ATS8i': (
    'nakagami', (0.2192228408632842, -6.1855369071466405e-25, 18781.395111388265), 0.0, 675942.317804745,
    12395.776375419735, 12887.591569436992), 'AATS0dv': (
    't', (5.115354015412023, 7.842103695547902, 1.7193651939467047), 0.0, 42.4, 7.928323988989389, 2.2240832785234823),
        'AATS1dv': (
        'burr', (10.189532515537312, 0.48809949251079787, -0.8238175070544473, 8.854971527777092), 0.0, 32.5,
        7.104832697189159, 1.88197749873139), 'AATS2dv': (
    't', (7.262686163848155, 5.86376648814892, 1.778260974757927), 0.0, 49.0, 5.9202134901237775, 2.143070246817987),
        'AATS3dv': ('burr', (6.945075819990272, 0.3012940644344271, 0.15613669834327318, 5.81498757966391), 0.0, 49.0,
                    4.482958670381139, 1.922980263091503), 'AATS4dv': (
    'logistic', (3.7885530888975736, 1.0751919486741928), 0.0, 49.0, 3.8017064082487098, 1.98772892238717), 'AATS5dv': (
    'foldcauchy', (2.863521646951222, -0.009555095582621, 1.2779729656686527), 0.0, 49.0, 3.536530125980979,
    2.111957184195663), 'AATS6dv': (
    'foldcauchy', (2.7419777028858903, -1.1040478245951804e-08, 1.2563991004393378), 0.0, 49.0, 3.358010960844928,
    2.150193780424086), 'AATS7dv': (
    'dweibull', (1.1358874623217794, 3.370166751926905, 1.483998426350923), -0.06862745098039216, 49.0,
    3.3487309958271463, 1.9306370069768166), 'AATS8dv': (
    'logistic', (3.171116919263432, 0.9707950824383553), 0.0, 49.0, 3.2398986705405455, 1.8284694959341041), 'AATS0d': (
    'johnsonsu', (0.315295762099748, 1.6901068800588177, 3.43873254175724, 0.573095389158258), 0.0, 15.333333333333334,
    3.311342043442157, 0.4158048200738249), 'AATS1d': (
    'johnsonsu', (0.13938565047712764, 1.374712852899619, 4.0358276817489305, 0.5169697486020426), 0.0,
    18.652173913043477, 3.9740509808455022, 0.5001135656382799), 'AATS2d': (
    'johnsonsu', (0.4259981771113073, 1.9004304831499619, 3.7756110560980245, 0.7597960530102629), 1.0,
    10.676470588235293, 3.5779686863975244, 0.4703388088973457), 'AATS3d': (
    'burr', (14.563615989864797, 0.2836396808322923, 0.9130646083579506, 2.536214268864331), 1.0, 8.782608695652174,
    3.0202834398058083, 0.48533116756196176), 'AATS4d': (
    'genlogistic', (0.3978849877866111, 3.0200694040508536, 0.19123517440075008), 1.0, 9.735849056603774,
    2.6382537147563876, 0.5453215547534528), 'AATS5d': (
    'foldcauchy', (5.357051397307572, 0.9999999990134643, 0.3095530721132968), 1.0, 14.25, 2.47936796348725,
    0.6412704123986143), 'AATS6d': (
    'foldcauchy', (4.90308643990566, 0.9999999962193842, 0.33696318575491846), 1.0, 8.6, 2.4351385162008117,
    0.6831456391520788), 'AATS7d': (
    't', (2.4544744762698167, 2.590019876633428, 0.3562505365663179), 1.0, 6.0, 2.465512828761491, 0.5846399571635784),
        'AATS8d': (
        'genlogistic', (0.37017528799567945, 2.8102203686607137, 0.16180987454176987), 1.0, 6.25, 2.451784374199811,
        0.5056427451773439), 'AATS0s': (
    'burr', (5.029368473446985, 0.9207569325138143, -0.028260795932042882, 4.903545026998861), 0.8441944416756456,
    54.863811047967424, 5.078495198659662, 2.0420490539590688), 'AATS1s': (
    'burr12', (16.316649506858603, 0.7932839689385951, -1.2020121302307183, 4.258093132162994), 0.33558908702941626,
    42.0, 3.202714592607546, 0.5734141277064322), 'AATS2s': (
    'burr12', (8.69468265834792, 0.6399025267778967, -0.04554963257086299, 2.967441306256716), 0.7933882241866925, 64.0,
    3.36230489002483, 1.1219656933717235), 'AATS3s': (
    'mielke', (4.6021634633270025, 5.862405376544313, 0.8146798656468, 2.4254284666230745), 0.4397805212620028, 64.0,
    3.224374284743717, 0.9903619213445586), 'AATS4s': (
    'mielke', (3.401691131249411, 5.242475896974737, 0.8310368451963992, 2.659804073980822), 0.43447506616230896, 64.0,
    3.3299176644640336, 1.2090367768023953), 'AATS5s': (
    'burr', (5.786544683548253, 0.6330665311460321, 0.3815945021809618, 3.1646082211353175), 0.4156378600823045, 64.0,
    3.3554761627224714, 1.4245945109293492), 'AATS6s': (
    't', (2.7602711943846656, 3.074689965515348, 0.7594255855345109), 0.42009602194787377, 64.0, 3.240544990560175,
    1.634215269084568), 'AATS7s': (
    'johnsonsu', (-0.2868762339149761, 1.2282215801817147, 2.840387324311272, 0.9310409723023984), 0.648148148148148,
    64.0, 3.1915462677518636, 1.3702878347948222), 'AATS8s': (
    'johnsonsu', (-0.5207032349415902, 1.2653517599216955, 2.619264282615036, 0.8731299619024969), 0.882716049382716,
    64.0, 3.1557591670760887, 1.3164035734225161), 'AATS0Z': (
    'mielke', (19.64718048572191, 4.888172571761931, -0.0757210543364015, 18.432317563685302), 8.0, 7744.0,
    28.68033815752204, 25.449597376798618), 'AATS1Z': (
    'mielke', (15.297023379207738, 9.242981956379182, -0.08898710108300417, 24.828984038855914), 6.0, 2809.0,
    27.356146771096157, 8.894637047599145), 'AATS2Z': (
    'mielke', (7.091241023787607, 8.3565348614869, -0.11330906678959071, 23.464318832964032), 1.0, 2339.0,
    23.20727245623397, 7.517107381570173), 'AATS3Z': (
    'logistic', (19.515115010083804, 3.024853369360848), 1.0, 2809.0, 19.793523970645793, 7.218978919953875),
        'AATS4Z': (
        'dweibull', (1.1142216160863903, 17.357914420580947, 4.825719478924822), 1.0, 1429.0, 17.40865800851001,
        7.219335634084673), 'AATS5Z': (
    'dgamma', (1.0554099951416038, 16.79136076246182, 4.917172301592645), 1.0, 1225.0, 16.359909491304705,
    7.670029742749918), 'AATS6Z': (
    'foldcauchy', (4.306494063192247, 0.9999999925414701, 3.621797800013118), 1.0, 640.0, 15.901693919044465,
    7.709594159451598), 'AATS7Z': (
    'johnsonsu', (0.11765708980758252, 1.1699752617400194, 16.904558744401236, 5.3917099543533515), 1.0, 560.0,
    16.186226233376047, 7.311086871794834), 'AATS8Z': (
    'johnsonsu', (-0.07292147422401013, 1.2200734292402677, 15.638457943601347, 5.250369633803025), 1.0, 1225.0,
    16.168317930643962, 7.393970258804873), 'AATS0m': (
    'fisk', (3.2761334524486205, 46.500411564741086, 55.90159206108221), 29.665675399999998, 51076.0, 116.8913697179632,
    148.52651423864438), 'AATS1m': (
    'mielke', (10.962053569927345, 9.194532116586608, -0.5498330948840893, 99.89963471607904), 12.107088,
    16104.744505980902, 104.76215791028521, 44.110224712503516), 'AATS2m': (
    'mielke', (5.965349886278246, 7.4968775751408305, -0.4210347085584688, 89.64283334579909), 1.016064,
    14728.247862053335, 87.50328849794306, 36.620212981698224), 'AATS3m': (
    'logistic', (71.24307970851457, 12.965586162635944), 1.016064, 16104.744505980902, 72.55704229085703,
    33.69325612647139), 'AATS4m': (
    'hypsecant', (61.845741516969966, 16.117656285641285), 1.0160639999999999, 8939.335917632, 62.64547548217618,
    32.40458360823789), 'AATS5m': (
    'foldcauchy', (4.05381997768473, 1.0160639972829735, 14.63090353737314), 1.0160639999999996, 6384.649216000001,
    58.52560355923793, 32.89280189193911), 'AATS6m': (
    'foldcauchy', (4.023644787442645, 1.016063990967216, 14.533760433793535), 1.0160639999999992, 3209.23941,
    56.81303247183024, 31.760954140930668), 'AATS7m': (
    'johnsonsu', (0.09773539320450418, 1.205535850265167, 59.78748818773914, 22.944192541937596), 1.0160639999999996,
    2561.72224, 57.921444233417304, 30.773086476808047), 'AATS8m': (
    'johnsonsu', (-0.14111586764054307, 1.2023268523836546, 54.23564253126884, 20.982303015097603), 1.0160639999999994,
    6384.649216, 57.753561248833684, 32.5542677469955), 'AATS0v': (
    'logistic', (223.29944975842196, 14.853345580154528), 84.14135162861858, 9013.54916058462, 224.13684587486335,
    33.88323266046321), 'AATS1v': (
    'burr12', (18.688606554569894, 1.756341620385952, -0.13150302180131543, 278.19901053701824), 74.1834929458842,
    1810.071568302755, 267.09940606335437, 22.457432370281307), 'AATS2v': (
    'burr12', (10.95767580714864, 2.1788389597335858, 0.21274482193604388, 243.96456718605177), 31.083744430930263,
    844.8018457028126, 223.0848771931695, 29.587346040070692), 'AATS3v': (
    'skewnorm', (-1.9140902951553471, 224.31768923714617, 44.779215751335315), 31.08374443093026, 1057.2272783435521,
    192.5002013722629, 32.07356488672518), 'AATS4v': (
    'genlogistic', (0.41548144176253354, 194.12769939481558, 13.351217598803888), 31.083744430930256, 624.6077732981918,
    168.53104708801393, 37.214475354220724), 'AATS5v': (
    'foldcauchy', (6.493452914156219, 31.08374439202752, 21.650190685762553), 31.083744430930256, 703.4084627293777,
    159.74491617122226, 45.57356300284532), 'AATS6v': (
    'foldcauchy', (6.358349232906802, 31.08374435775383, 22.103048208209565), 31.083744430930256, 683.3175445036558,
    157.00877196177245, 51.219587325067636), 'AATS7v': (
    'johnsonsu', (0.7538079865334864, 1.2682039392478663, 190.52827068733097, 34.15123822035628), 31.083744430930256,
    647.9028929599796, 160.61510594034476, 44.99087228336067), 'AATS8v': (
    'johnsonsu', (0.7585579785292093, 1.5500731680372886, 187.2087076746668, 40.77839694468669), 31.083744430930256,
    703.4084627293777, 161.30244093213375, 38.25310639099637), 'AATS0se': (
    'burr12', (52.54526749897725, 0.5677497905277586, 0.7016030672441411, 6.96753155849061), 0.198025, 14.963407,
    7.827626093671635, 0.3434652705838026), 'AATS1se': (
    'johnsonsu', (-0.5644629460967172, 1.4781549532087173, 7.726698651251532, 0.23912328811999714), 1.5556800000000002,
    12.697650000000001, 7.843855022655005, 0.2220335164876023), 'AATS2se': (
    'johnsonsu', (-0.5444950149865824, 1.5918038814776625, 7.704144883148288, 0.3314161979744376), 6.064239555555555,
    16.0, 7.845666311170176, 0.29161577672435496), 'AATS3se': (
    'johnsonsu', (-0.5222754054757657, 1.6388333103397357, 7.658901692653667, 0.377268297106367), 6.065639999999999,
    16.0, 7.809399032949085, 0.30670551841305044), 'AATS4se': (
    'mielke', (4.03416631646991, 8.023990380980958, 6.646549398549885, 1.289970813320113), 5.4001152, 16.0,
    7.79594300310374, 0.356472216653551), 'AATS5se': (
    'hypsecant', (7.7638114200933215, 0.24443326985081748), 1.4515200000000001, 16.0, 7.766562416336043,
    0.39619816828976595), 'AATS6se': (
    'johnsonsu', (0.11937750781448578, 1.1237191425031379, 7.757520199581264, 0.3368126341707165), 4.732992, 16.0,
    7.710539097321093, 0.4466186326549176), 'AATS7se': (
    't', (3.280131465471293, 7.717862458676416, 0.2690404491503361), 5.725728, 16.0, 7.706310447827774,
    0.41118959749561135), 'AATS8se': (
    'johnsonsu', (-0.15632061629889732, 1.3694234148301008, 7.643310246333439, 0.3871171528254938), 6.526742400000001,
    16.0, 7.700378772748229, 0.38926166542061874), 'AATS0pe': (
    'burr', (7.568153108484051, 0.7902568757714098, 5.010472626894403, 1.392640820949726), 0.6723999999999999,
    14.528400000000001, 6.375401942269964, 0.38104196385553246), 'AATS1pe': (
    'johnsonsu', (-0.45699532897835343, 1.5257143098800525, 6.467667452001777, 0.25803348716232655), 2.4738, 10.8704,
    6.567077289703945, 0.23115145702523707), 'AATS2pe': (
    't', (3.8564974040501716, 6.450253429729273, 0.21932476553719907), 4.64513888888889, 15.8404, 6.469070410863083,
    0.3173282621611944), 'AATS3pe': (
    'johnsonsu', (-0.2717615982303008, 1.6019563403838557, 6.273220258727898, 0.4188268654327126), 4.840000000000001,
    15.8404, 6.363399677063454, 0.33541666024348127), 'AATS4pe': (
    'mielke', (4.552689655952218, 10.410090750969378, 4.746831323090552, 1.7509296418323457), 4.729280000000001,
    15.8404, 6.290935806414173, 0.39941504861710037), 'AATS5pe': (
    'johnsonsu', (0.30899526488266926, 1.4106720697235287, 6.359796117503997, 0.48234218050260025), 2.0460000000000003,
    15.8404, 6.232244022532748, 0.4554024006712298), 'AATS6pe': (
    'johnsonsu', (0.35550888253128893, 1.0942226443226608, 6.344043393667347, 0.35348105843205974), 4.246, 15.8404,
    6.167915466957307, 0.5253119777643122), 'AATS7pe': (
    'johnsonsu', (0.21163190650502822, 1.0910096151617266, 6.278317253165966, 0.3349954130577152), 4.543, 15.8404,
    6.173154097689231, 0.4811096783209596), 'AATS8pe': (
    'johnsonsu', (0.1179403372500284, 1.2477589673087692, 6.2152692525264515, 0.38652990955574285), 4.757866666666667,
    15.8404, 6.170631211882775, 0.43993627244531125), 'AATS0are': (
    'johnsonsu', (-0.5830641943297747, 1.4801267138704892, 6.097525704746259, 0.40720814969656516), 0.8281000000000001,
    15.259085714285716, 6.302958801513289, 0.4002139992696721), 'AATS1are': (
    'johnsonsu', (-0.5421288327912726, 1.448731053266338, 6.299853056457643, 0.2540464623898754), 2.2321, 10.745,
    6.419737533486939, 0.2457687019197727), 'AATS2are': (
    'johnsonsu', (-0.4449673957851311, 1.473799879311396, 6.229733875221653, 0.3454028434549401), 4.371422222222223,
    16.81, 6.3620081433606925, 0.33170078846666384), 'AATS3are': (
    't', (4.3352246061982544, 6.252503137821176, 0.2507344842552636), 4.4408, 16.81, 6.270417718500041,
    0.34445175257070376), 'AATS4are': (
    'mielke', (4.772394925737968, 9.443351227308636, 4.691525858625233, 1.7008319777862075), 4.7330000000000005, 16.81,
    6.2177437342989315, 0.40525515784868493), 'AATS5are': (
    'johnsonsu', (0.12812953131561347, 1.391951004977225, 6.221815357344838, 0.48258674021141845), 2.2220000000000004,
    16.81, 6.167945147282086, 0.4565803803934578), 'AATS6are': (
    'johnsonsu', (0.27302602083664873, 1.0713384904095942, 6.2402152779609255, 0.350985073511809), 3.124,
    16.809999999999995, 6.100903454050574, 0.5217106287387862), 'AATS7are': (
    't', (2.822977636906798, 6.129430080586195, 0.29498983975141646), 3.982, 16.81, 6.1000132462513,
    0.47873627094793286), 'AATS8are': (
    't', (3.470984743942015, 6.087035061085423, 0.2949778106460556), 4.742466666666667, 16.810000000000002,
    6.0933633678107855, 0.4439800249882239), 'AATS0p': (
    'hypsecant', (1.549477062270072, 0.4184240082100459), 0.3774309524245, 1854.1636, 1.6445497808807252,
    4.856792832015227), 'AATS1p': (
    'mielke', (6.1073644987897335, 10.371333448177047, 1.0576773903992054, 0.8441671609516129), 0.37140370100000003,
    128.9885, 1.8442608119441375, 0.3250391996946847), 'AATS2p': (
    'mielke', (7.543672709861445, 11.632190318695809, 0.4670856765140305, 1.1700973099964376), 0.31024900000000005,
    45.282136, 1.5772985588893134, 0.21955488050714536), 'AATS3p': (
    'mielke', (4.510527154055972, 11.482558807585715, 0.5196938608322921, 1.0215253857230011), 0.31024900000000005,
    28.622499999999995, 1.4041951043445164, 0.21645571391440227), 'AATS4p': (
    'genlogistic', (0.5674199906816797, 1.3605927950484782, 0.10028924866686817), 0.31024900000000005,
    11.466563200000001, 1.2551645348252833, 0.2382369168071876), 'AATS5p': (
    'foldcauchy', (5.755563514636746, 0.3714036988987801, 0.15444114493608346), 0.31024900000000005, 16.07637923,
    1.201259647939347, 0.28741299728525554), 'AATS6p': (
    'foldcauchy', (6.537811960813959, 0.37140321995125836, 0.13734948442008538), 0.31024900000000005, 8.41,
    1.1922751856758922, 0.32222383721703324), 'AATS7p': (
    't', (2.369643668454497, 1.2564416643161795, 0.1644699014349983), 0.31024900000000005, 8.844999999999999,
    1.2189011709466255, 0.2852148203870618), 'AATS8p': (
    't', (3.330457390180503, 1.2488117614367544, 0.16457610201850992), 0.310249, 9.302499999999998, 1.2279313597012065,
    0.24477928665196286), 'AATS0i': (
    'johnsonsu', (-0.5080226864067631, 1.4604688635895955, 161.0359154477195, 4.689118062130934), 18.84135788396689,
    275.5219380343, 163.13682518652445, 4.535254636691781), 'AATS1i': (
    'johnsonsu', (-0.7359571087863273, 1.3448596854112465, 144.50029091055956, 3.5007948731519374), 53.70981943576,
    236.92295270039997, 147.15325181020987, 4.189736181855502), 'AATS2i': (
    'johnsonsu', (-0.511779250901355, 1.7483308770489616, 152.48405207890852, 7.4479880954765125), 96.25466426410001,
    303.55395984, 155.0759799035802, 5.3713129626367495), 'AATS3i': (
    'mielke', (80.61077213464037, 47.56526743664648, -0.23647931717807402, 156.17105467424483), 81.5144879124,
    303.55395983999995, 158.61135936796322, 5.334285122677498), 'AATS4i': (
    'burr12', (73.86519866662536, 0.4411532679851401, 0.0901833955039921, 158.77109316320565), 107.32980720010002,
    303.55395983999995, 162.70242927261074, 6.2146027516310385), 'AATS5i': (
    'johnsonsu', (-0.9902078765251177, 1.285313458053459, 158.20633767786694, 5.572339882802916), 69.883432058668,
    303.55395983999995, 164.5798384032591, 7.948681302196176), 'AATS6i': (
    'johnsonsu', (-1.1154097348115544, 1.1630848448692703, 156.87394763062017, 4.893010894514), 103.02493180988999,
    303.55395983999995, 164.677849042722, 9.309188637224587), 'AATS7i': (
    't', (2.237373738503779, 161.87847150653602, 4.2878665625793815), 107.32980720010002, 303.55395983999995,
    163.6978344806714, 8.124236534729809), 'AATS8i': (
    'johnsonsu', (-0.7786897550263137, 1.353476432870064, 158.49997119549553, 5.76244874006324), 116.65682060300001,
    303.55395983999995, 163.13877506104097, 7.0886410701150915), 'ATSC0c': (
    'burr', (4.6638546170762645, 0.40050701303698394, 0.002892450778378601, 1.0878445915471464), 0.0, 53.48813692814022,
    0.8571027027880382, 0.5787917468351356), 'ATSC1c': (
    'pearson3', (-0.6926976093298018, -0.4397202349276497, 0.27500791067506536), -22.065005932119636, 2.347418654183611,
    -0.4419178655891187, 0.34271579748929676), 'ATSC2c': (
    'johnsonsu', (-0.4551924813879624, 1.3376794091728632, -0.07612346272510664, 0.23515449552505413),
    -4.032489053937349, 17.3310273072338, 0.03190172475214784, 0.25798881348439356), 'ATSC3c': (
    'dgamma', (0.9944899916141584, 0.019241275503980734, 0.20886963938962255), -8.958225346025731, 13.713384379695533,
    0.038126247988480966, 0.31375295068734044), 'ATSC4c': (
    'dgamma', (0.9210832832042738, -0.03274180584966533, 0.2474751660152889), -24.405481439902445, 5.355417405308884,
    -0.06026076650802942, 0.3892892566019986), 'ATSC5c': (
    'dweibull', (0.9080951819086678, 6.161230284838296e-32, 0.19805487361409913), -4.9415734151248305,
    8.864997016635531, 0.007509835058703658, 0.31598334046278326), 'ATSC6c': (
    'dgamma', (0.6738185254560876, 6.049342250635525e-32, 0.3269095730189704), -5.801060333495509, 16.856436050756592,
    0.02396599881577325, 0.32737788534477685), 'ATSC7c': (
    'gennorm', (0.43734253650172383, -2.47683783217362e-17, 0.014750981441690991), -25.42419318704026,
    7.069609923504151, -0.01811084983612109, 0.3446977058335895), 'ATSC8c': (
    'gennorm', (0.34314922732941433, 1.1159381133383316e-21, 0.0031853189851789115), -5.916330540998878,
    31.672730093545475, 0.004421948278821126, 0.2577449750552494), 'ATSC0dv': (
    'vonmises_line', (32.35969350874873, 166.84781182234806, 438.2238461632224), 0.0, 4254.7244273723145,
    166.93565957015355, 81.92201156783146), 'ATSC1dv': (
    'skewnorm', (2.7753727061040054, 11.963550958375407, 46.831617249098514), -643.3572084481175, 956.6770370370368,
    45.91403293569881, 31.274943556401457), 'ATSC2dv': (
    'skewnorm', (3.866865263440852, -24.447083900023294, 61.26674104766417), -540.6598816568047, 1626.0126972825444,
    22.71542562490502, 39.74429869849498), 'ATSC3dv': (
    'johnsonsu', (-0.2522538163542452, 1.5110143423641789, -32.33516326145964, 53.39600324241148), -978.8473462099491,
    1543.6961285609937, -21.020265058274916, 45.24637675905271), 'ATSC4dv': (
    'johnsonsu', (0.17986602452187134, 1.3837556508222137, -19.280445123936694, 54.78103619793825), -940.5934914572383,
    1374.482466578967, -28.040583788418182, 51.923930876806615), 'ATSC5dv': (
    'norminvgauss', (0.9789802437731936, -0.3559274581158034, 3.0766474459591806, 53.446197758004246),
    -1203.0241051862672, 1861.2651398283303, -17.320121644164477, 58.537438337822174), 'ATSC6dv': (
    'norminvgauss', (0.739270948317881, -0.3029563076212217, 2.5968552423271563, 45.48027690745512),
    -1524.8991477698673, 950.067323286263, -18.05198653978562, 58.33819136567872), 'ATSC7dv': (
    'gennorm', (0.47630042137573536, -5.259413136049935e-14, 5.6504823602940295), -2409.42761109389, 1441.3595364071557,
    -19.775268478152757, 62.250047039830875), 'ATSC8dv': (
    'gennorm', (0.3044627707444023, 1.7009107764559665e-22, 0.3386171249151897), -1643.6976259891712, 3034.627373241694,
    -18.38980909034251, 59.614167338589596), 'ATSC0d': (
    'burr', (6.2373542206729935, 0.38538266925997844, -0.43479280104611545, 32.75434797236311), 0.0, 631.0422535211268,
    25.570464649347112, 12.385459624510169), 'ATSC1d': (
    'exponweib', (363.5088924810474, 1.3648674302579833, -31.45820098795651, 10.370808018988306), -60.67952249770431,
    159.18932487779102, 9.032444608435588, 5.939244167462605), 'ATSC2d': (
    'johnsonsu', (-0.7608366676105482, 1.6480995006470207, -5.679526528993192, 6.922060344290148), -123.07352648257137,
    113.35250922958328, -1.6387355791633351, 5.703967761066053), 'ATSC3d': (
    'johnsonsu', (0.3080477982093981, 1.506914726771941, -4.690592523766483, 7.532725738507361), -142.3213296398892,
    143.89965397923874, -6.5074229428418695, 6.428621300037205), 'ATSC4d': (
    'johnsonsu', (0.6907247103909567, 1.390372870669579, -0.6132174169228621, 6.33398695541152), -154.39000000000001,
    131.63285613992252, -4.7422649367706775, 6.642294676395334), 'ATSC5d': (
    'norminvgauss', (1.1640212413354853, -0.5512572485117062, 1.4767295876358595, 6.216179019063565),
    -349.4408554243707, 150.73798504805976, -2.0230408767147217, 7.1276218332256525), 'ATSC6d': (
    'johnsonsu', (0.7901926620429625, 1.1222245730070677, 2.005199810723301, 4.275301667961974), -295.48898535437536,
    227.11517041657396, -2.820648637575686, 7.49198964567762), 'ATSC7d': (
    'dgamma', (0.7164465573550989, 6.510733434208263e-30, 5.429523454656836), -444.4041955017301, 156.80133277800917,
    -2.483560057840297, 7.284914896760397), 'ATSC8d': (
    'dgamma', (0.6862126251777583, -2.2873922635903312e-30, 5.953782763748089), -293.2339965397924, 282.36592289612656,
    -2.073466260475056, 6.741979944401412), 'ATSC0s': (
    'mielke', (1.2626017853336404, 4.18815580565831, 0.6572667699052787, 111.3563035376711), 0.0, 3143.425099930676,
    74.91617790940502, 56.11694197617685), 'ATSC1s': (
    'norminvgauss', (1.2052482177950927, -1.045457920817276, -0.008771849605032953, 3.480377330887989),
    -579.5829223775352, 50.05681372931889, -6.008443879662435, 8.512807978934147), 'ATSC2s': (
    'johnsonsu', (-1.1090613842599515, 0.8183433942282738, -2.094672510536356, 4.914367455442278), -237.32098765432102,
    1442.0653599221096, 15.902152333962079, 28.82223214677129), 'ATSC3s': (
    'johnsonsu', (0.22540794905968084, 0.8945011890453147, -0.809564277399052, 8.059569138060153), -921.1679828190452,
    1580.381745108472, -3.6915170054880484, 20.74484853345177), 'ATSC4s': (
    'johnsonsu', (0.3289678783035239, 0.8552796217661749, -2.194694806667563, 11.087900083015882), -1271.3156240277601,
    1269.6305760800446, -9.75694311104474, 28.359579916888947), 'ATSC5s': (
    'johnsonsu', (0.11251118650236572, 0.8069760727308115, -2.910916928517139, 11.094734190121189), -978.1034006979952,
    1455.5973241036936, -5.330749342780286, 31.17958423458691), 'ATSC6s': (
    'cauchy', (-2.479487396809614, 9.239523125592584), -946.9303875948019, 1023.2292622283943, -3.1204605732849107,
    29.50498325284843), 'ATSC7s': (
    'dweibull', (0.7440338043540855, -8.943160305027112e-30, 14.455495822035338), -1131.7637645970617,
    1349.4968261822337, -4.011685894416676, 30.408863739110064), 'ATSC8s': (
    'dweibull', (0.7889895518299177, -1.583069391339582e-29, 13.394289229433753), -1301.345647492536,
    1391.1543167450716, -3.5309183016141996, 30.14361428093124), 'ATSC0Z': (
    'hypsecant', (395.82332013894916, 166.90103526929002), 0.0, 16805.559523809527, 438.7908086530401,
    342.794329011551), 'ATSC1Z': (
    'norminvgauss', (0.3138002433653184, 0.2482487918314274, 9.51216656508715, 14.14925512175089), -5400.0,
    7656.976218787158, 27.583322437435225, 57.61371990532117), 'ATSC2Z': (
    'johnsonsu', (-0.8264835846560417, 1.4780023667681195, -12.902670492800006, 75.63690054649564), -4102.960849645981,
    10353.913265306124, 42.782730586257664, 83.80787944660969), 'ATSC3Z': (
    'johnsonsu', (0.19327554595306062, 1.3736450442501846, -30.007130956876804, 103.54684120902236), -8911.425000000003,
    14058.446280991737, -49.47662400562919, 116.62140174799998), 'ATSC4Z': (
    'johnsonsu', (0.0784200322621462, 1.1729182108597873, -44.070378511973225, 104.63561608369774), -7774.848989298453,
    14527.425557655952, -53.36101846175824, 155.7032594952716), 'ATSC5Z': (
    'norminvgauss', (0.7012231032445938, -0.1692928296208704, 0.43003883511241364, 105.19044947319483),
    -13208.326530612245, 3151.6023495906015, -24.11895326130842, 142.24962065400373), 'ATSC6Z': (
    'norminvgauss', (0.5162006827792014, -0.1556186014203552, 1.4896791525463753, 92.70846832674542),
    -15464.702097505671, 6221.607500000003, -28.80812334807975, 143.07824284195706), 'ATSC7Z': (
    'dgamma', (0.8390118875894987, 6.672974479257369e-30, 105.40075335765479), -9229.462809917355, 8640.730807379488,
    -34.16108291000728, 148.41669311157693), 'ATSC8Z': (
    'dweibull', (0.7455464492101949, 9.429650884083748e-30, 70.48499698680095), -10271.059451762194, 5475.234304791295,
    -30.541412708453997, 140.05287827182627), 'ATSC0m': (
    'hypsecant', (1854.2047665019193, 786.0439531877344), 0.0, 106696.0584628235, 2089.764859984444,
    1854.2975863215536), 'ATSC1m': (
    'johnsonsu', (-0.6501347132873454, 0.7895481115006279, 27.745480475427378, 49.244699374598284), -35752.147916121605,
    45562.76473053402, 123.77249039493195, 282.9420023352428), 'ATSC2m': (
    'johnsonsu', (-1.0415384439596593, 1.6656432870524953, -111.28723804530969, 393.8565759208217), -25156.79288731071,
    64241.76653537416, 200.99476117871654, 407.81885934416243), 'ATSC3m': (
    'johnsonsu', (0.2108315183330872, 1.3147780388785342, -138.20928880843823, 461.259715189215), -52045.77772114707,
    88411.30320351897, -235.95342369819807, 580.5082588017867), 'ATSC4m': (
    'johnsonsu', (0.0835634654004224, 1.144564159050077, -205.63457352074198, 484.1547079912355), -48028.32539198313,
    84129.73030993738, -249.74331574696444, 782.5851404845101), 'ATSC5m': (
    'johnsonsu', (0.2646740416885127, 1.2549202629987666, 32.21439745194522, 538.6214784056781), -72286.24577708813,
    15898.83650306569, -110.12612750742295, 691.3873924532083), 'ATSC6m': (
    'dweibull', (0.9846836576379843, -46.41099513572034, 425.9601201277353), -90493.04782885264, 32768.617152322346,
    -133.69580847853695, 699.2903729294289), 'ATSC7m': (
    'cauchy', (-56.73948597972867, 256.1606617187425), -56105.628583336016, 50872.48491113301, -158.76100423707956,
    721.5710435324879), 'ATSC8m': (
    'dweibull', (0.7142098652647779, 2.5666942629766685e-29, 376.18167867684133), -58178.18040855736, 33094.1805432953,
    -142.66894203646206, 678.2951491999744), 'ATSC0v': (
    'burr', (7.496786225504543, 0.29032191501470606, -16.823715691075392, 2806.246394031414), 0.0, 59190.12964935933,
    2069.041781376725, 978.9776162368992), 'ATSC1v': (
    'genlogistic', (0.9900797031832115, 9.481333353187722, 51.22384063350165), -4201.487806524559, 4606.075909639292,
    9.644102817761514, 98.21321999742776), 'ATSC2v': (
    'johnsonsu', (-1.0029039864770501, 1.7859859002435776, -261.67419996199294, 532.2425341416116), -11136.52973713683,
    12568.104855841197, 104.88317224040591, 420.8189386944239), 'ATSC3v': (
    'johnsonsu', (0.20019959367677506, 1.4808239329936526, -253.24107872398295, 558.1552322272546), -16219.485306802053,
    9204.16092237672, -345.5858750709527, 488.4667587447693), 'ATSC4v': (
    'hypsecant', (-304.11428797174494, 364.5731436541961), -14618.982467067646, 17608.11548504139, -304.8275386354516,
    600.8851242147201), 'ATSC5v': (
    'johnsonsu', (0.2774245595582333, 1.5567654495127945, 117.87217824480922, 682.9030089851633), -15812.616383668825,
    10055.337930604766, -39.92408797880359, 560.4300221796445), 'ATSC6v': (
    'johnsonsu', (0.35756399388542814, 1.2212292204880066, 77.38042498899294, 506.86128703702093), -18106.81915109094,
    17132.091361919433, -125.83028319202221, 606.9346161079986), 'ATSC7v': (
    'dgamma', (0.797452031324831, 1.1308587398948956e-28, 455.5496043596953), -16062.120360286372, 12732.685944892773,
    -128.7105087725698, 576.6076054152842), 'ATSC8v': (
    'gennorm', (0.31469247263602895, -5.2113465983300836e-21, 4.645999950885331), -31650.727160756178,
    20529.761619234538, -110.35561440130387, 580.2446171558934), 'ATSC0se': (
    'kstwobign', (-2.9962325363015996, 7.592986255681626), 0.0, 210.46825020998713, 3.608224305859557,
    2.268142532367232), 'ATSC1se': (
    'norminvgauss', (0.27156311817814005, 0.006821664102663024, -0.07360362975525055, 0.19789550835981207),
    -36.56435559479303, 5.8931061299458545, -0.06683191558298097, 0.40299566234046125), 'ATSC2se': (
    'johnsonsu', (-0.8688998117224263, 1.2701693160378857, -0.21112498462333762, 0.8290716219744576),
    -19.11269864512159, 56.22694518583124, 0.651221373546099, 1.2622667175604754), 'ATSC3se': (
    'johnsonsu', (0.046400519931160344, 1.169149398081811, -0.2630708633081834, 0.7285221598733146),
    -32.239514239943055, 53.3832890693937, -0.2821057534436336, 0.9874665853614225), 'ATSC4se': (
    'johnsonsu', (0.26825958861987964, 1.0266042138607812, -0.21158436668217515, 0.8145768724483817),
    -57.16095343339639, 58.63546575866691, -0.5586863985083352, 1.3983260153205386), 'ATSC5se': (
    'gennorm', (0.8742610230262358, -0.18778228640018793, 0.7169040969474507), -43.50112061943025, 60.962042963688134,
    -0.24948180737999817, 1.3683062606082534), 'ATSC6se': (
    'gennorm', (0.78829556216393, -0.08680789607198079, 0.5736241957128996), -38.69394849632438, 36.10221478904177,
    -0.12305145870060387, 1.356890431178516), 'ATSC7se': (
    'dgamma', (0.672975418851667, -8.634893678041324e-32, 1.0517594022484529), -57.01984059365974, 59.189534211020415,
    -0.23386721840583452, 1.435711254719874), 'ATSC8se': (
    'gennorm', (0.15404941805571642, -1.268136721063887e-21, 1.2487127482553128e-06), -46.280653, 120.56451013020202,
    -0.19544734733736824, 1.3369905454516067), 'ATSC0pe': (
    'beta', (3.925227954372093, 1145832192576.4578, -0.14209701294377042, 1590723727230.6433), 0.0, 202.42118617157485,
    5.368351883536888, 3.1213545903014293), 'ATSC1pe': (
    'johnsonsu', (0.10272248895771129, 1.0256554031232032, 0.06186036092778427, 0.2775350575940076), -42.24562249448222,
    5.391451020408171, 0.00605990405386468, 0.5080671978327981), 'ATSC2pe': (
    'burr12', (50.06051247611637, 0.3564083528087779, -23.45169438009709, 23.308243634623178), -23.48087555029582,
    68.16384916340334, 0.9949013496705927, 1.7597781195809066), 'ATSC3pe': (
    'johnsonsu', (0.030573949471136886, 1.2605578488786449, -0.3870030781627587, 1.2154031352746344), -44.5660000000001,
    78.3328262965668, -0.4084387063671641, 1.424435059098795), 'ATSC4pe': (
    'johnsonsu', (0.2036620277913842, 1.2930512980080953, -0.4444816670019294, 1.7343064061065065), -72.89357832729738,
    80.3595953775868, -0.7801379268893747, 1.9915491234650775), 'ATSC5pe': (
    'norminvgauss', (0.5596352060564571, -0.07140698641920265, -0.2071986023828287, 1.4791896477147537),
    -63.00253060628197, 77.3167027767889, -0.4139521423268067, 2.0260194370915365), 'ATSC6pe': (
    'gennorm', (0.8417271295222606, -0.0679647858363592, 0.9985815766961701), -74.51999999999971, 51.19553484000002,
    -0.2520648624253419, 1.9961808612662648), 'ATSC7pe': (
    'dweibull', (0.7855307780786145, 1.2765176556571884e-31, 1.1631741288985458), -86.6936717128027, 87.19741155102037,
    -0.41228504803341637, 2.14448846880306), 'ATSC8pe': (
    'dgamma', (0.5869875976981296, 5.705345778888514e-32, 1.7711325810403782), -69.33985299999999, 128.21505081488826,
    -0.36244924885396623, 2.0096738628604545), 'ATSC0are': (
    'burr', (4.477262682446597, 0.4309687787446309, 0.17863429099357167, 6.903911697370343), 0.0, 215.92603405889884,
    5.7263246960744105, 3.48292071663405), 'ATSC1are': (
    'johnsonsu', (0.0753170322621736, 1.0060004681697656, -0.047452611625782855, 0.31243698388407315),
    -52.691346569974336, 5.525765816326528, -0.08867112887910229, 0.6081418569070675), 'ATSC2are': (
    'burr12', (17.298503550910784, 0.4337440954486311, -9.251220955436349, 9.207437923629938), -26.013826955949998,
    82.01092146671417, 1.1076795314846986, 2.0459979466953997), 'ATSC3are': (
    't', (3.2608717548905872, -0.41777388736778676, 0.9723591679082576), -61.82088950768548, 92.36372242512776,
    -0.41269699151930156, 1.5724828034218075), 'ATSC4are': (
    'johnsonsu', (0.24752914739675097, 1.1478100087165017, -0.40674310490325705, 1.5920395191162457),
    -87.36382281213209, 99.95568857833936, -0.8420625837678591, 2.1945217581441168), 'ATSC5are': (
    'norminvgauss', (0.4489867760633621, -0.0459942795649675, -0.3076307333225557, 1.4247194376140901),
    -70.10864660336014, 86.4498524741902, -0.44111943942848664, 2.185300058354626), 'ATSC6are': (
    'dweibull', (0.932110951406014, -0.11403550295857935, 1.379739669665916), -77.37189685898858, 60.21916256,
    -0.2557786319177532, 2.1789346029619123), 'ATSC7are': (
    'dgamma', (0.7388143429148397, -2.3389391266047903e-31, 1.9942333049992027), -90.68263124999984, 102.81886297959173,
    -0.4240910424402175, 2.322144450597847), 'ATSC8are': (
    'dweibull', (0.8210252563534528, -2.2318555269200432e-30, 1.220042460951047), -81.12210467999995, 142.3418302652137,
    -0.3679357606101047, 2.161853198471051), 'ATSC0p': (
    'logistic', (10.717589900770726, 4.1687917132075505), 0.0, 10088.155361932211, 12.67122752578811, 44.4089717853203),
        'ATSC1p': ('genlogistic', (0.6780695764809266, -0.05594674177196719, 0.4820715989894784), -625.6668444444446,
                   472.3304822727729, -0.36569973534388167, 2.688242255559501), 'ATSC2p': (
    'loggamma', (1197.6196846467792, -667.3680780762575, 94.22972143671291), -193.91068900000005, 1117.9959180495869,
    0.5830008797861936, 4.760268745417661), 'ATSC3p': (
    'johnsonsu', (0.2316541132636035, 1.327923648413948, -1.198074028435777, 2.6760462358768553), -311.99921415958505,
    977.9346886257886, -1.751802121276721, 4.87490732323444), 'ATSC4p': (
    'johnsonsu', (0.08435929160289161, 1.2180340990199798, -1.2994854091896932, 2.787742162273918), -331.80412514836325,
    1248.88795400915, -1.468716179614286, 5.830745699259232), 'ATSC5p': (
    'hypsecant', (0.042987811290332106, 1.9123570918187363), -429.77697529930435, 1529.0048100080014,
    0.04367051986524838, 5.832278024576029), 'ATSC6p': (
    'johnsonsu', (0.3342289788036116, 1.042128854621005, 0.39673658581885585, 2.027567224339731), -312.3303951289188,
    1437.7799430170303, -0.5117076198581096, 5.4806684149103235), 'ATSC7p': (
    'dweibull', (0.8617921071802762, -2.773917068292325e-31, 1.8524086768364971), -215.41929464408906,
    1518.1153123918039, -0.4716183299714707, 5.147065832940977), 'ATSC8p': (
    'johnsonsu', (0.16118550294373019, 0.8215442272317333, 0.033219616565207014, 1.2274325954891507),
    -234.68365005214156, 1563.1135528002537, -0.3577113415541398, 5.102431534415226), 'ATSC0i': (
    'mielke', (2.084750342323958, 6.166277531077719, 0.5799363470944424, 87.91792196023184), 0.0, 2330.912791310304,
    67.13741865333162, 33.40604361515584), 'ATSC1i': (
    'johnsonsu', (1.0859615754351808, 2.083130263151763, 2.619088018832019, 16.589385296855752), -504.0391752470749,
    125.87485032951972, -7.462059895669059, 10.300309399411658), 'ATSC2i': (
    'johnsonsu', (-0.5740052780109157, 1.1720290469461712, -7.924215460610079, 13.026892083575152), -518.6853647529304,
    459.64202638954583, 1.7679999056112097, 19.06524600139939), 'ATSC3i': (
    'johnsonsu', (0.182028857964924, 1.684405566902651, -7.700074544046967, 25.0154509499276), -948.0590398926297,
    429.77363537990806, -10.895474215058723, 18.437708381603965), 'ATSC4i': (
    'johnsonsu', (0.20446123476280254, 1.5322617836404817, -5.724882329041245, 22.40897967377196), -506.1875694620007,
    1445.1809651544577, -9.6019566158777, 19.23406629687865), 'ATSC5i': (
    'dgamma', (1.0736276998008507, 0.8720466431482421, 12.572727101108704), -1476.9285332077536, 416.02060257872745,
    0.7829584199932873, 18.961315204868114), 'ATSC6i': (
    'gennorm', (0.8446448245302726, -5.197338951162204e-09, 9.99132793826868), -446.3087200274448, 734.280962151874,
    -1.7580156181813391, 20.19689385654327), 'ATSC7i': (
    'dweibull', (0.7491760109297689, 7.469554456248279e-31, 10.4264207507584), -795.388314215538, 641.7151503194891,
    -1.8783330067018542, 17.811287912817786), 'ATSC8i': (
    'dweibull', (0.8438912638182838, -1.5446595893166663e-30, 8.78493067467955), -761.1405368759528, 715.8503040979942,
    -1.205811703866889, 17.32400869321102), 'AATSC0c': (
    'burr12', (5.256947352551604, 0.9824398489233541, -0.005738154117976506, 0.025268046729746647), 0.0, 6.0,
    0.021233731272377997, 0.0157953119874861), 'AATSC1c': (
    'crystalball', (0.9249785894180953, 9.491828468289231, -0.00875010975590199, 0.0040370602058647405),
    -0.28160725542848075, 0.31118947560417665, -0.01042169486641687, 0.006586619285167999), 'AATSC2c': (
    'johnsonsu', (-0.33140505492501077, 1.1898933882041265, -0.0008185092167375298, 0.0030629725416827912),
    -0.10966484547360623, 0.4255003178584717, 0.000442127524135446, 0.00448537500997234), 'AATSC3c': (
    'laplace', (0.00030225084317059335, 0.002524515833311508), -0.166102174915721, 0.3562199631386807,
    0.000310441749360075, 0.004052715585377047), 'AATSC4c': (
    'norminvgauss', (0.32384322915882374, 0.03543558241018614, -0.0006179111705668318, 0.002223206179923029),
    -0.1873554103566025, 0.403158125422087, -0.0004500174092781679, 0.004278332044836251), 'AATSC5c': (
    'norminvgauss', (0.2677529841848201, -0.013917158764223107, -5.097313350038192e-05, 0.002244064454090112),
    -0.19002830985463876, 0.3040214639480637, -9.743569936029701e-05, 0.004969622848972713), 'AATSC6c': (
    't', (2.045107766329557, 0.0001702735138885795, 0.0022816472319735033), -0.2639986549997197, 0.4030226685152452,
    0.00021243477150314455, 0.006470928138716423), 'AATSC7c': (
    't', (2.0065586347121758, -5.350800802079675e-05, 0.0020987094567360047), -0.19118064956674807, 0.2106408538019425,
    8.41203617287139e-05, 0.006132745187559098), 'AATSC8c': (
    'norminvgauss', (0.17461198483970006, 0.020950216975191484, -0.00012109413188504163, 0.0018026087493544743),
    -0.18970490383874516, 0.2026782969967993, 0.00011526654034688173, 0.005057389282543672), 'AATSC0dv': (
    'hypsecant', (4.007320564177982, 0.4436272311366277), 0.0, 15.076872427983536, 4.005493304160864,
    0.7015147211443948), 'AATSC1dv': (
    'norminvgauss', (7.631002771121249, -2.4463371466080384, 1.4824094631494713, 1.3147212202145129),
    -11.19511659807956, 6.349206349206349, 1.0350847006199755, 0.5162453429809362), 'AATSC2dv': (
    'burr12', (13.91708604348582, 1.3442908446890307, -4.348157216432036, 4.697370806310396), -6.222222222222222,
    12.760000000000002, 0.23679434287228138, 0.5494443168232928), 'AATSC3dv': (
    'johnsonsu', (0.2945534894288946, 1.5989474232173047, -0.1623298084633732, 0.7015144160648632), -11.820246913580247,
    11.600476190476188, -0.3200395191734802, 0.558358834536629), 'AATSC4dv': (
    'johnsonsu', (0.4323497241677201, 1.3887774922200906, -0.0973163104489114, 0.6156322868801241), -12.246913580246913,
    15.19435419825283, -0.3618701818534364, 0.6455329960133276), 'AATSC5dv': (
    'johnsonsu', (0.2910372129190507, 1.1450750967714023, -0.0007965524286099434, 0.605210566890701), -12.25,
    14.731763114896616, -0.22441488865476408, 0.9086478264584646), 'AATSC6dv': (
    't', (1.795202791131519, -0.16823379004844802, 0.5124807489294567), -12.25, 20.59763313609467, -0.12759553833364926,
    1.300797924406534), 'AATSC7dv': (
    't', (2.253569638772542, -0.21943621665212526, 0.565083914955271), -12.25, 18.646694214876035, -0.16863147976434573,
    1.1972748436580942), 'AATSC8dv': (
    't', (2.710146947190466, -0.23842932273001066, 0.579191124293708), -12.25, 17.82716049382716, -0.2214023195859657,
    1.055079676386861), 'AATSC0d': (
    'johnsonsu', (-0.4029175335576929, 1.2953346450373515, 0.5720145416531319, 0.10438600504111673), 0.0,
    4.222222222222221, 0.6167413128239195, 0.11805767437871909), 'AATSC1d': (
    'johnsonsu', (-0.7927225774409961, 1.7649729139344634, 0.1301931301260723, 0.13950460591573086),
    -3.0612244897959173, 1.730846549028367, 0.2066528328375836, 0.10393955439731101), 'AATSC2d': (
    't', (3.9625337650802726, -0.03309581052276793, 0.06777319568992454), -1.212244897959184, 0.7307692307692307,
    -0.039196056111847774, 0.0931261358287808), 'AATSC3d': (
    'crystalball', (0.9343861043788535, 5.9478713609061025, -0.06147939308130319, 0.05670249937067195),
    -1.728395061728395, 1.9285714285714286, -0.08970768283409582, 0.0982955300322628), 'AATSC4d': (
    'johnsonsu', (0.3887432092420646, 1.3352604298941677, -0.025623419947480304, 0.07258900595675558),
    -1.7600000000000005, 2.4693877551020416, -0.052078368353612514, 0.07611053034346506), 'AATSC5d': (
    't', (1.8828862580834231, -0.013996944695916629, 0.054345151148010896), -1.822485207100592, 3.0625,
    0.0015033288298435107, 0.12648452960726453), 'AATSC6d': (
    't', (1.5556214239759516, -0.021423409107397054, 0.05751064475102205), -1.728395061728395, 1.90702947845805,
    0.009963803388284651, 0.14651284407062318), 'AATSC7d': (
    't', (2.154022480707824, -0.021312891450999724, 0.0604658346651418), -1.8450413223140494, 1.6530612244897955,
    -0.006421025609692935, 0.11726403465833873), 'AATSC8d': (
    't', (2.749680575396982, -0.02413949393066679, 0.06078026026795222), -1.9054820415879015, 5.4444444444444455,
    -0.01538592594433876, 0.1048097430709935), 'AATSC0s': (
    'mielke', (1.740169411936277, 4.582392613807045, -0.0023735654435862704, 2.444354202095348), 0.0,
    11.698532878943759, 1.8309510806831277, 1.0573869195450125), 'AATSC1s': (
    'johnsonsu', (0.9892861712001457, 0.9358190995764888, 0.0008137409048089398, 0.06929377953981403),
    -11.069996951684196, 1.5636463735821111, -0.14672841373472412, 0.21826212811193965), 'AATSC2s': (
    'johnsonsu', (-0.7032980926602135, 0.7622287777958098, 0.0058453389128037304, 0.08229993642435736),
    -6.496918292451521, 9.90549452827313, 0.19750488562015445, 0.3891805447555309), 'AATSC3s': (
    'johnsonsu', (0.2199632261866008, 0.8600686624386021, -0.009179722358986307, 0.09200216529037736),
    -11.825068870523417, 6.271939351141629, -0.0525490944309884, 0.26115738190359084), 'AATSC4s': (
    'johnsonsu', (0.281895940230186, 0.8839841122686957, -0.03763752116092031, 0.135919710532601), -12.24670438957476,
    17.92503107853224, -0.10975179448408612, 0.35119214421940165), 'AATSC5s': (
    'johnsonsu', (0.20008933574893487, 0.761832294550876, -0.020929694179962023, 0.13370837088517146),
    -12.23962620027435, 23.68444444444445, -0.10671004804710177, 0.5556794959372641), 'AATSC6s': (
    't', (1.421155528409191, -0.03778446944409718, 0.16887487555544733), -12.171430211202939, 28.239686061801443,
    -0.0779918437701472, 0.7518675790975047), 'AATSC7s': (
    'johnsonsu', (0.020630422365000064, 0.7333046846642743, -0.04746064247546448, 0.146194659624426),
    -12.15701988674897, 26.39952839279439, -0.06783854252227871, 0.633154093101189), 'AATSC8s': (
    'johnsonsu', (0.055288227068134105, 0.7446215794073507, -0.04420224107381181, 0.13643528644608915),
    -11.948332759412304, 25.217863894139892, -0.07065973296025758, 0.586330273206157), 'AATSC0Z': (
    'fisk', (3.269408241960218, 3.7231643038402282, 5.134996999182714), 0.0, 1944.0, 10.681911957121926,
    10.393256352500384), 'AATSC1Z': (
    't', (1.3112896094377269, 0.3639618877383749, 0.2833378596283911), -1458.0, 221.75999999999996, 0.5279100004328541,
    4.700083430854676), 'AATSC2Z': (
    'johnsonsu', (-0.14325878495399125, 1.298490351541649, 0.344336430959831, 1.027209405300243), -466.3333333333333,
    1275.0, 0.5084196950393185, 2.8575944270221063), 'AATSC3Z': (
    'recipinvgauss', (0.0007955743394406458, -66.8031049916465, 0.052679096625871266), -1350.0, 245.44444444444437,
    -0.6762024918365608, 2.3828339402131795), 'AATSC4Z': (
    'johnsonsu', (0.1540465219919117, 1.1349000115272487, -0.4459902373158753, 1.1925357516100927), -287.7654320987654,
    912.25, -0.6696291214696238, 2.5632542839948718), 'AATSC5Z': (
    'johnsonsu', (0.1621839711808724, 0.9660279255740639, -0.02170608898289998, 1.0824142051320291), -1045.25,
    405.6666666666667, -0.3016697680237475, 2.8855661662677137), 'AATSC6Z': (
    't', (1.6822944750336197, -0.2873149384504453, 1.0920121376092027), -551.5917159763313, 342.25,
    -0.10410460025418668, 3.7586126852059363), 'AATSC7Z': (
    't', (1.7991658634329974, -0.3583305907989, 1.185468416374858), -319.734375, 203.77162629757785,
    -0.24091636183327736, 3.4294949337850653), 'AATSC8Z': (
    't', (2.0363804437674653, -0.3717390925091111, 1.1953584097883634), -368.8282548476454, 875.4636678200691,
    -0.37666606258284163, 3.8449985193444784), 'AATSC0m': (
    'exponweib', (1215.9442842754493, 0.5160719684042661, -3.40940464131182, 0.9538921663314275), 0.0,
    13254.112800240002, 51.05765449630826, 62.013187989093325), 'AATSC1m': (
    't', (1.3344716345552659, 1.7064970386457374, 1.2726511035929462), -9447.809080888888, 1463.8917504400004,
    2.324084840370968, 30.349764898286406), 'AATSC2m': (
    'loggamma', (17.51179856639525, -190.65103809281794, 67.64776340973918), -3035.7110340483773, 8441.479369084269,
    2.3972360743161008, 17.67029056962143), 'AATSC3m': (
    'johnsonsu', (0.4112544321122415, 1.2519168803103753, -0.9059237668542159, 5.216684284375756), -8938.036979030401,
    1466.7232720712116, -3.2403706895656446, 14.22476553343283), 'AATSC4m': (
    'johnsonsu', (0.1288804116887666, 1.1850186428623428, -2.2705093577940394, 5.796514816204223), -1544.8315717499997,
    6042.424250678499, -3.142302912578226, 14.572080999571453), 'AATSC5m': (
    'logistic', (-1.0682696006202894, 4.852558801489803), -6934.4922736675, 2279.6490938245647, -1.3745928104309706,
    15.47983681429849), 'AATSC6m': (
    't', (1.6667841585509566, -1.172785712507455, 5.110966804709873), -3299.403721702423, 2279.7616849224996,
    -0.4357867770282183, 19.186869242992554), 'AATSC7m': (
    't', (1.814853951678097, -1.736919783336158, 5.365031231949784), -1786.9907743222402, 1044.118810273813,
    -1.0863921052535306, 16.937537445461), 'AATSC8m': (
    't', (2.0025521071946795, -1.8429224557744233, 5.680522187085169), -2103.5156819637687, 4749.001568999999,
    -1.7560572597035355, 19.386541029001567), 'AATSC0v': (
    'burr', (36.151482371998, 0.47170933635910406, -1.2630620827188688, 52.40898438001909), 0.0, 1251.8019546940889,
    49.294693296662906, 6.60679652371829), 'AATSC1v': (
    'johnsonsu', (-0.07584233720482982, 1.3335424536247489, 0.10528952563303515, 2.57258324963912), -752.2033097240824,
    319.45435394214053, 0.2453964691310354, 3.055565229816657), 'AATSC2v': (
    'exponnorm', (0.6245892093661568, -1.9784754712371295, 4.777641114464404), -99.85121606374331, 443.2618751170735,
    0.8972491712980756, 5.784523713288644), 'AATSC3v': (
    'norminvgauss', (1.1547999800777191, -0.37366555522350897, -2.481358849750689, 6.249668434130351),
    -120.88804148439226, 496.30648985042325, -4.613993613316858, 6.257964682122457), 'AATSC4v': (
    't', (4.59442425962078, -3.6378278083857047, 5.042228643815796), -108.95322184462877, 317.61334315227185,
    -3.6920074009086834, 6.681401976279205), 'AATSC5v': (
    't', (2.3318145307048272, -0.10353658555808226, 4.966200533525607), -369.76512704645967, 234.29973031540223,
    0.17195626750074394, 9.51936950018785), 'AATSC6v': (
    't', (1.6482085381017573, -1.261069570586328, 5.301647406847836), -241.30403617766316, 231.26734335897885,
    1.262876900638136, 13.628111982252316), 'AATSC7v': (
    't', (1.8857604477099732, -1.397460806476718, 5.15136810652182), -169.91754618598011, 185.17562355111826,
    0.3928826556247801, 12.56903079207939), 'AATSC8v': (
    't', (2.410542931810047, -1.4837901169224004, 5.424520340544975), -175.85659064299213, 254.8544265949064,
    -0.5006135185025241, 10.911507780823248), 'AATSC0se': (
    'mielke', (4.09320441098828, 6.338651963225857, -0.021528634836906636, 0.1168513781803611), 0.0, 2.772225,
    0.08810557894053019, 0.04039660316135565), 'AATSC1se': (
    'johnsonsu', (0.09309779916706032, 0.9249837334193594, -0.001056188973086474, 0.004898857059319556), -2.772225,
    0.9949919999999997, -0.0024352883082704516, 0.012748469007643842), 'AATSC2se': (
    'johnsonsu', (-0.37779613093108166, 1.2022921896588414, 0.0019429576563457036, 0.01262814827975022),
    -0.1894830702947846, 2.0829705625, 0.007884953355205945, 0.018367379519677804), 'AATSC3se': (
    'johnsonsu', (0.09060166632000524, 1.0670749416752567, -0.002655282548857229, 0.007597961616769134), -0.991408,
    1.2834624100000005, -0.003693554312029733, 0.012907717664904414), 'AATSC4se': (
    'johnsonsu', (0.21444872830339923, 1.0772131573476111, -0.003026173107383046, 0.010188039221450713),
    -0.7959968320987655, 1.2706492071005917, -0.006225049214826779, 0.01643543200830351), 'AATSC5se': (
    'johnsonsu', (0.1752035683063557, 0.9631190370601284, -0.001374566390881681, 0.01010697720425647),
    -0.49553855999999996, 0.8918913600000007, -0.00441480600835476, 0.021898841305221326), 'AATSC6se': (
    't', (1.8709809824169334, -0.0015510761538032678, 0.01045549435637573), -0.5147085153061225, 0.9085510170454546,
    -0.00220723121242429, 0.027232365427440074), 'AATSC7se': (
    'johnsonsu', (-0.013108710440155574, 0.918797305410394, -0.0029376375684114515, 0.010972801473441093),
    -0.4888215306122448, 1.1113358900000005, -0.002791422653252645, 0.024356356890438524), 'AATSC8se': (
    'johnsonsu', (0.007847261925363967, 0.9457698832480872, -0.003033632043363519, 0.010667660608184552),
    -0.48427882086167795, 0.8796681337890618, -0.0032515006921789006, 0.023782967502331973), 'AATSC0pe': (
    'burr', (6.673229155595548, 0.9912558923566296, -0.026555024750568045, 0.15091178968677668), 0.0, 2.25,
    0.13054439162831946, 0.04725909762073698), 'AATSC1pe': (
    'johnsonsu', (0.2652624638793904, 0.9114131068366845, 0.0024702265781920796, 0.005945842329475095), -2.25,
    0.6044999999999997, -0.0009318084899133328, 0.014771252970918533), 'AATSC2pe': (
    't', (2.802883225789728, 0.009775369958416118, 0.013921734188469377), -0.22721111111111114, 1.3630562499999999,
    0.01219402413305497, 0.02468066666355278), 'AATSC3pe': (
    'johnsonsu', (0.2131183102928265, 1.13709766584961, -0.0022921579369461825, 0.012749674085935438), -0.803736,
    0.9350890000000002, -0.005841162124797947, 0.018501370261292407), 'AATSC4pe': (
    'johnsonsu', (0.2377852044778602, 1.1725490226300392, -0.004387333156895103, 0.017386560083670132),
    -0.791577551020408, 0.9304828402366865, -0.009372422844754388, 0.02423814744572501), 'AATSC5pe': (
    'johnsonsu', (0.20906078636374528, 0.9484388123634298, -0.0006120963413914211, 0.01533953966607616),
    -0.7920888888888887, 1.2454560000000003, -0.006816657745612179, 0.03406335259574024), 'AATSC6pe': (
    'johnsonsu', (-0.05700728659932908, 0.819932550918165, -0.003799884699895159, 0.014903162310253102),
    -0.7920471074380164, 1.0200999999999996, -0.0028448431895922313, 0.04443886550297005), 'AATSC7pe': (
    'norminvgauss', (0.22953123080963697, 0.012714949218763417, -0.004833361039180455, 0.0179727724869634),
    -0.7907902494331065, 1.3159622499999992, -0.003976112395432448, 0.03976854614309135), 'AATSC8pe': (
    'johnsonsu', (0.012931695850669125, 0.9783323691525635, -0.004429229960826349, 0.018376078724716888),
    -0.7873324263038547, 1.3053062499999994, -0.005241468718849634, 0.03711298148200999), 'AATSC0are': (
    'burr', (6.33285767536562, 0.8936621792184825, -0.0330361568533941, 0.1689308729033056), 0.0, 2.4492249999999993,
    0.13942179407824715, 0.05633448632694063), 'AATSC1are': (
    'johnsonsu', (0.24655658582683693, 0.8966157093308021, 0.00021655627493553258, 0.006761111944201632),
    -2.4492249999999993, 0.40377777777777774, -0.003127879117421028, 0.01727362235809625), 'AATSC2are': (
    'johnsonsu', (-0.4302845955595157, 1.1820435382675933, 0.002770227192922251, 0.019105225663543307), -0.432075,
    1.416100000000001, 0.013556693224652281, 0.028551496062713348), 'AATSC3are': (
    'johnsonsu', (0.14414079026858095, 1.0829363566647894, -0.00319315082512895, 0.012679855777142127),
    -0.9890160000000001, 0.9820809999999994, -0.00583526055946084, 0.020439083401661347), 'AATSC4are': (
    'johnsonsu', (0.23595822269126573, 1.1045970082273988, -0.004918363940469831, 0.016750329372745475),
    -0.9024489795918362, 0.9755360946745554, -0.009887780794318162, 0.02639165582530901), 'AATSC5are': (
    'johnsonsu', (0.21592255737054655, 0.961359411365723, -0.0010675931644689787, 0.016547615759669638),
    -0.9023039999999996, 1.5030759999999999, -0.0074881200037974684, 0.03663731220005812), 'AATSC6are': (
    'johnsonsu', (-0.017759226596342537, 0.790665995172264, -0.0033853516625168244, 0.01473976633483162),
    -1.060769387755102, 1.176390532544378, -0.003501371495711691, 0.046797464595823554), 'AATSC7are': (
    'johnsonsu', (-0.03737400237176841, 0.8946086541942817, -0.00550068269671351, 0.0175462086907569),
    -0.8992980833333328, 1.5254409999999976, -0.00445009787511551, 0.04148942202810248), 'AATSC8are': (
    'johnsonsu', (-0.006301490650218766, 0.9494474548732923, -0.005500867567009076, 0.017990673998346092),
    -0.8911222222222217, 1.5500250000000004, -0.00561739069764606, 0.039086958281541434), 'AATSC0p': (
    'gompertz', (7190692462.5759115, 0.10576928370489655, 7310784745.474476), 0.0, 355.5110250000001,
    0.31768999542222504, 2.0426663966180216), 'AATSC1p': (
    'chi', (1.704623804853925, -0.6957343986019804, 0.5175343867208198), -312.8334222222223, 110.01789900000003,
    -0.0072848758801139874, 0.6440084274936181), 'AATSC2p': (
    'genlogistic', (2.330076025485366, -0.022192369396599125, 0.023031600412545927), -3.5888111882005553,
    156.41671111111114, 0.008567931143649319, 0.4868342426310048), 'AATSC3p': (
    'genlogistic', (0.7357836843958873, -0.013733271746479613, 0.016591486878980936), -27.983232960000002,
    120.30786704246965, -0.021289975604485145, 0.22379073160656346), 'AATSC4p': (
    'hypsecant', (-0.017256127092004726, 0.02322000666630751), -18.140012743804622, 93.05583920661158,
    -0.015315884553834645, 0.1937685057856499), 'AATSC5p': (
    'hypsecant', (0.001590137071850609, 0.027374390394109764), -61.49474172174421, 59.94372544444447,
    0.004408117871052072, 0.1591655102495008), 'AATSC6p': (
    't', (1.825736943939798, -0.004492390007427391, 0.027200373015073734), -4.863038474067869, 21.381358195852464,
    0.006480235090866733, 0.10242847657652632), 'AATSC7p': (
    'laplace', (-0.0036299341578610216, 0.038509333304883785), -3.552297467815922, 22.5759421103066,
    0.0026781673069038586, 0.09241008435503731), 'AATSC8p': (
    't', (2.211384398310586, -0.005394383372653042, 0.026326169520710666), -3.7199736735684814, 8.845324047495662,
    -0.0007544545674433908, 0.07971632947030245), 'AATSC0i': (
    't', (1.5556375852622168, 1.5073455709332864, 0.12046664126129947), 0.0, 36.18672750714025, 1.6103156963969072,
    0.44085367026027883), 'AATSC1i': (
    'logistic', (-0.15533532185374577, 0.1296550556593732), -36.18672750714024, 7.501162131194013, -0.16481812924878175,
    0.2580554403882109), 'AATSC2i': (
    'fisk', (18.92211719253268, -2.4694807030399475, 2.4504276190419514), -4.371865533630668, 16.31027178630507,
    0.004836988648048373, 0.2691998738453835), 'AATSC3i': (
    'genlogistic', (0.6329708220530017, -0.05659258882281658, 0.09849697157074848), -13.98041484660576,
    9.564194552650235, -0.1393137123015741, 0.2256393106428841), 'AATSC4i': (
    't', (4.587425125341337, -0.10139289716465683, 0.15663406080789122), -7.399284026406246, 13.505143211796804,
    -0.10030764486037001, 0.21563474820932602), 'AATSC5i': (
    'johnsonsu', (-0.15040421927057465, 1.1425136890858, -0.010875221420587616, 0.2049637584407561),
    -10.725660518680023, 15.188601991182495, 0.029671377922702396, 0.27517200660282526), 'AATSC6i': (
    'norminvgauss', (0.5558427397830082, 0.22758997594345984, -0.05316920951326691, 0.2111512910707617),
    -6.5481515609374945, 8.625414298435405, 0.04017163434952556, 0.32462972195050166), 'AATSC7i': (
    'johnsonsu', (-0.3065078843576513, 1.0777424000633697, -0.06493483136387904, 0.18944492497091542),
    -9.180842051846895, 11.176523211595562, 0.01793455620319974, 0.29404765407884054), 'AATSC8i': (
    'johnsonsu', (-0.24347873186300084, 1.170141287036928, -0.060072303391854306, 0.208331792726705),
    -11.338813211596841, 13.25648711292582, 0.00248170944411244, 0.28610357258109803), 'MATS1c': (
    'burr12', (36.11921214511017, 0.8655400185433384, -3.384954214559063, 2.8843405092386263), -1.2064342076577053,
    0.6171299919828418, -0.47804362223171226, 0.15336848078613036), 'MATS2c': (
    'alpha', (13.428455475946702, -2.102978513597563, 28.239882253381744), -1.404858768168565, 1.2629328098105288,
    0.012044511050872378, 0.1595882435821033), 'MATS3c': (
    'johnsonsu', (1.2819667900159872, 2.8916229809636333, 0.17898174971740882, 0.3507579527801886), -1.730900025573978,
    1.1434330656446001, 0.009012844113596645, 0.14428221898940233), 'MATS4c': (
    'norminvgauss', (2.9377836378160955, 0.9390273481687834, -0.09933441300888513, 0.24028215687311494),
    -1.6816317211205483, 2.4394068571533363, -0.020494036460404833, 0.14862157773336462), 'MATS5c': (
    'norminvgauss', (1.4410869394256132, 0.026737852252100954, -0.007793457066320635, 0.19601243063301793),
    -3.0086947393176025, 4.606103504394669, -0.0011395630004153727, 0.16722920271094405), 'MATS6c': (
    't', (3.1796787816417726, 0.014746806563939986, 0.1321157835690173), -4.2146088536127335, 9.880618567678338,
    0.012939873032534492, 0.2182642083566634), 'MATS7c': (
    'johnsonsu', (-0.16232895192013963, 1.0863896445707393, -0.0270478049214539, 0.13053019573536637),
    -5.791117486318894, 7.014309879603893, 0.003937941162335159, 0.21959927370932672), 'MATS8c': (
    'johnsonsu', (-0.18876868604251956, 1.155385649140668, -0.02687158897158407, 0.12832348788927334),
    -6.736674449113112, 7.0238447116797795, 0.0037476492437588022, 0.18756417797929698), 'MATS1dv': (
    'johnsonsu', (1.0251674469263015, 2.6646475200520667, 0.3790371404695888, 0.2818997689646437), -1.2409177820267687,
    0.8571428571428573, 0.26164060867521644, 0.12398601792961841), 'MATS2dv': (
    'norminvgauss', (6.427868584553099, -1.406134655592144, 0.12360167272999273, 0.32175448914452187),
    -1.4736842105263157, 1.805196844529594, 0.05070800957542192, 0.1308228275390912), 'MATS3dv': (
    'genlogistic', (0.7160741034447842, -0.04408346951019005, 0.06454617312430747), -1.7098674698405745,
    1.2668885537469445, -0.08216740694536494, 0.1358313231769778), 'MATS4dv': (
    't', (4.229795143531401, -0.0809494322024053, 0.10889817117146994), -1.9459459459459456, 2.7222222222222223,
    -0.08792808490704752, 0.14819927990442702), 'MATS5dv': (
    'johnsonsu', (0.2458702672570019, 1.1758755533269256, -0.007646844529048563, 0.15727216481340062),
    -3.3823529411764706, 3.5874439461883405, -0.051694790527127214, 0.21068594083497102), 'MATS6dv': (
    't', (1.906398088099081, -0.044324171824059906, 0.1297656493358047), -3.407407407407408, 5.4390624999999995,
    -0.02856439787092073, 0.31054227655110667), 'MATS7dv': (
    't', (2.184340877575396, -0.05642842688841054, 0.1419565310466185), -3.101750547045953, 3.8515283842794767,
    -0.04089842104093184, 0.2868647443873235), 'MATS8dv': (
    't', (3.115767030188829, -0.06182172230730182, 0.1499149102606314), -2.8493150684931514, 5.818181818181818,
    -0.05328725983017956, 0.24896325690204713), 'MATS1d': (
    'vonmises_line', (10.592158373838487, 0.3284125644033826, 0.42287492681692207), -1.0000000000000002,
    1.079922965816081, 0.3297291030632681, 0.1339759381061719), 'MATS2d': (
    'genlogistic', (0.810004811025185, -0.038066652208228226, 0.07118811137773934), -1.0, 1.4999999999999996,
    -0.06301555336274048, 0.13781658532819352), 'MATS3d': (
    'norminvgauss', (1.4339688676051159, -0.6229931326263424, -0.07110620880411345, 0.13882651656310352),
    -1.1842105263157894, 1.0, -0.139484218821934, 0.1341349263525522), 'MATS4d': (
    'burr', (73.45445573179397, 0.5049900807443236, -3.466023420735145, 3.438199773613442), -2.0, 2.4999999999999996,
    -0.08745080627352017, 0.12018589069073647), 'MATS5d': (
    't', (2.283724616442983, -0.020873193219009517, 0.0980370410678852), -1.7142857142857144, 3.0,
    -0.005387847086048707, 0.1786038670280316), 'MATS6d': (
    't', (1.7704371261321439, -0.03202231226957289, 0.09980499576318667), -1.75, 2.75, 0.01086408287781789,
    0.22132522261998727), 'MATS7d': (
    't', (2.1630853249605613, -0.035638863062230144, 0.09936768962755596), -1.7131782945736438, 3.374999999999999,
    -0.008064036283189014, 0.193667531029139), 'MATS8d': (
    't', (2.744844411695382, -0.040287602205015496, 0.100548572606101), -1.8394160583941601, 2.076923076923077,
    -0.02383639239686466, 0.17197092310883058), 'MATS1s': (
    'johnsonsu', (0.4505946682198068, 1.1575602357471813, -0.03078671068184789, 0.0682787412585856), -1.313786636300134,
    0.645001988920259, -0.06882483252106543, 0.09181923071348312), 'MATS2s': (
    'norminvgauss', (1.3255754952414256, 0.3782207268510618, 0.04039439619828678, 0.1372015287171185),
    -1.4736842105263157, 1.2331432084402534, 0.08060268849052646, 0.12430895244802685), 'MATS3s': (
    'johnsonsu', (0.1775661719922449, 1.3908639154120634, -0.012986968048243123, 0.11002432756389371),
    -1.618131868131868, 1.0, -0.030383971743875197, 0.10525953946688672), 'MATS4s': (
    'johnsonsu', (-0.1684575246314931, 1.4586737903654075, -0.0769353470512033, 0.14809989054442924),
    -2.467008547008546, 2.843511862412842, -0.054474612868975786, 0.1347185592528608), 'MATS5s': (
    't', (3.1552998064271636, -0.04360431207086077, 0.12309863533747695), -2.8927335640138403, 5.8948598130841106,
    -0.05330297291746887, 0.20204759665719824), 'MATS6s': (
    'johnsonsu', (-0.03884370668331867, 0.894721613276925, -0.03693419291060855, 0.11831868881728239),
    -3.2305457881057946, 11.511574539363485, -0.036131498035296944, 0.29079607795394236), 'MATS7s': (
    'johnsonsu', (-0.12763480654735276, 0.9923680887594799, -0.057808541059737366, 0.13748106639883162),
    -3.7498176513493804, 7.641570141570146, -0.035662379423611015, 0.25878338708989906), 'MATS8s': (
    'johnsonsu', (-0.11643720698727386, 1.1068170312797851, -0.05694024739165166, 0.14399207839058117),
    -3.436823104693141, 11.450158168260904, -0.036069111456297494, 0.21857524308879483), 'MATS1Z': (
    't', (1.9617988854805342, 0.04468381541251877, 0.03782725232615419), -1.6596701649175407, 0.858596582531009,
    0.05512190407814077, 0.07403075105976369), 'MATS2Z': (
    'hypsecant', (0.048846492460305174, 0.06741791265512029), -1.2419354838709677, 1.375, 0.04714440320182758,
    0.10477476670456212), 'MATS3Z': (
    'norminvgauss', (1.6120562988879992, -0.5330725976321712, -0.020306414687948547, 0.14133731350925527),
    -1.5853658536585367, 1.0, -0.06998029180466327, 0.12415647382727914), 'MATS4Z': (
    't', (4.108295914345937, -0.06397043699317018, 0.10849946627484156), -1.9242228268141472, 2.892857142857143,
    -0.07119886738450668, 0.15035863440722355), 'MATS5Z': (
    't', (2.318504883218904, -0.021697164277146685, 0.10900490865548454), -3.113259668508287, 4.181672025723473,
    -0.028394393703404547, 0.21536566685793698), 'MATS6Z': (
    't', (1.5410827914470218, -0.029190518532845287, 0.11073061158685332), -3.611111111111111, 4.3484251968503935,
    0.0024613025995650515, 0.3239575774236395), 'MATS7Z': (
    't', (1.82638003310299, -0.038817321906204974, 0.1160842662155829), -4.097615979381444, 4.181672025723473,
    -0.012808170667379385, 0.2968928309934587), 'MATS8Z': (
    't', (2.409050262460072, -0.041098952468737834, 0.12484401438055756), -4.003225806451613, 14.336412058023575,
    -0.030709017415639403, 0.24932544630624176), 'MATS1m': (
    't', (2.0035742653354642, 0.04403156677949908, 0.03632247466268537), -1.6191337992736374, 0.8497440014100901,
    0.05392143130152253, 0.07052323333317093), 'MATS2m': (
    'dweibull', (1.1456601897922378, 0.04710881443145573, 0.0830788609474909), -1.2240836060111633, 1.3573011987610224,
    0.04737630483425349, 0.10487342792149844), 'MATS3m': (
    'norminvgauss', (1.5367817030208966, -0.5485575279417776, -0.017869245429491275, 0.13952143453364682),
    -1.578415297038186, 1.0000000000000018, -0.07068910762085864, 0.12422816254128702), 'MATS4m': (
    't', (3.9303866625338655, -0.06440013602132483, 0.10837653740557028), -1.9103248310669552, 2.9087321689231995,
    -0.07152137866397541, 0.15013251601093558), 'MATS5m': (
    'johnsonsu', (0.10595732219860632, 0.9808571534376958, -0.009019614952165904, 0.11484750933368318),
    -3.3537277075538983, 4.22956457978172, -0.027387473671416394, 0.2154316169298354), 'MATS6m': (
    't', (1.618744368543247, -0.027887455368032277, 0.11009609357959341), -3.6208033353930027, 4.373580444685693,
    0.0035791182154754657, 0.3241939910201521), 'MATS7m': (
    't', (1.8606479589248406, -0.03656051631498415, 0.11891170555466055), -4.119888242040346, 4.22956457978172,
    -0.011895565155082539, 0.2973362970812779), 'MATS8m': (
    't', (2.5074925394141414, -0.03854487644975415, 0.12338156495750371), -4.010484897841388, 14.495011400190824,
    -0.030240908119885813, 0.25011462351412567), 'MATS1v': (
    'norminvgauss', (0.6125890410165764, -0.0017544792087795002, 0.004861374023094686, 0.04379252752092582),
    -1.724684829801573, 0.6919352845028456, 0.004541843226648178, 0.056072277516706265), 'MATS2v': (
    'burr12', (7.402092043031299, 2.054974956806145, -0.5766995472507428, 0.6692308063449248), -1.4948498198253721,
    1.0782240601422475, 0.017245223131754465, 0.11546945766572905), 'MATS3v': (
    'norminvgauss', (1.2626145168710758, -0.5147973225481302, -0.03878068720984021, 0.12676897365418605),
    -1.5286756330232372, 1.0000000000000013, -0.0949898128160463, 0.12801641993174606), 'MATS4v': (
    't', (3.9704324498342825, -0.07383104982009711, 0.09933392869312989), -2.0375633299259985, 2.6485985948793833,
    -0.07649421089348447, 0.13868211533186595), 'MATS5v': (
    't', (2.28343078224822, -0.005163219129551705, 0.100243454879788), -2.3093733766150057, 3.606061467113855,
    0.0031972696347521315, 0.1994252470207825), 'MATS6v': (
    't', (1.572242315603141, -0.025452560984111847, 0.10421186783309595), -3.1080161984632904, 4.892912329148475,
    0.028336124084008596, 0.2906288178132041), 'MATS7v': (
    't', (1.7699484854349312, -0.028623354200032952, 0.10332342150262058), -3.3447233467885735, 4.20493732214939,
    0.010892390288093756, 0.26650947925969176), 'MATS8v': (
    't', (2.349076269622227, -0.030259088871118972, 0.10836568283986477), -3.3130494142395457, 5.10539336209302,
    -0.00897976183335963, 0.22536817145021615), 'MATS1se': (
    'norminvgauss', (0.543153995993045, 0.07891263734747073, -0.028032117461192847, 0.07153207491736337),
    -1.2029205473711906, 1.0, -0.016504325452826193, 0.09823656018468893), 'MATS2se': (
    'johnsonsb', (-109499355.22263984, 111591351.99318533, -60423632.37213542, 83072893.75426629), -1.3527054108216428,
    1.228653739261682, 0.0799379422257487, 0.14935753505556093), 'MATS3se': (
    'hypsecant', (-0.04401649849394866, 0.07404122606029473), -1.5076312943155852, 1.2576260304338245,
    -0.044375638071119994, 0.11684874630131306), 'MATS4se': (
    'burr12', (113583.50012869042, 0.8106941218852146, -8238.005642068736, 8237.915189646556), -1.9992429977289918,
    2.4108088460756645, -0.06559230912249453, 0.14593223092052698), 'MATS5se': (
    't', (3.9035988603840117, -0.040737081632421894, 0.1293354738072234), -3.0848487169300136, 4.045339561351051,
    -0.04959242786012833, 0.19247230044440608), 'MATS6se': (
    'johnsonsu', (-0.0003146994877732817, 1.0777371582146933, -0.0235528039133151, 0.16654297225251158),
    -3.572048502705216, 11.160073316640842, -0.027109562084611637, 0.26014373042708105), 'MATS7se': (
    'norminvgauss', (0.5671234463285619, 0.03544319211041665, -0.04792632653465585, 0.17013034740369076),
    -3.030403172504949, 7.15411634830898, -0.035255149587059054, 0.23883884791868137), 'MATS8se': (
    'johnsonsu', (-0.07525616641910346, 1.2299677196775451, -0.05256999207801218, 0.18415250506594355),
    -3.2481751824817464, 7.381071037734359, -0.03784707584943054, 0.22080244599654955), 'MATS1pe': (
    'dgamma', (1.0204331458526394, 0.006720010467224862, 0.06062212190940368), -1.3316473988439326, 1.0,
    0.0038974956389224782, 0.08897113806074954), 'MATS2pe': (
    'burr12', (7.498393237479534, 2.9158582787003176, -0.6987937152145296, 0.9332279843003499), -1.4816513761467889,
    1.2804538314139486, 0.08253595925921593, 0.1408561562709395), 'MATS3pe': (
    'norminvgauss', (1.4724451433427856, -0.3570649056143111, -0.01283836413404994, 0.13856283576290218),
    -1.617647058823529, 1.0866173742613046, -0.048859411779919835, 0.12238484104059888), 'MATS4pe': (
    't', (5.506585513194111, -0.06645540860669928, 0.12041444997695666), -2.4344262295081966, 2.264200747317539,
    -0.06778951827940599, 0.1536596237181427), 'MATS5pe': (
    'johnsonsu', (0.2534057845868429, 1.2601327375619193, 0.002293636265197336, 0.17656979755706384),
    -3.1912151737907246, 3.7881209930239783, -0.04976726322699709, 0.21116375171259036), 'MATS6pe': (
    't', (2.1628957322177715, -0.025480655341991745, 0.14442092359030467), -3.3832684824902715, 9.068175601750548,
    -0.021587571387608764, 0.2949524435041441), 'MATS7pe': (
    't', (2.5511801210042453, -0.04126681051633898, 0.1504440319291629), -3.48295418839942, 5.987682481751824,
    -0.033923646382044856, 0.272009853610106), 'MATS8pe': (
    't', (3.088881327101168, -0.03819110187183558, 0.15459789008549507), -4.330815709969788, 6.155833690095441,
    -0.040183094926391, 0.24359966518559778), 'MATS1are': (
    'norminvgauss', (0.42469058503238455, 0.03235602380110509, -0.014659051351904245, 0.06329734335951934),
    -1.4309375719880209, 0.6717838200175954, -0.009706668357359045, 0.09618277256110362), 'MATS2are': (
    'burr12', (7.268704397577495, 2.424603650684833, -0.6804546957249843, 0.8903701438017576), -1.43778801843318,
    1.3884264446934529, 0.08458464053070985, 0.14820476830827603), 'MATS3are': (
    'johnsonsu', (0.256772777606217, 1.5747705375322099, -0.01656878665714636, 0.15228288357955314),
    -1.5929778933680092, 1.1285173137581637, -0.04607619186516565, 0.12188486164187), 'MATS4are': (
    't', (4.964225359893245, -0.06787354217955151, 0.11779484921499858), -2.2814748201438846, 2.319493300258231,
    -0.0664648808546232, 0.15140948152748832), 'MATS5are': (
    'johnsonsu', (0.27027516326648277, 1.2265300464566191, -0.0005787085013916793, 0.16873274055571053),
    -3.0330759439966046, 4.114050145651269, -0.051381817919013986, 0.20525068723353002), 'MATS6are': (
    'johnsonsu', (-0.06796778838333431, 0.9839337228914985, -0.03521285831880258, 0.15138657763887725),
    -4.26897016187981, 9.950450450450447, -0.025526992292855363, 0.28305282867039117), 'MATS7are': (
    't', (2.8149997552182695, -0.04001262183857182, 0.1531719717556405), -3.335168352323644, 6.1968899355821785,
    -0.035829671295752305, 0.2593543335509619), 'MATS8are': (
    't', (3.1282998320593745, -0.043094025912481626, 0.14608895089610976), -3.942477876106193, 6.823064813444373,
    -0.04025255114417724, 0.23149972792440784), 'MATS1p': (
    'fisk', (417025122.356818, -21808634.806358352, 21808634.77473808), -1.4862463333016889, 0.9061971307432869,
    -0.03376125357581177, 0.09825836062747435), 'MATS2p': (
    'burr12', (8.481626270370317, 2.0042096960082585, -0.7023709487278723, 0.7924213384292962), -1.414214817440624,
    0.9558171267582808, 0.010813853756975775, 0.12282255604704899), 'MATS3p': (
    'johnsonsu', (0.6749479357295368, 1.4443831143319046, -0.011851032532762977, 0.13397970779789442),
    -1.6109709962168983, 1.3082841571447636, -0.09507896659808528, 0.13205607535282948), 'MATS4p': (
    't', (4.400267339019603, -0.06992654057564388, 0.09899901971487798), -1.9723675649114532, 1.5391779717901022,
    -0.07097302728663625, 0.13225662069539254), 'MATS5p': (
    't', (2.1214101670431846, 0.0041217853961745005, 0.09603942265012025), -2.243170639587707, 2.2887809698625246,
    0.014162411406248004, 0.18887914396723676), 'MATS6p': (
    't', (1.5664926794633902, -0.020236509232943917, 0.09989655539727472), -3.307285743333563, 3.2097310379461788,
    0.03060794912587144, 0.24964597519057183), 'MATS7p': (
    't', (1.852537723791663, -0.017689054150590022, 0.0956127234165001), -3.109627701739279, 3.0, 0.013367416373816745,
    0.22492045184402182), 'MATS8p': (
    't', (2.477489808263958, -0.019348194545196356, 0.10266827903552411), -3.246593736464303, 5.2399904754904085,
    -0.004717157464743732, 0.19635175826149687), 'MATS1i': (
    't', (6.224745793232341, -0.10022753790992012, 0.12575480574346332), -1.308828851147403, 0.7332113332236359,
    -0.1044494085581317, 0.15428632047789814), 'MATS2i': (
    'johnsonsu', (-0.630342026267624, 2.262487172474924, -0.09045714998056692, 0.2751971154864426), -1.305412999227394,
    1.0795991026838005, -0.003544397038325395, 0.1411679475516006), 'MATS3i': (
    'johnsonsu', (0.4946523942192753, 1.7760762865815316, -0.02504355765429335, 0.20148597511885027),
    -1.1480226534008175, 1.2416926549570033, -0.08838932786694674, 0.13700519308805104), 'MATS4i': (
    'johnsonsu', (-0.10964343379380531, 1.7497292736397039, -0.07896042285294641, 0.18392773373569757),
    -1.4903876747856166, 1.6334206237000581, -0.06350699298889131, 0.127776178432904), 'MATS5i': (
    'johnsonsu', (-0.3070389773668146, 1.1595649302442845, -0.024747526748172953, 0.1310578442788273),
    -1.78709982980123, 2.9241384190796094, 0.021238890419350055, 0.17044253090861095), 'MATS6i': (
    'norminvgauss', (0.5312615066568022, 0.2580800324601573, -0.04037876259935498, 0.12747548917742552),
    -1.9388705198398337, 2.583274023652576, 0.031299622162018516, 0.2079911301718182), 'MATS7i': (
    'norminvgauss', (0.597730938414238, 0.24239385824983267, -0.0337057290372465, 0.12293182726807493),
    -1.6300318744805609, 5.085158837639885, 0.016811611352453824, 0.1833786958368951), 'MATS8i': (
    'johnsonsu', (-0.41808253549054225, 1.3130034421409789, -0.057247091889413786, 0.1471597530909975),
    -3.333343238686711, 3.301166109275823, 0.005167609082912906, 0.1643421131756997), 'GATS1c': (
    'mielke', (96300545.8987714, 158927815.31697446, -14647244.203065626, 14647245.774010237), 9.241940133762187e-05,
    3.5, 1.484265634669138, 0.2116866983390584), 'GATS2c': (
    'johnsonsu', (0.17610335808386285, 4.017752825571159, 1.1009645886666364, 1.0239597506221227), 0.0,
    3.458456007722693, 1.05436866508767, 0.2623588621628481), 'GATS3c': (
    'johnsonsu', (-0.2728746602856886, 2.2888370916869594, 1.0026280406740593, 0.46677072979161605), 0.0,
    3.980899071957597, 1.0619337276602654, 0.22588427949946366), 'GATS4c': (
    'johnsonsu', (0.4265852356700573, 2.6812529038236796, 1.1824271543765468, 0.6093029852152105), 0.0,
    4.295839577045545, 1.0743680125306925, 0.24701593808764907), 'GATS5c': (
    'johnsonsu', (0.0544874887671122, 1.5636151388417718, 1.0504700086815015, 0.4116972501637758), 0.0,
    7.251060298232355, 1.0410473036307912, 0.32873614305273097), 'GATS6c': (
    'johnsonsu', (0.07390334815751087, 1.1829492390204357, 1.0206449969700615, 0.3348655573823712), 0.0,
    8.81584534164126, 0.9950350444401426, 0.43137782229624094), 'GATS7c': (
    'johnsonsu', (0.11185122373311984, 1.218704708033009, 1.0101227683315273, 0.31802640663224163), 0.0,
    11.27264937415861, 0.9817821667517901, 0.400379713157485), 'GATS8c': (
    't', (4.190559860988813, 0.9376615253745146, 0.2462480563700245), 0.0, 13.183266379842133, 0.9374200452847558,
    0.35079617228462806), 'GATS1dv': (
    'johnsonsu', (-1.7780785050099168, 2.0703221540547307, 0.37123086636865366, 0.1618491835030602), 0.0,
    3.5000000000000004, 0.5478123640479527, 0.12856316132905948), 'GATS2dv': (
    'burr12', (59.01194828750961, 0.5255881494451465, -3.799215027470723, 4.601120921846679), 0.0, 3.3169621947139514,
    0.9102260201297835, 0.20201009023518993), 'GATS3dv': (
    'mielke', (8.680317685260468, 10.430390740814529, 0.13061579131557421, 0.9383456337639766), 0.0, 4.100210693648911,
    1.0573347377041324, 0.17681060298794565), 'GATS4dv': (
    't', (4.7001245197203065, 1.0929649299250963, 0.1418285101745403), 0.0, 3.905487804878049, 1.0956158848106659,
    0.18855919053288211), 'GATS5dv': (
    't', (2.821891078444895, 1.0636208674687917, 0.17570825647868543), 0.0, 6.485294117647059, 1.0711588332187068,
    0.2973683743251973), 'GATS6dv': (
    't', (1.7532289594975645, 1.0419054382744393, 0.17717794496271422), 0.0, 6.805555555555556, 1.028001401629077,
    0.4295480739911257), 'GATS7dv': (
    't', (2.0882474752697053, 1.0493123754529625, 0.18983956354405968), 0.0, 7.3080000000000025, 1.0334577247005463,
    0.39235194380587346), 'GATS8dv': (
    't', (2.8999602615608095, 1.0482625769953837, 0.19465313274614887), 0.0, 7.763478260869566, 1.04169325734894,
    0.3316719897653585), 'GATS1d': (
    'gengamma', (11.458102820193751, 0.8249850771402818, 0.3409079357964355, 0.026493889875084026), 0.0,
    3.4999999999999996, 0.8582328417975039, 0.18769575296897564), 'GATS2d': (
    'johnsonsu', (-1.1577439132709495, 1.43981882473489, 1.0671405813040158, 0.21094010713453054), 0.0,
    3.635483870967742, 1.305433892664241, 0.26212329356024233), 'GATS3d': (
    'burr', (37.819598115754204, 1.2878108910899784, -2.7617772781032492, 3.9351363288077534), 0.0, 4.6875,
    1.2200597486476314, 0.1810106505668023), 'GATS4d': (
    'johnsonsu', (0.48984305574949094, 1.3701729505724103, 1.158586995857764, 0.22824488339756438), 0.0,
    4.2326732673267315, 1.0512248083623397, 0.2335834368131438), 'GATS5d': (
    't', (1.8941569809083816, 1.000041088345581, 0.17168733531445107), 0.0, 4.57258064516129, 0.9185273551020184,
    0.3346232429757639), 'GATS6d': (
    'foldcauchy', (7.1707571732377335, -1.4390426187547446e-09, 0.14120590592659377), 0.0, 4.002906976744187,
    0.8864919447098666, 0.385874107905087), 'GATS7d': (
    'johnsonsu', (0.6393906565643426, 1.0080616454733486, 1.091569438521247, 0.16725807289669412), 0.0,
    4.927152317880795, 0.9110071853274326, 0.33020093805660894), 'GATS8d': (
    't', (2.404242919952992, 0.969905997259799, 0.1596096131117128), 0.0, 4.2030456852791875, 0.9258094029145234,
    0.2809974063810361), 'GATS1s': (
    'burr12', (273.39845331553647, 0.13952776161409047, -6.394775539974606, 6.907069398381035), 0.16468524654063532,
    3.5, 0.6935108757410218, 0.20020393401557784), 'GATS2s': (
    'norminvgauss', (0.9537858906183139, 0.6464573320413652, 0.511860627768505, 0.12548356617151826), 0.0,
    2.1448351154017105, 0.6269573610010758, 0.1920909553555624), 'GATS3s': (
    'johnsonsu', (-0.34760313919922414, 1.7928380221761238, 0.8519212540057376, 0.3185885074296917), 0.0,
    3.5100000000000002, 0.9264179484535991, 0.21456649958101723), 'GATS4s': (
    'norminvgauss', (7.488949960702019, 1.8006875212409907, 0.9405199208423323, 0.8208432724062416), 0.0,
    5.178365937859608, 1.147690532607019, 0.31094995467498476), 'GATS5s': (
    'johnsonsu', (-0.38610526691072516, 1.362133091055349, 1.0459696336342679, 0.452765329158134), 0.0,
    8.990011098779133, 1.2255747904009342, 0.4886000155802822), 'GATS6s': (
    'johnsonsu', (-0.18788502546794367, 1.0310791063879008, 1.0195086141885616, 0.39268802886878007), 0.0,
    12.937216478369374, 1.1675882126227082, 0.7646319413018245), 'GATS7s': (
    'johnsonsu', (-0.23362062526254662, 1.1915610223307613, 0.9865654782893097, 0.4653384809232534), 0.0,
    16.34634395772967, 1.1349860099972398, 0.6833758274555597), 'GATS8s': (
    'johnsonsu', (-0.3627545354300681, 1.4131790763826175, 0.909306124711289, 0.5296287243014267), 0.0,
    16.84076142710589, 1.0959904658957311, 0.5600434124333461), 'GATS1Z': (
    'dweibull', (1.1218492112027172, 0.7505134051417137, 0.11226996498253408), 0.0, 4.375, 0.7584912716943232,
    0.1472476748650936), 'GATS2Z': (
    'burr12', (25.11588510219641, 1.184257368591021, -1.6236836315605085, 2.4784032147741613), 0.0, 4.824067336924347,
    0.8335193168103627, 0.16709352577425407), 'GATS3Z': (
    'johnsonsu', (-0.4563508122759803, 1.5515873286020094, 0.9441298584411273, 0.20379445358502474), 0.0,
    4.725718626664268, 1.0194071326720349, 0.1752609857041052), 'GATS4Z': (
    'johnsonsu', (-0.15626662583956075, 1.530666141486972, 1.0176085183020063, 0.2525018863397561), 0.0,
    5.275124614330071, 1.0475921011285263, 0.2065709714833164), 'GATS5Z': (
    'norminvgauss', (0.5520141275399495, 0.043541297920584275, 0.9899120246377962, 0.21101369704700668), 0.0,
    7.27275960170697, 1.0120721629557086, 0.2899716440765624), 'GATS6Z': (
    'johnsonsu', (0.05883799220706219, 0.8626838716320842, 1.0111002186743088, 0.17249576447329235), 0.0,
    9.8330344040437, 0.9857183950864574, 0.38816362489114337), 'GATS7Z': (
    't', (2.0534392938742814, 1.0175576193801013, 0.1843456083254794), 0.0, 11.247220163083766, 1.0028175231384242,
    0.3729584704902114), 'GATS8Z': (
    'johnsonsu', (-0.050745404516239837, 1.0060683389397378, 1.0084245260995506, 0.1936938691859587), 0.0,
    12.366281557552417, 1.0291751201018298, 0.3643317876113657), 'GATS1m': (
    'hypsecant', (0.7528544509607137, 0.09323461443631839), 0.0, 4.374999956752842, 0.7599385193127149,
    0.14928000170660613), 'GATS2m': (
    'burr12', (29.43151347246222, 1.0894526064242591, -1.9462190353277151, 2.78538357402247), 0.0, 5.0859387820937405,
    0.8322673656292625, 0.16596001147820186), 'GATS3m': (
    'johnsonsu', (-0.4191862953951737, 1.5169877554202809, 0.9476970188581012, 0.1958994160588649), 0.0,
    4.845461521506413, 1.0173614122615713, 0.17203989516235607), 'GATS4m': (
    'johnsonsu', (-0.1299836175849815, 1.4799481608308582, 1.0176997286442042, 0.23301902758506463), 0.0,
    5.467358929299348, 1.044421800721275, 0.20300491779923557), 'GATS5m': (
    'johnsonsu', (-0.06276318667260304, 1.0831549516729595, 0.991744378238627, 0.19796361913530333), 0.0,
    7.481061183351974, 1.0071505198091324, 0.28587071753118526), 'GATS6m': (
    'norminvgauss', (0.21800203910362004, -0.025485524314153997, 1.0087271761407335, 0.18127033973722245), 0.0,
    9.960612213698521, 0.9812333816556925, 0.3821930388174616), 'GATS7m': (
    't', (1.9449132583386786, 1.009410729424527, 0.17233576459014302), 0.0, 11.312390886803135, 1.0001813056740754,
    0.3675362163236711), 'GATS8m': (
    't', (2.2995099924288214, 1.0174023641667658, 0.17486506757386455), 0.0, 12.699388926139955, 1.0290691180931402,
    0.36019504632368626), 'GATS1v': (
    'mielke', (580.4862495554315, 284.41317516752235, -27.38743826296676, 28.263050425034784), 0.0, 3.499999999999999,
    0.977285720432533, 0.15266727954294582), 'GATS2v': (
    'norminvgauss', (2.018340807688099, 0.2808284400749179, 0.9099014553088158, 0.19185169611912856), 0.0,
    2.9849447694859657, 0.9362186961113664, 0.13767190825048684), 'GATS3v': (
    'johnsonsu', (-0.4598422879910456, 1.3504725669629218, 0.990965209216999, 0.12912290570514268), 0.0,
    3.704556107820661, 1.0496732473762496, 0.13727908476578385), 'GATS4v': (
    'johnsonsu', (0.07746406247414978, 1.3606011440037922, 1.0297306774459847, 0.14785411335470278), 0.0,
    5.9067759849397605, 1.0194481614423112, 0.14538717580488156), 'GATS5v': (
    't', (2.060692501685475, 0.9553823288020672, 0.10664619494026989), 0.0, 7.0373984727184595, 0.9386855843894385,
    0.21824343540976882), 'GATS6v': (
    't', (1.5067941490431136, 0.9884656575623821, 0.1073510088043232), 0.0, 9.7272605504906, 0.9214304454591948,
    0.30141836736063116), 'GATS7v': (
    't', (1.7115006442772263, 1.001511960455343, 0.10414181232567779), 0.0, 6.968158620287257, 0.9529674551242461,
    0.27615139816300804), 'GATS8v': (
    't', (2.370664503212735, 1.009789960595764, 0.11598155305899344), 0.0, 6.494564804698469, 0.990763554344595,
    0.231622410264639), 'GATS1se': (
    'burr', (9.418927682683641, 0.7639296034921117, -0.024771434114324573, 0.788961675803237), 0.0, 3.4999999999999996,
    0.7418579113415544, 0.1643549004339001), 'GATS2se': (
    'skewnorm', (3.684036099420223, 0.4872124766507931, 0.4121534077542287), 0.0, 3.134288919356849, 0.8049234399625332,
    0.26369428575800835), 'GATS3se': (
    'johnsonsu', (-0.33686095240447644, 1.5536278134595563, 0.9344331574596313, 0.2695773068975218), 0.0,
    4.082756998480603, 1.0067463448800618, 0.22041276444505006), 'GATS4se': (
    'johnsonsu', (-0.13770431110964718, 2.2967720687422783, 1.0734271975881708, 0.5692013753442797), 0.0,
    5.279170103419834, 1.1107247715951951, 0.2751442727227789), 'GATS5se': (
    'johnsonsu', (-0.2610226673039248, 1.4730280208223148, 1.0086210801365298, 0.4444796092449768), 0.0,
    8.950992420295458, 1.1132794816900384, 0.40723882825926494), 'GATS6se': (
    'johnsonsu', (-0.026656277337847017, 1.0642450838057533, 1.018055995152129, 0.35069771525959353), 0.0,
    11.39476569500817, 1.046460591361541, 0.5761050949174683), 'GATS7se': (
    'johnsonsu', (-0.06055483603118797, 1.1685488178940249, 1.0062246742982894, 0.395656931297249), 0.0,
    13.954249057556869, 1.044172175620161, 0.5246231774770617), 'GATS8se': (
    'johnsonsu', (-0.16886974347695222, 1.3364194340245614, 0.9621715679147321, 0.4391225830253332), 0.0,
    15.183426201807515, 1.0358803795669578, 0.4622889035543077), 'GATS1pe': (
    'johnsonsu', (-0.8008456321319821, 1.55448937970602, 0.6133604079560029, 0.14916620314786444), 0.0,
    3.5000000000000013, 0.71353288208098, 0.1394205458446326), 'GATS2pe': (
    'skewnorm', (3.118527702313986, 0.5281192363296201, 0.35385641886684527), 0.0, 2.557989346167294,
    0.7954871038284496, 0.23003879419731807), 'GATS3pe': (
    'johnsonsu', (-0.5039398839473566, 1.6743163808176935, 0.903874919621251, 0.27133932265184063), 0.0,
    3.63397284990785, 0.9999908647317746, 0.20296632737439207), 'GATS4pe': (
    'burr12', (23.596206267711672, 1.17569359000726, -2.2598882043453177, 3.387542497853201), 0.0, 4.57627118644068,
    1.0999504192594498, 0.24381089227981292), 'GATS5pe': (
    'johnsonsu', (-0.25769922569498765, 1.4379245349940297, 1.012070848934005, 0.3743266290086863), 0.0,
    7.897755083542317, 1.1023989918194466, 0.3648689570871965), 'GATS6pe': (
    'johnsonsu', (-0.03537043952709315, 0.9745641478478112, 1.0201220775161959, 0.26959793620760264), 0.0,
    9.355047230612369, 1.0398395633680662, 0.51760537848651), 'GATS7pe': (
    't', (2.767225158712761, 1.0372751933816056, 0.2774551234798457), 0.0, 10.828957913398261, 1.0436382001250142,
    0.4734126783815701), 'GATS8pe': (
    'johnsonsu', (-0.16088221753852341, 1.2995942597217895, 0.980945856626543, 0.3765389169645279), 0.0,
    11.483075384965172, 1.0437759901879269, 0.41570160783559584), 'GATS1are': (
    'johnsonsu', (-0.5821871906780917, 1.4764367406136234, 0.6614432410478412, 0.1529670724970619), 0.0,
    3.5000000000000004, 0.7403638207506371, 0.145368936279411), 'GATS2are': (
    'skewnorm', (3.232225741589356, 0.522690607592712, 0.3863714264006546), 0.0, 2.8005876591576895, 0.8098581054704829,
    0.24851012465748926), 'GATS3are': (
    'johnsonsu', (-0.5098661029102155, 1.815781828969309, 0.9051671398683012, 0.3078994591321186), 0.0,
    3.832444530945893, 1.0089951298202122, 0.21279500176118846), 'GATS4are': (
    'johnsonsu', (-0.23437871731861315, 2.4089566877223874, 1.0442646034089096, 0.5612852069787677), 0.0,
    4.9477055824290765, 1.1119780086590485, 0.2577234954478388), 'GATS5are': (
    'johnsonsu', (-0.2527848674422637, 1.3770072402822446, 1.0233811398181887, 0.39065257187475355), 0.0,
    8.425219941348974, 1.1173548416656236, 0.3844972896095889), 'GATS6are': (
    't', (2.5641255530147244, 1.0358616350972991, 0.2939080268533739), 0.0, 10.24365117393388, 1.0499206393531186,
    0.5434542856891014), 'GATS7are': (
    't', (2.980341550588113, 1.0347851210004193, 0.30292818591735304), 0.0, 12.118332744613213, 1.046734667161394,
    0.4959798813235695), 'GATS8are': (
    'johnsonsu', (-0.16918025440968248, 1.3022689987351428, 0.9688384410701805, 0.39255435082646917), 0.0,
    12.975851393188858, 1.0376058624271538, 0.43421780500103613), 'GATS1p': (
    'exponnorm', (0.43886192505490407, 1.0034248274253952, 0.20546301925932553), 0.0, 4.55626555522979,
    1.0936835409364583, 0.22910775480235326), 'GATS2p': (
    'genlogistic', (1.0954104957286326, 0.966415716425223, 0.09719151756600655), 0.0, 4.112804513407606,
    0.9821486186535133, 0.178637880526342), 'GATS3p': (
    'burr12', (258112233.67599884, 0.5608527410350076, -17806429.84257906, 17806430.845104564), 0.0, 5.186453183303414,
    1.080321426525854, 0.181293805119202), 'GATS4p': (
    'johnsonsu', (0.17799677097567604, 1.3783755253157508, 1.0545828999734583, 0.1937764070983932), 0.0,
    5.398028603073146, 1.0220660865135838, 0.19154172522603968), 'GATS5p': (
    't', (2.1020555181846365, 0.9498631438095808, 0.13814626481540593), 0.0, 7.60624409911055, 0.9181052627893487,
    0.2758176880041552), 'GATS6p': (
    't', (1.5725352630940677, 0.9772182371832024, 0.14555475554732994), 0.0, 9.068706951573096, 0.9024116385749213,
    0.3549236569649108), 'GATS7p': (
    't', (1.7374791389980404, 0.9780650068762855, 0.1375829671759984), 0.0, 9.518908468412558, 0.9323583641667933,
    0.32371850207068015), 'GATS8p': (
    't', (2.3502557730332514, 0.9843888731737409, 0.14524140432178384), 0.0, 10.551459756276692, 0.9648315338780339,
    0.28824175181807976), 'GATS1i': (
    'exponnorm', (0.89262419836314, 1.125127201828941, 0.1801499456746776), 0.0, 3.800549401684079, 1.2828122077947828,
    0.23924467135311187), 'GATS2i': (
    'johnsonsu', (0.2306387002227063, 1.6475394707269981, 1.1218669449778804, 0.2124265540944849), 0.0,
    3.6159346050422716, 1.0861135414992367, 0.15736095728746338), 'GATS3i': (
    'johnsonsu', (-0.20926273383589036, 1.4539628766187576, 1.0784879001472212, 0.17365236003430334), 0.0,
    4.273249552627078, 1.108524901852828, 0.15808459555880722), 'GATS4i': (
    'johnsonsu', (0.6523309500534941, 1.4800751808689725, 1.129796088827166, 0.18207178953003975), 0.0,
    4.638634653779667, 1.0260916331224263, 0.17175573371605643), 'GATS5i': (
    'johnsonsu', (0.6012451537852026, 0.9892353057797623, 1.034884726824572, 0.12509619911632744), 0.0,
    6.717876671789019, 0.9039122521551984, 0.25604297208993687), 'GATS6i': (
    't', (1.496426412096256, 0.9755028683122524, 0.1265502911094847), 0.0, 6.02923266698831, 0.8795538965100013,
    0.330848923147557), 'GATS7i': (
    't', (1.730790365712721, 0.971101136290998, 0.11227806090111189), 0.0, 3.9967620374711674, 0.9051499782475947,
    0.28786716288876024), 'GATS8i': (
    'johnsonsu', (0.42518109463714426, 1.0635940470032836, 1.0161976643826625, 0.13246406078080564), 0.0,
    7.685625791864621, 0.9269824190207376, 0.23337357715524967), 'BCUTc-1h': (
    'mielke', (4.983206361665168, 14.162814728696025, 0.1592340267648182, 0.3163692136830513), -1.0, 3.0,
    0.4349291081819701, 0.05910640304150421), 'BCUTc-1l': (
    'dweibull', (1.8374060402554027, -0.4545925814670295, 0.06967016191439455), -1.0398759252497647, 3.0,
    -0.44903359817687144, 0.07327948347102164), 'BCUTdv-1h': (
    'gennorm', (0.10815736089710529, 6.023201531710958, 2.0890597485785655e-11), -0.08888888888888889,
    7.045986507776948, 6.0619465043489305, 0.5550626823191781), 'BCUTdv-1l': (
    'gennorm', (0.1398110312470664, 0.9959553850705245, 5.4507027585203064e-08), -0.25991616822105357, 6.0,
    1.0010127828083593, 0.5258994905661225), 'BCUTd-1h': (
    'cauchy', (3.22545318258841, 0.08718070174773679), 0.0, 10.020332632677777, 3.474002385626374, 0.4028660260289439),
        'BCUTd-1l': ('cauchy', (0.9770278768021179, 0.002776843343034586), 0.0, 2.8010000000000015, 0.987743955704002,
                     0.1147156186550539), 'BCUTs-1h': (
    'cauchy', (7.009424214902109, 0.003715819587944075), 1.1066940128167098, 8.039944963546347, 6.607650611176435,
    1.3519097021900666), 'BCUTs-1l': (
    'dweibull', (0.8305472356021533, 1.218018911187063, 0.2679541362429264), -0.02283041011492809, 5.95769012548175,
    1.01090330218142, 0.38973242378004197), 'BCUTZ-1h': (
    'gennorm', (0.1004677692055464, 8.026220981331974, 5.405266011735056e-11), 3.0, 92.00205016892451,
    12.482085805128305, 6.308656152809193), 'BCUTZ-1l': (
    'powerlognorm', (6.593966096292687, 0.28734820643264913, 4.964175019187308, 1.065252446965156),
    -0.002019960190467107, 88.0, 5.712119011038181, 0.3141917813506215), 'BCUTm-1h': (
    'gennorm', (0.10655638312476062, 16.009448108945563, 4.709555904923063e-10), 6.94, 238.02968585347557,
    25.604745282362725, 14.43227289311363), 'BCUTm-1l': (
    'johnsonsu', (-0.30383717521816883, 0.46445659656744265, 11.702772830486131, 0.0037230846246581527),
    1.0058945548072025, 226.0, 11.727782019619433, 0.7606200574983649), 'BCUTv-1h': (
    'johnsonsu', (-0.6736687200945817, 0.25935391916527184, 20.89285289575045, 0.00874164905931951), 13.30578842767868,
    94.93971329525185, 22.435716044330814, 2.0149851725546535), 'BCUTv-1l': (
    'foldcauchy', (115.4351979982801, -0.2178521536841192, 0.12929096976075427), 5.57309424669215, 94.93971329525185,
    14.645065447640398, 0.7597859726391364), 'BCUTse-1h': (
    't', (0.49374934980855434, 3.704799680133142, 0.006927316909145274), 0.445, 4.070216428827304, 3.7204805910052343,
    0.14882112895703206), 'BCUTse-1l': (
    't', (0.7008554618193057, 2.4358775727164472, 0.005899667528870776), 0.445, 4.0, 2.450817842230683,
    0.04770951538216734), 'BCUTpe-1h': (
    'cauchy', (3.4940277399622355, 0.015777940769668895), 0.82, 4.040221846808313, 3.5290748979075617,
    0.19058215489840982), 'BCUTpe-1l': (
    't', (0.7252564427689141, 2.239402500620791, 0.006366123737563208), 0.82, 3.98, 2.2537988109851983,
    0.04863932358016037), 'BCUTare-1h': (
    't', (0.48491897797330247, 3.546210592718421, 0.006302168160078273), 0.91, 4.157337085515696, 3.5864659678780644,
    0.21535876778011312), 'BCUTare-1l': (
    't', (0.7775863404506358, 2.1888499439806317, 0.007326837649318666), 0.91, 4.1, 2.2026040311448347,
    0.05363604971266663), 'BCUTp-1h': (
    'gennorm', (0.24032507490783184, 1.9919227835953626, 0.00043047878736685095), 0.557, 43.06, 2.368047660385864,
    0.5547233554694834), 'BCUTp-1l': (
    'foldcauchy', (88.31248791341727, -0.19327322997035873, 0.01068016833511359), 0.5179865998153812, 43.06,
    0.7452175937737754, 0.16228957341666922), 'BCUTi-1h': (
    'cauchy', (14.551872635363237, 0.01845510097775724), 4.3406633, 17.463217935755196, 14.778544002085832,
    1.0094274522023488), 'BCUTi-1l': (
    'gennorm', (0.18886166377460795, 10.954032692177666, 1.1219758326573206e-05), 4.3406633, 17.4228,
    10.742256991528455, 0.34668432048469844), 'BalabanJ': (
    'norminvgauss', (0.552254335055371, 0.2976994500891046, 1.4369032640135515, 0.3318873454635408),
    -9.901238335451693e-06, 8.987599524396183, 1.6539713763890178, 0.5339953170947793), 'SpAbs_DzZ': (
    'burr', (5.1778982910085904, 0.23293349258806756, -2.47267831168492, 306.85782350638533), 0.0, 63291.1480319001,
    194.65042906247376, 290.7821288646471), 'SpMax_DzZ': (
    'burr', (4.915086479052306, 0.238504922306907, -0.6804745212789731, 154.81800842699647), -1.0, 31667.038301664343,
    97.91737785849018, 145.54468637022958), 'SpDiam_DzZ': (
    'kappa3', (5.429232832730728, 1.950321336721362, 180.45062360878143), 0.0, 49927.3834234344, 146.96748282299885,
    220.79041719620065), 'SpAD_DzZ': (
    'mielke', (1.1956423404242504, 5.104199832117822, -1.3554650670026818, 313.7506514841982), 0.0, 63333.89921253764,
    195.9322708901185, 291.2688619733423), 'SpMAD_DzZ': (
    'mielke', (2.5547639499943493, 9.136777653647545, -0.034479287701012856, 9.757126973334037), 0.0,
    130.85516366226784, 7.38812233876952, 2.8830184090339186), 'LogEE_DzZ': (
    'kappa3', (5.471281813450001, 1.2269760957722773, 120.10492418150014), 0.31326168751822286, 31667.038301664343,
    97.91758724686221, 145.54454861723235), 'SM1_DzZ': (
    'burr', (5.8457598254467324, 0.2462694662003645, -0.017702286780628268, 2.411369220254773), -23.839285714285715,
    42.92857142857143, 1.5386731681258785, 0.9215297823395855), 'VE1_DzZ': (
    'johnsonsu', (0.9206077594077609, 1.4355279620546924, 5.432671343521777, 0.9986938994872951), 1.0,
    21.79356038512303, 4.592789454974456, 1.0279687248347962), 'VE2_DzZ': (
    'johnsonsu', (-1.335077708745505, 0.973699258918457, 0.16987441057140362, 0.018077005998545483),
    0.04429585444130697, 1.0, 0.22391062778102302, 0.059820111324115646), 'VE3_DzZ': (
    'johnsonsu', (1.1910613172124414, 1.1613551088076626, 2.9035866702376305, 0.4060708151433764), -2.3025850929940455,
    6.9775081544777136, 2.2194420137214093, 0.7265035435679428), 'VR1_DzZ': (
    'mielke', (1.4303150942779097, 5.902469712404684, -1.185769645655896, 208.15195311617555), 0.0, 11843.233531029977,
    135.88369111142708, 106.72296800347546), 'VR2_DzZ': (
    'genlogistic', (0.44204690866813556, 6.204778270154758, 0.4752027006935855), 0.0, 24.071612867947106,
    5.410388307398959, 1.2605018924457254), 'VR3_DzZ': (
    'johnsonsu', (1.0970031069490123, 1.1393221484351646, 6.513164752973847, 0.6959986406138039), -1.2628643221541276,
    13.275405596933556, 5.40578898749116, 1.2202910061040773), 'SpAbs_Dzm': (
    'kappa3', (5.479208373072774, 0.8109873130017646, 242.64342171321522), 0.0, 63307.575798732185, 194.63602237292753,
    290.8414585519046), 'SpMax_Dzm': (
    'kappa3', (4.973278094806477, 0.7690019057736834, 117.10997085805728), -0.7306916426512966, 31675.198222252653,
    97.91171704172842, 145.57429598455963), 'SpDiam_Dzm': (
    'skewnorm', (53.587661491757814, 12.27177181577019, 178.21248278220298), 0.0, 49940.346704349984,
    146.96871832086336, 220.83842931520735), 'SpAD_Dzm': (
    'mielke', (1.2055406929154513, 4.993004124763662, -1.067152804474249, 309.7135326003472), 0.0, 63350.21949968807,
    195.92423732248662, 291.32822530943514), 'SpMAD_Dzm': (
    'mielke', (2.5014153734438813, 9.19580928584152, -0.015425279644763144, 9.813663404980911), 0.0, 130.88888326381834,
    7.387736828605003, 2.883474301653932), 'LogEE_Dzm': (
    'burr', (4.842268898912446, 0.2307297710018119, 1.212810906089323, 153.9521853307375), 0.39310624873243005,
    31675.198222252653, 97.91192959798987, 145.57415619253834), 'SM1_Dzm': (
    'rice', (0.00046323002478804946, -0.10349560706848973, 1.3448308231244333), -53.41874837737701, 42.82064577312764,
    1.5458567564430266, 0.9355133394757366), 'VE1_Dzm': (
    'genlogistic', (0.3525506348401811, 5.355356362672883, 0.32063108115394345), 1.0, 21.793556459845384,
    4.592827084025255, 1.0279974329250678), 'VE2_Dzm': (
    'norminvgauss', (1.068270117072414, 0.9327172665611052, 0.17748143415596052, 0.025996854864333646),
    0.04429584646310037, 1.0, 0.22391112480079425, 0.05981524942041603), 'VE3_Dzm': (
    'johnsonsu', (1.2261802410130094, 1.1979011727510929, 2.9175032406393826, 0.4243834694172844), -2.3025850929940455,
    6.977507974365886, 2.2194476373721, 0.7265180796110112), 'VR1_Dzm': (
    'mielke', (1.4504307989283598, 6.105737639802843, -1.1519588406150012, 209.253823550172), 0.0, 11843.240405748207,
    135.87666327917628, 106.72142346582477), 'VR2_Dzm': (
    'mielke', (3.442684849621337, 15.811000121574988, 0.6711934365222803, 5.967675737024839), 0.0, 24.07162684095164,
    5.410115652032544, 1.2604158839929738), 'VR3_Dzm': (
    'johnsonsu', (1.1847258526555307, 1.1610243919975618, 6.566491418810327, 0.6898067807001336), -1.2628643221541276,
    13.275406177409844, 5.405743472512479, 1.220257556959494), 'SpAbs_Dzv': (
    'burr', (5.305481735047742, 0.2098853399410356, 0.525532283451447, 412.34953628448704), 0.0, 84474.89500666707,
    252.41306106761317, 382.34514595345536), 'SpMax_Dzv': (
    'burr', (4.674064929483199, 0.2331700407394232, 1.8101750572012556, 200.48677520214258), -0.5466596653007074,
    42203.00306129708, 125.21469988953797, 190.6588583811321), 'SpDiam_Dzv': (
    'gumbel_r', (127.08703925141063, 104.59777794657626), 0.0, 66682.6279696805, 188.76297672142547,
    290.68963244036837), 'SpAD_Dzv': (
    'burr', (5.296950686357743, 0.22427373150685237, -3.179610167717744, 400.7602607482163), 0.0, 84407.9987762657,
    251.05337552615495, 381.6311063230523), 'SpMAD_Dzv': (
    'mielke', (2.380437745904773, 9.514023637105144, -0.025906886775993163, 12.831700686298088), 0.0,
    174.39669168649937, 9.448312798798908, 3.7477141523947686), 'LogEE_Dzv': (
    'burr', (4.928917141115141, 0.23416869816853914, -0.9669015562363703, 199.09682971864027), 0.45671588578168343,
    42203.00306129708, 125.21478601643824, 190.65880247823085), 'SM1_Dzv': (
    'pearson3', (-0.7858644394407855, -1.9635996586889037, 1.0590414542631328), -68.88888407288636, 3.2929519250380945,
    -1.956328904678836, 1.1822349864011352), 'VE1_Dzv': (
    'genlogistic', (0.37125818263577315, 5.329713537144556, 0.3382157467210118), 1.0, 21.788582219630605,
    4.5926047573019675, 1.02966092918247), 'VE2_Dzv': (
    'norminvgauss', (1.1072426887842397, 0.9608596570372023, 0.17735452177299832, 0.026358159606880417),
    0.04428573621876139, 1.0, 0.22384793109144902, 0.0596822644813439), 'VE3_Dzv': (
    'johnsonsu', (1.1593192949170383, 1.1525082298120644, 2.8992651929449345, 0.4065627720204136), -2.3025850929940455,
    6.977279704694544, 2.2192933856589425, 0.7270019554433305), 'VR1_Dzv': (
    'mielke', (1.4128641115603147, 6.2481678777042475, -1.0180033059029667, 209.87565008258014), 0.0,
    11850.334926272657, 136.11774315962003, 106.75212834052657), 'VR2_Dzv': (
    'burr', (17.87340064811895, 0.22951814801629297, -0.11334584023404651, 6.712506383624333), 0.0, 24.086046598115157,
    5.422079203517593, 1.2580222068611122), 'VR3_Dzv': (
    'johnsonsu', (1.2035677748782208, 1.2165272338610462, 6.562871526432909, 0.7369028584740536), -1.2628643221541276,
    13.276005033482603, 5.408217773290466, 1.2189165580776038), 'SpAbs_Dzse': (
    'mielke', (1.1933866808725893, 5.030080993428699, -1.324193124393081, 320.16699954237606), 0.0, 63424.82653869834,
    201.97291166534842, 293.83289260658967), 'SpMax_Dzse': (
    'kappa3', (5.541875864788032, 2.732050803880046, 125.09802750378995), -5.170786516853933, 31732.02931879829,
    101.5443566600094, 147.0580861807341), 'SpDiam_Dzse': (
    'kappa3', (5.6337093780437915, 0.9545162297542242, 189.94412555844184), 0.0, 50027.366182257894, 152.49857430312335,
    222.92301107681072), 'SpAD_Dzse': (
    'mielke', (1.1787224041605886, 5.259130935228223, -1.2934201975404274, 324.32227643439694), 0.0, 63463.896521485425,
    203.0220806704323, 294.29220073454474), 'SpMAD_Dzse': (
    'mielke', (2.459296119520145, 10.763871982208684, -0.017037789510923655, 10.325494078084233), 0.0,
    131.12375314356493, 7.6544037770474205, 2.9587332818377794), 'LogEE_Dzse': (
    'kappa3', (5.367708003226342, 0.5767358692636135, 124.92385601747938), 0.005664028629919503, 31732.02931879829,
    101.54448111144129, 147.05800116733568), 'SM1_Dzse': (
    'gengamma', (17.03330709747717, 0.8160845472372148, -0.9006997212316328, 0.06395567552274814), -5.170786516853933,
    39.23209889822667, 1.1863756326774229, 0.6845673064763438), 'VE1_Dzse': (
    'johnsonsu', (0.9620697523471529, 1.4062645947645631, 5.4750606789267255, 0.9540197041773456), 1.0,
    21.793106777311532, 4.59459184473887, 1.0285294956482538), 'VE2_Dzse': (
    'norminvgauss', (1.1768871705407276, 1.0365296616604565, 0.1760771402997915, 0.026141893327469995),
    0.04429493247421043, 1.0, 0.2239806718267464, 0.05977810902054777), 'VE3_Dzse': (
    'johnsonsu', (1.2091159013525568, 1.1943516697000707, 2.920013153389191, 0.43309028048923354), -2.3025850929940455,
    6.977487340415018, 2.2198403499334556, 0.7264267862077723), 'VR1_Dzse': (
    'mielke', (1.4264616737377134, 5.951233981886812, -1.225317875458234, 209.5538792355062), 0.0, 11844.761702931071,
    135.77826276657342, 106.61565019302093), 'VR2_Dzse': (
    'genlogistic', (0.42722279972593824, 6.239765191502084, 0.4610324820180208), 0.0, 24.074718908396488,
    5.407124573455428, 1.2574105018515846), 'VR3_Dzse': (
    'johnsonsu', (1.1924949717173141, 1.1909251409927495, 6.562978740826758, 0.7193406257721136), -1.2628643221541276,
    13.275534621942901, 5.405279117567525, 1.2197697121016278), 'SpAbs_Dzpe': (
    'burr', (4.982962550890905, 0.23767531906959077, -3.061630113069832, 320.1034201608634), 0.0, 62475.53651772555,
    200.83242962666938, 290.3612294162449), 'SpMax_Dzpe': (
    'foldnorm', (0.00013595392890433184, -0.09442060087145232, 133.9178803587634), -2.1097560975609757,
    31258.609522632643, 101.00187053651398, 145.33615218677843), 'SpDiam_Dzpe': (
    'genlogistic', (460.79931164119216, -409.6528200691687, 83.59203593666109), 0.0, 49272.449362002546,
    151.66026655528896, 220.19987022261313), 'SpAD_Dzpe': (
    'gamma', (12.679696269516931, -304.4262217257676, 40.145506047721575), 0.0, 62517.04680341594, 201.93402831926136,
    290.8507382108617), 'SpMAD_Dzpe': (
    'mielke', (2.4263746648532845, 9.562801584072169, -0.03878998228957001, 10.24054027858475), 0.0, 129.16745207317342,
    7.614698672092874, 2.9403971937569144), 'LogEE_Dzpe': (
    'kappa3', (5.632914456962161, 0.7943169110463961, 126.45008665118061), 0.11445977776952865, 31258.609522632643,
    101.00199514468926, 145.3360668097074), 'SM1_Dzpe': (
    'gengamma', (24.095233198167776, 0.7649602185340121, -1.2212249457105564, 0.038276788160465605),
    -2.1097560975609757, 41.68252753977969, 1.249325790797199, 0.726907973681923), 'VE1_Dzpe': (
    'johnsonsu', (0.9780792247208461, 1.481855121206258, 5.493715402077669, 1.044906552919026), 1.0, 21.793347037129287,
    4.5945367714199445, 1.028702848545988), 'VE2_Dzpe': (
    'johnsonsu', (-1.286379093188669, 0.9620487393827931, 0.1711693768778867, 0.018163802544420158),
    0.04429542080717335, 1.0, 0.22398278736821992, 0.0598193449805666), 'VE3_Dzpe': (
    'johnsonsu', (1.1608868742792793, 1.1673251986588213, 2.8983279104729935, 0.4123291347758768), -2.3025850929940455,
    6.977498364932808, 2.2198044700343815, 0.7266011905064603), 'VR1_Dzpe': (
    'mielke', (1.4544845178811754, 6.118293033640773, -1.1685505354926444, 206.90057307308865), 0.0, 11844.785201502882,
    135.79607892667514, 106.65127991917471), 'VR2_Dzpe': (
    'genlogistic', (0.41740570268087307, 6.2312083465907335, 0.4533338516784926), 0.0, 24.074766669721306,
    5.407452697159472, 1.2578963416871565), 'VR3_Dzpe': (
    'johnsonsu', (1.1565747439481047, 1.1295711030138267, 6.532664939026274, 0.6603288271729798), -1.2628643221541276,
    13.275536605819749, 5.405346608775016, 1.2199439513580557), 'SpAbs_Dzare': (
    'burr', (4.983139107088302, 0.23890527344625717, -3.0439355810650817, 317.9646961265887), 0.0, 61357.98247299369,
    198.81680511958461, 285.96133976317543), 'SpMax_Dzare': (
    'mielke', (1.149625612241414, 5.164671664918993, 0.2798685041742077, 161.83523861519666), -1.7472527472527473,
    30702.201318959913, 100.04536679723452, 143.16237237519468), 'SpDiam_Dzare': (
    'foldnorm', (1.0485872235354003, -4.767639186818616e-10, 140.41402619974767), 0.0, 48386.601089924574,
    150.19344982946436, 216.80225034127588), 'SpAD_Dzare': (
    'mielke', (1.2091270340778575, 3.832514841272184, -1.0720699554102953, 311.58535736046747), 0.0, 61404.210819056505,
    200.01385995271667, 286.5051540547395), 'SpMAD_Dzare': (
    'mielke', (2.5225882367402424, 10.174417598600186, -0.017053035155260906, 10.096170002833535), 0.0,
    126.86820417160435, 7.543840243550833, 2.9105055390315524), 'LogEE_Dzare': (
    'kappa3', (5.506217984855395, 1.3727924227474197, 120.13716075854543), 0.1606313497901986, 30702.201318959913,
    100.04548821122648, 143.1622888580271), 'SM1_Dzare': (
    'gengamma', (24.55723402239039, 0.7576301379982677, -1.3035230346351208, 0.03851113638466151), -2.6206896551724133,
    46.42016492611889, 1.3638441457106698, 0.8017679178972299), 'VE1_Dzare': (
    'johnsonsu', (0.9230545935018293, 1.440388591433462, 5.451857687829779, 1.0011111667014057), 1.0, 21.79363834991341,
    4.594343068210185, 1.028622677901834), 'VE2_Dzare': (
    'norminvgauss', (1.259116450561527, 1.1139384447294214, 0.17519937848217143, 0.02621250997916013),
    0.04429601290632807, 1.0, 0.22396879844428574, 0.059797304458322424), 'VE3_Dzare': (
    'johnsonsu', (1.1541081375344002, 1.1435512529653291, 2.8815599135727155, 0.3948163322594169), -2.3025850929940455,
    6.9775117318946, 2.2197851883022377, 0.7265245137025506), 'VR1_Dzare': (
    'mielke', (1.3310207693664595, 6.23742441924394, 3.1112837799107487, 211.91769280529002), 0.0, 11844.58565341103,
    135.80797413690905, 106.65335189336483), 'VR2_Dzare': (
    'genlogistic', (0.4039218386949811, 6.269776580098197, 0.43879024218654866), 0.0, 24.07436108416876,
    5.4079141010791805, 1.257999769468904), 'VR3_Dzare': (
    'johnsonsu', (1.2578262290190012, 1.2154643263023568, 6.597588466015198, 0.722115755392471), -1.2628643221541276,
    13.275519758762638, 5.405433539017827, 1.2199586318421427), 'SpAbs_Dzp': (
    'burr', (4.917710113787418, 0.2350018848509332, -1.7389428236272213, 447.6371805594737), 0.0, 93729.88387491078,
    281.30224540842187, 424.9530304799087), 'SpMax_Dzp': (
    'mielke', (1.1941065716131738, 4.9058890686994925, -1.089177087868175, 220.50295013874242), -1.9982046678635546,
    46785.4197468504, 138.37059868499654, 211.40165581619365), 'SpDiam_Dzp': (
    'chi', (1.0473477395695392, -0.0019574929562865876, 264.94749194715814), 0.0, 73941.15137327617, 208.2873862430493,
    322.4949682944886), 'SpAD_Dzp': (
    'recipinvgauss', (0.9929177510673644, -9.567808951160941, 144.11622299439136), 0.0, 93576.10195982367,
    278.33139229356203, 423.3228618608371), 'SpMAD_Dzp': (
    'burr', (10.853400735701626, 0.2124691395255759, -0.017904460151995153, 14.435990308519116), 0.0,
    193.33905363599933, 10.496039865548129, 4.228406053809096), 'LogEE_Dzp': (
    'mielke', (1.131935218263095, 5.126573357723895, 0.44116004693351024, 223.59491670672543), 0.12714218916535405,
    46785.4197468504, 138.3707088869272, 211.40158447695023), 'SM1_Dzp': (
    'gumbel_l', (-3.3200853859835555, 2.0833415158234003), -159.0443812099844, 6.034881835754816, -4.523322224734768,
    2.9897045922888927), 'VE1_Dzp': (
    'johnsonsu', (0.9025556919274208, 1.4178405472487499, 5.419146851904639, 0.9828211832809012), 1.0,
    21.787601477591092, 4.58415524128187, 1.0288648546347672), 'VE2_Dzp': (
    'johnsonsu', (-1.26345088439055, 0.9488156009896322, 0.17130756057876007, 0.017926294973368763), 0.0442837428406323,
    1.0, 0.22341354224845497, 0.05951602498879374), 'VE3_Dzp': (
    'johnsonsu', (1.1638663849161435, 1.145489212703017, 2.8957549158140106, 0.39932943352034966), -2.3025850929940455,
    6.977234691939572, 2.2173963315046477, 0.7272248864671316), 'VR1_Dzp': (
    'mielke', (1.3562087480818033, 6.601555048312935, 1.2944917602362827, 209.2139179768584), 0.0, 11854.251738717201,
    136.91364862433653, 107.1041832309094), 'VR2_Dzp': (
    'mielke', (4.042133613724653, 17.421832819412938, -0.00643805087635158, 6.65727070962863), 0.0, 24.094007599018703,
    5.454578282884309, 1.266566018923346), 'VR3_Dzp': (
    'johnsonsu', (1.2257084975593782, 1.2076769843114725, 6.5961587744387735, 0.731633700253966), -1.2628643221541276,
    13.276335502225681, 5.414128496655198, 1.2188512905878752), 'SpAbs_Dzi': (
    'mielke', (1.1785279610758832, 4.9371219225982585, -1.1976310775749273, 317.88750939956583), 0.0, 59610.49479866316,
    199.2908298770518, 280.89062503243025), 'SpMax_Dzi': (
    'genlogistic', (557.855789054202, -267.19179379678235, 53.0286054775065), -1.5941426970389525, 29823.60562858033,
    100.15349682349722, 140.5740689496836), 'SpDiam_Dzi': (
    'kappa3', (5.48290586715126, 2.59068502683638, 187.11208828734166), 0.0, 46975.48516634577, 150.09556853732494,
    212.53026096495205), 'SpAD_Dzi': (
    'mielke', (1.1797542399565084, 5.099318052520099, -1.1720242382970398, 319.0540002362525), 0.0, 59647.05953625778,
    200.26172895881723, 281.33300992263884), 'SpMAD_Dzi': (
    'mielke', (1.9624289219176947, 8.851475777942705, 1.1416413919794337, 9.144924388186777), 0.0, 123.23772631458219,
    7.563892030367763, 2.895984727356495), 'LogEE_Dzi': (
    'burr', (5.271885069649835, 0.2238288236382036, -0.6567983751337357, 161.99166729030537), 0.1848870607158845,
    29823.60562858033, 100.1536159082583, 140.57398544260982), 'SM1_Dzi': (
    'logistic', (1.0768630955020861, 0.3177943732451681), -2.428138761051116, 36.71645849748451, 1.118768661457338,
    0.6582104371978369), 'VE1_Dzi': (
    'genlogistic', (0.35401551336264503, 5.35525926292495, 0.3239925602182053), 1.0, 21.7943704665967,
    4.593068664663012, 1.0283480216890781), 'VE2_Dzi': (
    'norminvgauss', (1.2497158897159817, 1.0997493063112853, 0.17536121251067166, 0.026443284172726116),
    0.04429750094836728, 1.0, 0.22391656181344774, 0.05981889421820086), 'VE3_Dzi': (
    'johnsonsu', (1.184086597325353, 1.1494778110227692, 2.8979305073083843, 0.40065006195055286), -2.3025850929940455,
    6.9775453244675685, 2.2194863257426753, 0.7265727872845434), 'VR1_Dzi': (
    'logistic', (131.69461647355718, 43.913491072937745), 0.0, 11845.74770941786, 136.00522501847553,
    106.74939377753822), 'VR2_Dzi': (
    'mielke', (3.489312568642394, 16.559375464085516, 0.5364660134209617, 6.105150827293244), 0.0, 24.076722986621665,
    5.415699927190199, 1.26042267452056), 'VR3_Dzi': (
    'johnsonsu', (1.1982832256187006, 1.193733822531244, 6.574805921370107, 0.7139574810171414), -1.2628643221541276,
    13.275617862574851, 5.406813078528454, 1.2201817326003224), 'BertzCT': (
    'loggamma', (2336.264184778526, -160183.8530596384, 20749.226924124516), 0.0, 25991.498752959284, 754.3554924579568,
    438.3564872236383), 'nBonds': (
    'burr', (7.282238582210205, 0.2930140697402333, 1.9469424320945616, 55.96129581102576), 0.0, 953.0,
    43.47681502073507, 20.0749239615768), 'nBondsO': (
    'dweibull', (1.136837267659986, 25.451837706833185, 8.596805828482571), 0.0, 505.0, 24.83187933015217,
    11.195125006350075), 'nBondsS': (
    'gumbel_r', (24.142983935349747, 11.062610489296485), 0.0, 826.0, 30.71164078214262, 16.51505703765052),
        'nBondsD': (
        'gennorm', (0.1262436836338754, 1.999564020104211, 2.588645848605206e-08), 0.0, 87.0, 1.937882370162417,
        1.6239616965739994), 'nBondsT': (
    'wald', (-0.01594267304868799, 0.053105637716362696), 0.0, 8.0, 0.09228901270243318, 0.32973780465337843),
        'nBondsA': (
        'exponweib', (0.49339728450286385, 0.4273534633929336, -1.634222729229571e-26, 2.7449058478313484), 0.0, 184.0,
        10.735000241789294, 7.08967231269102), 'nBondsM': (
    'genlogistic', (0.6990796644131496, 15.15914898740491, 3.705016959810367), 0.0, 194.0, 12.765174238592447,
    7.44301874730796), 'nBondsKS': (
    'maxwell', (-0.22099332123415322, 23.145526919312886), 0.0, 841.0, 36.57449789512618, 17.655985308560066),
        'nBondsKD': (
        'dgamma', (1.4771716920819538, 7.410745826032059, 2.0419194696073326), 0.0, 112.0, 6.810025498968148,
        3.8321373847406073), 'PNSA1': ('norm', (0, 1), 0, 0, 0, 0), 'PNSA2': ('norm', (0, 1), 0, 0, 0, 0),
        'PNSA3': ('norm', (0, 1), 0, 0, 0, 0), 'PNSA4': ('norm', (0, 1), 0, 0, 0, 0),
        'PNSA5': ('norm', (0, 1), 0, 0, 0, 0), 'PPSA1': ('norm', (0, 1), 0, 0, 0, 0),
        'PPSA2': ('norm', (0, 1), 0, 0, 0, 0), 'PPSA3': ('norm', (0, 1), 0, 0, 0, 0),
        'PPSA4': ('norm', (0, 1), 0, 0, 0, 0), 'PPSA5': ('norm', (0, 1), 0, 0, 0, 0),
        'DPSA1': ('norm', (0, 1), 0, 0, 0, 0), 'DPSA2': ('norm', (0, 1), 0, 0, 0, 0),
        'DPSA3': ('norm', (0, 1), 0, 0, 0, 0), 'DPSA4': ('norm', (0, 1), 0, 0, 0, 0),
        'DPSA5': ('norm', (0, 1), 0, 0, 0, 0), 'FNSA1': ('norm', (0, 1), 0, 0, 0, 0),
        'FNSA2': ('norm', (0, 1), 0, 0, 0, 0), 'FNSA3': ('norm', (0, 1), 0, 0, 0, 0),
        'FNSA4': ('norm', (0, 1), 0, 0, 0, 0), 'FNSA5': ('norm', (0, 1), 0, 0, 0, 0),
        'FPSA1': ('norm', (0, 1), 0, 0, 0, 0), 'FPSA2': ('norm', (0, 1), 0, 0, 0, 0),
        'FPSA3': ('norm', (0, 1), 0, 0, 0, 0), 'FPSA4': ('norm', (0, 1), 0, 0, 0, 0),
        'FPSA5': ('norm', (0, 1), 0, 0, 0, 0), 'WNSA1': ('norm', (0, 1), 0, 0, 0, 0),
        'WNSA2': ('norm', (0, 1), 0, 0, 0, 0), 'WNSA3': ('norm', (0, 1), 0, 0, 0, 0),
        'WNSA4': ('norm', (0, 1), 0, 0, 0, 0), 'WNSA5': ('norm', (0, 1), 0, 0, 0, 0),
        'WPSA1': ('norm', (0, 1), 0, 0, 0, 0), 'WPSA2': ('norm', (0, 1), 0, 0, 0, 0),
        'WPSA3': ('norm', (0, 1), 0, 0, 0, 0), 'WPSA4': ('norm', (0, 1), 0, 0, 0, 0),
        'WPSA5': ('norm', (0, 1), 0, 0, 0, 0), 'RNCG': (
    'norminvgauss', (1.425701613867252, 1.2376525798392237, 0.14730513344739504, 0.054597615487734466), 0.0, 1.0,
    0.24353178824265864, 0.11763348483861683), 'RPCG': (
    'burr12', (87.18673549103164, 0.24828258634048045, -1.016470080273512, 1.1138603690514741), 0.0, 1.0,
    0.147121868465346, 0.06069623403455116), 'RNCS': ('norm', (0, 1), 0, 0, 0, 0), 'RPCS': ('norm', (0, 1), 0, 0, 0, 0),
        'TASA': ('norm', (0, 1), 0, 0, 0, 0), 'TPSA': ('norm', (0, 1), 0, 0, 0, 0),
        'RASA': ('norm', (0, 1), 0, 0, 0, 0), 'RPSA': ('norm', (0, 1), 0, 0, 0, 0), 'C1SP1': (
    'gengamma', (1.742326926934923, 0.49237695557660366, -4.451246839352909e-30, 0.001079479480475857), 0.0, 8.0,
    0.08086218140993218, 0.30246753202032123), 'C2SP1': (
    'pearson3', (2.378208814626684, 0.021127344766185115, 0.025122618776299198), 0.0, 9.0, 0.042340572635464084,
    0.26938073208831426), 'C1SP2': (
    'dgamma', (2.1828560945373194, 1.5300381099919278, 0.5223775236605837), 0.0, 88.0, 1.7492631961407814,
    1.5390921572141714), 'C2SP2': (
    'mielke', (0.6471637762136164, 13.443288821462687, -5.8419341861924095e-22, 15.160707844062047), 0.0, 132.0,
    7.363240708429559, 5.023187148307056), 'C3SP2': (
    'exponweib', (4.85333116543841, 0.19588514054616668, -2.6510787487292086e-27, 0.001399690890997275), 0.0, 44.0,
    1.4371354372922736, 1.3967005219974256), 'C1SP3': (
    'gennorm', (0.11141099084806921, 2.0000532586111524, 1.2470256845658639e-09), 0.0, 74.0, 2.7126079393148084,
    2.329380637803143), 'C2SP3': (
    'gamma', (0.4352201193931916, -1.3280764027212861e-27, 1.5408579110129792), 0.0, 122.0, 1.9488596040667652,
    2.7672246320893867), 'C3SP3': (
    'beta', (0.35167832582314834, 281.88664411443546, -5.6972520067813434e-30, 95.68231870549609), 0.0, 16.0,
    0.467668850612119, 0.9370341139177937), 'C4SP3': (
    'wald', (-0.015536416916785525, 0.05169249539175232), 0.0, 16.0, 0.08263573854866303, 0.35343704687535094),
        'HybRatio': ('gausshyper', (
        1.1562959665158528, 0.6489905473179053, 2.8660435551674217, 1.4214913602047292, -0.013094321436514473,
        1.0130943214365147), 0.0, 1.0, 0.38671709666255477, 0.27143029718501527), 'FCSP3': (
    'ncx2', (0.9283130633047496, 5.547787249080117, -6.117220015921675e-19, 0.05309389152055161), 0.0, 1.0,
    0.37639618005296527, 0.2585743535232945), 'Xch-3d': (
    'halfgennorm', (0.3846591327321903, -6.303157292907032e-25, 3.9877315999083126e-05), 0.0, 2.0516964570932466,
    0.022866564893600085, 0.07805784697869772), 'Xch-4d': (
    'wald', (-0.008903174086838305, 0.029871513738075853), 0.0, 13.033221151553057, 0.04932917316042616,
    0.15074392777967774), 'Xch-5d': (
    'halfgennorm', (0.10928832639933223, -4.872498979165587e-06, 2.03738750451828e-11), 0.0, 49.493119552231185,
    0.16398066699577837, 0.3064647537271622), 'Xch-6d': (
    'burr12', (4.81264443910083, 0.5703856994798858, -0.1599182460218635, 0.39505651337897074), 0.0, 138.18000212200073,
    0.4122768482243926, 0.5358332440417409), 'Xch-7d': (
    'burr12', (3.5494714252786776, 0.8401120975333123, -0.16753207776445836, 0.5841633840310957), 0.0,
    309.1539033023314, 0.5960967223911845, 0.8844794052625666), 'Xch-3dv': (
    'gengamma', (1.6579919109924819, 0.3859131021314341, -1.1922006282904917e-32, 0.0007302341379287186), 0.0,
    11.722558054748067, 0.019881886953288776, 0.07548098929568571), 'Xch-4dv': (
    'beta', (0.434759228588128, 238.44360423367323, -3.116711102595676e-29, 5.556382112467521), 0.0, 59.33797325235329,
    0.04001160299360859, 0.23351244799174084), 'Xch-5dv': (
    'foldcauchy', (0.01945812154375801, -1.8416840527040392e-10, 0.029259525939239854), 0.0, 262.57284951625104,
    0.10393653661093905, 0.7761658538602351), 'Xch-6dv': (
    'fisk', (2.17209709449591, -0.01331402407182288, 0.13240107796722758), 0.0, 807.191566663079, 0.21102271485770407,
    2.259337506377541), 'Xch-7dv': (
    'logistic', (0.1788466393572963, 0.12733513041027306), 0.0, 2200.5921030640325, 0.2797010483804966,
    6.026428377177678), 'Xc-3d': (
    'mielke', (2.309414573147547, 4.9049439774886165, -0.08397734379377053, 2.157647497411287), 0.0, 50.56360320907019,
    1.7199757524183525, 0.9790377240881489), 'Xc-4d': (
    'pareto', (2.895064011092381, -0.05523683611646546, 0.05523683547530853), 0.0, 26.15074560802202,
    0.07382488625139179, 0.15869572659730313), 'Xc-5d': (
    'kappa3', (3.9621697773555695, -6.38693701917401e-11, 0.5007562972304629), 0.0, 29.406393299214216,
    0.4396444060205586, 0.3862537058469509), 'Xc-6d': (
    'gilbrat', (-0.0026842408310945214, 0.007517132815878609), 0.0, 38.29438801795436, 0.04434652093715357,
    0.1497379909815042), 'Xc-3dv': (
    'burr', (3.6135928404610604, 0.6621102866178235, -0.052846912726090836, 0.9898377067517645), 0.0,
    168.25330570987947, 0.9072529532228041, 1.0203051045666287), 'Xc-4dv': (
    'exponnorm', (3034.566129644242, -4.420139393293013e-05, 1.1758136323538004e-05), 0.0, 168.96477841821394,
    0.03960824432524914, 0.5437841965382956), 'Xc-5dv': (
    'truncnorm', (-36.47439378327396, 51.533201657687414, 0.15866625125188888, 0.22382283965205457), 0.0,
    496.1540128302938, 0.17612813016819256, 1.8488819077256584), 'Xc-6dv': (
    'genhalflogistic', (0.00017455153953181446, -0.00018780646282678742, 0.7544804926905608), 0.0, 690.3548378676537,
    0.030621782864194893, 2.055102352676353), 'Xpc-4d': (
    'mielke', (2.0704674964468417, 5.765689300695758, -0.18129292318335433, 5.127477437539494), 0.0, 91.664661911565,
    3.770950223125036, 2.0552791037007476), 'Xpc-5d': (
    'mielke', (1.5863108400581374, 5.505590519694569, -0.10390956004600041, 8.368033110077075), 0.0, 141.93514978148647,
    5.759078619817923, 3.4471867070819666), 'Xpc-6d': (
    'rayleigh', (-1.3368731740948798, 7.934038358911076), 0.0, 273.7510871789938, 8.439785318103725, 6.004716304727657),
        'Xpc-4dv': ('fisk', (3.923078396093124, -0.5930193553758589, 2.0973229497888504), 0.0, 868.9931077563617,
                    1.7545516360648217, 3.710670193577047), 'Xpc-5dv': (
    'mielke', (1.349857964622335, 3.6804068374439383, -0.016087155912031102, 3.1123868634245717), 0.0,
    3375.366498220913, 2.3972065913625755, 10.81373981724153), 'Xpc-6dv': (
    'kappa3', (3.474249087648346, -1.6851010464818948e-09, 3.083508692112839), 0.0, 10553.835679897194,
    3.1296649811208996, 27.61243855813578), 'Xp-0d': (
    'burr', (8.778215039680449, 0.2575321079002442, -0.22988991816283666, 22.613936252589294), 2.0, 365.8937756248287,
    16.448139894699917, 7.3558023290187355), 'Xp-1d': (
    'burr', (9.942311351563568, 0.20982544112406903, -0.014097706912985855, 15.40870081628523), 0.0, 233.11860171723558,
    11.045476438829633, 4.937072286146515), 'Xp-2d': (
    'gennorm', (1.296449547827243, 10.166895228874985, 4.439800326426358), 0.0, 214.56931708782938, 10.025820020548752,
    4.570321946575723), 'Xp-3d': (
    'mielke', (2.1139456778011594, 8.314954188230182, -0.5362714022521082, 12.6396481941938), 0.0, 170.65147242283217,
    8.214651832338266, 3.8210288263498913), 'Xp-4d': (
    'mielke', (1.7219109242827375, 8.518826852058913, -0.05965806935583727, 9.90540839935792), 0.0, 142.6320380489936,
    6.630437249661058, 3.2870636630251644), 'Xp-5d': (
    'foldnorm', (2.0752592690219562, -1.4383044307475278e-07, 2.505592457996203), 0.0, 119.54808366852082,
    5.092738977239282, 2.8384173975906), 'Xp-6d': (
    'foldnorm', (1.4815751062135587, -2.669765975848203e-08, 2.2457467008602974), 0.0, 92.09950238857499,
    3.393438131346073, 2.146825035756556), 'Xp-7d': (
    'nakagami', (0.34404791865559836, -2.3200224368653123e-24, 2.8399638775959684), 0.0, 72.56023544790465,
    2.3590045822770196, 1.7009576371327084), 'AXp-0d': (
    'johnsonsu', (-0.5689047383023945, 1.3632466697790835, 0.7040872031252419, 0.026548226475398007),
    0.5723614639131599, 1.0, 0.7190813826757992, 0.028089100848888007), 'AXp-1d': (
    'johnsonsu', (-0.2521225006268228, 0.9289139469020591, 0.4417442041642873, 0.011178388499590429),
    0.26342265869910025, 1.0, 0.44721823220375434, 0.023524578937351184), 'AXp-2d': (
    'johnsonsu', (-0.16224878092699246, 1.076758279228507, 0.2864947287467777, 0.016684980923367083),
    0.11969624925631092, 0.7071067811865476, 0.29079767899408676, 0.025413791673309396), 'AXp-3d': (
    'johnsonsu', (-0.26966733508998775, 1.0287756182834729, 0.18097648425191215, 0.012883932900980298),
    0.06204626610052336, 0.5, 0.1865338797313067, 0.02207894355342886), 'AXp-4d': (
    'johnsonsu', (-0.42850310294075233, 1.09467542401099, 0.11408600182861212, 0.011505372859630006),
    0.034335973693674145, 0.3535533905932738, 0.1212497456156849, 0.01929962309146757), 'AXp-5d': (
    'johnsonsu', (-0.5535338861408583, 1.0114126370735583, 0.07218457096461697, 0.007966887436269568),
    0.018914222981861694, 0.25, 0.07979231485101906, 0.016695461109794685), 'AXp-6d': (
    'johnsonsu', (-0.8315973223938025, 1.0761100896292861, 0.04442563523713902, 0.00628637408282055),
    0.010017995530172574, 0.1767766952966369, 0.052886523482301565, 0.01380949591524242), 'AXp-7d': (
    'johnsonsu', (-0.8466400727310399, 0.9945772188946054, 0.02846351490935118, 0.003813136730382502),
    0.00481396112117947, 0.125, 0.03457746527034457, 0.010274726826388138), 'Xp-0dv': (
    'burr', (9.27707655951379, 0.23940362947487875, -0.14673839052967896, 18.699804731190355), 0.408248290463863,
    279.59460123012485, 13.545788322386729, 5.991159207591209), 'Xp-1dv': (
    'burr', (8.533958184752807, 0.25198778648793396, -0.10713201574598606, 11.186806209456137), 0.0, 193.9654074956451,
    8.07235298037669, 3.7130174812334924), 'Xp-2dv': (
    'logistic', (6.196252056715924, 1.5896560035418246), 0.0, 177.8830908920191, 6.302737009774327, 3.155597576179923),
        'Xp-3dv': ('burr', (5.913611155039497, 0.3155435301548666, -0.015923228024096063, 6.234246708478874), 0.0,
                   327.64861397543564, 4.521945862897209, 2.816930556113518), 'Xp-4dv': (
    'mielke', (1.5745853272091948, 5.619289349709604, -0.040696158383089875, 4.657179580325742), 0.0, 655.6055886731199,
    3.1857961796930025, 2.8932549349177705), 'Xp-5dv': (
    'logistic', (1.99829190024027, 0.7911927224609088), 0.0, 1259.3954340715368, 2.130526813615542, 3.0946882650370053),
        'Xp-6dv': (
        'norminvgauss', (30.755670320261316, 30.694441979722853, -0.36931058038110587, 0.10745922900848104), 0.0,
        1917.595340000578, 1.2610118807384751, 3.931963016831504), 'Xp-7dv': (
    'chi', (0.6473328860794729, -1.327159557567417e-29, 1.1936946482788922), 0.0, 2958.159250021719, 0.7745585775101377,
    5.037752270265705), 'AXp-0dv': (
    'mielke', (8.442522869993226, 8.971208468668864, 0.38268351245588655, 0.2073764323262537), 0.40237157840738186,
    6.519202405202649, 0.5913471777297175, 0.047966031651476476), 'AXp-1dv': (
    'burr', (14.401987089219846, 2.4786223939955976, -0.04273250397764029, 0.3365727771416246), 0.17580251839037933,
    9.0, 0.32695082218450605, 0.05143092466917053), 'AXp-2dv': (
    'genlogistic', (12.181143567379694, 0.10737144841219859, 0.025034262862792374), 0.06900655593423542,
    11.24540722577308, 0.1830765995704308, 0.04915166911629311), 'AXp-3dv': (
    'invgamma', (12.698747499448913, 0.023169066289780722, 0.9222329140374808), 0.035714285714285705, 13.5,
    0.10213858431951682, 0.03978693645979606), 'AXp-4dv': (
    'genextreme', (-0.0979711874026754, 0.04906781843998517, 0.011821761285723544), 0.01632993161855452,
    16.534055763786455, 0.057482226498265766, 0.03787633283080722), 'AXp-5dv': (
    'norminvgauss', (4.27416468194531, 3.808132762132021, 0.017590161246296906, 0.007574676935877818),
    0.006804138174397717, 6.890625, 0.03250578808095123, 0.021404615291743347), 'AXp-6dv': (
    'exponnorm', (4.644131234724837, 0.010414164811339874, 0.001753556026313978), 0.0033333333333333335,
    9.492187500000002, 0.018627627345075507, 0.019632180402639345), 'AXp-7dv': (
    'exponnorm', (5.331114005011084, 0.00525986408257091, 0.0009866778498186088), 0.001388888888888889,
    11.390625000000002, 0.01052773866199337, 0.018112796824385793), 'SZ': (
    'mielke', (2.197267379870927, 9.185822577273477, -0.16956895858846852, 39.78893463361583), 0.5, 654.6666666666667,
    28.878921288654144, 12.89572132341798), 'Sm': (
    'foldcauchy', (3.3118533665907393, 4.9178253218900885, 7.429648009616942), 0.5778036799600367, 632.3173835917075,
    27.413907339863922, 12.261773702260667), 'Sv': (
    'mielke', (2.231290380640946, 8.849097069921305, -0.22710390555880788, 36.56622191789103), 0.7290000000000001,
    567.6133783838795, 26.68491216837421, 11.964655631329322), 'Sse': (
    'mielke', (2.1734305857597898, 7.215405366229458, 1.9795743095049902, 54.04469419151688), 0.16205389657683905,
    959.9373634377275, 42.14572453037392, 19.41994565889605), 'Spe': (
    'mielke', (1.8046073114105141, 6.961917619638157, 6.249193380810588, 49.2148082279234), 0.3215686274509804,
    927.2745098039218, 40.75064361519805, 18.738708087290807), 'Sare': (
    'mielke', (2.238332147436524, 7.565787671942385, 1.0666164085459657, 53.70773035532322), 0.364, 942.5120000000002,
    41.287841192208624, 19.007928033640628), 'Sp': (
    'mielke', (2.205125175334695, 8.542685931622962, -0.09734226952126801, 38.73668728161745), 0.7328101796407186,
    803.0993203592815, 28.443443264488884, 12.84684067387702), 'Si': (
    'burr', (7.128726627458214, 0.2662234499617392, 5.444809159127036, 57.73369733755827), 0.38548380593767484,
    1077.0243593865173, 46.97955368287957, 21.84772805374602), 'MZ': (
    'dgamma', (1.2227306363948327, 0.6845856102961949, 0.06146250377143489), 0.33333333333333337, 14.666666666666666,
    0.6971552239175861, 0.11802913669458266), 'Mm': (
    'burr', (6.652380820061226, 0.5978436377294367, 0.33530076132527475, 0.3559179352554347), 0.26713845641495304,
    18.81608525518275, 0.6624058954492934, 0.13251414241511136), 'Mv': (
    'mielke', (3.452193929875371, 9.753842872563325, 0.47763999824876424, 0.19740177748997187), 0.39267631793201724,
    4.613308976185631, 0.6406136090973987, 0.04947875382186457), 'Mse': (
    'burr12', (180.87698650967192, 0.5105699083418003, -0.36657574442727303, 1.3692787191704374), 0.16205389657683905,
    1.4024034959941734, 1.0129095452444117, 0.020139979501092628), 'Mpe': (
    'johnsonsu', (-0.5640208196494025, 1.630554243009359, 0.9658695249394986, 0.03200586906132408), 0.3215686274509804,
    1.4823529411764707, 0.9796327657575736, 0.026411808097434243), 'Mare': (
    'burr12', (13.055778375135082, 0.7658564893945807, 0.8253844795925315, 0.15967938522636665), 0.364,
    1.545142857142857, 0.9926694745398255, 0.027807112515208596), 'Mp': (
    'mielke', (3.3027694274024344, 7.396103605701476, 0.5458340031413521, 0.15913894817438196), 0.3664050898203593,
    25.784431137724553, 0.682587297236826, 0.0991924549141476), 'Mi': (
    'burr12', (237.7595001121954, 0.6144514565906911, -0.3858328953801538, 1.5085146654247505), 0.38548380593767484,
    1.4576725309272398, 1.1285758964954824, 0.015540915342349896), 'SpAbs_Dt': (
    'logistic', (413.3006251801462, 162.89863445058037), 0.0, 144648.3205469764, 438.0390565134294, 501.7724326887513),
        'SpMax_Dt': ('logistic', (205.21234512294194, 79.88629530220373), 0.0, 62881.50769172604, 218.549007655118,
                     242.45175103342746), 'SpDiam_Dt': (
    'foldnorm', (0.011564515378767102, -0.00022647195173298545, 402.31991939225395), 0.0, 68485.49208782625,
    307.5952401903529, 336.33560632170946), 'SpAD_Dt': (
    'logistic', (413.21671689508145, 162.69003763700556), 0.0, 144648.32054697638, 438.0390565134294,
    501.7724326887513), 'SpMAD_Dt': (
    'burr', (9.28836269171246, 0.26813681429664116, -0.11103269810674087, 22.00645884310259), 0.0, 318.60863556602726,
    16.72967855804586, 6.407556477744869), 'LogEE_Dt': (
    'kappa3', (5.637217027569064, 0.6931471804812289, 276.1157220455618), 0.6931471805599453, 62881.50769172604,
    218.54907463451096, 242.45169093388216), 'SM1_Dt': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'VE1_Dt': ('johnsonsu', (0.8671751628820716, 1.4298628424417394, 5.41214272833281, 1.0167287774435363), 1.0,
                     21.801119358922005, 4.609955697198212, 1.0300555439848516), 'VE2_Dt': (
    'johnsonsu', (-1.329625052831381, 0.9611805534388125, 0.17040746003356594, 0.017981685349790874),
    0.04431121820919107, 1.0, 0.22481442465852056, 0.060248845087969106), 'VE3_Dt': (
    'johnsonsu', (1.1173411293983786, 1.15656410157658, 2.8923909678043733, 0.4235393814136514), -2.3025850929940455,
    6.977854938714649, 2.223294689104376, 0.7258897083684771), 'VR1_Dt': (
    'mielke', (1.4068750207108423, 6.453942258262806, -0.8105541179098739, 209.2562377653913), 0.0, 11841.29114229994,
    134.2692484690632, 105.77791501656243), 'VR2_Dt': (
    'genlogistic', (0.37739629044579437, 6.247027460409878, 0.42078146344402617), 0.0, 24.06766492337386,
    5.339111061078325, 1.257248303268567), 'VR3_Dt': (
    'johnsonsu', (1.12436395295844, 1.167503681238435, 6.519429439417911, 0.7151280104499216), -1.2628643221541276,
    13.275241575171568, 5.391684258068463, 1.2252769093378724), 'DetourIndex': (
    'hypsecant', (4268.184682733074, 3359.0162887816305), 0.0, 14261540.0, 3406.4127088454156, 32550.321059632555),
        'SpAbs_D': (
        'beta', (92.05797438151617, 29393905.298729006, -1381.7814135088297, 521178039.099203), 0.0, 70098.37510279981,
        254.60432785015615, 332.6178997350903), 'SpMax_D': (
    'rice', (0.003510931026342429, -31.270027574256545, 132.133629488038), 0.0, 35049.18755139991, 127.28261951693176,
    166.21436978894644), 'SpDiam_D': (
    'beta', (20.60426361469237, 16938666.04460718, -349.649085083975, 438097552.74289167), 0.0, 55232.27045520581,
    189.14916031133126, 251.09047184973343), 'SpAD_D': (
    'skewnorm', (74.32719378724286, 22.04929708496568, 321.09750359025986), 0.0, 70098.37510279982, 254.60432785015615,
    332.6178997350903), 'SpMAD_D': (
    'burr', (11.32448033937321, 0.21164259252649098, -0.018290209377767555, 13.118097547419794), 0.0,
    144.83135351818146, 9.63856336073486, 3.580948523612959), 'LogEE_D': (
    'burr', (5.422752599822208, 0.21463490385234732, -1.182439162677145, 207.0914859238716), 0.6931471805599453,
    35049.18755139991, 127.28268907252998, 166.21431700309788), 'VE1_D': (
    'johnsonsu', (0.8950951976548226, 1.4427808331753231, 5.425436973574945, 1.0316517532622766), 1.0,
    21.795064454771335, 4.594402967035201, 1.0293478698570764), 'VE2_D': (
    'norminvgauss', (1.0962073362906097, 0.9564127375315481, 0.17780387095255729, 0.026264616418107324),
    0.044298911493437676, 1.0, 0.22394431129438816, 0.059706291417172284), 'VE3_D': (
    'johnsonsu', (1.1926397799520045, 1.1633861829201275, 2.9068121957997244, 0.4068046429331412), -2.3025850929940455,
    6.9775771665034165, 2.2197130193253143, 0.7269116961452423), 'VR1_D': (
    'kappa3', (6.6043440224778465, 3.7224192704220105, 170.5887584653657), 0.0, 11850.218234286198, 136.23208272642896,
    106.87546500679314), 'VR2_D': (
    'burr', (16.734480284821217, 0.2056894247948951, 0.6711971698978827, 5.9864682624528704), 0.0, 24.08580941928089,
    5.4257512181131355, 1.2588913918381377), 'VR3_D': (
    'johnsonsu', (1.17327183792617, 1.1605824331113677, 6.558574357909055, 0.6799280301462445), -1.2628643221541276,
    13.27599518628742, 5.408918848375978, 1.219046687232216), 'NsLi': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    2.6139383032142292e-06, 0.0016167657438666784), 'NssBe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssssBe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssBH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 3.0,
    9.148784061249802e-06, 0.0041219552727610595), 'NsssB': (
    'genhalflogistic', (0.0015444968925378932, -1.3584497088156848e-05, 0.009029581007627144), 0.0, 4.0,
    0.00027969139844392254, 0.01953347805668293), 'NssssB': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 2.0,
    0.00023786838559249486, 0.01583923911492284), 'NsCH3': (
    'gennorm', (0.26707409337466387, 1.0, 0.002194605143571955), 0.0, 48.0, 1.4884967110121299, 1.4463825206232854),
        'NdCH2': ('exponnorm', (2605.1161668029536, -2.0760774877887215e-05, 5.631440237262134e-06), 0.0, 6.0,
                  0.017474177556987124, 0.1436576722770465), 'NssCH2': (
    'nakagami', (0.24413038327447983, -4.941919879925495e-27, 4.459467080533438), 0.0, 87.0, 3.071113498508095,
    3.0516195948726277), 'NtCH': (
    'wald', (-0.0037530076448386873, 0.012419881961504411), 0.0, 4.0, 0.02183814755420328, 0.15316734417977335),
        'NdsCH': (
        'gilbrat', (-0.008408590290246837, 0.02304288709566581), 0.0, 32.0, 0.31124424770202147, 0.7569665602249613),
        'NaaCH': ('fisk', (0.36038456949086795, -1.002589753605599e-27, 2.218285488256617), 0.0, 80.0, 5.38197088334124,
                  3.974084018143937), 'NsssCH': (
    'betaprime', (0.6466945408305884, 2.2198837054012754, -4.681932000218877e-30, 0.3308785645420841), 0.0, 70.0,
    0.9121716730120019, 1.6381488679330334), 'NddC': (
    'genhalflogistic', (1.3875652104787876e-10, -6.622761125939263e-07, 0.0013420430009228666), 0.0, 3.0,
    0.0002783844292923154, 0.019633603893163026), 'NtsC': (
    'halfgennorm', (0.5116143139907179, -1.4346609916608515e-20, 0.002182734492381738), 0.0, 9.0, 0.10242717241144957,
    0.3820378015316897), 'NdssC': (
    'dgamma', (0.6281093294422824, 0.9999999999999998, 0.8023407144115251), 0.0, 87.0, 1.3275617575598364,
    1.484824662317108), 'NaasC': (
    'bradford', (808.9537294760895, -4.1340081213016354e-05, 33.358310234751066), 0.0, 60.0, 3.230095840047887,
    2.3194426705560534), 'NaaaC': (
    'pareto', (3.3688448501455306, -0.20645021920297335, 0.20645021884355513), 0.0, 20.0, 0.4930737169810581,
    0.9963026394806761), 'NssssC': (
    'gilbrat', (-0.0074355969637799404, 0.020377311258839403), 0.0, 17.0, 0.2487711222552014, 0.5916557577062307),
        'NsNH3': ('halflogistic', (-1.886847541592249e-08, 0.00459979079431521), 0.0, 8.0, 0.004167924624475089,
                  0.08133570463659119), 'NsNH2': (
    'gengamma', (1.7489164341818746, 0.5464339491741594, -3.8471963328981034e-30, 0.006730514858089756), 0.0, 16.0,
    0.1025617902340651, 0.3783766492406949), 'NssNH2': (
    'genhalflogistic', (1.867693056127466e-06, -4.605636990766104e-05, 0.00338167327060121), 0.0, 4.0,
    0.0027812303546199397, 0.05432534322904044), 'NdNH': (
    'pearson3', (2.2329194919160207, 0.009742426748005248, 0.010877027292092466), 0.0, 8.0, 0.022767402620995938,
    0.15959141577305885), 'NssNH': (
    'alpha', (1.5195520912889303e-07, -0.04280185599387559, 0.061724789672901015), 0.0, 62.0, 0.6761448069541215,
    0.951129976917317), 'NaaNH': (
    'wald', (-0.017103784217681828, 0.05703991776460298), 0.0, 10.0, 0.09862127824196966, 0.3251597828646545), 'NtN': (
    'wald', (-0.010164995692837077, 0.03376047545929227), 0.0, 8.0, 0.05977946202535782, 0.2605022626376763),
        'NsssNH': ('halflogistic', (-3.610355405095659e-09, 0.001700402233660383), 0.0, 8.0, 0.0016964459587860347,
                   0.046491536715517374), 'NdsN': (
    'wald', (-0.025395272548593105, 0.08505514802887361), 0.0, 11.0, 0.1412833652887291, 0.40477885851179246), 'NaaN': (
    'halfgennorm', (0.11915942078407574, -6.9296131358427125e-18, 9.396057738105028e-10), 0.0, 23.0, 0.6302571200411957,
    0.9706158945149579), 'NsssN': (
    'halfgennorm', (0.2834753192262017, -4.444137062627731e-27, 0.0008895116025479238), 0.0, 18.0, 0.5296714671643605,
    0.7671309066130243), 'NddsN': (
    'frechet_r', (0.8133861525335763, -4.905547993024919e-30, 0.010517700528890294), 0.0, 8.0, 0.04734103660951291,
    0.22955032919402885), 'NaasN': (
    'gilbrat', (-0.00853697261711751, 0.023433084545637008), 0.0, 20.0, 0.24785101597247, 0.5257082088057872),
        'NssssN': ('halflogistic', (-8.294968042634555e-09, 0.002700501186443047), 0.0, 4.0, 0.003067456598821898,
                   0.060578122055642926), 'NsOH': (
    'gilbrat', (-0.013962515210686827, 0.03854113402455798), 0.0, 32.0, 0.3148031247018477, 0.7778837447510571),
        'NdO': (
        'gennorm', (0.09355797824079351, 0.9999822088431332, 9.573471262344977e-13), 0.0, 87.0, 1.525754480616994,
        1.45293501623905), 'NssO': (
    'kappa3', (1.0560062384862468, -2.6715990419052687e-10, 0.03362206181600307), 0.0, 59.0, 0.7868869171080956,
    1.045414519413223), 'NaaO': (
    'halfgennorm', (0.46362150280471415, -8.088239126827826e-20, 0.001674269252307879), 0.0, 4.0, 0.12880050292172954,
    0.35705292158561464), 'NsF': (
    'wald', (-0.03231126050105819, 0.10794373607062131), 0.0, 36.0, 0.20560715905422483, 0.7349990132298267),
        'NsSiH3': (
        'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0,
        0.0, 0.0), 'NssSiH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NsssSiH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 6.0,
    1.5683629819285374e-05, 0.0077537303923777955), 'NssssSi': (
    'genhalflogistic', (8.811582242842148e-09, -1.320332312799731e-05, 0.005368212075772061), 0.0, 6.0,
    0.001095240149046762, 0.041426536353256285), 'NsPH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssPH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    2.6139383032142292e-06, 0.0016167657438666784), 'NsssP': (
    'gompertz', (213848777095.25092, -1.8916270827195007e-12, 1304467267.1949177), 0.0, 4.0, 0.00023002657068285217,
    0.020766485205906356), 'NdsssP': (
    'halflogistic', (-1.8651773051013377e-10, 0.004599792395592446), 0.0, 19.0, 0.006537459696338788,
    0.09779307176396004), 'NsssssP': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 2.0,
    3.528816709339209e-05, 0.006763333131785856), 'NsSH': (
    'wald', (-0.001846951348220232, 0.00610630806960653), 0.0, 6.0, 0.012578271115066871, 0.11505746781382248), 'NdS': (
    'mielke', (0.7202912245017032, 2.0326095629482808, -9.021809302205356e-30, 0.01942379744339167), 0.0, 6.0,
    0.03593903773089244, 0.1932959006158938), 'NssS': (
    'burr', (2.9852741383758756, 0.22559585707621857, -1.8367459979874606e-29, 0.024284213660616595), 0.0, 19.0,
    0.11366972105357397, 0.34472417189561266), 'NaaS': (
    'halfgennorm', (0.4267797511611248, -1.501543412287615e-22, 0.0008010086335828767), 0.0, 8.0, 0.11310118947262487,
    0.33842539609238975), 'NdssS': (
    'halflogistic', (-3.250194873777078e-09, 0.0033000146329452114), 0.0, 8.0, 0.0024688647273858394,
    0.053479791103109894), 'NddssS': (
    'wald', (-0.025703225238154735, 0.08618379666724674), 0.0, 21.0, 0.14015153000343733, 0.37902602838420135),
        'NsCl': (
        'exponweib', (1.7896577652632464, 0.5081906611531315, -1.5875552446779992e-31, 0.013665838793193524), 0.0, 12.0,
        0.1565291604422261, 0.46289603276093266), 'NsGeH3': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssGeH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NsssGeH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssssGe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 3.0,
    3.920907454821344e-05, 0.0072302993515315625), 'NsAsH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssAsH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NsssAs': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 4.0,
    2.7446352183749406e-05, 0.007139400787911353), 'NsssdAs': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 2.0,
    0.0001359247917671399, 0.012522692308119563), 'NsssssAs': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NsSeH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.0011432267681605224), 'NdSe': (
    'genhalflogistic', (0.0022497233566978955, -0.0035956141611125352, 0.005539902011231192), 0.0, 2.0,
    1.960453727410672e-05, 0.004713607030654897), 'NssSe': (
    'genhalflogistic', (1.3875652104787876e-10, -6.622761125939263e-07, 0.0013420430009228666), 0.0, 2.0,
    0.0001973523418926743, 0.016605166155213583), 'NaaSe': (
    'genhalflogistic', (1.3875652104787876e-10, -6.622761125939263e-07, 0.0013420430009228666), 0.0, 4.0,
    9.148784061249803e-05, 0.011083624417404668), 'NdssSe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.5683629819285374e-05, 0.003960225226302296), 'NddssSe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.0011432267681605224), 'NsBr': (
    'wald', (-0.00618374999162757, 0.020491278090060145), 0.0, 10.0, 0.04054871792861073, 0.21734849585839525),
        'NsSnH3': (
        'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0,
        0.0, 0.0), 'NssSnH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.001143226768160522), 'NsssSnH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssssSn': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 2.0,
    0.0002404823238957091, 0.017184795504023364), 'NsI': (
    'genhalflogistic', (5.6970262525008867e-11, -1.5722665775538185e-05, 0.004026147005362659), 0.0, 6.0,
    0.0018598171027369242, 0.05914314362206175), 'NsPbH3': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssPbH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NsssPbH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'NssssPb': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.0455753212856917e-05, 0.0032335188092976444), 'SsLi': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0,
    1.4722222222222223, 2.5776336045584764e-06, 0.001777501224389756), 'SssBe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssssBe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssBH': ('betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
                    -0.18536776234828167, 3.2629166666666665, 3.6915359023356768e-06, 0.0037406393434180263), 'SsssB': (
    'argus', (92.98257398071645, -16.789193137306683, 16.790162586075226), -3.666666666666667, 0.7777777777777777,
    -0.0003807764815894114, 0.027180926265312606), 'SssssB': (
    'argus', (92.99028596328117, -66.52633994766913, 66.53018128137066), -7.83925925925926, 0.0, -0.001077359078932151,
    0.07615225403281219), 'SsCH3': (
    'mielke', (0.26291283843025026, 0.6524447617441068, -8.942638479651348e-29, 0.28742205036731283),
    -6.481327160493821, 102.2753537530557, 2.7148864257304095, 2.689896803438685), 'SdCH2': (
    'expon', (0.0, 0.07349866942364282), 0.0, 24.207353010910143, 0.06476920156763967, 0.5334301668070346), 'SssCH2': (
    'johnsonsu', (-1.49589740336001, 0.6717629819067898, -0.13058682085945172, 0.21134669060048317), -75.00150241553554,
    87.9345139307631, 2.035842965653939, 2.7613832774659026), 'StCH': (
    'pearson3', (2.3171663772754565, 0.03826607307191192, 0.04433442895630002), 0.0, 19.84722222222222,
    0.11117610881066838, 0.7794591245992146), 'SdsCH': (
    'burr12', (156.74543139909065, 0.01554143734232647, -0.3442721373564575, 0.33573051417562083), -1.0624999999999996,
    81.05531594755861, 0.4997984845549038, 1.3178134269667554), 'SaaCH': (
    'beta', (0.1875632652686996, 5.812714948882396, -1.787447493695929e-26, 189.23693911569492), -7.663441982613373,
    178.30807220747212, 9.57571982819388, 7.367101268832017), 'SsssCH': (
    'gennorm', (0.38496625561120923, -1.6724323807881734e-21, 0.008824127829421092), -148.321605341063,
    15.889047152959272, -0.11997588243288887, 1.827123349080767), 'SddC': (
    'genhalflogistic', (0.0022497233566978955, -0.004146179839653633, 0.006388179878836279), 0.0, 10.52724111866969,
    0.0006455706425752359, 0.04682459170769663), 'StsC': (
    'wald', (-0.0365549807387452, 0.121679859175498), -1.033024691358026, 31.57807192206543, 0.23089611734536872,
    0.8988390179959245), 'SdssC': (
    'gennorm', (0.3773201248173059, 3.837164053406075e-21, 0.012921406842122247), -134.54765325887593,
    62.34459099250385, -0.2737863603307131, 1.208596573219865), 'SaasC': (
    'johnsonsu', (-1.5349190428565287, 1.915901503538688, -0.5169297427271116, 2.3201608918247185), -56.56330706310413,
    57.08430524057581, 1.842256324514567, 1.8665173225959388), 'SaaaC': (
    'reciprocal', (0.009066879136953455, 8.572502885986216, -0.024184683131448757, 0.7801254723802082),
    -6.645513991651724, 26.644604897249597, 0.3684288447938521, 0.82201174697919), 'SssssC': (
    'norminvgauss', (0.02736163201264568, -0.027338134532543766, 0.009103720901695447, 0.011676762679877321),
    -129.64177721088433, 3.9397016460905356, -0.2689911936434532, 1.417512694686525), 'SsNH3': (
    'halflogistic', (-3.942208036594189e-09, 0.014067132576709234), 0.0, 30.287808638257932, 0.01546928803028391,
    0.3045974973952074), 'SsNH2': (
    'wald', (-0.09925106151476659, 0.3309456705381509), 0.0, 94.11012961627455, 0.5674480230027809, 2.1098325308058454),
        'SssNH2': (
        'halflogistic', (-1.3715376658679423e-08, 0.0066466966920016805), 0.0, 10.237879595308904, 0.005476649419937665,
        0.10827006709787905), 'SdNH': (
    'wald', (-0.02682376598888972, 0.08877185052980467), 0.0, 64.88267870703203, 0.16531190690333178,
    1.165249613714325), 'SssNH': (
    'alpha', (2.1357692219730266e-10, -0.05591084475738089, 0.07977964088108569), -0.5011574074074074,
    148.26048187173794, 1.872615725591354, 2.527002723191589), 'SaaNH': (
    'gengamma', (1.7316961647898537, 0.2957134828933718, -8.798130953014241e-30, 0.003101386068615518), 0.0,
    32.918096991017194, 0.2798728606738251, 0.925761262790398), 'StN': (
    'pearson3', (2.8177483982623377, 0.16449821958719316, 0.23175729737940992), 0.0, 78.14363742119318,
    0.5308221280722005, 2.3266621869481803), 'SsssNH': (
    'genhalflogistic', (0.0012518051509700567, -6.310326731660688e-08, 0.007035722469166129), -1.873903376165281,
    12.182263615685992, 0.0021548826156886527, 0.06113631348170719), 'SdsN': (
    'halfgennorm', (0.3604372221804163, -5.597239996814558e-14, 0.0007643744869299304), 0.0, 47.79802056222574,
    0.5781130855552645, 1.6722716369648067), 'SaaN': (
    'betaprime', (0.7334031405908654, 2.1010310343516814, -2.9673876670735295e-30, 0.5922175698371288), 0.0,
    94.11720918637928, 2.62942753883278, 4.058836419977124), 'SsssN': (
    'gennorm', (0.22988462127082615, 1.552964046177573e-27, 5.369675462007432e-05), -14.561111111111114,
    32.821124713942346, 0.9626944828084159, 1.4669246631896888), 'SddsN': (
    'genextreme', (1.0645318706123676, -0.016517540570334, 0.017583448361253327), -18.43035995910455,
    0.024375000000000036, -0.027345803890298528, 0.14895329975316254), 'SaasN': (
    'alpha', (1.6518677604776988, -0.05761231197465942, 0.1271848871501733), -1.2987731481481477, 30.259402922699206,
    0.40137040819319286, 0.8572883914676798), 'SssssN': (
    'hypsecant', (1.2519871204142749e-05, 0.004229318829934055), -2.166921817850591, 7.304753086419753,
    0.0025358061266037377, 0.05682833522496408), 'SsOH': (
    'gilbrat', (-0.13074421031394173, 0.3608254626500216), 0.0, 331.75897549187647, 3.008244811118855,
    7.711134327561477), 'SdO': (
    'nakagami', (0.2084534855283275, -2.6984347565292515e-27, 22.061871508475477), 0.0, 1264.934010630296,
    18.652307476950067, 18.6884617966101), 'SssO': (
    'alpha', (3.877090676228039e-08, -0.09553232522876841, 0.13594075975133157), 0.0, 357.5228788449419,
    4.188179259137251, 5.7121020697371305), 'SaaO': (
    'frechet_r', (0.6739342290550809, -7.660813081316288e-29, 0.05762599903367677), 0.0, 26.908487223475294,
    0.6789560995540567, 1.888924799483957), 'SsF': (
    'halfgennorm', (0.2753384017909205, -6.76157747385277e-13, 0.0037437511553147116), 0.0, 480.44693220118995,
    2.687728428084784, 9.556921929638278), 'SsSiH3': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssSiH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SsssSiH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -2.2523148148148153, 0.0, -1.1259720764588574e-05, 0.004503229090421628), 'SssssSi': (
    'loggamma', (0.00010914411002358967, 9.052216993898809e-06, 9.91848932424297e-07), -11.305941358024691, 0.0,
    -0.002199824955323657, 0.08698039702661457), 'SsPH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssPH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0,
    0.9455709876543208, 2.374518900218052e-06, 0.001469909327276509), 'SsssP': (
    'argus', (92.98344951379394, -28.399853575216078, 28.40149350564701), -5.859567901234567, 0.4216820987654324,
    -0.0001779634176766294, 0.0191805851764795), 'SdsssP': (
    'loggamma', (2.0349401738920872e-10, 5.95145932027817e-10, 6.597517039244909e-12), -113.03859895885266, 0.0,
    -0.02535126807234109, 0.43028336513505183), 'SsssssP': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -9.887924092270653, 0.0, -0.00013237902287270169, 0.025344561758035514), 'SsSH': (
    'wald', (-0.007069521400747873, 0.02336880014762118), 0.0, 25.60049940577646, 0.05431283351487234,
    0.49679985729141485), 'SdS': (
    'wald', (-0.02994378971495958, 0.09921821545590792), 0.0, 41.52552297071965, 0.1891287112186214,
    1.0207575330766399), 'SssS': (
    'dweibull', (0.26758763780146977, -8.485431324780814e-32, 0.0640923958460301), -2.7223542722783947,
    24.345659401319853, 0.15749087115615723, 0.49468882533316444), 'SaaS': (
    'gengamma', (1.3360580190556888, 0.514258071021571, -1.7374554040699098e-31, 0.018214755271620815),
    -0.7292855496594981, 16.166799801214637, 0.15922689688915903, 0.4858160130063887), 'SdssS': (
    'loggamma', (5.796773972751113e-06, 2.610522648463052e-07, 2.1885394682345993e-08), -28.943587171862482,
    1.6682010582010554, -0.0033992777111498435, 0.0921230082036007), 'SddssS': (
    'beta', (273.15912817485577, 0.4322263715214851, -77.31355799684604, 77.31355799684606), -147.675790909401, 0.0,
    -0.5294797366613263, 1.504005360407356), 'SsCl': (
    'wald', (-0.16702553384529545, 0.5596154631267518), 0.0, 82.69154090996284, 0.9362593820661333, 2.7700771708653393),
        'SsGeH3': (
        'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0,
        0.0, 0.0), 'SssGeH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SsssGeH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssssGe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -10.458784643487029, 0.0, -0.00010515968955384623, 0.020633265433925265), 'SsAsH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssAsH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SsssAs': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), -7.3125, 0.0,
    -3.855270671248727e-05, 0.011301443396262042), 'SsssdAs': (
    'argus', (92.99028596328117, -56.8245820386406, 56.82786317784531), -10.914773573040174, 0.0,
    -0.0006550472630007975, 0.06094014764380839), 'SsssssAs': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SsSeH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0,
    2.5909957640463595, 3.386351535553298e-06, 0.002962095713648322), 'SdSe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0,
    6.996284744996866, 5.800555494641041e-05, 0.014363403351934988), 'SssSe': (
    'skewnorm', (19241.761841507927, -4.445060243177192e-07, 0.0017612661561200427), -1.179560185185185,
    1.6688888888888889, 3.075801952250837e-05, 0.006387902637103971), 'SaaSe': (
    'genhalflogistic', (0.0022497233566978955, -0.00011793947374096533, 0.0001817139155148939), -0.7225684334671529,
    2.8936933106575964, 1.7380163993371688e-05, 0.00465596000426286), 'SdssSe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -4.1997328088162265, 0.0, -4.408312645115816e-05, 0.011599265923268754), 'SddssSe': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -4.257031131897203, 0.0, -5.563808366820762e-06, 0.004866751942877564), 'SsBr': (
    'wald', (-0.022109534276518836, 0.07327427048998383), 0.0, 35.38597358696565, 0.13667117933121364,
    0.734530795497625), 'SsSnH3': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssSnH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -0.6960040156180108, 0.0, -9.096557778074166e-07, 0.0007956904214017237), 'SsssSnH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssssSn': ('argus', (92.99028596328117, -44.49473000447715, 44.49729919899086), -9.103198327664396, 0.0,
                      -0.0008279721716620751, 0.06195019101430567), 'SsI': (
    'halflogistic', (-1.9582706924693007e-08, 0.005559026110135873), 0.0, 11.91164254326758, 0.0038749332444815558,
    0.12184796533501145), 'SsPbH3': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssPbH2': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SsssPbH': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SssssPb': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884),
    -3.9690432098765425, 0.0, -3.279430360818583e-05, 0.010323598115306089), 'MAXsLi': (
    'halfgennorm', (0.14252409343871947, 0.5, 9.287451525918426e-09), 0.5, 1.4722222222222223, 0.9861111111111112,
    0.48611111111111116), 'MAXssBe': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssssBe': ('norm', (0, 1), 0, 0, 0, 0),
        'MAXssBH': ('dweibull', (0.4649722776585581, -0.06725552721088436, 0.32410779845593995), -0.18536776234828167,
                    1.0876388888888888, 0.12984467912808326, 0.48125319391074795), 'MAXsssB': (
    'johnsonsu', (-0.41868545954765907, 0.6059334787937889, -1.6526331937095706, 0.1267096938995639),
    -3.666666666666667, 0.38888888888888884, -1.435498135977083, 0.6887855959363091), 'MAXssssB': (
    'bradford', (1515.522390173248, -6.000147797394547, 5.571230939754445), -6.0, -0.7744444444444445,
    -4.5966504915585595, 1.8729332361795121), 'MAXsCH3': (
    'burr', (20.66641345138387, 0.22342532445785906, 0.5772854757753493, 1.5513092602437868), -1.2962654320987634,
    2.8954166666666667, 1.8742686148144285, 0.25454241385666865), 'MAXdCH2': (
    'johnsonsu', (-0.41929152140605624, 1.2791603085083605, 3.616437668059283, 0.2046140263300274), 2.0,
    4.688323255228017, 3.708738877102979, 0.23037668318890836), 'MAXssCH2': (
    'johnsonsb', (-3.4050299587252253, 2.2497381178546147, -4.584984391455231, 6.536037673950222), -4.579167933587576,
    1.7729166666666667, 0.7154961243454612, 0.44027113644928306), 'MAXtCH': (
    'vonmises_line', (7.222002275341271, 5.091344856029335, 0.506540805219626), 3.5, 6.101328755152709,
    5.094831729829131, 0.1987299789017668), 'MAXdsCH': (
    'dgamma', (1.0681042881951703, 1.646947498820666, 0.32972982594422284), -1.0624999999999996, 3.2033744855967083,
    1.5876656309907953, 0.468593725891528), 'MAXaaCH': (
    'johnsonsu', (1.3057937290938262, 1.7988627922947305, 2.1012827859627903, 0.25126662092920193), -0.5916435310987973,
    2.705941358024692, 1.8699876352224485, 0.21753810976816118), 'MAXsssCH': (
    'genextreme', (0.4399025860920848, -0.14417055638367376, 0.6441061918769233), -5.917008529839328,
    1.3333333333333333, 0.01387821804231774, 0.6138921017178579), 'MAXddC': (
    'dgamma', (0.9441503710546801, 2.3462762188208623, 0.48311731393313195), 1.0081063397581254, 3.705351473922902,
    2.3610099231860873, 0.5822046363766193), 'MAXtsC': (
    'johnsonsu', (-1.0779424484243811, 1.7402606957735376, 1.872146793948239, 0.4608814472649181), -0.9710687122071047,
    3.9682234189972285, 2.228969013921093, 0.37416135360128383), 'MAXdssC': (
    'johnsonsu', (-0.5028075283344196, 1.119324967056361, -0.2958742478370007, 0.3677850038914919), -4.551172153989387,
    2.2375992063492065, -0.04490602867658035, 0.5150972773726085), 'MAXaasC': (
    'skewnorm', (-4.06036717715264, 1.2576869582750352, 0.5178861345095218), -2.7093287037037035, 1.841525258251449,
    0.8571704366676905, 0.33232828300858125), 'MAXaaaC': (
    'skewnorm', (-3.5095565412673526, 1.1486980614166513, 0.45150592425266967), -1.4499797388091038, 1.7242592592592594,
    0.7994269890385691, 0.28438639219784334), 'MAXssssC': (
    'norminvgauss', (0.6901955504686468, -0.5830924749384503, 0.005324894645771141, 0.6211927047184863),
    -8.764931972789116, 1.0925925925925928, -0.9612481261343988, 1.589960689283387), 'MAXsNH3': (
    'dweibull', (1.3392622564310075, 3.7036266777939373, 0.22170333996674008), 2.25, 4.942450282222541,
    3.708477985773897, 0.2544747237665176), 'MAXsNH2': (
    'gennorm', (2.7128110816685735, 5.54212314099049, 0.6828566305997767), 3.3201014132122086, 7.235597810111699,
    5.542009311449578, 0.42762943332321124), 'MAXssNH2': (
    'exponweib', (3.272027062612782, 3667.901571692776, -1456.2976630312678, 1458.0880539840864), 0.49080813807004287,
    2.73113547412384, 1.9696033425856725, 0.2600116992463322), 'MAXdNH': (
    'foldcauchy', (26.85426306659251, -0.04641476134793272, 0.2636087450917213), 5.388888888888889, 10.038194444444445,
    7.2634280536077895, 0.6335003178926565), 'MAXssNH': (
    'gennorm', (1.3616648473958026, 2.826516958811733, 0.34572015797821315), -0.5011574074074074, 4.400662005542958,
    2.8271804578058273, 0.323408464925247), 'MAXaaNH': (
    'frechet_r', (4.519819003109415, 1.3428529278169936, 1.6561100827887998), 0.8953009259259264, 4.182219410529746,
    2.8569926734456903, 0.37919870112915866), 'MAXtN': (
    'dweibull', (1.6033900126991258, 8.895335154417175, 0.5468829556532859), 6.25, 12.280716452939473,
    8.871180105532266, 0.5770709514253018), 'MAXsssNH': (
    'johnsonsu', (1.8334026718731318, 1.354125741313991, 1.720469211474359, 0.17411669337237873), -0.7075723838918277,
    1.888564814814815, 1.2999170019156827, 0.3905141065321859), 'MAXdsN': (
    't', (6.469604317996435, 4.11713196490536, 0.36554455725580676), 1.0, 6.407537792894935, 4.093871916859295,
    0.43331467391983414), 'MAXaaN': (
    'gennorm', (2.1617667395229097, 4.241308939571827, 0.5284203507788339), 1.867453703703704, 6.085067533824211,
    4.237368064570177, 0.362579130313704), 'MAXsssN': (
    'johnsonsb', (-1.1556049139398246, 1.4866172098218535, -0.3912390054972581, 3.3592603878066813), -2.912222222222222,
    3.2122608024691357, 1.852353935978119, 0.46089664820670057), 'MAXddsN': (
    'mielke', (48.15396000112605, 160.43219415590954, -6.536200568647331, 6.083244435468973), -2.4548611111111107,
    0.024375000000000036, -0.5616356123058408, 0.1418909306921071), 'MAXaasN': (
    'skewnorm', (-2.2499922653171387, 2.0348412862211678, 0.5107447662403799), -1.2974937799193755, 2.9096611226350335,
    1.6630272375287443, 0.35076285168797305), 'MAXssssN': (
    't', (3.563635934639035, 0.8719366957069168, 0.26586782083295024), -2.166921817850591, 1.8261882716049382,
    0.8173306387932919, 0.40056878975907356), 'MAXsOH': (
    'johnsonsu', (-0.5974906121948206, 1.851744556414996, 9.021148605376524, 1.3760481884753943), 6.0, 16.2417169306221,
    9.551481403880093, 0.9084644525931171), 'MAXdO': (
    'genlogistic', (0.46541329613101334, 12.817731208172194, 0.3550967383589406), 7.25, 17.70205215419501,
    12.254808817564642, 0.9480057171867863), 'MAXssO': (
    'johnsonsu', (-0.22258574035346876, 1.5253844404648036, 5.244964928592989, 0.4994339160663265), 1.483136101662888,
    9.390055272108846, 5.336985329407573, 0.40349054571262033), 'MAXaaO': (
    'dweibull', (1.1950732208373327, 5.300442942977851, 0.33450267315598947), 3.1040277777777776, 7.01218016036819,
    5.2783449422520405, 0.40763155260611517), 'MAXsF': (
    'johnsonsu', (-0.08776834545068776, 1.323871199877497, 13.197784567728306, 0.6963903116211925), 8.5,
    19.543884164777026, 13.254414720136928, 0.7226068640615774), 'MAXsSiH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MAXssSiH2': ('norm', (0, 1), 0, 0, 0, 0), 'MAXsssSiH': (
    'johnsonsb', (-0.43608324841300095, 0.11974648270591659, -1.6889351851851855, 1.313550585857337),
    -1.6889351851851853, -0.3753858024691359, -1.0131234567901237, 0.4654257861550824), 'MAXssssSi': (
    'dweibull', (1.090095807422061, -1.9623656263813012, 0.4274085076116819), -5.900462962962964, -0.6111111111111112,
    -1.9622828034640698, 0.574375209371302), 'MAXsPH2': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssPH': (
    'betaprime', (49.63570453584772, 0.39860716536557006, 0.8711790900748201, 4.754679880976928e-07),
    0.8712422839506172, 0.9455709876543208, 0.9084066358024689, 0.037164351851851796), 'MAXsssP': (
    'powernorm', (6945.606368048822, 7.8209119826987035, 2.297052303865982), -3.1899434156378597, 0.4216820987654324,
    -0.8277886687174183, 0.7210398635298929), 'MAXdsssP': (
    'burr', (11.512169266794693, 0.22139455078038411, -6.444036407499389, 3.665933777377977), -6.423058862433864,
    -1.0010038737717308, -3.7018433293413606, 0.9043997457336881), 'MAXsssssP': (
    'arcsine', (-5.807786876589118, 3.5550060201277374), -5.365543209876542, -2.252780856461381, -3.891489132159305,
    1.0018295580430538), 'MAXsSH': (
    'gennorm', (1.6200527828029636, 4.320988265068648, 0.2800018773094787), 3.0486725245653816, 5.224140841521795,
    4.321717487118506, 0.22415288263032668), 'MAXdS': (
    'dweibull', (1.092210330736319, 5.255855053262335, 0.22135193441373102), 3.2430555555555554, 7.0839389527620025,
    5.26052466460344, 0.290337619126236), 'MAXssS': (
    't', (7.415813729489272, 1.3880543679246307, 0.22343576668108986), -1.6582038926681781, 2.504802191371906,
    1.3823712308764415, 0.26086161245655176), 'MAXaaS': (
    'johnsonsb', (-10.665853933377996, 3.9102164585902024, -12.513331711714706, 14.860354648968809),
    -0.7292855496594981, 2.1412052787182514, 1.4084308035326156, 0.22683347570458864), 'MAXdssS': (
    'dgamma', (0.9551494856584415, -1.3445149911816578, 0.262016148461767), -3.7053577377453033, 0.5163580246913577,
    -1.3460491834115809, 0.3671460064638681), 'MAXddssS': (
    'johnsonsu', (0.18093168558500058, 1.2308537292896544, -3.6856898985116735, 0.27630647748235176),
    -8.910403321050644, -2.481481481481482, -3.744138309946941, 0.327372067997636), 'MAXsCl': (
    'burr12', (325.10890075505097, 0.691959451127997, -27.16357056912659, 33.09654211452789), 3.3888888888888884,
    9.238477576215669, 5.998962429926042, 0.22200605887792152), 'MAXsGeH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MAXssGeH2': ('norm', (0, 1), 0, 0, 0, 0), 'MAXsssGeH': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssssGe': (
    'dweibull', (0.9497275781067023, -2.665124952758881, 0.47414874945558133), -4.181826341647771, -1.340047230707404,
    -2.634128517128365, 0.6486694206111994), 'MAXsAsH2': ('norm', (0, 1), 0, 0, 0, 0),
        'MAXssAsH': ('norm', (0, 1), 0, 0, 0, 0), 'MAXsssAs': (
    'rdist', (1.1057038416296652, -1.4473693857649486, 0.7472540050804843), -2.1941666666666664, -0.7001153806844644,
    -1.3118613235732342, 0.4288965453047713), 'MAXsssdAs': (
    'gennorm', (0.4768227240458711, -4.917431359853067, 0.03667559246331593), -5.625, -3.125, -4.797511024092216,
    0.44404279315006095), 'MAXsssssAs': ('norm', (0, 1), 0, 0, 0, 0), 'MAXsSeH': (
    'burr12', (7243137.567914359, 4099139.3326131105, -27589.379669090966, 27592.02866210956), 2.5909957640463595,
    2.5909957640463595, 2.5909957640463595, 0.0), 'MAXdSe': (
    'rdist', (1.1843631862445876, 3.1628445351318586, 0.5760365387851719), 2.375, 3.738870308358268, 2.9202564198638297,
    0.3538310006266291), 'MAXssSe': (
    'dgamma', (1.828147602349612, 0.15678359942087444, 0.15676676035542536), -1.179560185185185, 0.8344444444444444,
    0.12983679393243996, 0.3506768436150775), 'MAXaaSe': (
    'dgamma', (2.253321156643974, 0.14252021223269867, 0.1090270812773636), -0.7225684334671529, 0.7299022108843537,
    0.15953385104213116, 0.29813018935388413), 'MAXdssSe': (
    'johnsonsb', (0.05765234694171492, 0.14877201719354954, -4.19973287163455, 2.6599180568197367), -4.1997328088162265,
    -1.539814814814814, -2.810773204870683, 0.8235524089249033), 'MAXddssSe': (
    'ncx2', (0.35071366054921704, 3.090055598780492e-10, -4.257031131897204, 16.344287852820308), -4.257031131897203,
    -4.257031131897203, -4.257031131897203, 0.0), 'MAXsBr': (
    'johnsonsu', (0.17073900091569735, 1.2599819806301356, 3.391793958852933, 0.12563225136417577), 0.3595904195011337,
    4.665185500125976, 3.370618943837133, 0.142042065247515), 'MAXsSnH3': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssSnH2': (
    'dgamma', (0.13652921364456044, -0.696004015618011, 1.3112477130872366), -0.6960040156180108, -0.6960040156180108,
    -0.6960040156180108, 0.0), 'MAXsssSnH': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssssSn': (
    'gennorm', (3.4536925504177196, -3.3728990848254767, 1.2698515034708378), -5.437297477324264, -1.5225,
    -3.384611008606914, 0.7640307616725636), 'MAXsI': (
    'mielke', (9.540322652059752, 29.498858146344, -0.04207979777238496, 2.329999016015078), 0.8790740740740746,
    3.159452481733435, 2.1040864030742132, 0.23925034152154118), 'MAXsPbH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MAXssPbH2': ('norm', (0, 1), 0, 0, 0, 0), 'MAXsssPbH': ('norm', (0, 1), 0, 0, 0, 0), 'MAXssssPb': (
    'johnsonsb', (0.49059965583863885, 0.08633813145974811, -3.969043209876543, 1.840683403816152), -3.9690432098765425,
    -2.1410802469135803, -3.136484090678452, 0.5963923162217548), 'MINsLi': (
    'johnsonsu', (2.2802635821993054, 0.3395693719029471, 1.4722225778721425, 3.8152697553298155e-07), 0.5,
    1.4722222222222223, 0.9861111111111112, 0.48611111111111116), 'MINssBe': ('norm', (0, 1), 0, 0, 0, 0),
        'MINssssBe': ('norm', (0, 1), 0, 0, 0, 0), 'MINssBH': (
    'burr12', (0.32842115290165314, 2.0859181170313974, -0.1853677623482817, 0.45339154492169054), -0.18536776234828167,
    1.0876388888888888, 0.12984467912808326, 0.48125319391074795), 'MINsssB': (
    't', (0.9986536422527845, -1.5894673577404603, 0.17732226678482155), -3.666666666666667, 0.38888888888888884,
    -1.4400724617137255, 0.6870660353983439), 'MINssssB': (
    'halfgennorm', (0.16866883740644223, -6.000000004487072, 9.373886314217659e-07), -6.0, -0.7744444444444447,
    -4.620157501393253, 1.8642684505068416), 'MINsCH3': (
    'gennorm', (2.316478077507489, 1.753882622846879, 0.4236286492061272), -1.296265432098766, 2.8954166666666667,
    1.7530940406883844, 0.27779384851846944), 'MINdCH2': (
    'johnsonsu', (-0.4471866521398984, 1.3048704946927479, 3.6098719184348997, 0.20702053431684503), 2.0,
    4.688323255228017, 3.703921883700313, 0.2286522622070192), 'MINssCH2': (
    'gennorm', (1.77741466458364, 0.3533193465005749, 0.6013706479313294), -4.579167933587581, 1.6805555555555556,
    0.3592608101409872, 0.45859974978489415), 'MINtCH': (
    'vonmises_line', (3.7314652571221245, 5.092469403788714, 0.3477438131141113), 3.5, 6.101328755152709,
    5.09317514902363, 0.1992530719353159), 'MINdsCH': (
    'laplace', (1.5570168024740332, 0.35209815965076874), -1.0624999999999996, 3.2033744855967075, 1.5097425786707899,
    0.46893585057797493), 'MINaaCH': (
    'pearson3', (-0.7115709050866711, 1.594569156896507, 0.2925821552091197), -1.08138888888889, 2.6448055240614763,
    1.5920858951158312, 0.2968441540881056), 'MINsssCH': (
    'exponweib', (1.0955985521340321, 7.402845891964997, -4.506078081095129, 4.5331636225), -6.219743509941371,
    1.3333333333333333, -0.19420379556070527, 0.6556303274671155), 'MINddC': (
    'dgamma', (0.9324767392529627, 2.3522429295792397, 0.4713500817559673), 1.0081063397581254, 3.705351473922902,
    2.350027266763321, 0.5759845764273875), 'MINtsC': (
    'burr12', (170517.887049719, 0.5029685416736667, -24532.264473657473, 24534.26002927427), -0.9710687122071047,
    3.894559133647337, 2.1884434095205334, 0.35508884504983546), 'MINdssC': (
    'johnsonsu', (-0.004692909284152846, 1.0719531177086103, -0.29871778252858544, 0.3470803574923832),
    -4.551172153989387, 2.2375992063492065, -0.2932074235622489, 0.50244467347738), 'MINaasC': (
    'skewnorm', (-2.7011211970397877, 0.8531262135433062, 0.7625579702595147), -2.935246414923994, 1.7856631078357272,
    0.290534663319798, 0.507229246211634), 'MINaaaC': (
    'beta', (2026.1626785292324, 14.428517959729138, -159.304723310562, 161.11563374106146), -1.603850623582767,
    1.6139583333333334, 0.6700744888146488, 0.2968450875554023), 'MINssssC': (
    'norminvgauss', (1.5927774426169408, -1.451777709430388, 0.3118186096540971, 0.646850677543781), -9.769375,
    1.0925925925925928, -1.1135317520217156, 1.6953586189468377), 'MINsNH3': (
    'exponnorm', (0.6510169144597889, 3.5452761587910695, 0.2105185769491399), 2.25, 4.942450282222541,
    3.6806606408516847, 0.2493998412819365), 'MINsNH2': (
    'genextreme', (0.20845138262892787, 5.3571503044459305, 0.39835050977441033), 3.3201014132122086, 7.235597810111699,
    5.5124766604151665, 0.4189385494822651), 'MINssNH2': (
    'pearson3', (-0.49914093047455593, 1.9681039034186218, 0.2584911128363138), 0.49080813807004287, 2.6987798896596695,
    1.9653944890099773, 0.260332279804155), 'MINdNH': (
    'loglaplace', (3.217722137225116, 5.7616792937982915, 1.3129038284912267), 5.388888888888889, 10.038194444444445,
    7.257111392452312, 0.6337119133359493), 'MINssNH': (
    'gennorm', (1.4459993988058832, 2.7666698553885336, 0.37706615275146016), -0.5011574074074074, 4.400662005542958,
    2.7687561419848894, 0.34164463737573), 'MINaaNH': (
    'frechet_r', (5.790935634474596, 0.844576346397246, 2.1530891848860296), 0.8953009259259264, 4.182219410529746,
    2.842532922171602, 0.38706347603467184), 'MINtN': (
    'dweibull', (1.5750188897607202, 8.846777692749697, 0.538473651358613), 5.75, 12.280716452939469, 8.863340885378538,
    0.572322688519902), 'MINsssNH': (
    'johnsonsu', (1.7732351654710343, 1.2817854941398457, 1.699660238314744, 0.1598437556362131), -0.7075723838918277,
    1.888564814814815, 1.2915857917649196, 0.39213415977643756), 'MINdsN': (
    't', (5.606463096326118, 4.0954880531733115, 0.3449980468927834), 1.0, 6.407537792894935, 4.074629730553732,
    0.4334895642096338), 'MINaaN': (
    'gamma', (502.1334561316331, -4.184587349991315, 0.016560193000597787), 1.8674537037037038, 6.08506753382421,
    4.135182438610137, 0.3671942269603857), 'MINsssN': (
    'gennorm', (2.5841284034275214, 1.7403310966239949, 0.710856919717697), -2.9122222222222236, 3.2122608024691357,
    1.7436407471624853, 0.45503628379412714), 'MINddsN': (
    'genlogistic', (0.30853794184474803, -0.45283875330498125, 0.03834990444481802), -2.4548611111111107,
    0.024375000000000036, -0.5648050373672183, 0.14672861050789726), 'MINaasN': (
    'gengamma', (0.84442745233835, 7.359746784995684, -0.46436158011302187, 2.301978967563298), -1.2974937799193755,
    2.9096611226350335, 1.616515887983029, 0.3729725241524158), 'MINssssN': (
    'burr12', (10094.795543366534, 8.5551988872257, -2826.8434631804203, 2828.4077553614193), -2.166921817850591,
    1.8261882716049382, 0.8148445529907045, 0.3995508101090363), 'MINsOH': (
    'johnsonsu', (-0.5361256160346134, 2.0072436616690625, 8.978231642816592, 1.4711028973617783), 6.0,
    16.2417169306221, 9.420336040213813, 0.8518564529629987), 'MINdO': (
    'mielke', (14.48911492547931, 39.86886630861307, -0.2201437500766837, 12.767758404015023), 7.25, 17.70205215419501,
    11.86147092023518, 0.8973568419670072), 'MINssO': (
    'gennorm', (1.061386764528367, 5.227036410220043, 0.28408132282337056), 1.1873417422524568, 9.390055272108846,
    5.2261916768454695, 0.36468966962351884), 'MINaaO': (
    'logistic', (5.279923408382141, 0.2245361850939221), 3.1040277777777776, 7.01218016036819, 5.26309173465139,
    0.40565170541849177), 'MINsF': (
    'johnsonsu', (-0.10696394492727815, 1.1529647771277478, 13.116679100038773, 0.5641396044502753), 8.5,
    19.54388416477702, 13.177908668396833, 0.7105744740656933), 'MINsSiH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MINssSiH2': ('norm', (0, 1), 0, 0, 0, 0), 'MINsssSiH': (
    'johnsonsb', (-0.3380079001646322, 0.1325976052591783, -1.9117236050559985, 1.5363378025868628),
    -1.6889351851851853, -0.3753858024691359, -1.0131234567901237, 0.4654257861550824), 'MINssssSi': (
    'gennorm', (1.2554304271753873, -1.9909982514347373, 0.5595546269431951), -5.900462962962964, -0.6111111111111112,
    -2.003194639627262, 0.5907663832980745), 'MINsPH2': ('norm', (0, 1), 0, 0, 0, 0), 'MINssPH': (
    'johnsonsu', (2.8587035250702373, 0.28040538468732434, 0.9455709925694757, 1.4158350234454313e-09),
    0.8712422839506172, 0.9455709876543208, 0.9084066358024689, 0.037164351851851796), 'MINsssP': (
    'powernorm', (4353.28437604419, 7.115353551042212, 2.1810499793252838), -3.1899434156378597, 0.4216820987654324,
    -0.849374120828281, 0.7055564872986495), 'MINdsssP': (
    'mielke', (2.964897398123412, 12.727686655724199, -6.855982946183853, 4.047158641631038), -6.567622227691768,
    -1.0010038737717308, -3.7205130452964683, 0.928017391782309), 'MINsssssP': (
    'arcsine', (-5.807786876589118, 3.5550060201277356), -5.365543209876542, -2.2527808564613827, -3.891489132159306,
    1.0018295580430538), 'MINsSH': (
    'gennorm', (1.6773183580131623, 4.324921838370241, 0.2833910513462391), 3.0486725245653816, 5.224140841521795,
    4.320589439570004, 0.2248029163219471), 'MINdS': (
    'hypsecant', (5.254463755763529, 0.181149642697833), 3.2430555555555554, 7.0839389527620025, 5.25556309670608,
    0.2794961297976262), 'MINssS': (
    'fisk', (4328813.069197053, -614940.3815463862, 614941.7555831451), -1.6582038926681781, 2.504802191371906,
    1.3752348349813315, 0.26052187004126326), 'MINaaS': (
    'powerlognorm', (23.51674343055997, 0.004238184033024343, -98.97519644742414, 101.20840561561818),
    -0.7292855496594981, 2.1204629629629625, 1.4002914885267543, 0.2271260183550327), 'MINdssS': (
    'dgamma', (0.9770347951088838, -1.3447321518223991, 0.25920691179924493), -3.7707119506264224, 0.5163580246913577,
    -1.347987697059112, 0.3725803404681394), 'MINddssS': (
    'johnsonsu', (0.21912337079901523, 1.1858445741495192, -3.682001324947937, 0.2695008219953692), -8.910403321050646,
    -2.481481481481482, -3.7568268328085237, 0.3430286781316807), 'MINsCl': (
    'burr12', (214.1924535174444, 0.6562039093160061, -14.178021781454117, 20.079553050382714), 3.3888888888888884,
    9.238477576215669, 5.971184679230731, 0.21735921472370962), 'MINsGeH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MINssGeH2': ('norm', (0, 1), 0, 0, 0, 0), 'MINsssGeH': ('norm', (0, 1), 0, 0, 0, 0), 'MINssssGe': (
    'dgamma', (0.8595440926297517, -2.665124952758883, 0.5070476718975043), -4.181826341647771, -1.340047230707404,
    -2.636830572843814, 0.6481841861067833), 'MINsAsH2': ('norm', (0, 1), 0, 0, 0, 0),
        'MINssAsH': ('norm', (0, 1), 0, 0, 0, 0), 'MINsssAs': (
    'rdist', (1.1289240585020295, -1.447726713024745, 0.7476113323402808), -2.1941666666666664, -0.7001153806844644,
    -1.3118613235732342, 0.4288965453047713), 'MINsssdAs': (
    'gennorm', (0.46297270990747197, -4.917431359852927, 0.03416062810542582), -5.625, -3.125, -4.804496450893808,
    0.4495791662136712), 'MINsssssAs': ('norm', (0, 1), 0, 0, 0, 0), 'MINsSeH': (
    'burr12', (7243137.567914359, 4099139.3326131105, -27589.379669090966, 27592.02866210956), 2.5909957640463595,
    2.5909957640463595, 2.5909957640463595, 0.0), 'MINdSe': (
    'rdist', (1.1843074067985189, 3.162660366128378, 0.5762099422298902), 2.375, 3.738870308358268, 2.9202564198638297,
    0.3538310006266291), 'MINssSe': (
    'burr', (22.184474653175997, 0.2073886313114574, -1.6900197070910585, 2.189663796857019), -1.179560185185185,
    0.8344444444444444, 0.12979726365752006, 0.3506836274808891), 'MINaaSe': (
    'dgamma', (2.0863913435644, 0.13586807558402822, 0.11229826575194601), -0.7225684334671529, 0.7169444444444444,
    0.14763944797884146, 0.28933755169225067), 'MINdssSe': (
    'gennorm', (0.12995776722414937, -2.3209463942111013, 3.1867165320548534e-08), -4.1997328088162265,
    -1.539814814814814, -2.810773204870683, 0.8235524089249033), 'MINddssSe': (
    'ncx2', (0.35071366054921704, 3.090055598780492e-10, -4.257031131897204, 16.344287852820308), -4.257031131897203,
    -4.257031131897203, -4.257031131897203, 0.0), 'MINsBr': (
    'johnsonsu', (0.1596960009259619, 1.314194271451265, 3.391044966492044, 0.12968135644428333), 0.3595904195011337,
    4.665185500125976, 3.367119797523973, 0.1416916314241133), 'MINsSnH3': ('norm', (0, 1), 0, 0, 0, 0), 'MINssSnH2': (
    'dgamma', (0.13652921364456044, -0.696004015618011, 1.3112477130872366), -0.6960040156180108, -0.6960040156180108,
    -0.6960040156180108, 0.0), 'MINsssSnH': ('norm', (0, 1), 0, 0, 0, 0), 'MINssssSn': (
    'dweibull', (1.6725313360839413, -3.61373776691548, 0.7524626226535909), -5.437297477324264, -1.5225,
    -3.3866538999488633, 0.7634041099109768), 'MINsI': (
    'burr', (27.465061205774152, 0.34994704212878774, -0.05617819759644542, 2.3294054003858697), 0.8790740740740746,
    3.159452481733435, 2.093032238213327, 0.24178951356064354), 'MINsPbH3': ('norm', (0, 1), 0, 0, 0, 0),
        'MINssPbH2': ('norm', (0, 1), 0, 0, 0, 0), 'MINsssPbH': ('norm', (0, 1), 0, 0, 0, 0), 'MINssssPb': (
    'johnsonsb', (0.05304051730721699, 0.14553052913029485, -3.9697008621845495, 1.8286206152709694),
    -3.9690432098765425, -2.1410802469135803, -3.136484090678452, 0.5963923162217548), 'ECIndex': (
    'wald', (-28000596.756044872, 92738032.82632232), 0.0, 100400000000.0, 171080677.18083355, 1090791509.246169),
        'ETA_alpha': (
        'burr', (9.875371710900929, 0.2126295248121755, -0.0012451108922765502, 15.203649359434763), 0.2857142857142857,
        224.7000000000007, 10.883167080374605, 4.805236825068982), 'AETA_alpha': (
    'norminvgauss', (0.9444810887546549, 0.1731342004350815, 0.4708761351435411, 0.019283501656447957),
    0.2857142857142857, 7.8, 0.4751158823295033, 0.03219563070728227), 'ETA_shape_p': (
    'johnsonsu', (-1.968975433510821, 2.270428393758319, 0.03073163817554124, 0.1278987907528446), 0.0, 1.0,
    0.16928402777684143, 0.08973901902471214), 'ETA_shape_y': (
    't', (3.7918905980558986, 0.30744204461813635, 0.0623264027547479), 0.0, 1.0, 0.3055043637459968,
    0.08809864107447657), 'ETA_shape_x': (
    'halfgennorm', (0.36382162302692944, -8.38846411821304e-24, 0.00018455866305693534), 0.0, 0.5833333333333333,
    0.02647103820544056, 0.0471213054928049), 'ETA_beta': (
    'genlogistic', (0.5454435151739323, 34.62687713816284, 5.519719727640909), 0.0, 499.5, 28.004419172362706,
    13.284057936620918), 'AETA_beta': (
    'genlogistic', (0.2494049684500073, 1.3936550265688714, 0.055966665592046286), 0.0, 2.0, 1.1894296833358593,
    0.22540459375731337), 'ETA_beta_s': (
    'burr', (10.11368194615671, 0.20800992861001788, -0.18947904546752736, 20.492617747739473), 0.0, 315.0,
    14.608006498535305, 6.6167729909900155), 'AETA_beta_s': (
    't', (3.5288517689314878, 0.6371762778771616, 0.028776997108206602), 0.0, 1.12, 0.6372279280942783,
    0.04193198927254156), 'ETA_beta_ns': (
    'genlogistic', (0.5457001009458231, 17.159533284921316, 3.2081163631632883), 0.0, 184.5, 13.3964126738274,
    7.4211534341877305), 'AETA_beta_ns': (
    'loggamma', (0.8159676372042696, 0.6971269655781808, 0.15351046716538713), 0.0, 1.5, 0.5522017552415807,
    0.22379740976598433), 'ETA_beta_ns_d': (
    'gamma', (0.2536687616884207, -7.272023033544328e-28, 0.44847768018843115), 0.0, 15.0, 0.6599414121687599,
    0.6572758879781848), 'AETA_beta_ns_d': (
    'halfgennorm', (0.09022534815796018, -2.521980181396944e-11, 3.935738822064039e-15), 0.0, 0.25, 0.02706704200618103,
    0.027613860916566882), 'ETA_eta': (
    'burr', (5.045584145115486, 0.320749358969875, 0.5189042777882695, 26.568287850350316), 0.0, 1543.7962288034066,
    19.58452344596537, 15.703777182496014), 'AETA_eta': (
    'mielke', (7.2967576556852105, 8.968058510499057, -0.09063589947812961, 0.9070320379637726), 0.0, 3.400432222033935,
    0.8028324311394559, 0.20289860309621846), 'ETA_eta_L': (
    'mielke', (1.9272290085627897, 5.795296409995466, 0.7626224740108609, 6.3779120032106675), 0.0, 135.82984670253177,
    5.507438799199697, 2.6498389746345183), 'AETA_eta_L': (
    'johnsonsu', (-2.5398319067987223, 1.7030880981038048, 0.15971175233217505, 0.035816754199197554), 0.0,
    1.9107050140703694, 0.24848921528090737, 0.05868292517004772), 'ETA_eta_R': (
    'vonmises_line', (111.23539760147848, 40.20391228191516, 263.7411767451925), 0.0, 2921.6311047011695,
    40.70276098888793, 29.911681610722862), 'AETA_eta_R': (
    'johnsonsu', (0.8186939765725381, 1.4248506978379485, 1.8943089927770347, 0.35189576165048136), 0.0,
    6.435310803306541, 1.6359087235935024, 0.3485037570354682), 'ETA_eta_RL': (
    'dgamma', (1.1893762506627414, 11.351643221297309, 2.968082785346547), 0.0, 233.11860171723583, 10.984298849235252,
    4.883294344705368), 'AETA_eta_RL': (
    'johnsonsu', (1.7827243702026112, 1.9585673307975973, 0.49181392446456873, 0.010216181103436243), 0.0, 0.5,
    0.4797511993413399, 0.009507818484830158), 'ETA_eta_F': (
    'logistic', (20.93179741970327, 7.145833641388084), -14.763288469084088, 1380.2228182186007, 21.124673975995098,
    15.315329992595144), 'AETA_eta_F': (
    'genlogistic', (0.26141947650513164, 1.073477454089921, 0.07033733748293469), -1.4107050140703694,
    3.0348785812726056, 0.8331844597084072, 0.27522767327031195), 'ETA_eta_FL': (
    'genlogistic', (0.5180553273438848, 6.896484925834317, 1.1166505263023307), -2.821410028140739, 98.69739408298287,
    5.477780996145838, 2.7199833071363195), 'AETA_eta_FL': (
    'johnsonsu', (2.7502282310779815, 1.8089229161323117, 0.32697487301547, 0.03728925801615208), -1.4107050140703694,
    0.4403715206000056, 0.2312657862900581, 0.060712358868489316), 'ETA_eta_B': (
    'burr12', (2.488553433120085, 2.6838390593444412, -0.0949819303738308, 0.6703544667398003), -0.08578643762690508,
    14.799378729892453, 0.36204637894939085, 0.2753954554845903), 'AETA_eta_B': (
    'norminvgauss', (3.173958480199058, 1.3918356476280573, 0.00925971918550511, 0.01286505067794582),
    -0.028595479208968284, 0.08349470627426447, 0.015480405384903233, 0.008504367929384641), 'ETA_eta_BR': (
    'mielke', (2.1760552170230634, 6.000467915827365, -0.02821967665918851, 0.822713586146336), -8.881784197001252e-16,
    15.401378729892453, 0.6090243539303922, 0.32070998748363316), 'AETA_eta_BR': (
    'johnsonsu', (-0.7302385973506151, 1.3860969403686942, 0.021321816758447618, 0.0078109530107672),
    -8.881784197001253e-17, 0.0945714103831669, 0.02704577670268616, 0.008653665789926256), 'ETA_dAlpha_A': (
    'exponnorm', (4059.386414450916, -1.3505691339083742e-06, 3.6903307311693533e-07), 0.0, 7.3, 0.001655040031905719,
    0.025841351112705826), 'ETA_dAlpha_B': (
    'gengamma', (0.1826880797300465, 3.9138569245313235, -3.010481137100676e-26, 0.05748192755937008), 0.0,
    0.2142857142857143, 0.026552353803678354, 0.016714544449273727), 'ETA_epsilon_1': (
    'burr12', (21.359265489754073, 0.8204799959850906, -0.05451415512992626, 0.6533318820318437), -7.2,
    2.7545454545454544, 0.6121697826639012, 0.06797804088912461), 'ETA_epsilon_2': (
    'burr12', (1061128.370367858, 0.6034018036653244, -27756.55749069879, 27757.392508975725), -7.2, 2.7545454545454544,
    0.8596755081942227, 0.06581267296251006), 'ETA_epsilon_3': (
    'johnsonsu', (0.19330132968940786, 1.0331322699080872, 0.4416292215002142, 0.0037302202289004553), 0.38,
    0.5222222222222225, 0.44070945152637453, 0.005967156314950775), 'ETA_epsilon_4': (
    'burr12', (21.59619438175742, 0.5407699400782274, 0.11214793235173177, 0.4200595870829722), -7.2,
    2.7545454545454544, 0.5592089569777373, 0.05928246385640101), 'ETA_epsilon_5': (
    'burr12', (18.599014785906306, 0.8777889034939791, 0.3030652256449091, 0.5146562481317969), -7.2,
    2.7545454545454544, 0.8261656607702677, 0.06069010673083106), 'ETA_dEpsilon_A': (
    'burr12', (4415.525975947161, 0.6030765010537984, -123.42629335254213, 123.57171203830546), -7.58,
    2.3745454545454545, 0.17145714124639652, 0.06872597033280432), 'ETA_dEpsilon_B': (
    'f', (0.6886271192957628, 2.0880892215895916, -8.438810987868487e-33, 0.07123730503839354), -4.577777777777778,
    0.34211017740429495, 0.05296082568616378, 0.03185173072403958), 'ETA_dEpsilon_C': (
    'norminvgauss', (1.1623217583528886, -0.5849292576380796, -0.09013143226039388, 0.048466139020334226),
    -2.3745454545454545, 7.58, -0.11850016329070528, 0.060261893871996715), 'ETA_dEpsilon_D': (
    'chi', (0.3194997692877428, -7.695614496062973e-30, 0.07424529366171517), -3.0666666666666673, 0.7777777777777778,
    0.03350984742395498, 0.03640488528213382), 'ETA_dBeta': (
    'crystalball', (1.934824931443334, 3.261857372977904, -0.9495461623233321, 3.8128194674170506), -157.25, 32.0,
    -1.2115938247079026, 4.609144275524617), 'AETA_dBeta': (
    'loggamma', (0.9347306928113515, 0.03254961094519623, 0.1751901045199551), -1.0, 1.125, -0.0850261728526972,
    0.22995633019713413), 'ETA_psi_1': (
    'genlogistic', (0.8837777243208667, 0.5625424004959738, 0.02843478239216235), -80.25806451612907,
    19.999999999999954, 0.5556496139579831, 0.156328092728016), 'ETA_dPsi_A': (
    'burr', (12.603296661481782, 0.6442106923622605, -0.15881989755013098, 0.3330727701614319), 0.0, 80.97206451612907,
    0.1588206801672017, 0.14993098540600744), 'ETA_dPsi_B': (
    'genhalflogistic', (2.178918362193309e-05, -0.0003033023498400878, 0.004403881168801036), 0.0, 19.285999999999955,
    0.0004702941251851, 0.04254159523903262), 'fragCpx': (
    'burr', (4.367514042418627, 0.2011822966592021, 2.019998804062138, 237.9190614498434), 0.0, 25906.46,
    130.0949241761847, 138.33194335862902), 'fMF': (
    'norminvgauss', (3.09140099858629, -2.0391286037826126, 0.528270846971278, 0.14901092521818476), 0.0, 1.0,
    0.3974957576165358, 0.12687133438968484), 'GeomDiameter': ('norm', (0, 1), 0, 0, 0, 0),
        'GeomRadius': ('norm', (0, 1), 0, 0, 0, 0), 'GeomShapeIndex': ('norm', (0, 1), 0, 0, 0, 0),
        'GeomPetitjeanIndex': ('norm', (0, 1), 0, 0, 0, 0), 'GRAV': ('norm', (0, 1), 0, 0, 0, 0),
        'GRAVH': ('norm', (0, 1), 0, 0, 0, 0), 'GRAVp': ('norm', (0, 1), 0, 0, 0, 0),
        'GRAVHp': ('norm', (0, 1), 0, 0, 0, 0), 'nHBAcc': (
    'dweibull', (1.2881602676764308, 4.46616983618981, 1.930934605335139), 0.0, 199.0, 4.527318922691467,
    2.4608962687571685), 'nHBDon': (
    'gennorm', (0.3365228038846866, 1.0, 0.009770164313723987), 0.0, 106.0, 1.238779343091165, 1.4844864225194823),
        'IC0': ('johnsonsu', (0.5004843784863329, 2.977099143474593, 1.70723392526094, 0.5444013754005486), -0.0,
                2.604310381621058, 1.6097980645078134, 0.1981394849613804), 'IC1': (
    'genlogistic', (0.3028120082789415, 3.6728949323827473, 0.12943013876620127), -0.0, 4.915873781480403,
    3.2938648870804865, 0.46854741136178446), 'IC2': (
    'mielke', (4.750882812185765, 25.80085695012641, 1.362794050288688, 3.3840458669398057), -0.0, 6.225942979057692,
    4.1865916493964175, 0.5290892743142375), 'IC3': (
    'genlogistic', (0.24302848207124872, 5.225482552159356, 0.15541186878350632), -0.0, 7.0543088279546176,
    4.646035027926655, 0.6389106959630096), 'IC4': (
    'genlogistic', (0.24155896663923973, 5.3575418955030845, 0.15999700806991596), -0.0, 7.773279532100057,
    4.755384090383325, 0.6729656498021772), 'IC5': (
    'genlogistic', (0.2465415781680293, 5.389021198706461, 0.16257853094451657), -0.0, 8.31247775058765,
    4.78128332905587, 0.6814760902955385), 'TIC0': (
    'dgamma', (1.2194968446611738, 68.83007186233264, 18.31035731378648), -0.0, 1689.1331266647264, 67.15705933084213,
    31.56561189779788), 'TIC1': (
    'mielke', (1.8884716439241225, 8.238185946602858, -0.7029161708325189, 202.22052740712738), -0.0, 3608.177527743796,
    140.5449732847637, 71.85076894365032), 'TIC2': (
    'vonmises_line', (33.168224478882934, 179.74593044726112, 517.4665919611493), -0.0, 5162.163861054036,
    180.97428685593528, 99.87242615044343), 'TIC3': (
    'vonmises_line', (46.46158630483353, 199.40943645544428, 731.5564255232739), -0.0, 6428.3929352146515,
    202.6257233634662, 116.41484304279233), 'TIC4': (
    'mielke', (1.7548709147554398, 6.648310538492089, -0.6875831525353389, 297.52034205860264), -0.0, 7306.882760174053,
    208.04804551941032, 123.10755207347098), 'TIC5': (
    'burr', (6.283249644499509, 0.27879862966681035, -0.07626033328342463, 297.9580887675787), -0.0, 7813.729085552392,
    209.4590704729716, 125.87003976520997), 'SIC0': (
    'johnsonsu', (-1.4572733672475742, 1.8836493470730886, 0.24371055734701969, 0.06964867603854612), -0.0, 1.0,
    0.3124313256274387, 0.05753899460423868), 'SIC1': (
    'norminvgauss', (1.5710427866479644, 0.19168495863653867, 0.6192068398789191, 0.1175254504888493), -0.0,
    1.0000000000000004, 0.6339548823784404, 0.09333492342594135), 'SIC2': (
    'johnsonsu', (0.7808863349419176, 2.1527543802345877, 0.8577580532047392, 0.13092359819597307), -0.0,
    1.0000000000000004, 0.8027516628118123, 0.07341722749726906), 'SIC3': (
    'johnsonsu', (1.9692203218924451, 1.9802567439669683, 0.9788481129952237, 0.06842133626067057), -0.0,
    1.0000000000000004, 0.8877565555899474, 0.06296564134771099), 'SIC4': (
    'powernorm', (86125.19196897314, 1.7997275070231722, 0.20486361493964045), -0.0, 1.0000000000000004,
    0.9078117336747534, 0.060990741214014516), 'SIC5': (
    'gompertz', (9.774928986043019e-11, -0.06942346014287343, 0.04371688245761682), -0.0, 1.0000000000000004,
    0.9124684385470687, 0.05938441551477935), 'BIC0': (
    'burr12', (1151.3733326064234, 0.3463094685018905, -18.347912067623454, 18.604907453083335), -0.0,
    1.5219280948873621, 0.2966887132438922, 0.052552063286322594), 'BIC1': (
    'norminvgauss', (1.5873576850307098, 0.16016835674384627, 0.5921934097362351, 0.1036595135371562),
    0.15767311441075044, 1.5219280948873621, 0.601932645920588, 0.0831822579223933), 'BIC2': (
    'crystalball', (1.2533225114775566, 22.913515753586335, 0.7708135127666345, 0.05609077709527769), 0.177622660637882,
    1.5219280948873621, 0.7629057765299484, 0.06640681172828361), 'BIC3': (
    'loggamma', (0.6743355909472617, 0.8814587573036805, 0.029009655088068256), 0.177622660637882, 1.5219280948873621,
    0.8435449650061588, 0.05282806344868261), 'BIC4': (
    'gengamma', (0.44654283228501557, 1416357.9633354028, -27350.49357150962, 27351.399400835195), 0.177622660637882,
    1.5219280948873621, 0.8625782975652837, 0.0498975212013101), 'BIC5': (
    'johnsonsu', (2.054019331138331, 1.4975617492393776, 0.9248454420960285, 0.025166271407912062), 0.177622660637882,
    1.5219280948873621, 0.8670186159560246, 0.048270007480036535), 'CIC0': (
    'burr', (21.038980606449865, 0.25515717855076614, -0.193105670486178, 4.4391920292060245), 0.0, 8.135528996465208,
    3.628327850435502, 0.679670025633002), 'CIC1': (
    'burr', (11.468941574571344, 0.35024060667079104, -0.413463184616762, 2.7906419432878247), -1.3322676295501878e-15,
    6.347734540004909, 1.94426102786283, 0.6058355862788555), 'CIC2': (
    'mielke', (2.8472374873261748, 6.997433289468844, -0.11667966152988232, 1.427184964809654), -1.3322676295501878e-15,
    5.949097202560697, 1.0515342655468982, 0.43960470242315064), 'CIC3': (
    'genlogistic', (203.5236454763996, -0.9175113568538307, 0.2551274216459887), -2.6645352591003757e-15,
    5.802151696400395, 0.592090887016663, 0.3440115473047051), 'CIC4': (
    'burr', (4.347666291977527, 0.33739696520313295, -0.01696344719554966, 0.7035344116824138), -2.6645352591003757e-15,
    5.587853777519797, 0.48274182455999154, 0.3213338198589061), 'CIC5': (
    'genlogistic', (363.09967893734506, -1.0144181570273048, 0.2273902670542074), -2.6645352591003757e-15,
    5.447694301838917, 0.4568425858874478, 0.3079213287355322), 'MIC0': (
    'johnsonsu', (-1.4105740007525456, 1.8848414131958124, 11.693925710666685, 5.87239342985923), -0.0,
    155.46526346756397, 17.256779883701096, 4.8749671533977645), 'MIC1': (
    'burr', (11.881321322198835, 0.49481806072407625, -0.20235297891649262, 36.88422993705357), -0.0,
    155.46526346756397, 33.18687135012882, 6.7699858232785255), 'MIC2': (
    'genlogistic', (0.6307399061290568, 41.65936600933333, 3.5860357207062843), -0.0, 155.46526346756397,
    38.44750628736468, 7.719993826758007), 'MIC3': (
    'mielke', (4.9731589902047695, 16.709319675379977, -0.329045019022585, 47.092029161704815), -0.0,
    155.46526346756397, 40.03733432792212, 8.10297045677583), 'MIC4': (
    'mielke', (4.925207474578404, 16.409462482950914, -0.12442509754342818, 47.31291228582921), -0.0,
    157.61250246882662, 40.36914899879246, 8.188048138332729), 'MIC5': (
    'burr', (17.40146299975538, 0.2850490556138604, -0.3047885736779298, 47.77225376708125), -0.0, 157.61250246882662,
    40.463752908685905, 8.21732365412936), 'ZMIC0': (
    'gennorm', (1.2233151165199674, 77.34391417073665, 30.129810896955192), -0.0, 1634.4509018421518, 76.40000109494723,
    33.69492623463577), 'ZMIC1': (
    'mielke', (2.6955296749855955, 8.514941093377708, -0.36698244814175873, 55.96954659536926), -0.0, 877.0401248877358,
    43.41647173043853, 17.70231660405346), 'ZMIC2': (
    'foldcauchy', (3.360934042979864, 11.910930914662027, 5.573726766012853), -0.0, 542.3248620173009,
    30.25575173683778, 10.28261587099519), 'ZMIC3': (
    'dgamma', (1.0317699408446175, 26.059142583311022, 4.444991959698575), -0.0, 371.8177902666409, 25.91515781850085,
    7.1782794562619365), 'ZMIC4': (
    'dgamma', (1.0720508875361463, 25.188876564115162, 3.8713135302158888), -0.0, 294.1947540666274, 25.011101236893175,
    6.264097644778944), 'ZMIC5': (
    'dgamma', (1.0494011996041954, 25.028627408212724, 3.8159654513471075), -0.0, 271.5503948447341, 24.750304282852582,
    5.928659524026725), 'Kier1': (
    'johnsonsu', (0.2962624952591478, 1.4878580130885912, 20.469743260663847, 9.59567872850518), 1.3333333333333333,
    470.27020408163264, 18.19594703584119, 8.886183835704921), 'Kier2': (
    'foldcauchy', (3.621428343086145, 0.4155124587317862, 2.291727006147198), 0.2222222222222222, 392.0,
    8.273833871130584, 4.6376404517127465), 'Kier3': (
    'hypsecant', (4.6428974200566175, 1.6553386327323611), 0.05333333333333334, 190.45027916203668, 4.749096110578549,
    3.1571211642521395), 'Lipinski': (
    'vonmises', (709.7827072898733, 0.9999595445690224, 0.1591009793261457), 0.0, 1.0, 0.8832223063039043,
    0.321155202279391), 'GhoseFilter': (
    'gennorm', (0.27553805029082035, 1.0, 0.0001438653954479279), 0.0, 1.0, 0.6763748335248043, 0.46785886557710704),
        'FilterItLogS': (
        'burr12', (29.891271879901453, 0.635278175474824, -35.07322496452836, 30.198632232139055), -52.38026145712952,
        23.53390411510895, -3.975989414493062, 2.1898380930161645), 'VMcGowan': (
    'burr', (9.005309070794134, 0.2559918440457596, -2.807706844607937, 328.5429776869584), 12.620000000000001,
    5217.879999999731, 240.42416845286053, 107.1124333004761), 'Mor01': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor02': ('norm', (0, 1), 0, 0, 0, 0), 'Mor03': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor04': ('norm', (0, 1), 0, 0, 0, 0), 'Mor05': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor06': ('norm', (0, 1), 0, 0, 0, 0), 'Mor07': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor08': ('norm', (0, 1), 0, 0, 0, 0), 'Mor09': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor10': ('norm', (0, 1), 0, 0, 0, 0), 'Mor11': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor12': ('norm', (0, 1), 0, 0, 0, 0), 'Mor13': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor14': ('norm', (0, 1), 0, 0, 0, 0), 'Mor15': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor16': ('norm', (0, 1), 0, 0, 0, 0), 'Mor17': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor18': ('norm', (0, 1), 0, 0, 0, 0), 'Mor19': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor20': ('norm', (0, 1), 0, 0, 0, 0), 'Mor21': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor22': ('norm', (0, 1), 0, 0, 0, 0), 'Mor23': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor24': ('norm', (0, 1), 0, 0, 0, 0), 'Mor25': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor26': ('norm', (0, 1), 0, 0, 0, 0), 'Mor27': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor28': ('norm', (0, 1), 0, 0, 0, 0), 'Mor29': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor30': ('norm', (0, 1), 0, 0, 0, 0), 'Mor31': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor32': ('norm', (0, 1), 0, 0, 0, 0), 'Mor01m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor02m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor03m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor04m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor05m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor06m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor07m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor08m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor09m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor10m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor11m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor12m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor13m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor14m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor15m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor16m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor17m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor18m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor19m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor20m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor21m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor22m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor23m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor24m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor25m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor26m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor27m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor28m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor29m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor30m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor31m': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor32m': ('norm', (0, 1), 0, 0, 0, 0), 'Mor01v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor02v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor03v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor04v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor05v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor06v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor07v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor08v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor09v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor10v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor11v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor12v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor13v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor14v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor15v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor16v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor17v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor18v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor19v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor20v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor21v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor22v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor23v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor24v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor25v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor26v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor27v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor28v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor29v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor30v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor31v': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor32v': ('norm', (0, 1), 0, 0, 0, 0), 'Mor01se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor02se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor03se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor04se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor05se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor06se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor07se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor08se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor09se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor10se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor11se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor12se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor13se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor14se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor15se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor16se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor17se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor18se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor19se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor20se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor21se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor22se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor23se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor24se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor25se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor26se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor27se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor28se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor29se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor30se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor31se': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor32se': ('norm', (0, 1), 0, 0, 0, 0), 'Mor01p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor02p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor03p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor04p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor05p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor06p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor07p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor08p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor09p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor10p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor11p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor12p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor13p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor14p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor15p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor16p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor17p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor18p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor19p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor20p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor21p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor22p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor23p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor24p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor25p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor26p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor27p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor28p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor29p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor30p': ('norm', (0, 1), 0, 0, 0, 0), 'Mor31p': ('norm', (0, 1), 0, 0, 0, 0),
        'Mor32p': ('norm', (0, 1), 0, 0, 0, 0), 'LabuteASA': (
    'burr', (9.0964308819358, 0.24498507190852034, -0.6627288438219012, 186.15961293636502), 6.09714072430475,
    3187.0035261657326, 136.8989707258897, 60.11696633844022), 'PEOE_VSA1': (
    'dgamma', (0.6797555632880312, 9.843390348640753, 9.063710080707587), 0.0, 546.8358147143317, 11.513786786927618,
    9.629080398360042), 'PEOE_VSA2': (
    'gennorm', (0.3743143225060378, 4.794537184071823, 0.13356969497905868), 0.0, 412.3301978301771, 7.442460999131086,
    7.229328332694745), 'PEOE_VSA3': (
    'halfgennorm', (0.2261513615359357, -1.0585732232597231e-23, 0.0007280904592050337), 0.0, 116.96330578647762,
    4.656396140593678, 5.391374759131406), 'PEOE_VSA4': (
    'lomax', (2.042666801373449, -2.0842184562101312e-10, 0.9830194560352736), 0.0, 209.82840072207244,
    2.364729705429073, 4.523190845877331), 'PEOE_VSA5': (
    'gilbrat', (-0.15065770764676178, 0.41809510617202056), 0.0, 138.59202496395514, 2.578091231682236,
    5.263422054304538), 'PEOE_VSA6': (
    'recipinvgauss', (2911271.411605034, -2.6198312530376407e-12, 23.623150541422945), 0.0, 546.5716914253613,
    22.726988730602212, 19.779487985816182), 'PEOE_VSA7': (
    'dweibull', (1.2968206850624888, 28.577401102875054, 17.044551072971473), 0.0, 467.1205835943879, 32.73997755795206,
    19.772794852255593), 'PEOE_VSA8': (
    'exponpow', (0.8446433626196224, -6.850110547034733e-28, 35.10329613945393), 0.0, 352.4497028281983,
    18.040121559249986, 13.480580424967933), 'PEOE_VSA9': (
    'exponpow', (0.738939049829366, -1.0103946348149454e-27, 22.30531800818659), 0.0, 465.4640026661613,
    13.164092729480279, 10.195250119604879), 'PEOE_VSA10': (
    'halfgennorm', (0.09831975809499452, -0.0002185641662521225, 3.4221593281789384e-11), -0.061901615733403276,
    343.80026926970595, 7.257696728734952, 8.247461222955435), 'PEOE_VSA11': (
    'halfgennorm', (0.25384939030860243, -8.839580952909237e-26, 0.0014172275949480564), 0.0, 259.01952579748405,
    4.172900491813558, 5.7759451899294945), 'PEOE_VSA12': (
    'gamma', (0.5810118709511618, -2.6280412440029743e-27, 1.5408578702091629), 0.0, 437.1312999720119,
    4.146283199904663, 6.5233543686820425), 'PEOE_VSA13': (
    'halfgennorm', (0.22512244911971263, -1.4508667498608876e-24, 0.00015093354599052028), 0.0, 104.57373378967445,
    3.1588028598613307, 4.489977758801154), 'SMR_VSA1': (
    'dgamma', (1.6713238933604289, 11.994000597724924, 4.402003389438558), 0.0, 1026.9379414997509, 13.718723499568217,
    11.212717895301873), 'SMR_VSA2': (
    'frechet_r', (0.575763391191825, -1.3090078393176326e-28, 0.04579052149253804), 0.0, 43.27426884633218,
    0.43769398040245117, 1.6269061064902643), 'SMR_VSA3': (
    'chi', (0.30991476726715067, -7.956246256954298e-29, 16.982667070876595), 0.0, 364.36060551482905,
    8.690795714130804, 7.923269249744683), 'SMR_VSA4': (
    'pareto', (1.4342778696694785, -0.5749686430698792, 0.5749686427258204), 0.0, 139.45040514188452,
    3.5877640921649485, 6.191011356330586), 'SMR_VSA5': (
    'mielke', (0.7450719237183094, 6.202308733968751, -1.4791159897705868e-19, 45.859261573680364),
    -0.061901615733403276, 919.7789929624, 23.530862643220537, 22.19440496438067), 'SMR_VSA6': (
    'nakagami', (0.13687704680360116, -4.656912433515596e-27, 25.670537313578457), 0.0, 421.3782661507248,
    14.525095451632389, 13.8656339450239), 'SMR_VSA7': (
    'kappa3', (0.14958434776970064, -7.980212128143566e-24, 3.6558297756252616), 0.0, 882.2645200274713,
    45.842206966024385, 29.746058973578617), 'SMR_VSA8': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SMR_VSA9': ('burr', (1.3675946447500311, 0.5539666989604425, -9.90690132136378e-31, 0.6204616481380272), 0.0,
                       183.53970795760154, 5.261086551860162, 7.2415767671592715), 'SlogP_VSA1': (
    'nakagami', (0.1969468890238392, -3.679507948306524e-26, 9.778778251023368), 0.0, 870.2580768595975,
    7.8678317666350805, 8.160160816581602), 'SlogP_VSA2': (
    'invgamma', (9.526233075336318, -23.738143946924502, 483.9808829176901), -0.061901615733403276, 1189.9355263842574,
    32.666036691827614, 22.532725579941896), 'SlogP_VSA3': (
    'exponpow', (0.5907095808511731, -2.5609360033816314e-27, 18.00847429488926), 0.0, 442.808021505953,
    10.2049986526518, 9.522088356910022), 'SlogP_VSA4': (
    'mielke', (0.6782685956404886, 0.9206138937713855, -3.8142590817079935e-28, 1.6349352810665856), 0.0,
    116.3464586161694, 6.618030511263571, 7.943929340940349), 'SlogP_VSA5': (
    'halfnorm', (-1.3670666886738449e-10, 30.046431261449467), 0.0, 616.1687457614408, 22.849304873998594,
    18.731792438068187), 'SlogP_VSA6': (
    'exponpow', (0.12973156786511914, -1.810805720898524e-24, 3.0800607097293407), 0.0, 793.2492961603192,
    37.75746155643546, 25.3543925369879), 'SlogP_VSA7': (
    'halfgennorm', (0.40606063168428597, -2.390434154556914e-11, 0.002842735370294993), 0.0, 78.56413624417304,
    0.7408561345804288, 2.259780122509873), 'SlogP_VSA8': (
    'burr', (0.9110999323448428, 0.6558918586401867, -2.1674136969452136e-27, 0.10477226627944583), 0.0,
    363.5139809255063, 4.867913955305813, 7.593236336798034), 'SlogP_VSA9': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'SlogP_VSA10': (
    'mielke', (0.23187784437574818, 1.5768175365217256, -5.080335785535852e-25, 2.41551823255653), 0.0,
    158.05494171629354, 4.347970808011295, 5.827780077357009), 'SlogP_VSA11': (
    'halfgennorm', (0.26444965885815397, -1.391143919899192e-20, 0.0005553174223491011), 0.0, 172.48535499851724,
    2.817046490663293, 5.038975628131706), 'EState_VSA1': (
    'gilbrat', (-1.3276012030324262, 4.477835181542019), 0.0, 1345.5786461266837, 8.624083576509467,
    16.740638041604914), 'EState_VSA2': (
    'nakagami', (0.22427591027166366, -1.994747789364048e-26, 22.073317211898235), 0.0, 1030.7113015906127,
    13.75128415953216, 11.861305801737526), 'EState_VSA3': (
    'exponpow', (0.7077861353616601, -9.56801133204424e-28, 33.416438465186594), 0.0, 350.16474411918483,
    16.26343573490295, 13.278555476074526), 'EState_VSA4': (
    'nakagami', (0.13101651191860858, -3.58130294865927e-26, 25.689797178488465), -0.061901615733403276,
    424.16192503410355, 17.55499237802841, 15.077014203642754), 'EState_VSA5': (
    'mielke', (0.3620787629320644, 0.8277959875592636, -1.1781338250263231e-24, 1.3451758789735502), 0.0,
    385.7450365075064, 12.21058797723583, 13.090781429089965), 'EState_VSA6': (
    'frechet_r', (0.43296705888879905, -2.0142528869027466e-25, 2.2725328714181106), 0.0, 339.71655583384995,
    15.444312445479303, 15.445545866896705), 'EState_VSA7': (
    'genpareto', (3.459608365967048, -5.96692908441174e-11, 1.151755253848489), 0.0, 291.3014557466244,
    19.333259206001383, 20.231258583096356), 'EState_VSA8': (
    'nakagami', (0.2639891354760462, -4.833774646587458e-27, 29.85664382409023), 0.0, 719.3288167744948,
    15.716174546376557, 15.361486714839408), 'EState_VSA9': (
    'exponweib', (0.6001189238101621, 0.42940666043159753, -7.641543908896475e-30, 2.9461590926011483), 0.0,
    361.43072638195883, 8.29954254560719, 8.06360973329626), 'EState_VSA10': (
    'exponpow', (0.643699941077595, -1.3818456922836198e-28, 16.191146100831162), 0.0, 520.5032437541387,
    9.466226810584546, 8.699743255689329), 'VSA_EState1': (
    'norminvgauss', (8.841258700749595, 8.832525364774051, -1.2716156327306969, 0.577537725264282), -9.819444444444443,
    934.3549853205029, 11.906015173106042, 15.404351371410385), 'VSA_EState2': (
    'mielke', (1.4124107487452369, 3.874254182166398, -4.694956057020322, 33.56261114712012), -14.32262345679012,
    1274.107397462619, 18.112237095826078, 16.819199983546312), 'VSA_EState3': (
    'exponnorm', (70.34765191620806, -0.22439545298066807, 0.11461492800899747), -16.317788879440666, 382.0614226702732,
    7.767988728231611, 9.215164458970682), 'VSA_EState4': (
    'burr12', (50.641932857408584, 0.27183628184041336, -28.0079347186933, 28.162447072429348), -51.01721198039664,
    94.11012961627455, 2.1677674025515836, 2.768135437733604), 'VSA_EState5': (
    'cauchy', (0.10394124092618076, 0.5470469224789652), -152.20027429489576, 27.48909392092964, 0.17520406706240396,
    1.9258675839393704), 'VSA_EState6': (
    'genextreme', (0.08060583515037695, 5.854712894928454, 6.965905279606472), -106.84966312387768, 159.7394176043044,
    8.967334964275553, 7.124575301424593), 'VSA_EState7': (
    'johnsonsu', (-0.7924873092812137, 0.9290723433678282, 0.18532772975997816, 1.2634748802279574), -148.321605341063,
    101.40711789371618, 2.0922261565698608, 3.2301316856273936), 'VSA_EState8': (
    'burr12', (73.64912439249508, 0.07839110756764125, -15.387131114579311, 15.162492946492947), -128.2949450461895,
    102.2753537530557, 2.7961710415229724, 2.8832839199939366), 'VSA_EState9': (
    'dweibull', (0.5882977908402547, -8.970199128750003e-32, 0.5760085161900701), -147.675790909401, 27.588300769902506,
    0.18525868470562049, 2.055581304898749), 'MDEC-11': (
    'exponnorm', (25.38539850794546, 0.04688414056736427, 0.018879424915497704), 0.0, 33.45157353677909,
    0.529399621185521, 0.715810243084704), 'MDEC-12': (
    'exponnorm', (4.208109050274016, 0.9429427480055352, 0.4486819626298635), 0.0, 40.355990767829844,
    2.8101395604665838, 1.9401878683359044), 'MDEC-13': (
    'exponnorm', (7.515246899004921, 0.5953906060504, 0.30438911822595216), 0.0, 50.984778696524344, 2.8745087343362488,
    2.587898100244769), 'MDEC-14': (
    'pearson3', (1.8959724949486714, 1.4206440626536074, 1.3485194877832836), 0.0, 30.77479574420852, 1.413814524006418,
    1.416052259670712), 'MDEC-22': (
    'mielke', (0.9258686151964272, 6.657345724759478, -1.7651785494175085e-17, 18.5785552699525), 0.0,
    68.77608777876988, 9.7140905321011, 6.933338104299465), 'MDEC-23': (
    'burr', (6.917018495600609, 0.16718293501476506, -0.049766429315054345, 25.027505531136452), 0.0, 83.87540692315564,
    14.550520042726662, 8.658043386082465), 'MDEC-24': (
    'norminvgauss', (2.0239551899077424, 1.7160782993784014, 0.9831530536433704, 1.140438181909881), 0.0,
    36.9872225047038, 2.8273449369222785, 2.1782830267022786), 'MDEC-33': ('genexpon', (
    0.18111294764717925, 0.6592161149247522, 0.9247970066486889, -1.3647364163925174e-09, 3.355476289068404), 0.0,
                                                                           108.11545671039127, 5.861398921443405,
                                                                           4.716919503825704), 'MDEC-34': (
    'johnsonsu', (-1.2889006405313357, 1.0591067578959066, 0.903694714340666, 0.6289704632250377), 0.0,
    41.8486261216016, 2.4271079849472117, 2.189150222519687), 'MDEC-44': (
    'gennorm', (0.2447050548227666, 1.0, 0.0003637007796157321), 0.0, 35.05573519420005, 0.9124123705191318,
    1.145972419049189), 'MDEO-11': (
    'exponnorm', (13.468056716866801, 0.0807995155854373, 0.04318398376512071), 0.0, 37.235551716884494,
    0.6565411359243059, 0.8957495521077666), 'MDEO-12': (
    'burr12', (2.607259551047828, 0.9372566514806085, -0.049279723718418905, 0.5490766663173621), 0.0,
    41.65343528592975, 0.6968568514094572, 0.8404890620262644), 'MDEO-22': (
    'exponnorm', (22.517796882799203, 0.060937626165160526, 0.01748695169406673), 0.0, 27.625008349340263,
    0.4484209462942085, 0.6274464076929313), 'MDEN-11': (
    'dgamma', (0.5290414769360985, 0.24999999999999997, 0.20632951731352694), 0.0, 7.499999999999998,
    0.3500797764455901, 0.37756001324697985), 'MDEN-12': (
    'exponnorm', (9.255412970862512, 0.15175815648065266, 0.05755060280140864), 0.0, 14.363643572585554,
    0.678020559766345, 0.668337368390368), 'MDEN-13': (
    'norminvgauss', (6.646983762214335, 6.381948565085676, 0.02167267162423123, 0.10838347141268925), 0.0,
    4.500000000000001, 0.3967242763350655, 0.28792262950984127), 'MDEN-22': (
    'exponnorm', (27.75705816574319, 0.10305810419915469, 0.030894995426027208), 0.0, 28.262025492057816,
    0.9588776957000407, 0.9304856730802744), 'MDEN-23': (
    'fatiguelife', (0.7205180268593808, -0.053907465526459544, 0.7380212192227515), 0.0, 46.988248326732,
    0.8855756753091376, 0.7154568031810566), 'MDEN-33': (
    'norminvgauss', (3.8863503670697863, 3.694187109913714, 0.0726991243564502, 0.1136316712019165), 1e-08,
    20.53570384365925, 0.4222529819981966, 0.368994814473952), 'MID': (
    'mielke', (2.060650641475558, 9.504334291251038, -0.262892295747326, 65.46258927967588), 1.0, 971.2256936239659,
    46.25527567418836, 20.820342920594886), 'AMID': (
    'johnsonsu', (1.0386689469885808, 1.4759726600280128, 2.0603740925579306, 0.0506131950229661), 1.0,
    2.2514788685783538, 2.0114571281749596, 0.05705049701147953), 'MID_h': (
    'mielke', (1.7675418638836322, 7.450518145682109, -0.44820233420428485, 17.968793566828992), 0.0,
    361.84268967407246, 11.99618899599464, 6.522863374181982), 'AMID_h': (
    'johnsonsu', (-0.36023823280713063, 1.834607698952498, 0.4659594346871079, 0.26569626057945095), 0.0,
    2.141702554369893, 0.5273057473803122, 0.1728501560521846), 'MID_C': (
    'mielke', (1.8870834970067567, 8.962894626954352, -0.14276133390852241, 49.60889465898357), 0.0, 626.3152110917201,
    34.25903441358088, 15.83264743573066), 'AMID_C': (
    'burr', (262.38373122457466, 0.565701196402997, -20.445432563164974, 22.017178192545188), 0.0, 2.2514788685783538,
    1.4841493545344262, 0.19458050843442695), 'MID_N': (
    'dweibull', (1.3075100153249661, 5.125739505969723, 3.0906135422980845), 0.0, 171.53182058105742, 5.294225990816125,
    3.8200588212730056), 'AMID_N': (
    'foldcauchy', (2.7208284572700387, -1.0416169852612982e-09, 0.07822114642362328), 0.0, 1.6776157129688625,
    0.23405641767260085, 0.15373776180903723), 'MID_O': (
    'dgamma', (1.8172720521747041, 4.616186112429022, 1.4688644553147823), 0.0, 193.68760445635664, 5.113467070038761,
    3.8703853862385373), 'AMID_O': (
    'gennorm', (1.241623335086675, 0.21909281828241545, 0.1340047883061429), 0.0, 1.385569534355964,
    0.22851096198572013, 0.13600192110329368), 'MID_X': (
    'gilbrat', (-0.039514046806889455, 0.10989619880061427), 0.0, 61.330147988772154, 0.6962694132110887,
    1.5166839552490812), 'AMID_X': (
    'lomax', (3.6928646802914464, -2.796760985097841e-12, 0.017413326495492), 0.0, 1.5, 0.0286413853044517,
    0.06467623139686966), 'MOMI-X': ('norm', (0, 1), 0, 0, 0, 0), 'MOMI-Y': ('norm', (0, 1), 0, 0, 0, 0),
        'MOMI-Z': ('norm', (0, 1), 0, 0, 0, 0), 'PBF': ('norm', (0, 1), 0, 0, 0, 0), 'MPC2': (
    'mielke', (2.067216348018385, 8.119177254891007, -0.05098596832824698, 48.15836028915771), 0.0, 758.0,
    34.82743955594416, 16.034633698413966), 'MPC3': (
    'mielke', (1.9135251515561844, 7.860005819431674, -0.7854278759162621, 64.88529775728767), 0.0, 991.0,
    45.182553530189026, 22.12144191732558), 'MPC4': (
    'mielke', (1.5239387459841183, 6.64937523353627, -0.36279352274696414, 86.3605586672208), 0.0, 1358.0,
    57.369574280938245, 31.294587400549997), 'MPC5': (
    'logistic', (67.23178538125225, 23.253358972888076), 0.0, 1789.0, 69.00703410797395, 43.57683243745075), 'MPC6': (
    'foldnorm', (0.003721404092651334, -1.497665544399537e-10, 90.3824268247522), 0.0, 2720.0, 72.39169342686004,
    54.48653596464316), 'MPC7': (
    'nakagami', (0.27109885132635925, -3.0425661555695595e-27, 100.86602278061795), 0.0, 4248.0, 79.33872719502202,
    69.72279814342593), 'MPC8': (
    'nakagami', (0.2292908614116027, -1.2558281290718913e-24, 129.78653591198287), 0.0, 6408.0, 85.9383607208719,
    86.55327592334828), 'MPC9': (
    'beta', (0.4193702542631789, 87.39323055754363, -9.97124012158597e-26, 23063.580839004244), 0.0, 9184.0,
    90.48416410827456, 102.84584215336324), 'MPC10': (
    'gompertz', (51433241405.447235, -6.313207690600209e-11, 4815856390994.138), 0.0, 13152.0, 93.09231384511631,
    119.25490018767742), 'TMPC10': (
    'kappa3', (4.578677436647152, 0.9999999991975512, 833.2863247352566), 1.0, 40115.0, 675.4824741971615,
    549.6529520635369), 'piPC1': (
    'johnsonsu', (1.1782477375718363, 1.1255235973896698, 3.8675610497948294, 0.2660403031522569), 0.0,
    6.429719478039138, 3.394121699246979, 0.5097473087090069), 'piPC2': (
    'johnsonsu', (1.4737139423524641, 1.2077268740193077, 4.54226896442867, 0.28971543760884105), 0.0,
    7.055744156695586, 3.9287156864232955, 0.5931264069168012), 'piPC3': (
    'johnsonsu', (1.604879737542559, 1.2658623039533312, 5.179803860981824, 0.3558845454608236), 0.0, 7.529272184590755,
    4.398465131207924, 0.7187136306242671), 'piPC4': (
    'johnsonsu', (1.6983556314507653, 1.2774942312638975, 5.8263938956579935, 0.41820628935005105), 0.0,
    8.065854287399658, 4.839269978829238, 0.904928765618812), 'piPC5': (
    'johnsonsu', (1.515023645004076, 1.1488510605658266, 6.315222185722765, 0.4463345206932801), 0.0, 8.70855707619442,
    5.1672624902739726, 1.1845719482976298), 'piPC6': (
    'johnsonsu', (1.6879436676041308, 1.2239738694400675, 6.767985701828554, 0.6046134463377248), 0.0,
    9.304445280277989, 5.2104813150703215, 1.4971228656285969), 'piPC7': (
    'johnsonsu', (1.5137358858965204, 1.0937203957629784, 7.1209627037605845, 0.6724952314433714), 0.0,
    10.009029301770157, 5.250245340041788, 1.9584337081709617), 'piPC8': (
    'johnsonsu', (1.5881710670507925, 1.0774684303172495, 7.5989125751581925, 0.7572382067782378), 0.0,
    10.668661746914253, 5.224835384620026, 2.430477400118903), 'piPC9': (
    'fisk', (0.2743891491076923, -4.0201311040044082e-28, 2.2817275490038726), 0.0, 11.38734209050216, 5.23521629010054,
    2.733006153258735), 'piPC10': (
    'lognorm', (7.554921236493771, -2.94162768444025e-25, 1.8285745737834915), 0.0, 12.18322849328366,
    5.325794531322389, 2.846546767865571), 'TpiPC10': (
    'genlogistic', (0.21935520157334992, 8.97107198535923, 0.33107419577171426), 0.6931471805599453, 12.769736431820743,
    7.562609204897683, 1.5144952643770313), 'apol': (
    'mielke', (2.1971822572888815, 8.510021100186473, 0.03774257533126395, 64.4599305062213), 1.2237930000000001,
    1341.17586500003, 47.50055025169642, 21.454223925374627), 'bpol': (
    'nakagami', (1.0371349171969595, 1.5515797815254406, 27.725393961561494), 0.0, 667.3101349999926,
    25.759322022807947, 12.914904713951437), 'nRing': (
    'gennorm', (0.09270560108121037, 3.000326188310267, 1.0089103823025651e-12), 0.0, 48.0, 2.8770873931062604,
    1.3321494158237002), 'n3Ring': (
    'beta', (0.3013901412673222, 347.8348644555971, -1.7974274832006555e-30, 19.590819314023754), 0.0, 20.0,
    0.10060264347580604, 0.3403329214011643), 'n4Ring': (
    'gengamma', (1.2158529631130597, 0.680615270918926, -5.104918228365214e-30, 0.0186675533642499), 0.0, 12.0,
    0.11146878500226759, 0.4675214215841552), 'n5Ring': (
    'fisk', (0.43800131493022587, -1.1412720304864933e-28, 0.23552774130327528), 0.0, 26.0, 0.7308310101956663,
    0.7850801603117676), 'n6Ring': (
    'dgamma', (0.3384090236622897, 1.9999999999999998, 1.2330223574456185), 0.0, 32.0, 1.8873745472985601,
    1.3020351258521268), 'n7Ring': (
    'wald', (-0.005560846678228157, 0.01842345202152962), 0.0, 4.0, 0.03249517401640769, 0.18548165331885527),
        'n8Ring': (
        'wald', (-0.0008391456614791086, 0.0027726641008927223), 0.0, 10.0, 0.005567688585846308, 0.07784264313536758),
        'n9Ring': ('genhalflogistic', (1.0324848071443045e-08, -0.000137789353996829, 0.0026941022970623724), 0.0, 2.0,
                   0.000752814231325698, 0.02799311989931423), 'n10Ring': (
    'genhalflogistic', (2.2686270567561925e-11, -1.2793853280508567e-07, 0.0013420420809865242), 0.0, 4.0,
    0.00038294196142088456, 0.0215366525782144), 'n11Ring': (
    'genhalflogistic', (1.3875652104787876e-10, -6.622761125939263e-07, 0.0013420430009228666), 0.0, 2.0,
    0.00029276108995999366, 0.017708384661789818), 'n12Ring': (
    'halflogistic', (-1.9658953056981434e-10, 0.0014001527887523488), 0.0, 6.0, 0.001755259570608355,
    0.04281601011126311), 'nG12Ring': (
    'halflogistic', (-1.2580136054633328e-08, 0.006999904143629505), 0.0, 22.0, 0.007319027248999842,
    0.13425508982961504), 'nHRing': (
    'dgamma', (3.1265425311807085, 1.4919848374792446, 0.263661977876027), 0.0, 46.0, 1.3925168174255582,
    0.9929844090181476), 'n3HRing': (
    'frechet_r', (0.8136136856713632, -8.295151080495225e-29, 0.014219896526014384), 0.0, 20.0, 0.04320055833722156,
    0.2254218807532488), 'n4HRing': (
    'frechet_r', (0.784536000505533, -2.381945695524649e-29, 0.016500398805880494), 0.0, 6.0, 0.056884525354548056,
    0.2968875308579847), 'n5HRing': (
    'halfgennorm', (0.2041007448770498, -3.1018174544447507e-25, 1.9761829537497114e-05), 0.0, 26.0, 0.664536306949547,
    0.7488223370297451), 'n6HRing': (
    'loglaplace', (0.6221703468211712, -1.2818036978483853e-25, 0.008210371415470801), 0.0, 20.0, 0.5893594413491058,
    0.741191183077624), 'n7HRing': (
    'wald', (-0.004242665608877409, 0.014045504787469618), 0.0, 4.0, 0.026037439438316937, 0.16471715561954126),
        'n8HRing': ('exponnorm', (2003.9061423795883, -8.436326388084296e-06, 2.3186603341474564e-06), 0.0, 10.0,
                    0.004371811812125799, 0.06924200059825224), 'n9HRing': (
    'genhalflogistic', (4.804897652509919e-13, -0.00047658077289150914, 0.0013426815532828072), 0.0, 2.0,
    0.0006600194215615929, 0.026186316635924498), 'n10HRing': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 4.0,
    0.00019996628019588853, 0.016367305507206834), 'n11HRing': (
    'genhalflogistic', (2.2686270567561925e-11, -1.2793853280508567e-07, 0.0013420420809865242), 0.0, 2.0,
    0.00024440323135053045, 0.016206204569038842), 'n12HRing': (
    'genhalflogistic', (2.2943552930087887e-11, -5.205393403545636e-06, 0.0013754202537865083), 0.0, 6.0,
    0.001584046611747823, 0.04064620206447852), 'nG12HRing': (
    'halflogistic', (-3.2288502825797057e-07, 0.004100584204174239), 0.0, 22.0, 0.007022345251585027,
    0.1329946052425725), 'naRing': (
    'gennorm', (0.14899035743374986, 2.0022464383422838, 9.3218396664275e-07), 0.0, 28.0, 1.9066118262410652,
    1.279619946295601), 'n3aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    9.148784061249802e-06, 0.0030246818611219225), 'n4aRing': (
    'genhalflogistic', (3.5231269011012516e-08, -1.869533382298461e-07, 0.0013420602505800783), 0.0, 2.0,
    0.0005371643213105241, 0.023226917877877142), 'n5aRing': (
    'halfgennorm', (0.2003553056427284, -2.635437492882027e-24, 2.4570028677521566e-06), 0.0, 12.0, 0.43729358055961803,
    0.6240301816185914), 'n6aRing': (
    'exponweib', (0.17481162022566488, 1.5068138614813509, -3.995335591056791e-28, 2.4481480963992928), 0.0, 20.0,
    1.4673015922805175, 1.0978771534841465), 'n7aRing': (
    'genhalflogistic', (9.363414634568922e-09, -1.1867094305977415e-06, 0.0013420509262318508), 0.0, 4.0,
    0.0013148109665167573, 0.03740778264806876), 'n8aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.001143226768160523), 'n9aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    3.398119794178498e-05, 0.005829240363887167), 'n10aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 2.0,
    3.9209074548213434e-06, 0.002556331430882997), 'n11aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n12aRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.0011432267681605226), 'nG12aRing': (
    'genhalflogistic', (0.0015444968925378932, -6.792248544078424e-06, 0.004514790503813572), 0.0, 4.0,
    0.0001163202544930332, 0.012781142889009724), 'naHRing': (
    'alpha', (1.0896344100462849e-07, -0.033012982785839085, 0.0473400409714011), 0.0, 26.0, 0.7241746163065313,
    0.8155013445763114), 'n3aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    6.534845758035573e-06, 0.0025563260851907176), 'n4aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    7.841814909642687e-06, 0.002800313092420487), 'n5aHRing': (
    'halfgennorm', (0.26573287366657283, -4.271868606212921e-26, 0.0001497287644908454), 0.0, 12.0, 0.43706486095808683,
    0.6239191818456981), 'n6aHRing': (
    'halfgennorm', (0.3182033961538323, -7.156360781511646e-25, 0.0004293818260366595), 0.0, 20.0, 0.2862458487392322,
    0.5146312854684673), 'n7aHRing': (
    'genhalflogistic', (9.363414634568922e-09, -1.1867094305977415e-06, 0.0013420509262318508), 0.0, 2.0,
    0.0006940006195033779, 0.026433820368042434), 'n8aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.001143226768160523), 'n9aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    3.398119794178498e-05, 0.005829240363887167), 'n10aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 2.0,
    3.9209074548213434e-06, 0.002556331430882997), 'n11aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n12aHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.3069691516071146e-06, 0.0011432267681605226), 'nG12aHRing': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 4.0,
    0.0001163202544930332, 0.012781142889009724), 'nARing': (
    'burr12', (0.5756117533219619, 2.1895663500892915, -1.8504085135908619e-28, 0.9597707802796165), 0.0, 32.0,
    0.9704755668651953, 1.111367120414234), 'n3ARing': (
    'wald', (-0.017514587240547136, 0.058391676302725515), 0.0, 20.0, 0.10059349469174479, 0.34032218456252866),
        'n4ARing': (
        'exponweib', (1.543430913317417, 0.5025617800834752, -1.6739195840323138e-30, 0.005103546783653385), 0.0, 12.0,
        0.11093162068095706, 0.46707169357972617), 'n5ARing': (
    'gilbrat', (-0.015711029956778637, 0.043491269531785066), 0.0, 20.0, 0.2935374296360483, 0.5864893698523241),
        'n6ARing': (
        'pareto', (2.199945133078818, -0.09588887258752354, 0.09588887246211439), 0.0, 16.0, 0.4200729550180427,
        0.7350075906088294), 'n7ARing': (
    'pearson3', (2.3532394409833612, 0.01062521776133899, 0.012501840752509924), 0.0, 4.0, 0.031180363049890934,
    0.1809593382569381), 'n8ARing': ('genexpon', (
    1.8627274541481011, 8.170569784799848e-09, 2.610477376970607, -1.4792663782821527e-09, 0.010427460628324923), 0.0,
                                     10.0, 0.005566381616694701, 0.0778343412192515), 'n9ARing': (
    'genhalflogistic', (3.5231269011012516e-08, -1.869533382298461e-07, 0.0013420602505800783), 0.0, 2.0,
    0.000718833033383913, 0.027380350109021612), 'n10ARing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 4.0,
    0.00037902105396606323, 0.021384469740985877), 'n11ARing': (
    'genhalflogistic', (2.2686270567561925e-11, -1.2793853280508567e-07, 0.0013420420809865242), 0.0, 2.0,
    0.00029276108995999366, 0.017708384661789818), 'n12ARing': (
    'halflogistic', (-9.167492647116605e-09, 0.002000224264822819), 0.0, 6.0, 0.0017539526014567477,
    0.04280079834685604), 'nG12ARing': (
    'exponnorm', (2562.464391036465, -1.0650316973468792e-05, 2.7544405411128356e-06), 0.0, 22.0, 0.007202706994506809,
    0.13365158874113695), 'nAHRing': (
    'recipinvgauss', (526240.501380272, -7.105883101291517e-13, 0.22149873784237784), 0.0, 32.0, 0.668342201119027,
    0.8293524175168359), 'n3AHRing': (
    'frechet_r', (0.8135867806726818, -1.7502125602978344e-28, 0.014567831463981735), 0.0, 20.0, 0.04319402349146353,
    0.22540863792641222), 'n4AHRing': (
    'wald', (-0.009031620181197087, 0.029952442348175068), 0.0, 6.0, 0.056876683539638415, 0.296875826328762),
        'n5AHRing': (
        'gilbrat', (-0.005880933097150617, 0.01609404454258202), 0.0, 20.0, 0.22747144599146027, 0.5047200355440372),
        'n6AHRing': (
        'gilbrat', (-0.021158793508237163, 0.0590229230871277), 0.0, 16.0, 0.30311359260987364, 0.5605133779883301),
        'n7AHRing': (
        'wald', (-0.0041282693584374, 0.013666299120118929), 0.0, 4.0, 0.025343438818813558, 0.16268238159776316),
        'n8AHRing': ('halflogistic', (-2.5855991277207054e-09, 0.0043996373529214365), 0.0, 10.0, 0.004370504842974191,
                     0.069232644782898), 'n9AHRing': (
    'hypsecant', (0.0007899936257257517, 0.0014086650986068774), 0.0, 2.0, 0.0006260382236198079, 0.02553009366991271),
        'n10AHRing': (
        'genhalflogistic', (1.3875652104787876e-10, -6.622761125939263e-07, 0.0013420430009228666), 0.0, 4.0,
        0.0001960453727410672, 0.01616648992617908), 'n11AHRing': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 2.0,
    0.00024440323135053045, 0.016206204569038842), 'n12AHRing': (
    'genhalflogistic', (7.907290671412047e-10, -8.824945023327373e-06, 0.001342054973785443), 0.0, 6.0,
    0.0015827396425962157, 0.040630172433879175), 'nG12AHRing': (
    'halflogistic', (-2.9424343646140343e-09, 0.005300380898814575), 0.0, 22.0, 0.006906024997091993,
    0.1323850974666288), 'nFRing': (
    'lomax', (1.2674766419013324, -6.965530280724182e-14, 0.04289811542774811), 0.0, 8.0, 0.4889005644799766,
    0.5582345985945036), 'n4FRing': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 1.0,
    1.1762722364464032e-05, 0.0034296623744658346), 'n5FRing': (
    'wald', (-0.0025093442078070274, 0.008299749616474417), 0.0, 2.0, 0.0161110087318609, 0.12624462005768355),
        'n6FRing': (
        'wald', (-0.0033879758366848166, 0.011211757199463174), 0.0, 4.0, 0.021236941744464007, 0.14434541515949623),
        'n7FRing': (
        'wald', (-0.003243080171197355, 0.010731265217046196), 0.0, 3.0, 0.02121210933058347, 0.14466110002842278),
        'n8FRing': (
        'wald', (-0.004457324502328058, 0.014759455446886583), 0.0, 3.0, 0.028687972877776167, 0.16807504877438725),
        'n9FRing': (
        'gilbrat', (-0.0021793090886942502, 0.005940229426502177), 0.0, 8.0, 0.17442940994263711, 0.3987086501138418),
        'n10FRing': ('halfgennorm', (0.4523210429909895, -6.1910475825374085e-21, 0.0015732655473477443), 0.0, 4.0,
                     0.1292723187854597, 0.34919505018673974), 'n11FRing': (
    'exponweib', (1.2230945458422484, 0.8131721022501902, -3.6924132170527556e-30, 0.001424070794771532), 0.0, 4.0,
    0.008635145184668206, 0.09311479399667331), 'n12FRing': (
    'wald', (-0.0016599765677535996, 0.00548739027276577), 0.0, 3.0, 0.011753573580402781, 0.10878877656248752),
        'nG12FRing': ('halfgennorm', (0.4124981509977451, -1.5666398237752333e-20, 0.0003259483879880262), 0.0, 5.0,
                      0.08930389516016253, 0.29043594145044116), 'nFHRing': (
    'loglaplace', (0.2770106407743199, -4.040530930685934e-24, 0.015965263888035066), 0.0, 8.0, 0.4361643592126295,
    0.5429745305860959), 'n4FHRing': (
    'genhalflogistic', (0.0022497233566978955, -0.0017978070805562676, 0.002769951005615596), 0.0, 1.0,
    7.841814909642687e-06, 0.002800313092420489), 'n5FHRing': (
    'wald', (-0.0014891469698490411, 0.00492207911815609), 0.0, 2.0, 0.011087019313083153, 0.10495892568952275),
        'n6FHRing': (
        'wald', (-0.002557100593222535, 0.00845809530263902), 0.0, 4.0, 0.01605219512003858, 0.12587369454984576),
        'n7FHRing': (
        'wald', (-0.002557100593222535, 0.00845809530263902), 0.0, 2.0, 0.01584046611747823, 0.12526567504502023),
        'n8FHRing': (
        'pearson3', (2.3246112165104935, 0.010333120672988041, 0.012010244108992232), 0.0, 3.0, 0.02670660764393978,
        0.16238772080349947), 'n9FHRing': (
    'gilbrat', (-0.0020683720754815626, 0.005635639847983922), 0.0, 8.0, 0.17024710865749434, 0.39441919457151914),
        'n10FHRing': (
        'gengamma', (1.9099446022439084, 0.35950907565134826, -1.312487343289288e-29, 0.0020404939850171572), 0.0, 4.0,
        0.10760930509757179, 0.31859555766036685),
        'n11FHRing': ('expon', (0.0, 0.0099), 0.0, 4.0, 0.00830317502016, 0.09131697452759344), 'n12FHRing': (
    'wald', (-0.0019577253862550696, 0.006472678742188005), 0.0, 3.0, 0.011191576845211722, 0.10590240760347541),
        'nG12FHRing': (
        'gengamma', (0.9789632348928894, 0.516838138813325, -2.9236481931367675e-32, 0.018869728445661257), 0.0, 4.0,
        0.08031064042795398, 0.2760961237770606), 'nFaRing': (
    'mielke', (0.6585821822787178, 2.296124545763198, -2.2959422220957824e-32, 0.03193696821414031), 0.0, 8.0,
    0.21357836390987664, 0.4297700632585301), 'n4FaRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n5FaRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n6FaRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n7FaRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    6.534845758035573e-06, 0.0025563260851907167), 'n8FaRing': (
    'exponnorm', (2887.066257710452, -3.96842183114956e-06, 1.098775212895904e-06), 0.0, 3.0, 0.004333909706729192,
    0.06650036393746199), 'n9FaRing': (
    'mielke', (0.6248982819736091, 3.0091986757352855, -8.601239751976863e-31, 0.04428270260225267), 0.0, 8.0,
    0.10721460041378643, 0.3180184114735473), 'n10FaRing': (
    'gengamma', (1.5161461220547763, 0.5471737480481218, -1.1281955251132256e-31, 0.002153949865227184), 0.0, 4.0,
    0.07897622492416312, 0.277082842415502), 'n11FaRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    6.534845758035573e-05, 0.008083575147139267),
        'n12FaRing': ('expon', (0.0, 0.0026), 0.0, 2.0, 0.0022113918045192377, 0.04700122859148852), 'nG12FaRing': (
    'wald', (-0.003613508707670766, 0.011958602955734568), 0.0, 4.0, 0.022981745561859505, 0.15107001765255293),
        'nFaHRing': (
        'gilbrat', (-0.005703214885651871, 0.015610734156138322), 0.0, 8.0, 0.1995911800493773, 0.4152274606746775),
        'n4FaHRing': (
        'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0,
        0.0, 0.0), 'n5FaHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n6FaHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 0.0, 0.0,
    0.0), 'n7FaHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    6.534845758035573e-06, 0.0025563260851907167), 'n8FaHRing': ('genexpon', (
    2.269415530740585, 2.0314851473886852e-08, 1.8045634889506703, -8.424767896451031e-13, 0.009076951714624804), 0.0,
                                                                 3.0, 0.004331295768425978, 0.06648087782080031),
        'n9FaHRing': (
        'beta', (0.23456761367658818, 232.49977632574766, -8.322280638556086e-30, 23.387298321919047), 0.0, 8.0,
        0.10720283769142197, 0.31800388275395075), 'n10FaHRing': (
    'gengamma', (1.9348187032638746, 0.4621705664838919, -2.133972797745229e-30, 0.0008076432329087703), 0.0, 4.0,
    0.06555757264461287, 0.2511242615574548), 'n11FaHRing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    3.267422879017786e-05, 0.00571604419025525), 'n12FaHRing': (
    'genhalflogistic', (5.133826876302925e-12, -2.8454390487004766e-08, 0.0022999080954695227), 0.0, 2.0,
    0.0021970151438515596, 0.04684871616824157), 'nG12FaHRing': (
    'wald', (-0.0035957258109696622, 0.011900233983811346), 0.0, 4.0, 0.022460264870368264, 0.14929089569303747),
        'nFARing': ('loglaplace', (0.9243671654556924, -2.0694968607947443e-27, 0.005726600901823292), 0.0, 6.0,
                    0.27532220057009993, 0.46670917557493674), 'n4FARing': (
    'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
    1.1762722364464032e-05, 0.0034296623744658346), 'n5FARing': (
    'halfgennorm', (0.49333933259321405, -8.546566975008064e-20, 0.0006406541413877748), 0.0, 2.0, 0.0161110087318609,
    0.12624462005768355), 'n6FARing': (
    'wald', (-0.003275471904363791, 0.01083834931844659), 0.0, 4.0, 0.021236941744464007, 0.14434541515949623),
        'n7FARing': (
        'wald', (-0.0030983062756464426, 0.010251162613130452), 0.0, 3.0, 0.021205574484825435, 0.14463946974701078),
        'n8FARing': (
        'pearson3', (2.2951094462420456, 0.010975800998585913, 0.012595332275963704), 0.0, 2.0, 0.024354063171046974,
        0.1549408047565578), 'n9FARing': (
    'halfgennorm', (0.337297388924395, -5.953010193902347e-19, 0.00017513599543582278), 0.0, 6.0, 0.06721480952885069,
    0.2573335729002024), 'n10FARing': (
    'gengamma', (1.3749949937463137, 0.6591404535442351, -2.9906128507304304e-31, 0.010301728928494014), 0.0, 4.0,
    0.05029609386129659, 0.22226135121316334), 'n11FARing': (
    'halflogistic', (-1.0229201856288416e-09, 0.0076046438002211544), 0.0, 4.0, 0.008569796727087851,
    0.0927692875895856), 'n12FARing': (
    'wald', (-0.0014420071293233395, 0.004766589630877503), 0.0, 3.0, 0.009542181775883543, 0.09831312976252517),
        'nG12FARing': (
        'exponweib', (0.9381314500365114, 0.5753865933417484, -1.66214299721943e-32, 0.018308732000380593), 0.0, 4.0,
        0.06632214959830303, 0.2534034964726789), 'nFAHRing': (
    'gilbrat', (-0.01253004037623071, 0.0346188087766215), 0.0, 5.0, 0.2365731791632522, 0.44227263994925936),
        'n4FAHRing': (
        'betaprime', (0.12979362790686721, 2.0084510281921832, -1.7874327445880742e-34, 0.4022005514286884), 0.0, 1.0,
        7.841814909642687e-06, 0.002800313092420489), 'n5FAHRing': (
    'wald', (-0.0016917699110529831, 0.005592522482815329), 0.0, 2.0, 0.011087019313083153, 0.10495892568952275),
        'n6FAHRing': (
        'wald', (-0.0025257684523880357, 0.008353361980002146), 0.0, 4.0, 0.01605219512003858, 0.12587369454984576),
        'n7FAHRing': ('halfgennorm', (0.612576201103469, -2.154472132927548e-17, 0.0010026263373503065), 0.0, 2.0,
                      0.015833931271720194, 0.12524041474710945), 'n8FAHRing': (
    'wald', (-0.0036624158676007955, 0.01212056483851413), 0.0, 2.0, 0.022375311875513802, 0.14870280992496338),
        'n9FAHRing': (
        'gengamma', (1.9560415040297368, 0.40193165512800744, -3.2664506881045682e-31, 0.0008096116155216344), 0.0, 4.0,
        0.06304427096607239, 0.24924964341175343), 'n10FAHRing': (
    'wald', (-0.006748582157109512, 0.022374322864107683), 0.0, 4.0, 0.042051732452958915, 0.2034880284465054),
        'n11FAHRing': ('expon', (0.0, 0.0092), 0.0, 4.0, 0.00827050079136982, 0.09114086427151293), 'n12FAHRing': (
    'wald', (-0.0013645493766860542, 0.0045102761877262604), 0.0, 3.0, 0.008994561701360163, 0.09517051102015463),
        'nG12FAHRing': (
        'gengamma', (1.956070530058758, 0.40235975824971637, -3.559012979767579e-30, 0.0009401496081219934), 0.0, 4.0,
        0.057850375557585716, 0.23727512558154965), 'nRot': (
    'kappa3', (5.800073679949392, -2.545078654633995e-11, 5.739741425359231), 0.0, 234.0, 4.393508807011628,
    3.6946063028714455), 'RotRatio': (
    'dweibull', (1.136369953144827, 0.16370183961464344, 0.07713247510677906), 0.0, 0.975609756097561,
    0.16697297185711668, 0.09932409486556877), 'SLogP': (
    'johnsonsu', (0.6214286707458487, 1.9858803411156374, 3.6833855993828886, 3.11245519189037), -63.94361999999847,
    43.443939999999856, 2.5327913757810774, 1.939011697527057), 'SMR': (
    'burr', (9.789728879471756, 0.21447836080936383, -0.7030968557746824, 123.32812643025531), 0.0, 1779.8584000000078,
    88.03464519904489, 39.01604377122793), 'TopoPSA(NO)': (
    'logistic', (68.39219241362838, 20.29460730390537), 0.0, 3107.1200000000053, 70.69329707800905, 46.59003268313095),
        'TopoPSA': ('logistic', (77.06226844858108, 22.982706175584084), 0.0, 3339.9200000000064, 79.67881184741395,
                    50.48175553975207), 'GGI1': (
    'dgamma', (1.4878509605554462, 4.763443497334221, 1.1772049632887929), 0.0, 127.5, 4.9831335630985105,
    2.536830444330054), 'GGI2': (
    'dgamma', (1.4008015358311976, 2.772000106396132, 0.7430307985469584), 0.0, 66.22222222222226, 2.888149144349081,
    1.4755883051581542), 'GGI3': (
    'mielke', (1.7482832834341988, 4.776685549752424, -0.019938743295883254, 2.4510691898144343), 0.0,
    46.26388888888889, 1.8117631507599083, 1.069445036127203), 'GGI4': (
    'mielke', (0.8960714153330555, 5.7226211203057735, -1.1832697521086788e-13, 2.342909023833702), 0.0,
    42.80666666666667, 1.3191800830680553, 0.9434134214099144), 'GGI5': (
    'chi', (0.6352358318686822, -1.7027632119016364e-31, 1.2976420571792495), 0.0, 28.559444444444445,
    0.7812800434088017, 0.6348561749181031), 'GGI6': (
    'chi', (0.7147972020219483, -1.203514910648601e-29, 0.7237457618957286), 0.0, 19.387165532879816,
    0.4853043433705631, 0.4416627777904916), 'GGI7': (
    'genhalflogistic', (0.005773533325443359, -1.7105228339577259e-09, 0.24374863285516574), 0.0, 19.98529620181406,
    0.32522902308843693, 0.3386312502630871), 'GGI8': (
    'recipinvgauss', (7854080.72379375, -3.4994763897081046e-15, 0.2195381415211704), 0.0, 13.2340482489292,
    0.21663417686739211, 0.24155460319338537), 'GGI9': (
    'betaprime', (0.419582157710013, 0.9149514578545129, -5.387843107097259e-28, 0.18159077080929797), 0.0,
    11.016250000000003, 0.14512844796009466, 0.1834047725955691), 'GGI10': (
    'pearson3', (2.4072988304240015, 0.07447202094319216, 0.08963820445792914), 0.0, 10.646278951127435,
    0.09699662442805737, 0.1507504129852491), 'JGI1': (
    'johnsonsu', (-1.2617030990539817, 1.7158489079833847, 0.14338196244753398, 0.06694029071076277), 0.0, 1.25,
    0.2068865424518474, 0.06144246649961665), 'JGI2': (
    'johnsonsu', (-0.7717596107149157, 1.0696723431912312, 0.06994883791380468, 0.015582476530948691), 0.0,
    0.3842592592592593, 0.08856851902923621, 0.031033216831521538), 'JGI3': (
    'burr12', (10.100777908951581, 0.4080524929078656, -0.018083099542546985, 0.059924814440748264), 0.0, 0.5625,
    0.05811288214338478, 0.02940281649265532), 'JGI4': (
    'norminvgauss', (0.2301736258826153, 0.10134695178235911, 0.040101176400422975, 0.007690360046375248), 0.0,
    0.26222222222222225, 0.04378126002579126, 0.018385329813081202), 'JGI5': (
    'norminvgauss', (0.2689038449076572, -0.10474586246078765, 0.026956457099676732, 0.006142820646585087), 0.0,
    0.1527777777777778, 0.02444919681982394, 0.012127744670531238), 'JGI6': (
    'chi2', (0.7227270344647205, -3.736632122148354e-29, 0.039795789136186144), 0.0, 0.10040816326530613,
    0.015072647712611053, 0.008302855943854456), 'JGI7': (
    'gengamma', (0.0842999410557228, 2.899594550864382, -2.5986301441907193e-31, 0.031876953097879246), 0.0,
    0.06510416666666666, 0.010962448906738888, 0.006419265012574128), 'JGI8': (
    'exponweib', (0.050251849405246005, 2.270381140542005, -7.38657655476822e-31, 0.4290457002896779), 0.0,
    0.045099521289997474, 0.008295828732743156, 0.005193645751722518), 'JGI9': (
    'powerlaw', (0.22270077244343572, -1.9890710326690204e-19, 0.028071451539582043), 0.0, 0.0384375,
    0.0064074288827714095, 0.004402277905883783), 'JGI10': (
    'burr12', (0.30835201131564227, 4.613437644434542, -2.2402572603080053e-26, 0.01486066784361217), 0.0,
    0.027242118151209062, 0.004938039848466308, 0.0038336974502364615), 'JGT10': (
    'burr12', (146639654.76270106, 0.5101781037595787, -5860148.559758129, 5860148.973965683), 0.0, 1.4125652798998387,
    0.46747479455341423, 0.10173571730600686), 'Diameter': (
    'halfgennorm', (0.46111874599061964, 1.0, 10899.554488602538), 0.0, 100000000.0, 2960819.4248930574,
    16950349.257121854), 'Radius': (
    'wald', (-434620.6964226499, 1439034.8410559355), 0.0, 100000000.0, 2960813.942758672, 16950350.21471488),
        'TopoShapeIndex': (
        'beta', (79.21831169015955, 0.4353339663616668, -6.5987419991451555, 7.598741999145156), 0.0, 1.0,
        0.8653365306018065, 0.20753085806911536), 'PetitjeanIndex': (
    'johnsonsu', (2.6765984107305236, 0.27429107458113444, 0.5000000052246438, 6.159677864149259e-09), 0.0, 0.5,
    0.4537408198386347, 0.09369524089643011), 'Vabc': (
    'mielke', (2.231857958773365, 8.928924830263334, -1.4749784739403502, 396.6781697992034), 14.624017901549562,
    6600.4559057882925, 290.5199590190373, 131.48071661593713), 'VAdjMat': (
    'johnsonsu', (1.1666146143808995, 1.190456941660159, 6.15588496375109, 0.4319230172727777), 1.0, 9.980139577639157,
    5.475707052039938, 0.7206791639723511), 'MWC01': (
    'burr', (8.475906161208465, 0.2539540726010284, -0.17980033582551344, 34.558171657670734), 0.0, 505.0,
    24.83187933015217, 11.195125006350075), 'MWC02': (
    'johnsonsu', (1.125583460565493, 1.2206063346771856, 5.140683728634062, 0.3167214009118031), 0.0, 7.83241092718792,
    4.679590938145614, 0.5031966957375836), 'MWC03': (
    'johnsonsu', (1.1720500922949586, 1.3012130216406494, 6.018925064925257, 0.3605041400373915), 0.0, 8.70267641154777,
    5.520146196105176, 0.5255624659462284), 'MWC04': (
    'johnsonsu', (1.079452623688018, 1.3011661528833283, 6.888467648614883, 0.39765528742963474), 0.0,
    9.624368710744834, 6.39602911281148, 0.5485649361405998), 'MWC05': (
    'johnsonsu', (1.095656007099795, 1.3121525501638303, 7.77632984352714, 0.41114403298701246), 0.0,
    10.517672691292779, 7.257694954372371, 0.5796031907670685), 'MWC06': (
    'johnsonsu', (1.0437912879859117, 1.3133502324512236, 8.654164710850646, 0.44129541345852075), 0.0,
    11.869879369995699, 8.138934530134627, 0.6113323478089224), 'MWC07': (
    'johnsonsu', (0.9827618387486365, 1.2637337797908752, 9.522060798897144, 0.4458125212940506), 0.0,
    13.336695421159892, 9.008581016695981, 0.6505149897851618), 'MWC08': (
    'johnsonsu', (0.9319491238024378, 1.254064718732371, 10.413957359247906, 0.47170281545746984), 0.0,
    14.81005815769501, 9.892240395345544, 0.6891419609417603), 'MWC09': (
    'johnsonsu', (0.8836365355370557, 1.2629011854699308, 11.294996764688026, 0.5241068047645954), 0.0,
    16.279916241674318, 10.766095752328747, 0.7342449672993493), 'MWC10': (
    'johnsonsu', (0.7850927916639554, 1.2259508388688383, 12.172068227690058, 0.542434412070001), 0.0,
    17.751766772912383, 11.651216769015807, 0.7777468371072223), 'TMWC10': (
    'mielke', (5.112856564740293, 15.55855039647257, -0.5001195361067714, 140.17752069461343), 1.0, 1097.0725016900942,
    121.16119929060022, 26.083171003266045), 'SRW02': (
    'johnsonsu', (1.1327583326976547, 1.1993624304194999, 4.26855255176816, 0.29817030461872135), 0.0,
    6.918695219020472, 3.8205339599598522, 0.48624789517862776), 'SRW03': (
    'halfgennorm', (0.3623194016673267, -7.830143628967502e-24, 0.000132042628383607), 0.0, 4.795790545596741,
    0.18047389194486743, 0.5800680846195471), 'SRW04': (
    'johnsonsu', (1.1963122717358299, 1.2994641329363525, 5.614896597494887, 0.3405031828554336), 0.0, 8.30325712085294,
    5.143058830429269, 0.49981011847165285), 'SRW05': (
    'burr12', (0.31664410254567044, 1.8936426140826284, -2.6150622498401426e-32, 0.7674215269701106), 0.0,
    7.9658927350845286, 1.7286308299123734, 1.4707336270164744), 'SRW06': (
    'johnsonsu', (1.0631929896482526, 1.260427650486955, 7.116040963998501, 0.35221031407704795), 0.0, 9.85466488783856,
    6.661834522160893, 0.5280097135472518), 'SRW07': (
    'betaprime', (0.26639504350249144, 0.6762695196008305, -1.4207368638132818e-30, 1.9327046456827448), 0.0,
    10.945547126244623, 3.1696317200907314, 2.4994405989984596), 'SRW08': (
    'johnsonsu', (0.9562731098111374, 1.2187665236550003, 8.705789550181915, 0.3752842117652645), 0.0,
    12.444683951947502, 8.2684944651312, 0.5762535453867393), 'SRW09': (
    'mielke', (0.1733674549135334, 0.40911644039395045, -5.779227231692359e-29, 1.680105774273967), 0.0,
    13.890748819671451, 4.4745217608098375, 3.478474801848068), 'SRW10': (
    'johnsonsu', (0.8857659527400557, 1.2365979779145022, 10.379902413569214, 0.4306441684981339), 0.0,
    15.366855054874671, 9.921517180063718, 0.6420282341770224), 'TSRW10': (
    'vonmises_line', (21.638388742873452, 66.2468719546147, 64.1993188507055), 1.0, 559.0174678973506,
    66.38748745599538, 14.586239454802792), 'MW': (
    'mielke', (2.1785901045315343, 9.482349015054464, -4.054818104224206, 458.4732040356919), 7.01545597009,
    7589.748612690066, 328.8978723672533, 147.10998975403842), 'AMW': (
    'mielke', (3.747236482973138, 6.651712638070194, 4.162606246708846, 4.158927565187775), 3.2062600256, 223.0185022,
    7.947031534158518, 1.585550579246475), 'WPath': (
    'genhalflogistic', (0.0010921694749248213, -389.3032356396852, 494508727.53393984), 0.0, 3960901303818.0,
    266492153.29946715, 7397199815.403856), 'WPol': (
    'mielke', (1.64763155591689, 7.517067097156364, -1.9252033886261968, 54.30669569425331), 0.0, 801.0,
    34.58910981024115, 19.302959668426208), 'Zagreb1': (
    'dgamma', (1.27558453027034, 122.99316117043466, 31.76347867399368), 0.0, 2520.0, 119.31887825451656,
    54.320667684344876), 'Zagreb2': (
    'burr', (7.70495238427219, 0.26060604631706086, 0.472183699654553, 194.5055327183703), 0.0, 3009.0,
    139.97154989550782, 64.74056664533873), 'mZagreb1': (
    'burr', (6.897188810704428, 0.27453050946122337, 0.8801691450984155, 9.49527901950395), 0.6666666666666667,
    213.44444444444443, 7.759949341290033, 3.7235462072074945), 'mZagreb2': (
    'mielke', (2.2059933922058863, 9.064218389155684, -0.01576904590961397, 6.965452854689449), 0.0, 111.91666666666697,
    5.105618911752458, 2.2652263449016448)}
