# Installation

We provide installation instructions for ImageNet classification experiments here.

## Dependency Setup
Create an new conda virtual environment and install environment.
```
conda create -n disclassify python==3.9
pip3 install torch torchvision torchaudio
pip3 install wandb timm==0.3.2 six tensorboardX
```

## Dataset Preparation

Download images and generate images to construct distribution and organize them as follows:

```
/path/to/distributions_root/ 
  train/
    distribution1/
      ...
    distribution2/
      ...
    distribution3/
      ...
  val/
    distribution1/
      ...
    distribution2/
      ...
    distribution3/
      ...
```

# Training

We give example commands for single-machine and multi-node training related to ImageNet below.

## Multi-node

```python
python run_with_submitit.py --nodes 4 --ngpus 8 \
    --model convnext_tiny --opt_betas 0.9 0.95 \
    --batch_size 128 --lr 1e-3 --update_freq 1 \
    --weight_decay 0.3 --reprob 0 \
    --data_set image_folder --nb_classes 3 \ 
    --data_path /path/to/distributions_root/train \
    --eval_data_path /path/to/distributions_root/val \
    --job_dir /path/to/save_results
```

## Single-node

```python
python -m torch.distributed.launch --nproc_per_node=8 main.py \
    --model convnext_tiny --opt_betas 0.9 0.95 \
    --batch_size 128 --lr 1e-3 --update_freq 1 \
    --weight_decay 0.3 --reprob 0 \
    --data_set image_folder --nb_classes 3 \ 
    --data_path /path/to/distributions_root/train \
    --eval_data_path /path/to/distributions_root/val \
    --output_dir /path/to/save_results
```

# LICENSE

This project is released under the MIT license. Please see the LICENSE file for more information.