# Trading Alchemist

Please construct the system in directory './oai/', leave './oai_demo/'
a working old version, until being merged back to **dev** branch when './oai_demo/' will be deleted.


## Run

- The server: under this folder, run `python run_server.py`

## Crafting Rules
- We assume the players stay in a space on undistroyable blocks. NO new resources but the existing and crafted ones will be available.
- There are undistroyable `crafting-table`, `campfire`, `furnace`, `stone-cutter`, etc. So the players need not to build them before using their functions.
- Furnace rule: use same amount of fuel as in the MC game, while crafting allow the fractional amount, but once done the non-integer fuel will be burned up.

## Existing tools
- Graph: it is an and-or-graph with recipes the and-node and all others the or-node. Nodes are stored in `Graph.node_dict` as dictionary.
- node has `parents`:
  - for recipes, a parent points to input of it,
  - for items, a parent is either a tag which it belongs to or a recipe that uses it as input,
  - for tags, a parent is a recipe that uses it as input.
- node has `children`, the inverse of parents:
  - for recipes, a child points to output of it,
  - for items, a child is a recipe that produces it as output,
  - for tags, a child is an item which belongs to it.

There are simple and flexible traversal methods, forward (on children) or backward (on parents).

## Development:

Please register the messages in the following Message list
when you add a new socketio message type in the system.

Leave the last one blank (as template to copy from~)

### Message list
Rules:

Terminology:
- Client -> Server (*C*): Backend implement `on`, Frontend implement `emit`
- Server -> Client (*S*) Backend implement `emit`, Frontend implement `on`
  - Broadcast to Game (*G*)
  - Unicast (*U*): To special client

The implementations should follow the written format as known part.
We allow adding new keys in the message / message parts. But unless
changing this list, all implementations on augmented-messages must
be able to deal with un-augmented version using some default settings.
e.g. if `connect_to_server`'s implementation actually deals with
`{username:str, timestamp:timestamp}` format, it must be able to
handle `{username:str}` without exceptions as well.

#### The messages:

- [] `connect_to_server` *C*
  - JSON format `{"username": str}`.
  - status:

- [] `is_connected` *U*
  - JSON format `{"username": str, "token":str}`
  - description: token is generated by server to avoid impostor's behavior
  - status:

- [] `game__start` *G*
  - JSON format `{"token": str, "gamename": str, "player_id": int, "players": {player_id: {"username":str, "hands": {item_name: int}}}}`
  - status

- [NotNeccesarry] `player__start_received` *C*
  - JSON format `{"token": str, "gamename": str, "player_id": int}`
  - status:

- [] `game__request_proposal` *G*
  - JSON format `{"token": str, "gamename": str, "proposer_id": int}`
  - status

- [] `player__submit_proposal` *C*
  - JSON format `{"token": str, "gamename": str, "proposal":{"proposer": int, "target": int(player_id), "request":{}, "offer":{}, "message":{}}},`
  - description: [MAYBE? auto-gen for non-proposers with proposal empty object]
  - status: `Player._submit_proposal` skeletoned.

- [] `game__proposal_submitted` *G*
  - JSON format `{"token": str, "gamename": str}`
  - status

- [] `player__transmit_proposal` *U*
  - JSON format `{"token": str, "gamename": str}`
  - status

- [] `player__accept_or_reject` *C*
  - JSON format `{"token": str, "gamename": str}`
  - status

- [] `game__proposal_result` *G*
  - JSON format `{"username": str, "gamename": str, "accepted":bool, "proposal": obj}`
  - description: proposal is `{}` when accepted==false, else the proposal as in `player__submit_proposal`. (this also works as `game__start_crafting`)
  - status

- [] `player__request_possible_recipes_from_hand` *C*
  - JSON format `{"token": str, "gamename": str}`
  - status: need-transfer from script.js

- [] `player__respond_possible_recipes_from_hand` *U*
  - JSON format `{"token": str, "gamename": str, "recipes": list}`
  - description: recipes: list of recipe names.
  - status: need-transfer from app.py

- [] `player__request_recipe_correctedness` *C*
  - JSON format `{"token": str, "gamename": str, "recipe":{"input":{}, "output":{}}}`.
  - status

- [] `player__respond_recipe_is_correct` *U*
  - JSON format `{"token": str, "gamename": str, "is_correct": bool, "recipe":{"input":{}, "output":{}}}`.
  - status

- [] `player__request_apply_last_recipe` *C*
  - JSON format `{"token": str, "gamename": str}`.
  - status


- [] `player__respond_apply_last_recipe` *U*
  - JSON format `{"token": str, "gamename": str, "hand":{}}`.
  - status


- [] `player__no_more_crafting` *C*
  - JSON format `{"token": str, "gamename": str}`.
  - status

- [] `game__crafting_phase_over` *G*
  - JSON format `{"token": str, "gamename": str, "hands":{}}`.
  - description: hands as in `game__start`.
  - status


- [] `player__proposer_status` *U*
  - JSON format `{"token": str, "gamename": str, "status": {"timeout-after":int, "propose-chances":int, "proposal-spec":{player_id:int}}}`
  - description: proposal-spec may not be implemented.
  - status

- [] `player__no_more_proposal` *C*
  - JSON format `{"token": str, "gamename": str}`
  - status

- [] `game__game_over` *G*
  - JSON format `{"token": str, "gamename": str, "result":{player_id: {status:bool, target:str}}}`
  - status

- [] `_`
  - JSON format `{"token": str, "gamename": str}`
  - status

### Backend in `./oai/`
We try to make things simple, by handling abnormal events together,
and then try to resend the filtered messages to correct positions.

In the center, we "simulate" the game and interactions using
Game and Player instances to handle the possibly complicated
game-to-specific-client interactions. Broadcasting is simply 
handled in Game level

#### `__init__.py`. <- app.py, route.py, event_handlers.py
Exports a module


#### `app.py`.
Make basic definitions.
```
app, socketio, logger
```


#### `route.py`. <- app.py
Deal with all http requests, i.e., rendering all websites.

```
```

#### `event_handler.py`. <- app.py
Deals with all socketio interactions, simplifying and redirect them
into correct handlers.

Goal of this module is to filter abnormal activities


#### `player.py`. <- event_handler.py
- `class MessageHandler` 
Base class for Player and Game
- `class Player(MessageHandler)`.


#### `game.py`. <- player.py
- `class Game(MessageHandler)`.

- `class GameWithChatroom(Game)` Not in recent plans.

#### `hall.py` <- player.py, game.py
- `class Hall(Game)`.
Deal with Games and players waiting/joining the same type of games
- `class MainEntry(Hall)`.
Only one instance per server, main entry of everyone and distribute the processing of their messages to correct Halls / Games after `connect` event.

### Frontend
Modules:
- crafting wiki
- 



### LLM agent
In Javascript?
