See implementation_details.md for a structured template with the relevant details used during the execution of this code. This code is released privately and will be released publicly under the Apache 2.0 License.
## Datasets

We used a processed version of [Pick-a-Pic](https://huggingface.co/datasets/yuvalkirstain/pickapic_v2) with binary label instead of pair-wise preference. The processed annotation `train_processed_v3.csv` can be found at this anyonymous [link](https://mega.nz/file/wfF2mCDZ). Please use the encryption key `O3epVH2nRjTqxkhiH_NvjlLZ_k3iOSmujab2yGyZOVw` for download. 

Please download the original Pick-a-Pic dataset and preprocessed annotation and organize the data folder in the following manner:

```
<root of pick-a-pic>
-train_processed_v3.csv
-train
--- 17a0ce90-9e1c-4366-82c7-aa5977b06375.jpg
-- ... 
```

## Training on Custom Data
Please prepare a folder in the following format 

```
<root of your-dataset>
-train_processed_v3.csv
-train
--- 0001.jpg
-- ... 
```

wheere train_processed_v3.csv should contain the following columns:

```
file_path: string, relative path of image
caption: string, prompt
label: string, use "exclusive_win" for winning samples and "exclusive_lose" for winning samples 
```


## Training

``` 
bash exps/example.sh 
```

## Reproduce Results

Additional Dependencies:

hpsv2: https://github.com/tgxs002/HPSv2
ImageReward: https://github.com/THUDM/ImageReward


First, download prompt using
```shell
python ./eval/prompts/download.py
```

Second, generate images using
```shell
accelerate launch  --num_processes $1 eval/generate_images.py \
    --model_name $MODEL_NAME \
    --ckpt <model checkpoint> \
    --output_dir <output dir>  \
    --mixed_precision fp16 \
    --gen_count 1 \
    --prompts eval/prompts/<downloaded_prompt_file>.csv \
```

Next, generate the scores using

```shell
accelerate launch --main_process_port=12343 --num_processes $1 score_folder.py\
    -p  <output dir>
```

This will generate a csv file containing the scores of individual generations

Finally, run 

```shell
python win_rate.py <folder 1> <folder 2>
```
To obtain the win rate reported in the paper

