import torch
from PIL import Image
from hpsv2.src.open_clip import create_model_and_transforms, get_tokenizer
import warnings
import argparse
import os
import requests
from clint.textui import progress
from typing import Union
import huggingface_hub
# from hpsv2.utils import root_path, hps_version_map

from tqdm import tqdm

warnings.filterwarnings("ignore", category=UserWarning)


def hps_initialize_model(device):
    model_dict = {}
    model, preprocess_train, preprocess_val = create_model_and_transforms(
        'ViT-H-14',
        'laion2B-s32B-b79K',
        precision='amp',
        device=device,
        jit=False,
        force_quick_gelu=False,
        force_custom_text=False,
        force_patch_dropout=False,
        force_image_size=None,
        pretrained_image=False,
        image_mean=None,
        image_std=None,
        light_augmentation=True,
        aug_cfg={},
        output_dict=True,
        with_score_predictor=False,
        with_region_predictor=False
    )
    model_dict['model'] = model
    model_dict['device']=device
    model_dict['preprocess_val'] = preprocess_val
    model_dict['tokenizer'] = get_tokenizer('ViT-H-14')
    return model_dict

@torch.no_grad()
def hps_score(prompt, image: Union[list, str, Image.Image], model_dict) -> list:
    """
    Edited for KTO
    """
    tokenizer = model_dict['tokenizer']
    preprocess_val = model_dict['preprocess_val']    
    device = model_dict['device']
    model = model_dict['model']
        # Process the image
    image = preprocess_val(image).unsqueeze(0).to(device=device, non_blocking=True)
    # Process the prompt
    text = tokenizer([prompt]).to(device=device, non_blocking=True)
    # Calculate the HPS
    with torch.cuda.amp.autocast():
        outputs = model(image, text)
        image_features, text_features = outputs["image_features"], outputs["text_features"]
        logits_per_image = image_features @ text_features.T

        hps_score = torch.diagonal(logits_per_image).cpu().numpy()
    return hps_score[0]
