import glob as glob
import os
import sys
from matplotlib import pyplot as plt
from tqdm.cli import tqdm
from PIL import Image
import json
from pathlib import Path
from tqdm.cli import tqdm
import numpy as np
import shutil
import argparse
import pandas as pd
root = './'
parser = argparse.ArgumentParser()
parser.add_argument('src',type=str,)
parser.add_argument('tgt',type=str,)
parser.add_argument('-c','--count',type=int,default=-1)
args = parser.parse_args()
folder_1 = args.src
folder_2 = args.tgt
count = args.count

images = glob.glob(os.path.join(folder_1,'*.jpg'))
print(folder_2.split('/'))

root_folder = os.path.join(root,f"{(a:=folder_1.split('/')[-1])}_vs_{(b:=folder_2.split('/')[-1])}")

tgt_folder = os.path.join(root,f'{a}_vs_{b}')

csv_name = 'eval_gpu_0.csv'
df1 = pd.read_csv(os.path.join(folder_1,csv_name))
df2 = pd.read_csv(os.path.join(folder_2,csv_name))
keys = ['aesthetic', 'pick', 'image_reward', 'clip', 'hps']
df11 = df1.groupby('prompt').agg({k:'median' for k in keys}).sort_values(['prompt'])
df22 = df2.groupby('prompt').agg({k:'median' for k in keys}).sort_values(['prompt'])
max_ct = df1.groupby('prompt').count()['aesthetic'].max()
max_ct2 = df2.groupby('prompt').count()['aesthetic'].max()
cdf1 = df1.sort_values('prompt')[keys]
cdf2 = df2.sort_values('prompt')[keys]
cdf1 = np.array(cdf1).reshape(-1,max_ct,len(keys))
cdf2 = np.array(cdf2).reshape(-1,max_ct2,len(keys))
auto_win = (np.array(df11) >np.array(df22)).sum(0) / len(df11)
auto_win_df = pd.DataFrame([auto_win])
auto_win_df.columns = keys
print(auto_win_df)
