#!/bin/bash

# Script to reproduce results
cd ..
#
envs=(
  "metaworld-0"
  "metaworld-1"
  "metaworld-2"
  "metaworld-3"
)

gpus=(0 1 2 3 4 5 6 7)
#strategies=("oracle")
comment=0928_tau_0.7
for ((i = 0; i < 4; i += 1)); do
  for ((k = 0; k < 4; k += 1)); do
    env=${envs[k]}
#    strategy=${strategies[k]}
    strategy="zero"
    coeff=3
    CUDA_VISIBLE_DEVICES=${gpus[(i * 4 + k) % 8]} nohup python train_data_sharing.py \
      --env_name "$env" \
      --source_name na \
      --var_coeff="${coeff}" \
      --config=configs/metaworld_config.py \
      --comment="${comment}"_"${i}" \
      --data_share "${strategy}" > nohup_logs/"${comment}"_"${strategy}"_"${env}"_"${coeff}"_"${i}".out &
    sleep 2
  done
done
