# Implicit Causal Representation Learning through Soft Interventions

We propose SoftILCM to address the identifiability of Implicit Latent Causal Models (ILCMs) through soft interventions. 
Previously, ILCMs have been introduced with hard interventions which restricts their application. Soft interventions on the other hand, are more
general and are usually observed in real-world applications. 

SoftILCM improves the identifiability of via causal mechanisms switch variable to better model the effect of soft interventions.

--- 

## Overview of the model

We learn the invariant representations Z, variant representations S, and the causal mechanisms that generate
the observed trajectories X and future trajectories Y using variational inference in end-to-end manner. Our method can be incorporated into 
the existing motion forecasting models that have an encoder, an interaction module, and a decoder. 

<img src="images/soft_ilcm_arc.png" height="300"/>

--- 

### Requirements

```
pip install --upgrade pip
pip install -r requirements.txt

```

---

---

### Dataset

* Epic-Kitchens dataset can be downloaded from [here](https://epic-kitchens.github.io/2023). 
* ProcTHOR dataset can be downloaded from [here](https://zenodo.org/record/7813658). 
* Synthetic dataset are generated using the bash script when training the model. 

--- 

### Training

To train each model on a dataset just run its corresponding bash file located in `/scripts/`. For example,
to train SoftILCM on the synthetic dataset run this bash file:
```
bash scripts/run_softilcm_synthetic.sh
```

Pretrained models on `syntheic` dataset with dimension 4 are
already saved `/experiments/synthetic/`.

---

### Test

After training is done, specify the path to weights in the following bash file and run it:
```
bash scripts/run_test_synthetic.sh
```

The results should be saved in the path containing the wights inside the `test` folder.

--- 
