#!/bin/bash

base_dir="/home/sshirahm/UWaterloo/PhD_thesis/Causal_Model_Learning/Codes/paper_experiments/synthetic"
dims=(4 5 6 7 8 9 10 11 12 13 14 15) # Replace with your actual dim values
seeds=(1 2 5 6 7 8 9 10 11 12) # Replace with your actual seed values
models=(ilcm softilcm) # Replace with your actual model values

result_file="average_metrics.tsv"

# Initialize result file with headers
echo -e "Dimension,Model,Seed,Causal Completeness,Causal Disentanglement" > "$result_file"

for dim in "${dims[@]}"
do
  for model in "${models[@]}"
  do
    total_causal_completeness=0
    total_causal_disentanglement=0
    count=0
    for seed in "${seeds[@]}"
    do
      path="$base_dir/$dim/soft/$seed/$model"

      tsv_files=$(find "$path" -type f -name "test_metrics.tsv")  # find all matching TSV files in the specified path

      for tsv_file in $tsv_files
      do
        if [ -f "$tsv_file" ]; then
          # Extract the values; replace 3, 4, and 5 with your actual column numbers for the metrics
          if [ "$model" == "betavae" ]; then
              causal_disentanglement=$(awk -F',' 'NR==2 {print $14}' "$tsv_file")
              causal_completeness=$(awk -F',' 'NR==2 {print $15}' "$tsv_file")
          elif [ "$model" == "dvae" ]; then
              causal_disentanglement=$(awk -F',' 'NR==2 {print $22}' "$tsv_file")
              causal_completeness=$(awk -F',' 'NR==2 {print $23}' "$tsv_file")
          elif [ "$model" == "softilcm" ]; then
              if [ "$dim" -eq 4 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $34}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $35}' "$tsv_file")
              elif [ "$dim" -eq 5 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $43}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $44}' "$tsv_file")
              else
                causal_disentanglement=$(awk -F',' 'NR==2 {print $18}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $19}' "$tsv_file")
              fi
          else
              if [ "$dim" -eq 4 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $38}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $39}' "$tsv_file")
              elif [ "$dim" -eq 5 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $48}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $49}' "$tsv_file")
              elif [ "$dim" -eq 6 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $24}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $25}' "$tsv_file")
              elif [ "$dim" -eq 7 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $25}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $26}' "$tsv_file")
              elif [ "$dim" -eq 8 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $26}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $27}' "$tsv_file")
              elif [ "$dim" -eq 9 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $27}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $28}' "$tsv_file")
              elif [ "$dim" -eq 10 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $28}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $29}' "$tsv_file")
              elif [ "$dim" -eq 11 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $29}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $30}' "$tsv_file")
              elif [ "$dim" -eq 12 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $30}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $31}' "$tsv_file")
              elif [ "$dim" -eq 13 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $31}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $32}' "$tsv_file")
              elif [ "$dim" -eq 14 ]; then
                causal_disentanglement=$(awk -F',' 'NR==2 {print $32}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $33}' "$tsv_file")
              else
                causal_disentanglement=$(awk -F',' 'NR==2 {print $33}' "$tsv_file")
                causal_completeness=$(awk -F',' 'NR==2 {print $34}' "$tsv_file")
              fi
          fi

          echo $causal_disentanglement

          echo -e "$dim,$model,$seed,$causal_completeness,$causal_disentanglement" >> "$result_file"

          # Accumulate the values to calculate average later
          total_causal_completeness=$(echo "$total_causal_completeness + $causal_completeness" | bc)
          total_causal_disentanglement=$(echo "$total_causal_disentanglement + $causal_disentanglement" | bc)

          ((count++))
        fi
      done
    done

    # Calculate and save the averages
    if [ $count -gt 0 ]; then
      avg_causal_completeness=$(echo "scale=2; $total_causal_completeness / $count" | bc)
      avg_causal_disentanglement=$(echo "scale=2; $total_causal_disentanglement / $count" | bc)

      echo -e "$dim,$model,Average,$avg_causal_completeness,$avg_causal_disentanglement" >> "$result_file"
    fi
  done
done