#!/usr/bin/env bash

# Latent and input dim
dim=4
int_type=soft
int_set=atomic
model_name=dvae
des=atomic_soft_new_soft_data_with_significantly_different_post_intervention_data
DESCRIPTION="--description=$des"


#Model settings
MODEL="--encoder=mlp --scm=mlp --model=$model_name --scm_adjacency_matrix=none_trivial"

# Optimizer settings
OPTIMIZER="--clip_grad_norm=10.0 "

# Training epochs and settings
TRAINING="--epochs=90 --pretrain_epochs=10 --model_interventions_after_epoch=30 --batch_size=64 --num_workers=8 --seed=4901"

# Setting for e_norm regularizer
Z_REGULARIZE="--z_regularization_schedule=constant_linear_constant --z_regularization_schedule_initial=0.01 --z_regularization_schedule_final=0.0
              --z_regularization_schedule_initial_constant_epochs=10 --z_regularization_schedule_decay_epochs=10"

# Settings for consistency_mse regularizer
C_REGULARIZE="--consistency_regularization_schedule=constant --consistency_regularization_schedule_initial=0.01 --consistency_regularization_schedule_final=0.01
              --consistency_regularization_schedule_initial_constant_epochs=0 --consistency_regularization_schedule_decay_epochs=0"

# Settings for intervention entropy regularizer
IE_REGULARIZE="--intervention_entropy_regularization_schedule=constant --intervention_entropy_regularization_schedule_initial=1.0
               --intervention_entropy_regularization_schedule_final=1.0 --intervention_entropy_regularization_schedule_initial_constant_epochs=0
               --intervention_entropy_regularization_schedule_decay_epochs=0"

# Settings for intervention encoder offset regularizer
IEF_REGULARIZE="--intervention_encoder_offset_schedule=constant_exponential_constant --intervention_encoder_offset_schedule_initial=0.025
                --intervention_encoder_offset_schedule_final=1.e-4 --intervention_encoder_offset_schedule_initial_constant_epochs=10
                --intervention_encoder_offset_schedule_decay_epochs=10"


NUM_TRAINERS=2 # number of gpus

cd ..

# ------ python ------
for nature_seed in 1 2 5 6 7 8 9 10 11 12
do
  # Dataset and log paths
  DATADIR="--path_data=./data/synthetic/$dim/$int_set/$int_type/$nature_seed --dataset=synthetic --intervention_set=$int_set --intervention_type=$int_type"
  EXPDIR="--expdir=./experiments/synthetic/$dim/$int_type/$nature_seed/$model_name"
  python main.py --nature_seed=$nature_seed $DATADIR $DESCRIPTION $EXPDIR $MODEL $OPTIMIZER $TRAINING $Z_REGULARIZE $C_REGULARIZE $IE_REGULARIZE $IEF_REGULARIZE --dim_x=$dim --dim_z=$dim
done
