#!/usr/bin/env bash

# Latent and input dim
dim=4
int_type=soft
int_set=atomic
model_name=softilcm
des=first_experiment
DESCRIPTION="--description=$des"

#Model settings
MODEL="--encoder=mlp --scm=mlp --noise_model=additive --model=$model_name --scm_adjacency_matrix=none"

# Optimizer settings
OPTIMIZER="--clip_grad_norm=10.0 "

# Training epochs and settings
TRAINING="--epochs=100 --pretrain_epochs=0 --model_interventions_after_epoch=0 --model_noise_after_epoch=0 --batch_size=64 --num_workers=8 --seed=4901 --num_samples=1"

# Setting for e_norm regularizer
Z_REGULARIZE="--z_regularization_schedule=constant_linear_constant --z_regularization_schedule_initial=0.01 --z_regularization_schedule_final=0.0
              --z_regularization_schedule_initial_constant_epochs=10 --z_regularization_schedule_decay_epochs=10"

# Settings for consistency_mse regularizer
C_REGULARIZE="--consistency_regularization_schedule=constant --consistency_regularization_schedule_initial=0.01 --consistency_regularization_schedule_final=0.01
              --consistency_regularization_schedule_initial_constant_epochs=0 --consistency_regularization_schedule_decay_epochs=0"


NUM_TRAINERS=2 # number of gpus

cd ..

# ------ python ------
for nature_seed in 1 2 5 6 7 8 9 10 11 12
do
  DATADIR="--path_data=./data/synthetic/$dim/$int_set/$int_type/$nature_seed --dataset=synthetic --intervention_set=$int_set --intervention_type=$int_type"
  EXPDIR="--expdir=./experiments/synthetic/$dim/$int_type/$nature_seed/$model_name"
  python main.py --nature_seed=$nature_seed $OPTIMIZER $DESCRIPTION $DATADIR $EXPDIR $MODEL $TRAINING $Z_REGULARIZE $C_REGULARIZE --dim_x=$dim --dim_z=$dim
done
