#!/bin/bash

base_dir="/home/sshirahm/UWaterloo/PhD_thesis/Causal_Model_Learning/Codes/paper_experiments/synthetic"
dims=(15) # Replace with your actual dim values
seeds=(1 2 5 6 7 8 9) # Replace with your actual seed values
models=(ilcm) # Replace with your actual model values
int_type=soft
int_set=atomic

cd ..

for dim in "${dims[@]}"
do
  for seed in "${seeds[@]}"
  do
    for model in "${models[@]}"
    do
      path="$base_dir/$dim/soft/$seed/$model"

      # Find the model file with the highest epoch number
      model_file=$(ls $path/mlp_*/weights/mlp_*_*.pt 2>/dev/null | sort -V | tail -n1)

      if [ ! -z "$model_file" ]; then
        echo "Loading model from $model_file"

        # Assume that your test.py accepts model file as an argument, adjust as needed
        if [ "$model" == "betavae" ]; then
            MODEL="--encoder=mlp --scm=unstructured --model=$model"
        elif [ "$model" == "dvae" ]; then
            MODEL="--encoder=mlp --scm=mlp --model=$model --scm_adjacency_matrix=none_trivial"
        else
            MODEL="--encoder=mlp --scm=mlp --noise_model=additive --model=$model --scm_adjacency_matrix=none"
        fi

        DATADIR="--path_data=./data/synthetic/$dim/$int_set/$int_type/$seed --dataset=synthetic --intervention_set=$int_set --intervention_type=$int_type"
        EXPDIR="--expdir=./experiments/synthetic/$int_type/$seed/$model"
        python test.py --nature_seed=$seed $EXPDIR $DATADIR $MODEL --ckpt=$model_file --dim_x=$dim --dim_z=$dim
      else
        echo "No model files found in $path"
      fi

    done
  done
done
