#!/bin/bash

base_dir="/home/sshirahm/UWaterloo/PhD_thesis/Causal_Model_Learning/Codes/paper_experiments/procthor"
models=(ilcm betavae dvae softilcm) # Replace with your actual model values

cd ..

for model in "${models[@]}"
do
  path="$base_dir/$model"

  # Find the model file with the highest epoch number
  model_file=$(ls $path/resnet50_*/weights/resnet50_*_*.pt 2>/dev/null | sort -V | tail -n1)

  if [ ! -z "$model_file" ]; then
    echo "Loading model from $model_file"

    if [ "$model" == "betavae" ]; then
        MODEL="--encoder=resnet50 --scm=unstructured --model=$model"
    elif [ "$model" == "dvae" ]; then
        MODEL="--encoder=resnet50 --scm=mlp --model=$model --scm_adjacency_matrix=none_trivial"
    else
        MODEL="--encoder=resnet50 --scm=mlp --noise_model=additive --model=$model --scm_adjacency_matrix=none"
    fi
    
    DATADIR="--path_data=./data/procthor/causaltriplet-thor/ --dataset=procthor --num_actions=7 --num_objects=23 --nature_seed=1"
    EXPDIR="--expdir=./experiments/procthor/$model"
    python test.py $EXPDIR $DATADIR $MODEL --ckpt=$model_file --dim_x=3 --dim_z=7
  else
    echo "No model files found in $path"
  fi

done

