# Supplementary Materials for "Tracking Temporal Dynamics of Vector Sets with Gaussian Process"

## Setup
```
docker build -t rff .
docker run -it rff
```

## Create Dataset
```
# pseudo
python3 generate_pseudo.py

# chicago
# download dataset from https://data.cityofchicago.org/Public-Safety/Crimes-2001-to-Present/ijzp-q8t2/about_data
python3 obtain_chicago.py

# semantic change
# download dataset from https://www.ims.uni-stuttgart.de/en/research/resources/corpora/sem-eval-ulscd/
# download packages in requirements.txt
# t0
python3 obtain_semanticchange.py \
    --file_path path/to/tokenized/corpus/t0.txt \
    --lemma_path path/to/lemmatized/corpus/t0.txt \
    --target_words_list path/to/targetwords.txt \
    --output_name path/to/result/t0.pkl
# t1
python3 obtain_semanticchange.py \
    --file_path path/to/tokenized/corpus/t1.txt \
    --lemma_path path/to/lemmatized/corpus/t1.txt \
    --target_words_list path/to/targetwords.txt \
    --output_name path/to/result/t1.pkl
```

## Preprocess
```
# .pkl -> data.dat
python3 preprocess.py 200 path/to/data/t0.pkl path/to/data/t1.pkl ... path/to/data/tT.pkl
```

## Estimation
```
python3 rffreg-mcmc.py data.dat 1000 30 output_path
```
