This repo contains the code for the paper: *Conformal Linguistic Calibration: Trading-off between Factuality and Specificity*.

## Setup

Install the required packages using pip:

```bash
pip install -r requirements.txt
```

(Optional) Make sure that $(pwd) is in your PYTHONPATH. You can do this by running:

```bash
export PYTHONPATH=$(pwd):$PYTHONPATH
```

## General Structure of the repo

```bash
configs
```

This directory contains runnable configurations for different steps of the experiments. Each configuration file is a YAML file that specifies the hyperparameters for an experiments. You can use the scripts in the `scripts` directory to run these configurations:

```bash
python scripts/run.py --config configs/<config_file>.yaml
```

Some of the tasks requires an OpenAI-compatible server (VLLM) running locally. You may need a separate environment for [running the VLLM server](https://docs.vllm.ai/en/latest/serving/openai_compatible_server.html).

## Special Instructions for Running Experiments for Section 4.2

4.2 uses some lately released models on huggingface, and does not adhere to the general task-based structure of the repo. They can be directly run with the following scripts:

```bash
python scripts/clc_rewrite.py --input-path <input_path> --output-path <output_path>
python scripts/clc_info_scoring.py --input-path <input_path>
```

Notice that the input files are the outputs from the `ltt` tasks.