""" """

import os
import ujson as json
import click


__CLAIM_PATH__ = "data/CoreFActScore/FActScore/cast_labeled/claims_ChatGPT.jsonl"
__RESPONSE_PATH__ = "data/CoreFActScore/FActScore/labeled/ChatGPT.jsonl"
__TOPIC_PATH__ = "data/CoreFActScore/FActScore/cast_topic_labeled/ChatGPT.jsonl"


@click.command()
def main():
    """ """
    
    os.makedirs(os.path.dirname(__TOPIC_PATH__), exist_ok=True)
    write_to = open(__TOPIC_PATH__, 'w', encoding='utf-8')
    
    with open(__CLAIM_PATH__, 'r', encoding='utf-8') as claim_file_:
        with open(__RESPONSE_PATH__, 'r', encoding='utf-8') as response_file_:
            for claim_line, response_line in zip(claim_file_, response_file_):
                claim = json.loads(claim_line)
                response = json.loads(response_line)
                claim['topic'] = response['topic']
                
                write_to.write(json.dumps(claim) + '\n')
                
                
if __name__ == '__main__':
    main()