"""Take a file and generate multiple file splits.
"""

import click


@click.command()
@click.option("--input-data-path", type=click.Path(exists=True, file_okay=True, dir_okay=False), help="Path to the input data.", required=True)
@click.option("--num-splits", type=click.INT, help="Number of splits to generate.", required=True)
def main(
    input_data_path,
    num_splits: int
):
    """
    """
    
    with open(input_data_path, 'r', encoding='utf-8') as file_:
        data = [line for line in file_]

    num_lines = len(data)
    per_split = num_lines // num_splits
    
    for i in range(num_splits):
        with open(f"{input_data_path}.split-{i:02d}", 'w', encoding='utf-8') as file_:
            if i == num_splits - 1:
                file_.writelines(data[i * per_split:])
            else:
                file_.writelines(data[i * per_split: (i + 1) * per_split])

                
if __name__ == '__main__':
    main()