""" """

import transformers
from trl import SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

tokenizer = transformers.AutoTokenizer.from_pretrained('meta-llama/Meta-Llama-3-8B-Instruct')
full = tokenizer.apply_chat_template([
    {
        "role": "user",
        "content": "hello!"
    },
    {
        "role": "assistant",
        "content": "hi!"
    },
])

response = tokenizer.apply_chat_template([
    {
        "role": "assistant",
        "content": "hi!"
    },
])

print(tokenizer.convert_tokens_to_ids(['<|end_of_text|>']))
tokenizer.pad_token = '<|end_of_text|>'
print(tokenizer.pad_token_id)
# print(response)
# print(tokenizer.encode("<|start_header_id|>assistant<|end_header_id|>"))

data_collator = DataCollatorForCompletionOnlyLM(
    instruction_template=[128006, 882, 128007, 271],
    response_template=[128006, 78191, 128007, 271], tokenizer=tokenizer
)

print(data_collator([full]))
print(tokenizer.convert_ids_to_tokens(data_collator([full])['input_ids'][0]))
print(tokenizer.batch_decode(data_collator([full])['input_ids']))