""" """

from typing import Text
import click

from langchain_core.runnables.config import RunnableConfig
from langchain_interface.models import ChatOpenAIWithBatchAPI
from langchain_core.globals import set_llm_cache
from langchain_community.cache import SQLiteCache


@click.command()
@click.option("--input-file", type=str, help="Path to the input file.", required=True)
@click.option("--output-file", type=str, help="Path to the output file.", required=True)
@click.option("--cache-path", type=str, help="Path to the cache file.", required=True)
def main(
    input_file: Text,
    output_file: Text,
    cache_path: Text
):
    """ """
    llm = ChatOpenAIWithBatchAPI(
        temperature=0,
        top_p=0.98,
        model="gpt-4o",
        max_tokens=None,
        verbose=True,
    )
    set_llm_cache(SQLiteCache(cache_path))
    
    llm.cache_results(
        input_files=input_file,
        output_files=output_file
    )

    
if __name__ == "__main__":
    main()