""" This script will upload a directory of models to the server. """

import click
import os
from peft import PeftConfig, PeftModel
from transformers import AutoModelForCausalLM


@click.command()
@click.option(
    "--model-dir",
    type=click.Path(exists=True, file_okay=False, dir_okay=True),
    required=True,
    help="The directory containing the models to upload."
)
@click.option(
    "--repo-name",
    type=str,
    required=True,
    help="The name of the repository to upload the models to."
)
def main(
    model_dir,
    repo_name
):
    """ """
    
    # os.environ['HF_HOME'] = "/scratch/bvandur1/zjiang31/conformal-backoff/data/hub-home/"
    print(model_dir)

    config = PeftConfig.from_pretrained(model_dir)
    model = AutoModelForCausalLM.from_pretrained(config.base_model_name_or_path)
    model = PeftModel.from_pretrained(model, model_dir)

    model.push_to_hub(repo_name, private=True)

    
if __name__ == "__main__":
    main()