"""
"""

from overrides import overrides
from typing import (
    List,
    Union,
    Dict,
    Text,
    Any
)
from .base_template import BaseTemplate


class AnswerShorteningTemplate(BaseTemplate):
    """ """
    def __init__(self):
        super().__init__()
        self._examples = [
            {
                "question": "In what year was the Cunningham Dance Foundation established to support the Merce Cunningham Dance Company?",
                "general_answer": "The respondent believes that Mary Ann Willson was active primarily in the 19th century, with a focus on the mid-1800s.",
                "short_answer": "It is in the 19th centure, with a focus on the mid-1800s.",
            },
            {
                "question": "What was the name of the first schoolhouse in Newbliss, Ontario, built around 1830?",
                "general_answer": "the first schoolhouse in Newbliss, Ontario, was named with a reference to log construction or a specific locality.",
                "short_answer": "It is a reference to log construction or a specific locality.",
            },
            {
                "question": "From which university did computer scientist Andrea Arpaci-Dusseau earn her bachelor's degree in 1991?",
                "general_answer": "Andrea Arpaci-Dusseau earned her bachelor's degree from a prestigious university known for its liberal arts and sciences programs.",
                "short_answer": "It is a prestigious university known for its liberal arts and sciences programs.",
            },
            {
                "question": "Who is the god with the Hawaiian name Kama\u02bbehuakanaloa?",
                "general_answer": "Kama\u02bbehuakanaloa is a Hawaiian deity associated with natural elements like volcanoes or the ocean.",
                "short_answer": "It is a Hawaiian deity associated with natural elements like volcanoes or the ocean.",
            },
        ]
        
    @overrides
    def get_prompt_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """
        """
        
        user_template = (
            "You'll be given a question and a answer to that question."
            " Please rewrite the answer to be a simple sentence that preferably starts with \"It is\".\n\n"
            "You should achieve this by not repeatintg any information from the question and only using the additional information in the answer.\n\n"
            "You should generate the shortened answer without any additional information or context.\n\n"
            "**Question**: {question}\n\n"
            "**Original Answer**: {general_answer}\n\n"
        )
        
        agent_template = (
            "{short_answer}"
        )
        
        response = []
        
        for example in self._examples:
            response.append({
                "role": "user",
                "content": user_template.format(**example)
            })
            response.append({
                "role": "assistant",
                "content": agent_template.format(**example)
            })
            
        response.append({
            "role": "user",
            "content": user_template.format(**kwargs)
        })
        
        return response
    
    @overrides
    def get_completion_template(self, **kwargs) -> Union[List[Dict[Text, Any]], Text]:
        """ """
        
        agent_template = (
            "{short_answer}"
        )
        
        return [{
            "role": "assistant",
            "content": "" if kwargs.get("is_completion") else agent_template.format(**kwargs)
        }]